/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.auxiliary;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.formplugin.bill.helper.BidModeHelper;
import kd.scm.bid.formplugin.bill.util.PartnerUserDealHelper;

public class InvitationPartner
extends AbstractBillPlugIn
implements AfterF7SelectListener,
RowClickEventListener {
    public static final String PAR_BID_SECTION = "bidsection";
    public static final String SUPPLIER_ENTRY = "supplierentry";
    private PartnerUserDealHelper helper = new PartnerUserDealHelper();

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.registerF7Listener("supplier");
        this.registerF7Listener("projectpartner");
        EntryGrid fakeSectionGrid = (EntryGrid)this.getView().getControl(PAR_BID_SECTION);
        fakeSectionGrid.addRowClickListener((RowClickEventListener)this);
    }

    private void registerF7Listener(String f7Name) {
        Control control = this.getView().getControl(f7Name);
        if (control != null && BasedataEdit.class.isInstance(control)) {
            ((BasedataEdit)control).addAfterF7SelectListener((AfterF7SelectListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean isOpen = this.isOpendPublic();
        if (isOpen) {
            this.dealDepositIsWrite(this.isAddInviSupplier());
            return;
        }
        this.dealDepositIsWrite(true);
        this.dealPartnerIsWriter();
    }

    public void dealDepositIsWrite(boolean flag) {
        boolean lock = this.getModel().getDataEntity(true).getDynamicObject("bidproject").getBoolean("issupplierget");
        if (lock) {
            DynamicObjectCollection sections = this.getModel().getDataEntity(true).getDynamicObjectCollection(PAR_BID_SECTION);
            if (sections.size() <= 0) {
                return;
            }
            for (DynamicObject section : sections) {
                DynamicObjectCollection supplierCollection = section.getDynamicObjectCollection(SUPPLIER_ENTRY);
                Iterator supplierItertor = supplierCollection.iterator();
                int i = 0;
                while (supplierItertor.hasNext()) {
                    DynamicObject row = (DynamicObject)supplierItertor.next();
                    if (flag) {
                        row.set("isdeposit", (Object)"YES");
                        this.getControl(SUPPLIER_ENTRY).getView().setEnable(Boolean.FALSE, i, new String[]{"suppliersecdeposit"});
                    } else {
                        row.set("isdeposit", (Object)"no");
                        this.getControl(SUPPLIER_ENTRY).getView().setEnable(Boolean.TRUE, i, new String[]{"suppliersecdeposit"});
                    }
                    ++i;
                }
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"suppliersecdeposit"});
        }
    }

    public void dealDepositIsWriteByEntity() {
        boolean lock = this.getModel().getDataEntity(true).getDynamicObject("bidproject").getBoolean("issupplierget");
        if (lock) {
            DynamicObjectCollection sections = this.getModel().getDataEntity(true).getDynamicObjectCollection(PAR_BID_SECTION);
            if (sections.size() <= 0) {
                return;
            }
            for (DynamicObject section : sections) {
                DynamicObjectCollection supplierCollection = section.getDynamicObjectCollection(SUPPLIER_ENTRY);
                Iterator supplierItertor = supplierCollection.iterator();
                int i = 0;
                while (supplierItertor.hasNext()) {
                    DynamicObject row = (DynamicObject)supplierItertor.next();
                    String isdeposit = row.getString("isdeposit");
                    if (!isdeposit.equals("no")) {
                        this.getControl(SUPPLIER_ENTRY).getView().setEnable(Boolean.FALSE, i, new String[]{"suppliersecdeposit"});
                    }
                    ++i;
                }
            }
        }
    }

    public void dealPartnerIsWriter() {
        Map<String, Boolean> writerMap = this.isWriterMap();
        DynamicObjectCollection sections = this.getModel().getDataEntity(true).getDynamicObjectCollection(PAR_BID_SECTION);
        for (DynamicObject section : sections) {
            DynamicObjectCollection supplierCollection = section.getDynamicObjectCollection(SUPPLIER_ENTRY);
            Iterator supplierItertor = supplierCollection.iterator();
            int i = 0;
            while (supplierItertor.hasNext()) {
                DynamicObject row = (DynamicObject)supplierItertor.next();
                String supplierPk = row.getDynamicObject("supplier").getPkValue().toString();
                boolean partLockFlag = writerMap.get(supplierPk);
                this.getControl(SUPPLIER_ENTRY).getView().setEnable(Boolean.valueOf(partLockFlag), i, new String[]{"projectpartner"});
                ++i;
            }
        }
    }

    public Map<String, Boolean> isWriterMap() {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        DynamicObjectCollection sections = this.getModel().getDataEntity(true).getDynamicObjectCollection(PAR_BID_SECTION);
        for (DynamicObject section : sections) {
            DynamicObjectCollection supplierCollection = section.getDynamicObjectCollection(SUPPLIER_ENTRY);
            for (DynamicObject row : supplierCollection) {
                String supplierPk = row.getDynamicObject("supplier").getPkValue().toString();
                Boolean flag = Boolean.TRUE;
                Boolean valueSupplierPK = (Boolean)result.get(supplierPk);
                if (valueSupplierPK != null) {
                    flag = (Boolean)result.get(supplierPk);
                }
                if (!flag.booleanValue()) continue;
                String invitationstatus = row.getString("invitationstatus");
                String tenderstatus = row.getString("tenderstatus");
                flag = StringUtils.equals((CharSequence)"UNSEND", (CharSequence)invitationstatus) && StringUtils.equals((CharSequence)",-,", (CharSequence)tenderstatus);
                result.put(supplierPk, flag);
            }
        }
        return result;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String field = e.getProperty().getName();
        boolean isOpen = this.isOpendPublic();
        if (isOpen) {
            return;
        }
        if (field.equals("projectpartner")) {
            boolean enablemultisection = this.isSingleBesction();
            if (enablemultisection) {
                return;
            }
            String supplierFlag = "supplier";
            DynamicObjectCollection sectionEntry = this.getModel().getEntryEntity(PAR_BID_SECTION);
            EntryGrid supplierEntryGrid = (EntryGrid)this.getControl(SUPPLIER_ENTRY);
            int[] supplierEntrySelects = supplierEntryGrid.getSelectRows();
            DynamicObjectCollection supplierEntryColl = this.getModel().getEntryEntity(SUPPLIER_ENTRY);
            DynamicObject supplierEntry = (DynamicObject)supplierEntryColl.get(supplierEntrySelects[0]);
            DynamicObject supplier = supplierEntry.getDynamicObject(supplierFlag);
            String supplierId = supplier.getPkValue().toString();
            DynamicObject projectpartner = supplierEntry.getDynamicObject("projectpartner");
            if (projectpartner == null) {
                this.getPageCache().put(supplierId, "0");
            } else {
                this.getPageCache().put(supplierId, projectpartner.getPkValue().toString());
            }
        }
    }

    public void entryRowClick(RowClickEvent rowclickevent) {
        EntryGrid entryGrid = (EntryGrid)rowclickevent.getSource();
        String key = entryGrid.getKey();
        this.dealDepositIsWriteByEntity();
        if (!PAR_BID_SECTION.equals(key)) {
            return;
        }
        boolean isOpen = this.isOpendPublic();
        if (isOpen) {
            return;
        }
        int rowIndex = rowclickevent.getRow();
        if (rowIndex <= -1) {
            return;
        }
        boolean enablemultisection = this.isSingleBesction();
        if (enablemultisection) {
            return;
        }
        HashMap<String, DynamicObject> supplierUser = new HashMap<String, DynamicObject>();
        String supplierFlag = "supplier";
        DynamicObjectCollection sections = this.getModel().getDataEntity(true).getDynamicObjectCollection(PAR_BID_SECTION);
        for (DynamicObject section : sections) {
            DynamicObjectCollection supplierCollection = section.getDynamicObjectCollection(SUPPLIER_ENTRY);
            for (DynamicObject row : supplierCollection) {
                String supplierPk = row.getDynamicObject(supplierFlag).getPkValue().toString();
                String cachePk = this.getPageCache().get(supplierPk);
                if (StringUtils.isBlank((CharSequence)cachePk)) continue;
                if (!supplierUser.containsKey(supplierPk)) {
                    if (cachePk.equals("0")) {
                        supplierUser.put(supplierPk, null);
                    } else {
                        DynamicObject bosUser = BusinessDataServiceHelper.loadSingle((Object)cachePk, (String)"bos_user");
                        supplierUser.put(supplierPk, bosUser);
                    }
                }
                DynamicObject modify = (DynamicObject)supplierUser.get(supplierPk);
                this.updateRow(row, modify);
            }
        }
        this.getView().updateView(SUPPLIER_ENTRY);
        this.dealEntryClickEntry(rowclickevent);
    }

    public void dealEntryClickEntry(RowClickEvent rowclickevent) {
        Map<String, Boolean> writerMap = this.isWriterMap();
        int selectSection = rowclickevent.getRow();
        DynamicObject section = (DynamicObject)this.getView().getModel().getDataEntity(true).getDynamicObjectCollection(PAR_BID_SECTION).get(selectSection);
        DynamicObjectCollection supplierentry = section.getDynamicObjectCollection(SUPPLIER_ENTRY);
        Iterator supplierIterator = supplierentry.iterator();
        int i = 0;
        while (supplierIterator.hasNext()) {
            DynamicObject row = (DynamicObject)supplierIterator.next();
            String supplierPk = row.getDynamicObject("supplier").getPkValue().toString();
            boolean partLockFlag = writerMap.get(supplierPk);
            this.getControl(SUPPLIER_ENTRY).getView().setEnable(Boolean.valueOf(partLockFlag), i, new String[]{"projectpartner"});
            ++i;
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        BasedataEdit source = (BasedataEdit)afterF7SelectEvent.getSource();
        String fieldKey = source.getFieldKey();
        if (!StringUtils.equals((CharSequence)"supplier", (CharSequence)fieldKey) && !StringUtils.equals((CharSequence)"projectpartner", (CharSequence)fieldKey)) {
            return;
        }
        boolean isOpen = this.isOpendPublic();
        if (isOpen) {
            return;
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"projectpartner")) {
            this.helper.dealAfterF7Select(this, afterF7SelectEvent);
            this.getView().updateView(SUPPLIER_ENTRY);
            return;
        }
        int currentRowIndex = afterF7SelectEvent.getCurrentRowIndex();
        DynamicObjectCollection bidsections = this.getModel().getDataEntity(true).getDynamicObjectCollection(PAR_BID_SECTION);
        if (bidsections.size() <= 1) {
            this.getView().setEnable(Boolean.TRUE, currentRowIndex, new String[]{"projectpartner"});
            this.getView().updateView(SUPPLIER_ENTRY);
            return;
        }
        DynamicObjectCollection rows = this.getView().getModel().getEntryEntity(SUPPLIER_ENTRY);
        DynamicObject row = (DynamicObject)rows.get(currentRowIndex);
        String supplierPk = row.getDynamicObject("supplier").getPkValue().toString();
        boolean flag = true;
        DynamicObject partner = null;
        HashMap<String, Boolean> isLock = new HashMap<String, Boolean>();
        for (DynamicObject bidsection : bidsections) {
            DynamicObjectCollection supplierentry = bidsection.getDynamicObjectCollection(SUPPLIER_ENTRY);
            Iterator supplierIterator = supplierentry.iterator();
            while (supplierIterator.hasNext()) {
                DynamicObject suplierRow = (DynamicObject)supplierIterator.next();
                if (suplierRow.getDynamicObject("supplier") == null) {
                    supplierIterator.remove();
                    continue;
                }
                if (partner == null && supplierPk.equals(suplierRow.getDynamicObject("supplier").getPkValue().toString())) {
                    partner = suplierRow.getDynamicObject("projectpartner");
                }
                if (flag = isLock.containsKey(suplierRow.getDynamicObject("supplier").getPkValue().toString()) ? (Boolean)isLock.get(suplierRow.getDynamicObject("supplier").getPkValue().toString()) : true) {
                    String invitationstatus = suplierRow.getString("invitationstatus");
                    String tenderstatus = suplierRow.getString("tenderstatus");
                    flag = StringUtils.equals((CharSequence)"UNSEND", (CharSequence)invitationstatus) && StringUtils.equals((CharSequence)",-,", (CharSequence)tenderstatus);
                }
                isLock.put(suplierRow.getDynamicObject("supplier").getPkValue().toString(), flag);
            }
        }
        if (partner != null) {
            row.set("projectpartner", partner);
            row.set("suppliercontact", (Object)new LocaleString(partner.getString("name")));
            row.set("contactphone", (Object)partner.getString("phone"));
            row.set("email", (Object)partner.getString("email"));
        }
        this.getView().updateView(PAR_BID_SECTION);
        this.getView().updateView(SUPPLIER_ENTRY);
        for (DynamicObject newBidSection : bidsections) {
            DynamicObjectCollection supplierentry = newBidSection.getDynamicObjectCollection(SUPPLIER_ENTRY);
            Iterator iterator = supplierentry.iterator();
            int i = -1;
            while (iterator.hasNext()) {
                DynamicObject newRow = (DynamicObject)iterator.next();
                DynamicObject supplier = newRow.getDynamicObject("supplier");
                ++i;
                if (supplier == null) continue;
                boolean partLockFlag = (Boolean)isLock.get(supplier.getPkValue().toString());
                this.getView().setEnable(Boolean.valueOf(partLockFlag), i, new String[]{"projectpartner"});
            }
        }
        this.getView().updateView(SUPPLIER_ENTRY);
    }

    public void updateRow(DynamicObject row, DynamicObject newUser) {
        DynamicObject projectpartner = row.getDynamicObject("projectpartner");
        if (projectpartner == null && newUser == null) {
            return;
        }
        if (projectpartner == null && newUser != null) {
            row.set("projectpartner", (Object)newUser);
            row.set("suppliercontact", (Object)new LocaleString(newUser.getString("name")));
            row.set("contactphone", (Object)newUser.getString("phone"));
            row.set("email", (Object)newUser.getString("email"));
            return;
        }
        if (projectpartner != null && newUser == null) {
            row.set("projectpartner", (Object)newUser);
            return;
        }
        if (projectpartner != null && newUser != null && projectpartner.getPkValue().toString().equals(newUser.getPkValue().toString())) {
            return;
        }
        row.set("projectpartner", (Object)newUser);
        row.set("suppliercontact", (Object)new LocaleString(newUser.getString("name")));
        row.set("contactphone", (Object)newUser.getString("phone"));
        row.set("email", (Object)newUser.getString("email"));
    }

    public boolean isSingleBesction() {
        DynamicObjectCollection bidsections = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection(PAR_BID_SECTION);
        return bidsections == null || bidsections.size() <= 1;
    }

    public boolean isAddInviSupplier() {
        String sourcebillid = this.getView().getModel().getDataEntity(true).getString("sourcebillid");
        return !StringUtils.isBlank((CharSequence)sourcebillid) && !StringUtils.equals((CharSequence)"0", (CharSequence)sourcebillid);
    }

    public boolean isOpendPublic() {
        DynamicObject model = this.getView().getModel().getDataEntity(true).getDynamicObject("bidproject").getDynamicObject("bidmode");
        return BidModeHelper.isPublicBiddingByModel(model);
    }
}

