/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.bidassinvite;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.bidassinvite.BidAssInviteSureStatusEnum;
import kd.scm.bid.formplugin.bill.helper.MessageCenterHelper;

public class BidAssInviteFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"fs_baseinfo"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"attachmentpanel"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Date sureFinishTime = (Date)this.getModel().getValue("surefinishtime");
        Date now = new Date();
        int finishTime = 0;
        if (sureFinishTime != null && sureFinishTime.after(now)) {
            finishTime = (int)((sureFinishTime.getTime() - now.getTime()) / 1000L);
        }
        Object templatecontent_tag = this.getModel().getValue("templatecontent_tag");
        Date publishTime = (Date)this.getModel().getValue("publishtime");
        Date startBidTime = (Date)this.getModel().getValue("startbidtime");
        String startBidPlace = (String)this.getModel().getValue("startbidplace");
        String bidassinvite_preview = FormTypeConstants.getFormConstant((String)"bidassinvite_preview", ((Object)((Object)this)).getClass());
        String title = (String)this.getModel().getValue("titlename");
        DynamicObject bidAssInviteSum = (DynamicObject)this.getModel().getValue("bidassinvitesum");
        FormShowParameter fsp = new FormShowParameter();
        OpenStyle openStyle = fsp.getOpenStyle();
        fsp.setFormId(bidassinvite_preview);
        fsp.setCustomParam("title", (Object)title);
        fsp.setCustomParam("finishTime", (Object)finishTime);
        fsp.setCustomParam("templatecontent_tag", templatecontent_tag);
        fsp.setCustomParam("publishTime", (Object)publishTime);
        fsp.setCustomParam("startBidTime", (Object)startBidTime);
        fsp.setCustomParam("startBidPlace", (Object)startBidPlace);
        fsp.setCustomParam("bidAssInviteSumId", bidAssInviteSum.getPkValue());
        openStyle.setShowType(ShowType.InContainer);
        openStyle.setTargetKey("targetflex");
        this.getView().showForm(fsp);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String sureStatus;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String bidAssInviteKey = FormTypeConstants.getFormConstant((String)"bidassinvite", ((Object)((Object)this)).getClass());
        DynamicObject bidAssInviteInfo = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)bidAssInviteKey);
        if (("surejoin".equals(key) || "sureavoid".equals(key)) && !"10".equals(sureStatus = bidAssInviteInfo.getString("surestatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5f85\u786e\u8ba4\u72b6\u6001\u7684\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BidAssInviteFormPlugin_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"sureavoid", (CharSequence)key)) {
            FormShowParameter fsp = new FormShowParameter();
            OpenStyle openStyle = fsp.getOpenStyle();
            fsp.setFormId("bid_bidassivite_avoid");
            fsp.setCaption(ResManager.loadKDString((String)"\u56de\u907f\u539f\u56e0", (String)"BidAssInviteFormPlugin_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "avoid"));
            openStyle.setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (StringUtils.equals((CharSequence)event.getActionId(), (CharSequence)"avoid") && event.getReturnData() != null) {
            HashMap returnData = (HashMap)event.getReturnData();
            String avoidreason = (String)returnData.get("avoidreason");
            DynamicObject dataEntity = this.getModel().getDataEntity();
            this.backWrite(dataEntity, "sureavoid", avoidreason);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u56de\u907f\u6210\u529f", (String)"BidAssInviteFormPlugin_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
            this.refuseInviteSendMessage(dataEntity);
        }
    }

    private void refuseInviteSendMessage(DynamicObject dataEntity) {
        String msgentity;
        String tplScene;
        String formId;
        HashMap<String, Object> msgParam = new HashMap<String, Object>();
        String appName = this.getView().getFormShowParameter().getServiceAppId();
        DynamicObject bidProject_f7 = dataEntity.getDynamicObject("name");
        if ("bid".equals(appName)) {
            msgParam.put("formId", "bid_bidassinvite");
            formId = "bid_project";
            tplScene = "BIDREFUSEINVITE";
            msgentity = "bid_bidassinvite";
        } else {
            msgParam.put("formId", "rebm_bidassinvite");
            formId = "rebm_project";
            tplScene = "BIDREFUSEINVITE_REBM";
            msgentity = "rebm_bidassinvite";
        }
        msgParam.put("tplScene", tplScene);
        msgParam.put("msgentity", msgentity);
        msgParam.put("title", null);
        msgParam.put("content", null);
        msgParam.put("urlParams", null);
        msgParam.put("operation", "avoid");
        msgParam.put("appId", appName);
        msgParam.put("id", dataEntity.getPkValue());
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject_f7.getPkValue(), (String)formId);
        DynamicObjectCollection memberColl = bidProject.getDynamicObjectCollection("memberentity");
        HashSet<Long> receiveUserIds = new HashSet<Long>();
        for (DynamicObject member : memberColl) {
            String[] values;
            if (member.getString("respbusiness") == null || (values = member.getString("respbusiness").split(",")) == null || values.length <= 0) continue;
            for (int m = 0; m < values.length; ++m) {
                if (!"01".equals(values[m]) && !"06".equals(values[m]) && !"11".equals(values[m]) && !"12".equals(values[m])) continue;
                receiveUserIds.add(member.getDynamicObject("user").getLong("id"));
            }
        }
        MessageCenterHelper.sendMessagesToOpetator(msgParam, false, new ArrayList<Long>(receiveUserIds));
    }

    public void backWrite(DynamicObject bidAssInviteInfo, String target, String avoidreason) {
        DynamicObject expertExtract;
        String bidAssInviteKey = FormTypeConstants.getFormConstant((String)"bidassinvite", ((Object)((Object)this)).getClass());
        String bidAssInviteSumKey = FormTypeConstants.getFormConstant((String)"bidassinvitesum", ((Object)((Object)this)).getClass());
        String extractKey = FormTypeConstants.getFormConstant((String)"proficient_extract", ((Object)((Object)this)).getClass());
        boolean isJoin = false;
        String sureResult = BidAssInviteSureStatusEnum.SureAvoid.getValue();
        if (StringUtils.equals((CharSequence)target, (CharSequence)"surejoin")) {
            isJoin = true;
            sureResult = BidAssInviteSureStatusEnum.Sure.getValue();
        }
        bidAssInviteInfo = BusinessDataServiceHelper.loadSingle((Object)bidAssInviteInfo.getPkValue(), (String)bidAssInviteKey);
        bidAssInviteInfo.set("sureresult", (Object)sureResult);
        bidAssInviteInfo.set("surestatus", (Object)sureResult);
        bidAssInviteInfo.set("avoidreason", (Object)avoidreason);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidAssInviteInfo});
        avoidreason = bidAssInviteInfo.getString("avoidreason");
        DynamicObject expert = bidAssInviteInfo.getDynamicObject("expertid");
        DynamicObject bidAssInviteSum = bidAssInviteInfo.getDynamicObject("bidassinvitesum");
        if (bidAssInviteSum != null && (expertExtract = (bidAssInviteSum = BusinessDataServiceHelper.loadSingle((Object)bidAssInviteSum.getPkValue(), (String)bidAssInviteSumKey, (String)"linkexpertextract")).getDynamicObject("linkexpertextract")) != null) {
            expertExtract = BusinessDataServiceHelper.loadSingle((Object)expertExtract.getPkValue(), (String)extractKey);
            DynamicObjectCollection extractResults = expertExtract.getDynamicObjectCollection("extractionresults");
            for (int i = 0; i < extractResults.size(); ++i) {
                DynamicObject extractResult = (DynamicObject)extractResults.get(i);
                DynamicObject proficient = extractResult.getDynamicObject("proficient");
                if (!expert.getPkValue().equals(proficient.getPkValue())) continue;
                extractResult.set("isjoinbidevaluation", (Object)isJoin);
                extractResult.set("bidevaluationinvite", (Object)sureResult);
                extractResult.set("invitereceipt", (Object)sureResult);
                extractResult.set("avoidreason", (Object)avoidreason);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{expertExtract});
            }
        }
    }
}

