/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.bidcenter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.BusinessAppCache;
import kd.bos.entity.cache.IBusinessAppCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.BizLog;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.bid.business.bidcenter.IBidCenterService;
import kd.scm.bid.business.bidcenter.impl.BidCenterServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.constant.entity.DefaultOrgReg;
import kd.scm.bid.common.constant.entity.bidcenter.BidCenterConstant;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.CommonUtil;
import kd.scm.bid.common.util.DefaultOrgUtil;
import kd.scm.bid.formplugin.bill.util.PermissionUtils;

public class BidCenterList
extends AbstractListPlugin {
    private IBidCenterService bidCenterService = new BidCenterServiceImpl();
    private BidCenterConstant bidCenterConstant = new BidCenterConstant();
    public static final String CURRENT_BILLNO_PAGE = "currentbillno";
    public static final String CURRENT_BILLNO_ROW = "idandstatus";
    public static final String CURRENT_BILLNO_RELOAD = "load";
    public static final String NEED_REFRESH = "needrefresh";

    public void setFilter(SetFilterEvent e) {
        boolean isAdmin;
        Optional<QFilter> of;
        super.setFilter(e);
        RequestContext context = RequestContext.get();
        Long userId = context.getCurrUserId();
        QFilter filter4Org = null;
        List qFilters = e.getQFilters();
        if (qFilters == null || qFilters.size() <= 0) {
            this.getPageCache().put(CURRENT_BILLNO_RELOAD, "0");
        }
        boolean orgNameFilterFlag = false;
        if (qFilters != null && (of = qFilters.stream().filter(filter -> "org.name".equals(filter.getProperty())).findFirst()).isPresent()) {
            QFilter f = of.get();
            List nestList = f.getNests(true);
            if (nestList != null && nestList.size() > 0) {
                for (QFilter.QFilterNest nest : nestList) {
                    QFilter qFilter = nest.getFilter();
                    if ("org.name".equals(qFilter.getProperty())) continue;
                    qFilters.add(qFilter);
                }
            }
            qFilters.remove(f);
            DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", f.getCP(), f.getValue())});
            Set orgIds = orgs.stream().map(org -> org.get("id")).collect(Collectors.toSet());
            QFilter q1 = new QFilter("org", "in", orgIds);
            QFilter q2 = new QFilter("entrustmentorgunit", "in", orgIds);
            filter4Org = q1.or(q2);
            orgNameFilterFlag = true;
        }
        if (qFilters != null) {
            int index = 0;
            String tempStr = "";
            for (int i = 0; i < qFilters.size(); ++i) {
                QFilter filter2 = (QFilter)qFilters.get(i);
                if (!filter2.getProperty().equals(CURRENT_BILLNO_PAGE) && !filter2.getProperty().equals("rebmcurrentbillno")) continue;
                tempStr = filter2.getValue().toString();
                index = i;
                break;
            }
            if (StringUtils.isNotBlank((CharSequence)tempStr)) {
                qFilters.remove(index);
                QFilter filter3 = this.reFilterByStatus(tempStr.substring(1, tempStr.length() - 1));
                if (filter3 != null) {
                    qFilters.add(filter3);
                }
            }
        }
        List orgIds = ((ListView)this.getView()).getSelectedMainOrgIds();
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        String formId = FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass());
        Long orgId = null;
        if (orgIds == null || orgIds.size() == 0) {
            DefaultOrgReg defaultOrgReg = new DefaultOrgReg(appId, "02", formId, this.getControlFilters(), "org.id");
            orgId = DefaultOrgUtil.getListUIDefaultOrg((DefaultOrgReg)defaultOrgReg);
        } else {
            orgId = (Long)orgIds.get(0);
        }
        this.getPageCache().put("org", String.valueOf(orgId));
        if (!orgNameFilterFlag) {
            String orgNotLimitflag = "select";
            if (orgIds == null || orgIds.size() <= 0) {
                HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac");
                if (allPermOrgs.hasAllOrgPerm()) {
                    orgIds = OrgUnitServiceHelper.getAllOrgByViewNumber((String)"02", (boolean)true);
                    orgNotLimitflag = "all";
                } else {
                    int hasSize;
                    List allOrgList = OrgUnitServiceHelper.getAllOrgByViewNumber((String)"02", (boolean)true);
                    orgIds = allPermOrgs.getHasPermOrgs();
                    int allSize = allOrgList.size();
                    int notSize = allSize - (hasSize = orgIds.size());
                    if (notSize > hasSize) {
                        orgNotLimitflag = "has";
                    } else {
                        orgNotLimitflag = "not";
                        if (allOrgList.removeAll(orgIds)) {
                            orgIds = allOrgList;
                        }
                    }
                }
            }
            filter4Org = "all".equals(orgNotLimitflag) ? new QFilter("org", "not in", (Object)-1).or(new QFilter("entrustmentorgunit", "not in", (Object)-1)) : ("not".equals(orgNotLimitflag) ? new QFilter("org", "not in", (Object)orgIds).or(new QFilter("entrustmentorgunit", "not in", (Object)orgIds)) : new QFilter("org", "in", (Object)orgIds).or(new QFilter("entrustmentorgunit", "in", (Object)orgIds)));
        }
        if (filter4Org != null && qFilters != null) {
            qFilters.add(filter4Org);
        }
        if (!(isAdmin = CommonUtil.isBidAdmin((String)appId, (Long)RequestContext.get().getCurrUserId())) && qFilters != null) {
            QFilter bidQFilter = this.bidCenterService.getCenterLookPermissionBidIdFilter((Object)userId);
            qFilters.add(bidQFilter.or(this.getProficientFilter()));
        }
        BaseDataServiceHelper helper = new BaseDataServiceHelper();
        if (orgId != null) {
            QFilter qfilter = BaseDataServiceHelper.getBaseDataFilter((String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (Long)orgId);
            if (qfilter != null && qFilters != null) {
                qFilters.add(qfilter);
            }
        }
        BizLog.log((String)(ResManager.loadKDString((String)"\u62db\u6807\u4e2d\u5fc3\u8fc7\u6ee4\uff1a", (String)"BidCenterList_2", (String)"scm-bid-formplugin", (Object[])new Object[0]) + e.getQFilters()));
        super.setFilter(e);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List listColumns = args.getListColumns();
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        boolean visiable = false;
        if ("bid".equals(appId)) {
            visiable = true;
        }
        for (IListColumn item : listColumns) {
            String fieldName = item.getListFieldKey();
            if (CURRENT_BILLNO_PAGE.equals(fieldName)) {
                item.setVisible(visiable ? 63 : 0);
                continue;
            }
            if (!"rebmcurrentbillno".equals(fieldName)) continue;
            item.setVisible(!visiable ? 63 : 0);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public QFilter reFilterByStatus(String pageCacge) {
        String[] currentbillno = pageCacge.split(",");
        TreeSet<String> billNoSet = new TreeSet<String>();
        for (String currentBillNo : currentbillno) {
            billNoSet.add(currentBillNo.trim());
        }
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        IBusinessAppCache appCache = BusinessAppCache.get((String)appId);
        String jsonStr = (String)appCache.get(CURRENT_BILLNO_PAGE, String.class);
        List data = JSONObject.parseArray((String)jsonStr, String.class);
        Set idSet = data.parallelStream().filter(row -> {
            String[] split = row.split(",");
            for (int i = 0; i < split.length; ++i) {
                String s = split[i].trim();
                if (!billNoSet.contains(s)) continue;
                return true;
            }
            return false;
        }).map(row -> Long.parseLong(row.split(",")[0])).collect(Collectors.toSet());
        if (idSet == null || idSet.size() <= 0) {
            return new QFilter("id", "=", (Object)-1);
        }
        return new QFilter("id", "in", idSet);
    }

    private QFilter getProficientFilter() {
        RequestContext requestContext = RequestContext.get();
        Long userId = Long.valueOf(requestContext.getUserId());
        QFilter filter = new QFilter("bidevaluator.proficientname.id", "=", (Object)userId);
        String formId = FormTypeConstants.getFormConstant((String)"onlinebideval", ((Object)((Object)this)).getClass());
        DynamicObject[] onlinebidevals = BusinessDataServiceHelper.load((String)formId, (String)"bidproject", (QFilter[])new QFilter[]{filter});
        HashSet<Long> bidProIds = new HashSet<Long>(onlinebidevals.length);
        for (DynamicObject onlinebideval : onlinebidevals) {
            if (null == onlinebideval.getDynamicObject("bidproject")) continue;
            bidProIds.add(Long.parseLong(onlinebideval.getDynamicObject("bidproject").getPkValue().toString()));
        }
        QFilter idQFilter = new QFilter("id", "in", bidProIds);
        return idQFilter;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        if ("bidnew".equals(operateKey)) {
            String formId;
            String permisionCode;
            boolean hasPermission;
            String orgIdStr = this.getPageCache().get("org");
            Long orgId = -1L;
            if (StringUtils.isNotEmpty((CharSequence)orgIdStr)) {
                try {
                    orgId = Long.parseLong(orgIdStr);
                }
                catch (Exception e) {
                    orgId = -1L;
                    BizLog.log((String)(ResManager.loadKDString((String)"\u62db\u6807\u4e2d\u5fc3orgId\u8f6c\u6362\u5f02\u5e38\uff1a", (String)"BidCenterList_3", (String)"scm-bid-formplugin", (Object[])new Object[0]) + e.getMessage()));
                }
            }
            if (!(hasPermission = PermissionUtils.checkPermission(permisionCode = (String)BidCenterConstant.OPKEY_PERMISIONCODE_MAP.get(operateKey), orgId, appId, formId = FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass())))) {
                String tip = (String)BidCenterConstant.OPKEY_PERMISIONTIP_MAP.get(operateKey);
                this.getView().showErrorNotification(tip);
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        boolean isAnswer;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if (opResult != null && !opResult.isSuccess()) {
            return;
        }
        if (operateKey.equals("bidnew")) {
            this.showNewBid();
        }
        if (isAnswer = StringUtils.equals((CharSequence)"bidanswerquestion", (CharSequence)operateKey)) {
            QFilter bidFilter;
            ListSelectedRow src = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            if (src == null) {
                return;
            }
            Long bidProjectId = Long.parseLong(src.getPrimaryKeyValue().toString());
            String formId = FormTypeConstants.getFormConstant((String)"answerquestion_reco", ((Object)((Object)this)).getClass());
            Boolean haveAnswerDataReco = QueryServiceHelper.exists((String)formId, (QFilter[])new QFilter[]{bidFilter = new QFilter("bidproject.id", "=", (Object)bidProjectId)});
            if (haveAnswerDataReco.booleanValue()) {
                this.doBidProcessOp(operateKey);
            } else {
                String bidFormId = FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass());
                DynamicObject entity = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)bidFormId, (String)"entrustmentorgunit,org");
                Boolean checkOpPermision = this.checkOpPermission("QXX0002", entity, formId);
                if (!checkOpPermision.booleanValue()) {
                    this.getView().showErrorNotification(this.bidCenterConstant.ADD_ANSWER_TIP);
                    return;
                }
                HashMap<String, String> recoEditMap = new HashMap<String, String>();
                recoEditMap.put("formId", formId);
                FormShowParameter recoEditPara = FormShowParameter.createFormShowParameter(recoEditMap);
                recoEditPara.setStatus(OperationStatus.ADDNEW);
                recoEditPara.setCustomParam("bidproject", (Object)bidProjectId);
                OpenStyle openStyle = recoEditPara.getOpenStyle();
                openStyle.setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(recoEditPara);
            }
        } else {
            this.doBidProcessOp(operateKey);
        }
    }

    public void doBidProcessOp(String operateKey) {
        if (BidCenterConstant.OPKEY_FLEX_MAP.containsKey(operateKey)) {
            ListSelectedRow src = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            if (src == null) {
                return;
            }
            Object primaryKeyValue = src.getPrimaryKeyValue();
            BillShowParameter showParameter = new BillShowParameter();
            String formId = FormTypeConstants.getFormConstant((String)"bidcenter", ((Object)((Object)this)).getClass());
            showParameter.setFormId(formId);
            showParameter.setPkId(primaryKeyValue);
            showParameter.setCustomParam("opKeyFromList", (Object)operateKey);
            showParameter.setCustomParam("bidProjectId", primaryKeyValue);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            CloseCallBack back = new CloseCallBack((IFormPlugin)this, NEED_REFRESH);
            showParameter.setCloseCallBack(back);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void showNewBid() {
        BillShowParameter showParameter = new BillShowParameter();
        String formId = FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass());
        showParameter.setFormId(formId);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setHasRight(true);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String orgId = this.getPageCache().get("org");
        showParameter.setCustomParam("org", (Object)orgId);
        showParameter.setCustomParam("BidCenterNewBid", (Object)"BidCenterNewBid");
        CloseCallBack back = new CloseCallBack((IFormPlugin)this, NEED_REFRESH);
        showParameter.setCloseCallBack(back);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (NEED_REFRESH.equals(closedCallBackEvent.getActionId())) {
            BillList x = (BillList)this.getView().getControl("billlistap");
            x.refresh();
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
        Object bidProjectId = sr.getPrimaryKeyValue();
        if (StringUtils.equals((CharSequence)"currentstep", (CharSequence)fieldName)) {
            args.setCancel(true);
            FormShowParameter showParameter = new FormShowParameter();
            String formId = FormTypeConstants.getFormConstant((String)"projectprocess", ((Object)((Object)this)).getClass());
            showParameter.setFormId(formId);
            showParameter.setCustomParam("bidProjectId", bidProjectId);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm(showParameter);
        } else if (StringUtils.equals((CharSequence)"name", (CharSequence)fieldName)) {
            args.setCancel(true);
            RequestContext context = RequestContext.get();
            String userId = context.getUserId();
            String appId = this.getView().getFormShowParameter().getServiceAppId();
            boolean isAdmin = CommonUtil.isBidAdmin((String)appId, (Long)RequestContext.get().getCurrUserId());
            if (!isAdmin) {
                String formId;
                DynamicObject entity;
                DynamicObject permissionMember = this.bidCenterService.getPermissionMember((Object)userId, bidProjectId, "01");
                if (permissionMember == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u62db\u6807\u7acb\u9879\u7684\u4e1a\u52a1\u7ecf\u529e\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidCenterList_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    return;
                }
                String permisionCode = (String)BidCenterConstant.OPKEY_PERMISIONCODE_MAP.get("bidproject");
                boolean hasPermission = this.checkOpPermission(permisionCode, entity = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)(formId = FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass())), (String)"id,org,entrustmentorgunit"), formId);
                if (!hasPermission) {
                    String tip = (String)BidCenterConstant.OPKEY_PERMISIONTIP_MAP.get("bidproject");
                    this.getView().showErrorNotification(tip);
                    return;
                }
            }
            this.doBidProcessOp("bidproject");
        }
    }

    private boolean checkOpPermission(String permisionCode, DynamicObject entity, String formId) {
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        long orgId = (Long)entity.getDynamicObject("org").getPkValue();
        boolean orgHasPermission = PermissionUtils.checkPermission(permisionCode, orgId, appId, formId);
        DynamicObject entrustmentorgunit = entity.getDynamicObject("entrustmentorgunit");
        if (entrustmentorgunit == null) {
            return orgHasPermission;
        }
        Long entrustmentorgunitId = (Long)entrustmentorgunit.getPkValue();
        boolean entrustmentorgHasPermission = PermissionUtils.checkPermission(permisionCode, entrustmentorgunitId, appId, formId);
        return orgHasPermission || entrustmentorgHasPermission;
    }

    public String getBidAdminRoleID() {
        return "/FFXFSRKI73+";
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
    }

    static class MyListDataProvider
    extends ListDataProvider {
        private String appid;

        public MyListDataProvider() {
        }

        public MyListDataProvider(String appid) {
            this.appid = appid;
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            DynamicObjectCollection rows = super.getData(arg0, arg1);
            if (rows.isEmpty()) {
                return rows;
            }
            Set<Object> ids = rows.stream().map(r -> r.getPkValue()).collect(Collectors.toSet());
            Map<Object, String> supplierinvitation = this.getStatusByBillType(ids, this.getBillEntityName(this.appid, "supplierinvitation"));
            Map<Object, String> biddocument_edit = this.getStatusByBillType(ids, this.getBillEntityName(this.appid, "biddocument_edit"));
            Map<Object, String> bidpublish = this.getStatusByBillType(ids, this.getBillEntityName(this.appid, "bidpublish"));
            Map<Object, String> answerquestion = this.getStatusByBillType(ids, this.getBillEntityName(this.appid, "answerquestion"));
            Map<Object, String> bidopen = this.getStatusByBillType(ids, this.getBillEntityName(this.appid, "bidopen"));
            Map<Object, String> bidevaluation = this.getStatusByBillType(ids, this.getBillEntityName(this.appid, "bidevaluation"));
            Map<Object, String> bustalk = this.getStatusByBillType(ids, this.getBillEntityName(this.appid, "bustalk"));
            Map<Object, String> decision = this.getStatusByBillType(ids, this.getBillEntityName(this.appid, "decision"));
            Map<Object, String> clarificaiton = this.getStatusByBillType(ids, this.getBillEntityName(this.appid, "clarificaiton"));
            for (DynamicObject row : rows) {
                String k;
                if (row == null) continue;
                StringBuffer idAndStatus = new StringBuffer();
                Object purprojectID = row.getPkValue();
                String billstatus = row.getString("billstatus");
                String currentStepBillstatus = "";
                idAndStatus.append(row.getPkValue());
                String[] currentSteps = ((String)row.get("currentstep")).split(",");
                StringBuffer tempStatus = new StringBuffer();
                for (String step : currentSteps) {
                    if (StringUtils.isEmpty((CharSequence)step)) continue;
                    String status = "";
                    if ("BidProject".equals(step)) {
                        status = billstatus;
                    } else if ("SupplierInvitation".equals(step)) {
                        status = supplierinvitation.get(purprojectID);
                    } else if ("BidDocument".equals(step)) {
                        status = biddocument_edit.get(purprojectID);
                    } else if ("BidPublish".equals(step)) {
                        status = bidpublish.get(purprojectID);
                    } else if ("BidAnswerQuestion".equals(step)) {
                        status = answerquestion.get(purprojectID);
                    } else if ("BidOpen".equals(step)) {
                        status = bidopen.get(purprojectID);
                        if (StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)"p")) {
                            status = "INP";
                        }
                    } else if ("BidEvaluation".equals(step)) {
                        status = bidevaluation.get(purprojectID);
                    } else if ("BidBustalk".equals(step)) {
                        status = bustalk.get(purprojectID);
                    } else if ("BidDecision".equals(step)) {
                        status = decision.get(purprojectID);
                    } else if ("Clarificaiton".equals(step)) {
                        status = clarificaiton.get(purprojectID);
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)status)) continue;
                    if (StringUtils.isNotEmpty((CharSequence)currentStepBillstatus)) {
                        currentStepBillstatus = currentStepBillstatus + " ";
                    }
                    try {
                        currentStepBillstatus = currentStepBillstatus + BillStatusEnum.getAliasByVal((String)status);
                        String k2 = status + ",";
                        tempStatus.append(k2);
                    }
                    catch (IllegalArgumentException e) {
                        currentStepBillstatus = currentStepBillstatus + status;
                        String k3 = status + ",";
                        tempStatus.append(k3);
                    }
                }
                row.set(BidCenterList.CURRENT_BILLNO_PAGE, (Object)currentStepBillstatus);
                row.set("rebmcurrentbillno", (Object)currentStepBillstatus);
                if (StringUtils.isBlank((CharSequence)tempStatus) || tempStatus.length() <= 1) {
                    k = "," + tempStatus;
                    idAndStatus.append(k);
                } else {
                    k = "," + tempStatus.substring(0, tempStatus.length() - 1);
                    idAndStatus.append(k);
                }
                row.set(BidCenterList.CURRENT_BILLNO_ROW, (Object)idAndStatus);
            }
            String appId = ((DynamicObject)rows.get(0)).getString("entitytypeid").split("_")[0];
            ArrayList<String> collect = new ArrayList<String>();
            for (DynamicObject row : rows) {
                collect.add(row.getString(BidCenterList.CURRENT_BILLNO_ROW));
            }
            if (collect != null && collect.size() > 0) {
                String toJSONString = JSON.toJSONString(collect);
                IBusinessAppCache appCache = BusinessAppCache.get((String)appId);
                appCache.put(BidCenterList.CURRENT_BILLNO_PAGE, (Object)toJSONString);
            }
            return rows;
        }

        private Map<Object, String> getStatusByBillType(Set<Object> purprojectID, String billEntityName) {
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)billEntityName, (String)"id,billstatus,bidproject", (QFilter[])new QFilter[]{new QFilter("bidproject", "in", purprojectID)}, (String)"createtime desc");
            HashMap<Object, String> result = new HashMap<Object, String>();
            if (bills != null && bills.length > 0) {
                for (DynamicObject bill : bills) {
                    Object bidproject = bill.getDynamicObject("bidproject").getPkValue();
                    String billstatus = bill.getString("billstatus");
                    if (!CollectionUtils.isEmpty(result)) {
                        String billStatus = (String)result.get(bidproject);
                        if (!StringUtils.isEmpty((CharSequence)billStatus)) continue;
                        result.put(bidproject, billstatus);
                        continue;
                    }
                    result.put(bidproject, billstatus);
                }
            }
            return result;
        }

        private String getStatusByBillType(Object purprojectID, String billEntityName) {
            Long purId = Long.parseLong(purprojectID.toString());
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)billEntityName, (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "in", (Object)purId)}, (String)"createtime desc");
            if (bills.length > 0) {
                return bills[0].getString("billstatus");
            }
            return "";
        }

        private String getBillEntityName(String appID, String billType) {
            String entityName = "";
            entityName = "rebm".equals(appID) ? "rebm" : "bid";
            entityName = entityName + "_" + billType;
            return entityName;
        }
    }
}

