/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.bidcenter;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.BizLog;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.RespBusiness;
import kd.scm.bid.common.util.CommonUtil;

public class BidCenterSonFormEdit
extends AbstractFormPlugin
implements ClickListener {
    protected Map<String, String> FORMID_OPKEY_MAP = new HashMap<String, String>(){
        {
            this.put("bid_project", "bidproject");
            this.put("bid_biddocument_edit", "biddocument");
            this.put("bid_supplierinvitation", "supplierinvitation");
            this.put("bid_bidpublish", "bidpublish");
            this.put("bid_answerquestion_reco", "bidanswerquestion");
            this.put("bid_bidopen", "bidopen");
            this.put("bid_onlinebideval", "onlineevaluation");
            this.put("bid_bidevaluation", "bidevaluation");
            this.put("bid_bustalk", "bidbustalk");
            this.put("bid_decision", "biddecision");
            this.put("bid_bottom_make", "bidbottommake");
            this.put(BidCenterSonFormEdit.this.getFormIdByApp("project", BidCenterSonFormEdit.REBM_APPID), "bidproject");
            this.put(BidCenterSonFormEdit.this.getFormIdByApp("biddocument_edit", BidCenterSonFormEdit.REBM_APPID), "biddocument");
            this.put(BidCenterSonFormEdit.this.getFormIdByApp("supplierinvitation", BidCenterSonFormEdit.REBM_APPID), "supplierinvitation");
            this.put(BidCenterSonFormEdit.this.getFormIdByApp("bidpublish", BidCenterSonFormEdit.REBM_APPID), "bidpublish");
            this.put(BidCenterSonFormEdit.this.getFormIdByApp("answerquestion_reco", BidCenterSonFormEdit.REBM_APPID), "bidanswerquestion");
            this.put(BidCenterSonFormEdit.this.getFormIdByApp("bidopen", BidCenterSonFormEdit.REBM_APPID), "bidopen");
            this.put(BidCenterSonFormEdit.this.getFormIdByApp("onlinebideval", BidCenterSonFormEdit.REBM_APPID), "onlineevaluation");
            this.put(BidCenterSonFormEdit.this.getFormIdByApp("bidevaluation", BidCenterSonFormEdit.REBM_APPID), "bidevaluation");
            this.put(BidCenterSonFormEdit.this.getFormIdByApp("bustalk", BidCenterSonFormEdit.REBM_APPID), "bidbustalk");
            this.put(BidCenterSonFormEdit.this.getFormIdByApp("decision", BidCenterSonFormEdit.REBM_APPID), "biddecision");
            this.put(BidCenterSonFormEdit.this.getFormIdByApp("bottom_make", BidCenterSonFormEdit.REBM_APPID), "bidbottommake");
        }
    };
    public static final String BID_APPID = "bid";
    public static final String REBM_APPID = "rebm";

    public void preOpenForm(PreOpenFormEventArgs e) {
        String pkId;
        String formId;
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        String apptype = (String)formShowParameter.getCustomParam("apptype");
        if (apptype != null && apptype.equals("mcenter") && (formId = (String)formShowParameter.getCustomParam("formId")) != null && formId.endsWith("bidevaluation") && ((pkId = (String)formShowParameter.getCustomParam("pkId")) == null || !QueryServiceHelper.exists((String)formId, (Object)Long.parseLong(pkId)))) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5df2\u91cd\u65b0\u8c03\u6574\u8bc4\u6807\u4e13\u5bb6\uff0c\u8bf7\u4ece\u8bc4\u6807\u5217\u8868\u67e5\u770b\u3002", (String)"BidCenterSonFormEdit_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getView().getControl("tbmain");
        toolbar.addItemClickListener((ItemClickListener)this);
    }

    public String getBidAdminRoleID(String formId) {
        String[] s;
        if (formId != null && !"".equals(formId) && (s = formId.split("_")).length > 0) {
            if (BID_APPID.equals(s[0])) {
                return "/FFXFSRKI73+";
            }
            if (REBM_APPID.equals(s[0])) {
                return "/V6OAY0JH+8R";
            }
        }
        return "";
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        RequestContext context = RequestContext.get();
        String userId = context.getUserId();
        String formId = ((BillView)e.getSource()).getFormId();
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        boolean isAdmin = CommonUtil.isBidAdmin((String)appId, (Long)RequestContext.get().getCurrUserId());
        if (isAdmin) {
            return;
        }
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        long projectId = 0L;
        BizLog.log((String)("wbyformId" + formId));
        Object bidproject = dynamicObject.get("bidproject");
        projectId = bidproject instanceof Boolean ? dynamicObject.getLong("id") : (dynamicObject.getDynamicObject("bidproject") == null && "rebm_biddocument_edit".equals(formId) ? (Long)formShowParameter.getCustomParam("bidproject") : (dynamicObject.getDynamicObject("bidproject") == null && "rebm_supplierinvitation".equals(formId) ? ((Long)formShowParameter.getCustomParam("bidproject")).longValue() : ((Long)dynamicObject.getDynamicObject("bidproject").getPkValue()).longValue()));
        BizLog.log((String)("wbyprojectId" + String.valueOf(projectId)));
        if (projectId == 0L) {
            return;
        }
        if ("bid_bidopen".equals(formId) || "rebm_bidopen".equals(formId)) {
            String opentype = dynamicObject.getString("opentype");
            QFilter qFilter = new QFilter("user", "=", (Object)Long.parseLong(userId));
            QFilter qFilter1 = new QFilter("bidproject", "=", (Object)projectId);
            QFilter qFilter3 = new QFilter("isdirector", "=", (Object)"1");
            QFilter openTypeQFilter = new QFilter("respbusiness", "in", new ArrayList());
            if (BidOpenTypeEnum.TECHNICAL.getValue().equals(opentype)) {
                openTypeQFilter = new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.TechnicalOpen.getVal() + "%"));
            } else if (BidOpenTypeEnum.BUSSINESS.getValue().equals(opentype)) {
                openTypeQFilter = new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.BusinessOpen.getVal() + "%")).or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.BidOpen.getVal() + "%")));
            } else if (BidOpenTypeEnum.MULTI.getValue().equals(opentype)) {
                openTypeQFilter = new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.BidOpen.getVal() + "%"));
            }
            qFilter.and(qFilter1).and(qFilter3).and(openTypeQFilter).toArray();
            DynamicObject leader = BusinessDataServiceHelper.loadSingle((String)"bid_leadermemberentity", (String)"id", (QFilter[])qFilter.toArray());
            QFilter memberQFilter = new QFilter("user", "=", (Object)Long.parseLong(userId));
            memberQFilter.and(qFilter1).and(openTypeQFilter);
            DynamicObject member = BusinessDataServiceHelper.loadSingle((String)"bid_memberentity", (String)"id", (QFilter[])memberQFilter.toArray());
            if (leader == null && member == null) {
                formShowParameter.setStatus(OperationStatus.VIEW);
            }
            this.getIsdirector(formShowParameter, userId, projectId, formId);
        } else if ("bid_bidevaluation".equals(formId) || "rebm_bidevaluation".equals(formId) || "bid_onlinebideval".equals(formId) || "rebm_onlinebideval".equals(formId) || "bid_onlinebideval_ex".equals(formId) || "rebm_onlinebideval_ex".equals(formId)) {
            long bidevaluator;
            String evaltype = dynamicObject.getString("evaltype");
            QFilter qFilter = new QFilter("user", "=", (Object)Long.parseLong(userId));
            QFilter qFilter1 = new QFilter("bidproject", "=", (Object)projectId);
            QFilter qFilter3 = new QFilter("isdirector", "=", (Object)"1");
            QFilter evalTypeQFilter = new QFilter("respbusiness", "in", new ArrayList());
            if (BidOpenTypeEnum.TECHNICAL.getValue().equals(evaltype)) {
                evalTypeQFilter = new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.TechnicalEval.getVal() + "%")).or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.BidEvaluation.getVal() + "%")));
            } else if (BidOpenTypeEnum.BUSSINESS.getValue().equals(evaltype)) {
                evalTypeQFilter = new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.BusinessEval.getVal() + "%")).or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.BidEvaluation.getVal() + "%")));
            } else if (BidOpenTypeEnum.MULTI.getValue().equals(evaltype)) {
                evalTypeQFilter = new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.BidEvaluation.getVal() + "%"));
            }
            qFilter.and(qFilter1).and(qFilter3).and(evalTypeQFilter).toArray();
            DynamicObject leader = BusinessDataServiceHelper.loadSingle((String)"bid_leadermemberentity", (String)"id", (QFilter[])qFilter.toArray());
            QFilter memberQFilter = new QFilter("user", "=", (Object)Long.parseLong(userId));
            memberQFilter.and(qFilter1).and(evalTypeQFilter);
            DynamicObject member = BusinessDataServiceHelper.loadSingle((String)"bid_memberentity", (String)"id", (QFilter[])memberQFilter.toArray());
            Boolean flag = Boolean.TRUE;
            if (("bid_onlinebideval".equals(formId) || "bid_onlinebideval_ex".equals(formId) || "rebm_onlinebideval".equals(formId) || "rebm_onlinebideval_ex".equals(formId)) && (bidevaluator = dynamicObject.getLong("bidevaluator.proficientname.id")) == Long.parseLong(userId)) {
                flag = Boolean.FALSE;
            }
            if (leader == null && member == null && flag.booleanValue()) {
                formShowParameter.setStatus(OperationStatus.VIEW);
            }
            this.getIsdirector(formShowParameter, userId, projectId, formId);
        } else {
            boolean isseparatedoc;
            OperationStatus status = formShowParameter.getStatus();
            boolean isRePublish_new = false;
            if (("bid_bidpublish".equals(formId) || "rebm_bidpublish".equals(formId)) && status.equals((Object)OperationStatus.ADDNEW)) {
                isRePublish_new = true;
            }
            QFilter qFilter = new QFilter("user", "=", (Object)Long.parseLong(userId));
            QFilter qFilter1 = new QFilter("bidproject", "=", (Object)projectId);
            QFilter qFilter2 = new QFilter("respbusiness", "like", (Object)("%" + this.getRespBusinessNo(formId) + "%"));
            if (("rebm_biddocument_edit".equals(formId) || "bid_biddocument_edit".equals(formId)) && (isseparatedoc = dynamicObject.getBoolean("isseparatedoc"))) {
                qFilter2 = new QFilter("respbusiness", "like", (Object)"%03%").or(new QFilter("respbusiness", "like", (Object)"%04%"));
            }
            QFilter qFilter3 = new QFilter("isdirector", "=", (Object)"1");
            qFilter.and(qFilter1).and(qFilter2).and(qFilter3);
            DynamicObject[] leaders = BusinessDataServiceHelper.load((String)"bid_leadermemberentity", (String)"entryid,bidproject,respbusiness,isdirector", (QFilter[])new QFilter[]{qFilter});
            QFilter qFilter4 = new QFilter("user", "=", (Object)Long.parseLong(userId));
            qFilter4.and(qFilter1).and(qFilter2);
            DynamicObject[] members = BusinessDataServiceHelper.load((String)"bid_memberentity", (String)"entryid,bidproject,respbusiness,isdirector", (QFilter[])new QFilter[]{qFilter4});
            if (!(leaders != null && leaders.length >= 1 || members != null && members.length >= 1)) {
                formShowParameter.setStatus(OperationStatus.VIEW);
            }
            QFilter qFilter5 = new QFilter("user", "=", (Object)Long.parseLong(userId));
            qFilter5.and(new QFilter("bidproject", "=", (Object)projectId)).and(new QFilter("isdirector", "=", (Object)"1"));
            DynamicObject[] isdirectorMembers = BusinessDataServiceHelper.load((String)"bid_memberentity", (String)"entryid,bidproject,respbusiness,isdirector", (QFilter[])new QFilter[]{qFilter5});
            if (isdirectorMembers.length > 0) {
                if (isRePublish_new) {
                    formShowParameter.setStatus(OperationStatus.ADDNEW);
                } else {
                    formShowParameter.setStatus(OperationStatus.EDIT);
                }
            }
        }
    }

    public void getIsdirector(FormShowParameter formShowParameter, String userId, long projectId, String formId) {
        QFilter qFilter5 = new QFilter("user", "=", (Object)Long.parseLong(userId));
        qFilter5.and(new QFilter("bidproject", "=", (Object)projectId)).and(new QFilter("isdirector", "=", (Object)"1"));
        DynamicObject[] isdirectorMembers = BusinessDataServiceHelper.load((String)"bid_memberentity", (String)"entryid,bidproject,respbusiness,isdirector", (QFilter[])new QFilter[]{qFilter5});
        if (isdirectorMembers.length > 0) {
            formShowParameter.setStatus(OperationStatus.EDIT);
        }
    }

    public String getRespBusinessNo(String formId) {
        String bizNo = "null";
        switch (formId) {
            case "bid_project": 
            case "rebm_project": {
                bizNo = "01";
                break;
            }
            case "bid_supplierinvitation": 
            case "rebm_supplierinvitation": {
                bizNo = "02";
                break;
            }
            case "bid_biddocument_edit": 
            case "bid_biddocument_history": 
            case "rebm_biddocument_edit": {
                bizNo = "09";
                break;
            }
            case "bid_bidpublish": 
            case "bid_bidpublish_history": 
            case "rebm_bidpublish": {
                bizNo = "05";
                break;
            }
            case "bid_answerquestion": 
            case "rebm_answerquestion": 
            case "bid_answerquestion_reco": 
            case "rebm_answerquestion_reco": {
                bizNo = "10";
                break;
            }
            case "bid_bidopen": 
            case "rebm_bidopen": {
                bizNo = "06";
                break;
            }
            case "bid_bidevaluation": 
            case "rebm_bidevaluation": {
                bizNo = "07";
                break;
            }
            case "bid_decision": 
            case "rebm_decision": {
                bizNo = "08";
                break;
            }
            case "bid_bustalk": 
            case "rebm_bustalk": {
                bizNo = "15";
                break;
            }
            case "bid_clarificaiton": 
            case "rebm_clarificaiton": {
                bizNo = "18";
                break;
            }
            case "bid_bottom_make": 
            case "rebm_bottom_make": {
                bizNo = "19";
                break;
            }
        }
        return bizNo;
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String customParam = (String)formShowParameter.getCustomParam("BidCenter");
        if (StringUtils.isNotEmpty((CharSequence)customParam) && "bar_close".equals(key)) {
            this.sendExitActionToParent();
        }
    }

    public void afterBindData(EventObject eventobject) {
        String customParam;
        OperationStatus status;
        super.afterBindData(eventobject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String BidCenterNewBid = (String)formShowParameter.getCustomParam("BidCenterNewBid");
        if (StringUtils.isNotEmpty((CharSequence)BidCenterNewBid) && OperationStatus.ADDNEW.equals((Object)(status = formShowParameter.getStatus())) && StringUtils.isEmpty((CharSequence)(customParam = this.getPageCache().get("first")))) {
            String orgId = (String)formShowParameter.getCustomParam("org");
            this.getModel().setValue("org", (Object)orgId);
            this.getModel().setValue("entrustmentorgunit", null);
            this.getModel().setDataChanged(false);
            this.getPageCache().put("first", "first");
        }
        String customParam2 = (String)formShowParameter.getCustomParam("BidCenter");
        String formId = formShowParameter.getFormId();
        if (StringUtils.isNotEmpty((CharSequence)customParam2)) {
            if ("bid_project".equals(formId) || this.getFormIdByApp("project", REBM_APPID).equals(formId)) {
                this.doBidProjectInSon();
            }
            IFormView parentView = this.getView().getParentView();
            parentView.setVisible(Boolean.TRUE, new String[]{"mainflexpanel"});
            this.getView().sendFormAction(parentView);
        }
        if ("bid_project".equals(formId) || this.getFormIdByApp("project", REBM_APPID).equals(formId)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            String datasource = dataEntity.getString("datasource");
            String billstatus = dataEntity.getString("billstatus");
            if ("2".equals(datasource) && "A".equals(billstatus)) {
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_del"});
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if (opResult != null && !opResult.isSuccess()) {
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String customParam = (String)formShowParameter.getCustomParam("BidCenter");
        if (StringUtils.isNotEmpty((CharSequence)customParam)) {
            String opKey;
            if ("close".equals(key) || "delete".equals(key) || "newdelete".equals(key)) {
                this.sendExitActionToParent();
                return;
            }
            String formId = formShowParameter.getFormId();
            String string = opKey = formShowParameter.getCustomParam("operateKey") == null ? this.FORMID_OPKEY_MAP.get(formId) : (String)formShowParameter.getCustomParam("operateKey");
            if (StringUtils.isNotEmpty((CharSequence)opKey) && ("submit".equals(key) || "unsubmit".equals(key) || "audit".equals(key) || "unaudit".equals(key) || "confirmpublish".equals(key) || "confirmopen".equals(key))) {
                this.getView().invokeOperation("refresh");
                this.sendRefreshActionToParent(opKey);
            }
            if ("bid_project".equals(formId) || this.getFormIdByApp("project", REBM_APPID).equals(formId)) {
                this.doBidProjectInSon();
            }
        }
    }

    public void sendExitActionToParent() {
        IFormView parentView = this.getView().getParentView();
        parentView.getModel().setValue("exitmark", (Object)Boolean.TRUE);
        this.getView().sendFormAction(parentView);
    }

    public void sendRefreshActionToParent(String opKey) {
        IFormView parentView = this.getView().getParentView();
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        parentView.getModel().setValue("refreshmark", (Object)(opKey + "#" + uuid));
        this.getView().sendFormAction(parentView);
    }

    public void doBidProjectInSon() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new"});
    }

    public String getFormIdByApp(String formTypeConstants, String appId) {
        if (BID_APPID.equals(appId)) {
            return "bid_" + formTypeConstants;
        }
        if (REBM_APPID.equals(appId)) {
            return "rebm_" + formTypeConstants;
        }
        return "bid_" + formTypeConstants;
    }
}

