/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.cancel;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.common.util.PermissionUtil;
import kd.scm.bid.common.util.ReWfUtil;

public class BidProjectCancelList
extends AbstractListPlugin {
    public static final Set<String> ENABLE_OP = new HashSet<String>(16);

    public void setFilter(SetFilterEvent e) {
        String bidProjectId = this.getView().getFormShowParameter().getCustomParam("bidproject").toString();
        List qFilters = e.getQFilters();
        if (StringUtils.isBlank((CharSequence)bidProjectId)) {
            return;
        }
        qFilters.add(new QFilter("bidproject", "=", (Object)Long.parseLong(bidProjectId)));
        this.getView().getPageCache().put("bidProjectId", bidProjectId);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String number;
        String billstatus;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (!ENABLE_OP.contains(operateKey)) {
            return;
        }
        ListSelectedRowCollection currentSelectedRowInfo = args.getListSelectedData();
        if (currentSelectedRowInfo == null || currentSelectedRowInfo.size() <= 0) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"BidProjectCancelList_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        Object primaryKeyValue = currentSelectedRowInfo.get(0).getPrimaryKeyValue();
        DynamicObject cancelDyn = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)(this.getAppId() + "_projectcancel"));
        String checkP = this.checkPermisstion(operateKey, cancelDyn);
        if (!StringUtils.isBlank((CharSequence)checkP)) {
            this.getView().showTipNotification(checkP);
            args.setCancel(true);
            return;
        }
        String cause = cancelDyn.getString("cause");
        if (StringUtils.isBlank((CharSequence)cause)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f5c\u5e9f\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u3002", (String)"BidProjectCancelList_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"submitandauti")) {
            boolean flag = ReWfUtil.hasEableProcess((String)(this.getAppId() + "_projectcancel"));
            if (flag) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u542f\u52a8\u5ba1\u6279\u6d41\uff0c\u65e0\u6cd5\u64cd\u4f5c\u63d0\u4ea4\u5e76\u5ba1\u6838\u3002", (String)"BidProjectCancelList_12", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String billstatus2 = cancelDyn.getString("billstatus");
            if (!"A".equals(billstatus2)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u63d0\u4ea4\u5e76\u5ba1\u6838\u3002", (String)"BidProjectCancelList_13", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if ((billstatus = cancelDyn.getString("billstatus")).equals("C")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5904\u4e8e\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01", (String)"BidProjectCancelList_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if (StringUtils.isBlank((CharSequence)(number = cancelDyn.getString("number")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f5c\u5e9f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u3002", (String)"BidProjectCancelList_14", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        this.getView().updateView();
    }

    public String checkPermisstion(String opkey, DynamicObject cancelDyn) {
        boolean haspermission;
        String appId = this.getAppId();
        Long orgId = (Long)cancelDyn.getDynamicObject("org").getPkValue();
        String entityName = "";
        if ("submit".equals(opkey) && !(haspermission = PermissionUtil.checkPermission((String)"QXX0009", (Long)orgId, (String)appId, (String)entityName))) {
            return ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u63d0\u4ea4\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BidProjectCancelList_15", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if ("delete".equals(opkey) && !(haspermission = PermissionUtil.checkPermission((String)"QXX0004", (Long)orgId, (String)appId, (String)entityName))) {
            return ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u5220\u9664\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BidProjectCancelList_16", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if ("audit".equals(opkey) && !(haspermission = PermissionUtil.checkPermission((String)"QXX0006", (Long)orgId, (String)appId, (String)entityName))) {
            return ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u5ba1\u6838\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BidProjectCancelList_17", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if ("submitandauti".equals(opkey) && !(haspermission = PermissionUtil.checkPermission((String)"CANEEL-OP", (Long)orgId, (String)appId, (String)entityName))) {
            return ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u63d0\u4ea4\u5e76\u5ba1\u6838\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BidProjectCancelList_18", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    public String getAppId() {
        return "bid";
    }

    static {
        ENABLE_OP.add("save");
        ENABLE_OP.add("submit");
        ENABLE_OP.add("audit");
        ENABLE_OP.add("submitandauti");
    }
}

