/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.clarify;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.scm.bid.business.bill.IQuestionClarifyService;
import kd.scm.bid.business.bill.serviceImpl.QuestionClarifyServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.ClarifyStatusEnum;
import kd.scm.bid.common.util.BidDarkUtil;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.ReWfUtil;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.formplugin.bill.util.PermissionUtils;
import kd.scm.bid.formplugin.bill.util.QuestionClarifyUtil;

public class MultipleChoiceQuestionClarifyEdit
extends AbstractBillPlugIn
implements CellClickListener,
BeforeF7SelectListener {
    protected final QuestionClarifyUtil questionClarifyUtil = new QuestionClarifyUtil();
    protected IQuestionClarifyService questionClarifyService = new QuestionClarifyServiceImpl();
    protected String ADD_SUPPLIER_ACTION_ID = "addsupplier";
    protected static final String BAR_SEND = "bar_send";
    protected static final String BAR_UNSUBMIT = "bar_unsubmit";
    protected static final String BAR_SAVE = "bar_save";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("multiclarifyentry");
        entryGrid.addCellClickListener((CellClickListener)this);
        entryGrid = (EntryGrid)this.getView().getControl("supplierentry");
        entryGrid.addCellClickListener((CellClickListener)this);
        BasedataEdit clarifysupplier = (BasedataEdit)this.getControl("clarifysupplier");
        clarifysupplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        OperationStatus status = showParameter.getStatus();
        DynamicObject dataModel = this.getModel().getDataEntity();
        String openType = (String)showParameter.getCustomParam("opentype");
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            Object bidPrjoctId = showParameter.getCustomParam("bidproject");
            this.getModel().setValue("bidproject", bidPrjoctId);
            this.getModel().setValue("clarifytype", (Object)openType);
            this.getModel().setValue("opentype", (Object)openType);
            if (showParameter.getCustomParam("org") != null) {
                DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)showParameter.getCustomParam("org").toString(), (String)"bos_org");
                this.getModel().setValue("org", (Object)org);
            }
            this.dealSection();
        } else {
            this.addSelectQuery();
        }
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        boolean checkboxfield = dataEntity.getBoolean("checkboxfield");
        if (checkboxfield && openType != null) {
            ComboEdit comboEdit = (ComboEdit)this.getView().getControl("clarifysupplier1");
            DynamicObject bidProject = dataModel.getDynamicObject("bidproject");
            this.questionClarifyUtil.setComboEditValuesByBidProjectId(this.getAppId(), comboEdit, bidProject, openType);
        }
        Map historyMap = null;
        if (showParameter.getCustomParam("historyMap") != null && (historyMap = (Map)showParameter.getCustomParam("historyMap")) != null && historyMap.size() > 0) {
            this.getModel().setValue("bidevaluationid", historyMap.get("bidevaluationid"));
            this.getModel().setValue("supplierinvitationid", historyMap.get("supplierinvitationid"));
            this.getModel().setValue("bidpublishid", historyMap.get("bidpublishid"));
            this.getModel().setValue("bidopenid", historyMap.get("bidopenid"));
        }
        this.getModel().setDataChanged(false);
    }

    public void addSelectQuery() {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObjectCollection bidsections = dataEntity.getDynamicObjectCollection("bidsection");
        for (DynamicObject next : bidsections) {
            DynamicObjectCollection supplierentry = next.getDynamicObjectCollection("supplierentry");
            Iterator entryIter = supplierentry.iterator();
            while (entryIter.hasNext()) {
                ((DynamicObject)entryIter.next()).set("promblerecord", (Object)ResManager.loadKDString((String)"\u67e5\u770b", (String)"MultipleChoiceQuestionClarifyEdit_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
        }
        this.getView().updateView("supplierentry");
        EntryGrid entryGrid = (EntryGrid)this.getControl("bidsection");
        entryGrid.selectRows(0, true);
        boolean aBoolean = this.getModel().getDataEntity(true).getDynamicObject("bidproject").getBoolean("enablemultisection");
        if (!aBoolean) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bidsection"});
            SplitContainer splitContainer = (SplitContainer)this.getControl("sectionsplitcontainer");
            splitContainer.changeFlexStatus(SplitDirection.left, true);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.controlBtnByPortalEnable();
        this.controlClarifyTypeCanEdit();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        String billstatus = dataEntity.getString("billstatus");
        if ("UNCLARIFIED".equals(billstatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"promblerecord", "qcbillstatus"});
        } else {
            String publicstatis = dataEntity.getString("publicstatis");
            if ("S".equals(publicstatis)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"promblerecord", "qcbillstatus"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"promblerecord", "qcbillstatus"});
            }
        }
        long bidOpenId = dataEntity.getLong("bidopenid");
        String openType = dataEntity.getString("opentype");
        boolean isDark = BidDarkUtil.isDarkEvaluation((String)this.getAppId(), (Object)bidOpenId, (String)openType);
        if (isDark) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconbaritemap4", "clarifysupplier"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconbaritemap2", "clarifysupdarkname"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        Set<Object> ids;
        OperationResult opResult;
        super.afterDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        if ("unsubmit".equals(operateKey) || "unaudit".equals(operateKey) || "submit".equals(operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("bidsection");
            entryGrid.selectRows(0, true);
        }
        if ((opResult = e.getOperationResult()) != null && !opResult.isSuccess()) {
            return;
        }
        if ("send".equals(operateKey)) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().invokeOperation("refresh");
        }
        if ("unsubmit".equals(operateKey)) {
            this.getView().setStatus(OperationStatus.EDIT);
        }
        if ("suppliernew".equals(operateKey)) {
            ids = this.addSupplier();
            if (ids != null && ids.size() > 0) {
                this.showBDSupplierForm(ids);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u5b58\u5728\u5f85\u6f84\u6e05\u95ee\u9898\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u65b0\u7684\u8d28\u7591\u3002", (String)"MultipleChoiceQuestionClarifyEdit_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if ("supplierdarknew".equals(operateKey)) {
            ids = this.addSupplier();
            if (ids != null && ids.size() > 0) {
                this.showDarkSupplierSelectFrom(ids);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u5b58\u5728\u5f85\u6f84\u6e05\u95ee\u9898\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u65b0\u7684\u8d28\u7591\u3002", (String)"MultipleChoiceQuestionClarifyEdit_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        this.controlBtnByPortalEnable();
        if ("unsend".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void showDarkSupplierSelectFrom(Set<Object> ids) {
        String formId = "";
        String appId = this.getAppId();
        FormShowParameter formShowParameter = new FormShowParameter();
        formId = "bid".equals(appId) ? "bid_clarydarksupselect" : "rebm_clarydarksupselect";
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long bidEvaluationId = dataEntity.getLong("bidevaluationid");
        DynamicObject curSectionEntry = this.getCurSectionEntry(dataEntity);
        String sectionName = curSectionEntry.getString("sectionname");
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("supplierIds", ids);
        formShowParameter.setCustomParam("bidEvaluationId", (Object)bidEvaluationId);
        formShowParameter.setCustomParam("appId", (Object)appId);
        formShowParameter.setCustomParam("sectionName", (Object)sectionName);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "darkSupplierAdd"));
        this.getView().showForm(formShowParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Set<Object> ids = this.addSupplier();
        if (ids == null || ids.size() <= 0) {
            beforeF7SelectEvent.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u5b58\u5728\u5f85\u6f84\u6e05\u95ee\u9898\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u65b0\u7684\u8d28\u7591\u3002", (String)"MultipleChoiceQuestionClarifyEdit_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter idFilter = new QFilter("id", "in", ids);
        qFilters.add(idFilter);
        showParameter.getListFilterParameter().setQFilters(qFilters);
        showParameter.setCustomParam("isIncludeBlack", (Object)Boolean.TRUE);
    }

    public String filterClarify() {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObject curSectionEntry = this.getCurSectionEntry(dataEntity);
        DynamicObject clarifytype = dataEntity.getDynamicObject("clarifytype");
        String formId = this.getAppId() + "_multiquestclarify";
        HashSet<String> statusSet = new HashSet<String>();
        statusSet.add("UNCLARIFIED");
        statusSet.add("A");
        QFilter statusQFilter = new QFilter("billstatus", "in", statusSet);
        QFilter projectFilter = new QFilter("bidproject", "=", dataEntity.getDynamicObject("bidproject").getPkValue());
        QFilter optype = new QFilter("clarifytype", "=", (Object)clarifytype);
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)formId, (String)"id,clarifysupplier", (QFilter[])new QFilter[]{statusQFilter, projectFilter, optype});
        return "";
    }

    public Set<Object> addSupplier() {
        HashSet<Object> ids = new HashSet<Object>();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObject curSectionEntry = this.getCurSectionEntry(dataEntity);
        String sectionName = curSectionEntry.getString("sectionname");
        DynamicObjectCollection supplierentry = curSectionEntry.getDynamicObjectCollection("supplierentry");
        Iterator supplierIter = supplierentry.iterator();
        HashSet<Object> existsIds = new HashSet<Object>();
        while (supplierIter.hasNext()) {
            DynamicObject supplierRow = (DynamicObject)supplierIter.next();
            try {
                if (supplierRow == null) continue;
                existsIds.add(supplierRow.getDynamicObject("clarifysupplier").getPkValue());
            }
            catch (Exception exception) {}
        }
        Object bidproject = dataEntity.getDynamicObject("bidproject").getPkValue();
        String appId = this.getAppId();
        String bidopenid = dataEntity.getString("bidopenid");
        DynamicObject bidevaluation = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(bidopenid), (String)(appId + "_bidopen"));
        DynamicObjectCollection bidsections = bidevaluation.getDynamicObjectCollection("bidsection");
        for (DynamicObject row : bidsections) {
            String bidOpSectionname = row.getString("sectionname");
            if (StringUtils.isBlank((CharSequence)bidOpSectionname)) {
                bidOpSectionname = ResManager.loadKDString((String)"\u6807\u6bb5\u4e00", (String)"MultipleChoiceQuestionClarifyEdit_2", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            }
            if (!sectionName.equals(bidOpSectionname)) continue;
            DynamicObjectCollection bidOpenSupplierEntry = row.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierRow : bidOpenSupplierEntry) {
                DynamicObject[] pkValue = supplierRow.getDynamicObject("supplier").getPkValue();
                int supplier_isinvalid = supplierRow.getBoolean("supplier_isinvalid");
                boolean supplier_istender = supplierRow.getBoolean("supplier_istender");
                if (!supplier_istender || supplier_isinvalid != 0 || existsIds.contains(pkValue)) continue;
                ids.add(pkValue);
            }
        }
        String clarifytype = dataEntity.getString("clarifytype");
        QFilter projectQfilter = new QFilter("bidproject", "=", bidproject);
        QFilter clarifyTypeFilter = new QFilter("clarifytype", "=", (Object)clarifytype);
        QFilter billStatusFilter = new QFilter("billstatus", "!=", (Object)"A");
        billStatusFilter = billStatusFilter.or(new QFilter("publicstatis", "!=", (Object)"S"));
        DynamicObject[] multiquestclarify = BusinessDataServiceHelper.load((String)(appId + "_multiquestclarify"), (String)"id,bidsection,bidsection.sectionname,bidsection.supplierentry,bidsection.supplierentry.clarifysupplier", (QFilter[])new QFilter[]{projectQfilter, clarifyTypeFilter, billStatusFilter});
        if (multiquestclarify != null && multiquestclarify.length > 0) {
            for (DynamicObject mult : multiquestclarify) {
                DynamicObject mulDb = BusinessDataServiceHelper.loadSingle((Object)mult.getPkValue(), (String)(appId + "_multiquestclarify"));
                DynamicObjectCollection multBids = mulDb.getDynamicObjectCollection("bidsection");
                for (DynamicObject multBid : multBids) {
                    if (!multBid.getString("sectionname").equals(sectionName) || mulDb.getString("billstatus").equals("INVALIDXX")) continue;
                    DynamicObjectCollection multSupplierEntry = multBid.getDynamicObjectCollection("supplierentry");
                    for (DynamicObject row : multSupplierEntry) {
                        if (row.getDynamicObject("clarifysupplier") == null) continue;
                        Object pkValue = row.getDynamicObject("clarifysupplier").getPkValue();
                        ids.remove(pkValue);
                    }
                }
            }
        }
        QFilter promstatus = new QFilter("billstatus", "=", (Object)ClarifyStatusEnum.UNCLARIFIED.getValue());
        DynamicObject[] latestDatas = BusinessDataServiceHelper.load((String)(appId + "_questionclarify"), (String)"id,clarifysupplier", (QFilter[])new QFilter[]{projectQfilter, clarifyTypeFilter, promstatus});
        if (latestDatas != null && latestDatas.length > 0) {
            for (DynamicObject row : latestDatas) {
                String pkValue;
                String clarifysupplierName = row.getString("clarifysupplier");
                String[] target = clarifysupplierName.split("&&");
                String csectionName = "";
                csectionName = target.length < 3 ? ResManager.loadKDString((String)"\u6807\u6bb5\u4e00", (String)"MultipleChoiceQuestionClarifyEdit_2", (String)"scm-bid-formplugin", (Object[])new Object[0]) : target[2];
                if (!StringUtils.equals((CharSequence)csectionName, (CharSequence)sectionName) || !ids.contains(Long.parseLong(pkValue = clarifysupplierName.split("&&")[0]))) continue;
                ids.remove(Long.parseLong(pkValue));
            }
        }
        return ids;
    }

    protected void showBDSupplierForm(Set<Object> pkids) {
        String formId = null;
        String appId = this.getAppId();
        formId = appId.equals("rebm") ? "resm_official_supplier" : "bd_supplier";
        ListShowParameter para = ShowFormHelper.createShowListForm((String)formId, (boolean)false);
        para.setShowUsed(true);
        para.setShowQuickFilter(true);
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (appId.equals("rebm")) {
            para.setCustomParam("selectorgId", org.getPkValue());
            if (pkids != null && pkids.size() > 0) {
                para.setCustomParam("isIncludeBlack", (Object)Boolean.TRUE);
            }
        } else {
            para.setCustomParam("groupStandard", (Object)"716529547008326656");
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("id", "in", pkids));
        para.getListFilterParameter().setQFilters(qFilters);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, this.ADD_SUPPLIER_ACTION_ID);
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)para);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null && this.ADD_SUPPLIER_ACTION_ID.equals(actionId)) {
            this.entryAddSupplier(closedCallBackEvent);
        } else if (returnData != null && "darkSupplierAdd".equals(actionId)) {
            this.entryAddSupplierDark(closedCallBackEvent);
        }
    }

    private void entryAddSupplierDark(ClosedCallBackEvent closedCallBackEvent) {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObject curSectionEntry = this.getCurSectionEntry(dataEntity);
        DynamicObjectCollection supplierentry = curSectionEntry.getDynamicObjectCollection("supplierentry");
        DynamicObject returnData = (DynamicObject)closedCallBackEvent.getReturnData();
        String supplierDarkName = returnData.getString("supplierdarkname");
        long supplierId = returnData.getLong("supplierid");
        DynamicObject supplier = null;
        supplier = this.getAppId().equals("bid") ? BusinessDataServiceHelper.loadSingle((Object)supplierId, (String)"bd_supplier") : BusinessDataServiceHelper.loadSingle((Object)supplierId, (String)"resm_official_supplier");
        DynamicObject supplierRow = supplierentry.addNew();
        supplierRow.set("clarifysupdarkname", (Object)supplierDarkName);
        supplierRow.set("clarifysupplier", (Object)supplier);
        this.getView().updateView("supplierentry");
    }

    public void entryAddSupplier(ClosedCallBackEvent closedCallBackEvent) {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObject curSectionEntry = this.getCurSectionEntry(dataEntity);
        DynamicObjectCollection supplierentry = curSectionEntry.getDynamicObjectCollection("supplierentry");
        ListSelectedRowCollection supplierList = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        Object primaryKeyValue = supplierList.get(0).getPrimaryKeyValue();
        DynamicObject supplier = null;
        supplier = this.getAppId().equals("rebm") ? BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"resm_official_supplier") : BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"bd_supplier");
        DynamicObject addNew = supplierentry.addNew();
        addNew.set("clarifysupplier", (Object)supplier);
        this.getView().updateView("supplierentry");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("send".equals(operateKey) || "unsubmit".equals(operateKey)) {
            boolean hasPermission;
            String openType;
            IDataModel model = this.getModel();
            DynamicObject bidProject = (DynamicObject)model.getValue("bidproject");
            Object bidprojectId = bidProject.getPkValue();
            String notification = this.questionClarifyUtil.checkBidEvalStatusCanSendOrUnSubmmit(bidprojectId, openType = (String)model.getValue("opentype"), operateKey);
            if (notification != null) {
                this.getView().showTipNotification(notification);
                args.setCancel(true);
                return;
            }
            DynamicObject org = bidProject.getDynamicObject("org");
            Long orgId = (Long)org.getPkValue();
            String appId = this.getView().getFormShowParameter().getServiceAppId();
            if (!"send".equals(operateKey) && "unsubmit".equals(operateKey) && !(hasPermission = PermissionUtils.checkPermission("QXX0010", orgId, appId, FormTypeConstants.getFormConstant((String)"multiquestclarify", ((Object)((Object)this)).getClass())))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u8d28\u7591/\u6f84\u6e05\u7684\u64a4\u9500\u6743\u9650\u3002", (String)"MultipleChoiceQuestionClarifyEdit_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if ("send".equals(operateKey) || "save".equals(operateKey) || "submit".equals(operateKey)) {
            if (!this.checkMulticlarifyEntry()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f85\u6f84\u6e05\u95ee\u9898\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MultipleChoiceQuestionClarifyEdit_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
            Object bidprojectId = bidProject.getPkValue();
            QFilter qTaotaiPro = new QFilter("bidproject", "=", bidprojectId);
            QFilter qTaotaiSta = new QFilter("billstatus", "!=", (Object)"C");
            boolean exists = QueryServiceHelper.exists((String)(this.getAppId() + "_supplierinvalid"), (QFilter[])new QFilter[]{qTaotaiPro, qTaotaiSta});
            if (exists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u6ca1\u6709\u5ba1\u6838\u5b8c\u6210\u7684\u4f9b\u5e94\u5546\u6dd8\u6c70\u5355\u636e\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"MultipleChoiceQuestionClarifyEdit_16", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if ("unaudit".equals(operateKey)) {
            boolean queryid;
            Object selectedCplAcceId = this.getView().getModel().getDataEntity(true).getPkValue();
            boolean isletter = this.getView().getModel().getDataEntity(true).getBoolean("isletter");
            if (isletter && (queryid = QueryServiceHelper.exists((String)this.getQueryLetter(), (QFilter[])new QFilter[]{new QFilter("queryid", "=", selectedCplAcceId)}))) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5173\u8054\u7684\u8d28\u7591\u51fd\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"MultipleChoiceQuestionClarifyEdit_17", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            String publicstatis = this.getView().getModel().getDataEntity(true).getString("publicstatis");
            if ("S".equals(publicstatis)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5904\u4e8e\u53d1\u5e03\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"MultipleChoiceQuestionClarifyEdit_18", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    public boolean checkMulticlarifyEntry() {
        boolean result = false;
        DynamicObjectCollection bidsections = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("bidsection");
        for (DynamicObject next : bidsections) {
            DynamicObjectCollection supplierentry = next.getDynamicObjectCollection("supplierentry");
            if (supplierentry.size() > 0) {
                result = true;
            }
            if (!result) continue;
            break;
        }
        return result;
    }

    public void cellClick(CellClickEvent arg0) {
        int row = arg0.getRow();
        if (row < 0) {
            return;
        }
        String itemName = arg0.getFieldKey();
        if ("promblerecord".equals(itemName)) {
            DynamicObject multiclarifyentry = this.getModel().getEntryRowEntity("supplierentry", row);
            BillShowParameter showParameter = new BillShowParameter();
            Object questclarifyid = multiclarifyentry.getDynamicObject("questclarifyid").getPkValue();
            String formId = this.getAppId() + "_questionclarify";
            showParameter.setFormId(formId);
            showParameter.setPkId(questclarifyid);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String appId;
        boolean enable;
        super.propertyChanged(e);
        ChangeData cd = e.getChangeSet()[0];
        Object newVal = cd.getNewValue();
        Object oldVal = cd.getOldValue();
        if (newVal != null && newVal.equals(oldVal)) {
            return;
        }
        String filedName = e.getProperty().getName();
        if (newVal != null && StringUtils.equals((CharSequence)filedName, (CharSequence)"clarifysupplier")) {
            DynamicObject clarifysupplier = (DynamicObject)newVal;
            int index = cd.getRowIndex();
            if (index == -1) {
                return;
            }
            DynamicObject dataModel = this.getModel().getDataEntity(true);
            DynamicObject bidProject = dataModel.getDynamicObject("bidproject");
            String openType = dataModel.getString("opentype");
            Boolean checkRepeatedSupplier = this.questionClarifyService.checkRepeatedSupplier(bidProject.getPkValue(), openType, clarifysupplier.getPkValue());
            long sourcebillid = dataModel.getLong("sourcebillid");
            if (sourcebillid != 0L && checkRepeatedSupplier.booleanValue()) {
                String appId2 = this.getModel().getDataEntityType().getAppId();
                long bidevaluationid = dataModel.getLong("bidevaluationid");
                QFilter qFilter = new QFilter("bidevaluationid", "=", (Object)bidevaluationid);
                qFilter.and("multiclarifyentry.clarifysupplier", "=", (Object)clarifysupplier.getPkValue().toString());
                qFilter.and("billstatus", "=", (Object)"UNCLARIFIED");
                DynamicObjectCollection questionclarifycoll = QueryServiceHelper.query((String)(appId2 + "_questionclarify"), (String)"id", (QFilter[])qFilter.toArray());
                if (questionclarifycoll.size() == 0) {
                    checkRepeatedSupplier = Boolean.FALSE;
                }
            }
            if (checkRepeatedSupplier.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4f9b\u5e94\u5546\u5b58\u5728\u5f85\u6f84\u6e05\u95ee\u9898\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u65b0\u7684\u6f84\u6e05\u3002", (String)"MultipleChoiceQuestionClarifyEdit_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("clarifysupplier", null);
                return;
            }
        }
        if (enable = SystemParamHelper.getSystemParameter((String)(appId = this.getModel().getDataEntityType().getAppId()), (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable")) {
            int compareTo;
            Date clarifydeadline;
            Boolean flag = newVal != null;
            if (flag.booleanValue() && StringUtils.equals((CharSequence)"clarifydeadline", (CharSequence)filedName)) {
                Date nowDate = new Date();
                int compareTo2 = nowDate.compareTo((Date)newVal);
                if (compareTo2 >= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6f84\u6e05\u622a\u6b62\u65f6\u95f4\u201d\u5fc5\u987b\u665a\u4e8e\u670d\u52a1\u5668\u5f53\u524d\u65f6\u95f4\u3002", (String)"MultipleChoiceQuestionClarifyEdit_8", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("clarifydeadline", null);
                    return;
                }
                Date initiationtime = (Date)this.getModel().getValue("initiationtime");
                if (initiationtime != null && (compareTo2 = initiationtime.compareTo((Date)newVal)) >= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6f84\u6e05\u622a\u6b62\u65f6\u95f4\u201d\u5fc5\u987b\u665a\u4e8e\u6f84\u6e05\u53d1\u8d77\u65f6\u95f4\u3002", (String)"MultipleChoiceQuestionClarifyEdit_9", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("clarifydeadline", null);
                    return;
                }
            } else if (flag.booleanValue() && StringUtils.equals((CharSequence)"initiationtime", (CharSequence)filedName) && (clarifydeadline = (Date)this.getModel().getValue("clarifydeadline")) != null && (compareTo = clarifydeadline.compareTo((Date)newVal)) <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6f84\u6e05\u53d1\u8d77\u65f6\u95f4\u201d\u5fc5\u987b\u65e9\u4e8e\u201c\u6f84\u6e05\u622a\u6b62\u65f6\u95f4\u201d\u3002", (String)"MultipleChoiceQuestionClarifyEdit_10", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("initiationtime", null);
                return;
            }
        }
    }

    public void controlBtnByPortalEnable() {
        Boolean isModifiable;
        CodeRuleInfo codeRule;
        String publicstatis;
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        String billstatus = dataEntity.getString("billstatus");
        boolean subAndAutiFlag = ReWfUtil.hasEableProcess((String)(this.getAppId() + "_projectcancel"));
        if (subAndAutiFlag) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"submitandauti"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"submitandauti"});
        }
        if (StringUtils.isBlank((CharSequence)billstatus) || "SAVED".equals(billstatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BAR_SAVE, "submit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"audit", "unaudit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"unsubmit"});
            this.getView().setEnable(Boolean.TRUE, new String[]{BAR_SAVE, "submit"});
            this.lockCompoiner(true);
        } else if (StringUtils.equals((CharSequence)billstatus, (CharSequence)"B")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SAVE});
            this.getView().setVisible(Boolean.TRUE, new String[]{"submit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"audit", "unaudit"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"unsubmit", "audit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"submit", "unaudit"});
            this.lockCompoiner(false);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SAVE});
            this.getView().setVisible(Boolean.FALSE, new String[]{"submit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"audit", "unaudit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"submit", "unsubmit", "audit"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"unaudit"});
            publicstatis = dataEntity.getString("publicstatis");
            if ("UNCLARIFIED".equals(billstatus) || "S".equals(publicstatis)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"audit", "unaudit"});
            }
            this.lockCompoiner(false);
        }
        if (StringUtils.equals((CharSequence)billstatus, (CharSequence)"A")) {
            publicstatis = dataEntity.getString("publicstatis");
            if (StringUtils.equals((CharSequence)"B", (CharSequence)publicstatis)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"sendpromeble"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"sendpromeble"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"unsend"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"sendpromeble"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"sendpromeble", "unsend"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"sendpromeble", "unsend"});
        }
        Object bidevaluationid = this.getView().getModel().getDataEntity(true).get("bidevaluationid");
        DynamicObject bidevaluation = BusinessDataServiceHelper.loadSingle((Object)bidevaluationid, (String)(this.getAppId() + "_bidevaluation"));
        String evaltype = bidevaluation.getString("evaltype");
        if (!"MULTI".equals(evaltype)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"clarifytype"});
        }
        if ((codeRule = CodeRuleServiceHelper.getCodeRule((String)(this.getAppId() + "_multiquestclarify"), (DynamicObject)dataEntity, null)) != null && !(isModifiable = codeRule.getIsModifiable()).booleanValue()) {
            this.getView().setEnable(isModifiable, new String[]{"billno"});
        }
    }

    public void lockCompoiner(boolean flag) {
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"clarifytheme", "clarifydeadline", "initiationtime", "creator", "clarifytype", "isletter"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"bidsection", "supplierentry"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"advconbaritemap4", "advconbaritemap5", "billno", "clarifytype"});
    }

    public void controlClarifyTypeCanEdit() {
        DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
        bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)(this.getAppId() + "_project"));
        String bidopentype = bidProject.getString("bidopentype");
        if (!StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.UNIONOPEN.getValue(), (CharSequence)bidopentype)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"clarifytype"});
        }
        String docType = bidProject.getString("doctype");
        if (BidOpenTypeEnum.BUSSINESS.getValue().equals(docType)) {
            this.getModel().setValue("clarifytype", (Object)docType);
            this.getView().setEnable(Boolean.FALSE, new String[]{"clarifytype"});
        }
    }

    public void dealSection() {
        String billstatus = this.getView().getModel().getDataEntity(true).getString("billstatus");
        if (!StringUtils.isBlank((CharSequence)billstatus) && !"SAVED".equals(billstatus)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("bidsection");
            entryGrid.selectRows(0, true);
            SplitContainer splitContainer = (SplitContainer)this.getControl("sectionsplitcontainer");
            splitContainer.changeFlexStatus(SplitDirection.left, true);
            return;
        }
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        String openType = dataEntity.getString("clarifytype");
        DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
        QFilter openTypeFilter = new QFilter("openType", "=", (Object)openType);
        QFilter enableFilter = new QFilter("billstatus", "not in", (Object)new String[]{"X", "XX", "J"});
        String formConstant = this.getAppId() + "_" + "bidopen";
        DynamicObject bidOpen = BusinessDataServiceHelper.loadSingle((String)formConstant, (String)"id,bidsection,bidsection.sectionname,supplierentry,supplierentry.supplier,supplierentry.supplier_istender,supplierentry.supplier_isinvalid", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), openTypeFilter, enableFilter});
        DynamicObjectCollection bidsections = dataEntity.getDynamicObjectCollection("bidsection");
        DynamicObjectCollection opSection = bidOpen.getDynamicObjectCollection("bidsection");
        int size = 0;
        for (DynamicObject sectionRow : opSection) {
            String sectionname = sectionRow.getString("sectionname");
            bidsections.addNew().set("sectionname", (Object)sectionname);
            ++size;
        }
        if (bidsections.size() == 1) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("bidsection");
            entryGrid.selectRows(0, true);
            this.getView().setVisible(Boolean.FALSE, new String[]{"bidsection"});
            SplitContainer splitRollContainer = (SplitContainer)this.getControl("sectionsplitcontainer");
            splitRollContainer.changeFlexStatus(SplitDirection.left, true);
        }
        this.getView().updateView("bidsection");
    }

    public void dealHistory() {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObjectCollection multiclarifyentry = dataEntity.getDynamicObjectCollection("multiclarifyentry");
        if (multiclarifyentry == null || multiclarifyentry.size() <= 0) {
            return;
        }
        DynamicObjectCollection bidsections = dataEntity.getDynamicObjectCollection("bidsection");
        if (bidsections.size() > 0) {
            return;
        }
        HashMap<String, DynamicObject> oldData = new HashMap<String, DynamicObject>();
        for (DynamicObject row : multiclarifyentry) {
            String clarifysupplier = row.getString("clarifysupplier1");
            oldData.put(clarifysupplier, row);
        }
        String openType = dataEntity.getString("clarifytype");
        DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
        QFilter openTypeFilter = new QFilter("openType", "=", (Object)openType);
        QFilter enableFilter = new QFilter("billstatus", "not in", (Object)new String[]{"X", "XX", "J"});
        String formConstant = this.getAppId() + "_" + "bidopen";
        DynamicObject bidOpen = BusinessDataServiceHelper.loadSingle((String)formConstant, (String)"id,bidsection,bidsection.sectionname,supplierentry,supplierentry.supplier,supplierentry.supplier_istender,supplierentry.supplier_isinvalid", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), openTypeFilter, enableFilter});
        DynamicObjectCollection opSection = bidOpen.getDynamicObjectCollection("bidsection");
        boolean aBoolean = this.getModel().getDataEntity(true).getDynamicObject("bidproject").getBoolean("enablemultisection");
        for (DynamicObject opSectionRow : opSection) {
            String sectionname = opSectionRow.getString("sectionname");
            if (StringUtils.isBlank((CharSequence)sectionname)) {
                sectionname = ResManager.loadKDString((String)"\u6807\u6bb5\u4e00", (String)"MultipleChoiceQuestionClarifyEdit_2", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            }
            DynamicObject newSectionRow = bidsections.addNew();
            newSectionRow.set("sectionname", (Object)sectionname);
            if (!aBoolean) {
                sectionname = "";
            }
            DynamicObjectCollection suppliereEntryColl = opSectionRow.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierentry : suppliereEntryColl) {
                DynamicObject supplier;
                Boolean istender = supplierentry.getBoolean("supplier_istender");
                Boolean isinvalid = supplierentry.getBoolean("supplier_isinvalid");
                if (!istender.booleanValue() || isinvalid.booleanValue() || (supplier = supplierentry.getDynamicObject("supplier")) == null) continue;
                String supplierName = supplier.getString("name");
                String supplierId = supplier.getPkValue().toString();
                String key = supplierId + "&&" + supplierName + "&&" + sectionname;
                DynamicObject oldDataRow = (DynamicObject)oldData.get(key);
                if (oldDataRow == null) continue;
                DynamicObjectCollection newSupplierEntry = newSectionRow.getDynamicObjectCollection("supplierentry");
                DynamicObject newSupplierRow = newSupplierEntry.addNew();
                newSupplierRow.set("clarifysupplier", (Object)supplier);
                newSupplierRow.set("questiondescription", (Object)oldDataRow.getString("questiondescription1"));
                newSupplierRow.set("resubmisstenders", oldDataRow.get("resubmisstenders1"));
                DynamicObjectCollection newAttachFiles = newSupplierRow.getDynamicObjectCollection("multiclarifyattach");
                DynamicObjectCollection oldAttachFiles = oldDataRow.getDynamicObjectCollection("multiclarifyattach");
                newAttachFiles.stream().forEach(item -> {
                    DynamicObject inviteAttach = oldAttachFiles.addNew();
                    inviteAttach.set("fbasedataid", (Object)item.getDynamicObject("fbasedataid"));
                });
                Object questclarifyid = oldDataRow.get("questclarifyidbak");
                if (questclarifyid == null) continue;
                newSupplierRow.set("questclarifyid", oldDataRow.get("questclarifyidbak"));
            }
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("bidsection");
        entryGrid.selectRows(0, true);
        if (!aBoolean) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bidsection"});
            SplitContainer splitContainer = (SplitContainer)this.getControl("sectionsplitcontainer");
            splitContainer.changeFlexStatus(SplitDirection.left, true);
        }
        this.getView().updateView("bidsection");
        this.getView().updateView("supplierentry");
    }

    public String getAppId() {
        String appName = this.getView().getFormShowParameter().getServiceAppId();
        return appName;
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }

    protected DynamicObject getCurSectionEntry(DynamicObject dataEntity) {
        EntryGrid grid = (EntryGrid)this.getControl("bidsection");
        DynamicObjectCollection sectionEntry = dataEntity.getDynamicObjectCollection("bidsection");
        if (sectionEntry.size() == 1) {
            return (DynamicObject)sectionEntry.get(0);
        }
        int focusRow = grid.getEntryState().getFocusRow();
        if (focusRow <= 0) {
            focusRow = 0;
        }
        return (DynamicObject)sectionEntry.get(focusRow);
    }

    public String getQueryLetter() {
        if (this.getAppId().equals("bid")) {
            return "bid_query_letters";
        }
        return "rebm_query_letters_inh";
    }

    public void printClassInfo() {
    }
}

