/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.clarify.letter;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.metadata.form.control.RichTextEditorAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.scm.bid.common.constant.bill.BidTemplateConstant;
import kd.scm.bid.common.constant.bill.OptionalColumnConstant;
import kd.scm.bid.common.enums.BidProjectEnum;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.ReWfUtil;
import kd.scm.bid.formplugin.bill.helper.TemplateManageHelper;
import kd.scm.bid.formplugin.bill.util.DateUtils;

public class BidQueryLetterPlugin
extends AbstractBillPlugIn
implements UploadListener,
BeforeF7SelectListener {
    private static String ATTACHE_TAG = "atta";
    private static String RICHTEXT_TAG = "queryrich";
    private static String SEND_BUTTON = "send";
    private static String PREVIEW_BUTTON = "preview";
    private static String TEMPLATE_MANAGE = "mdelbasedata";
    private static String SUPPLIERTAB = "suppliertab";
    private static String NEXT = "next";
    private static String PREVIOUS = "previous";
    private static final Set<String> ENABLE_OP = new HashSet<String>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit mdelbasedata = (BasedataEdit)this.getView().getControl(TEMPLATE_MANAGE);
        mdelbasedata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObjectCollection bidsections = dataEntity.getDynamicObjectCollection("bidsection");
        for (DynamicObject bidNext : bidsections) {
            String bidSectionName = bidNext.getString("sectionname");
            DynamicObjectCollection supplierentry = bidNext.getDynamicObjectCollection("supplierentry");
            for (DynamicObject suppluerRow : supplierentry) {
                DynamicObject supplier = suppluerRow.getDynamicObject("supplier");
                if (supplier == null) continue;
                String attaKey = this.appendStr(ATTACHE_TAG, supplier.getPkValue().toString(), bidSectionName);
                AttachmentPanel panel = (AttachmentPanel)this.getView().getControl(attaKey);
                if (panel == null) continue;
                panel.addUploadListener((UploadListener)this);
            }
        }
        AttachmentPanel atta = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        atta.addUploadListener((UploadListener)this);
    }

    public void beforeBindData(EventObject e) {
        Object queryid = this.getView().getFormShowParameter().getCustomParam("queryid");
        Object newData = this.getView().getFormShowParameter().getCustomParam("newData");
        if (queryid == null || newData == null) {
            return;
        }
        if ("oldData".equals(newData.toString())) {
            return;
        }
        this.setValue();
    }

    public boolean isMulSection() {
        return this.getModel().getDataEntity(true).getDynamicObject("bidproject").getBoolean("enablemultisection");
    }

    public void afterBindData(EventObject e) {
        String newData = "";
        if (this.getView().getFormShowParameter().getCustomParam("newData") != null) {
            newData = this.getView().getFormShowParameter().getCustomParam("newData").toString();
        }
        if ("newData".equals(newData)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_audit"});
        } else {
            DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
            String billstatus = this.getView().getModel().getDataEntity(true).getString("status");
            boolean visiFlag = StringUtils.isBlank((CharSequence)billstatus) || billstatus.equals("A");
            DynamicObjectCollection bidsection = dataEntity.getDynamicObjectCollection("bidsection");
            Iterator bidsections = bidsection.iterator();
            boolean flag = this.isMulSection();
            while (bidsections.hasNext()) {
                DynamicObject bidRow = (DynamicObject)bidsections.next();
                String sectionname = bidRow.getString("sectionname");
                String needSectionName = flag ? sectionname : "";
                DynamicObjectCollection supplierentry = bidRow.getDynamicObjectCollection("supplierentry");
                for (DynamicObject row : supplierentry) {
                    DynamicObject supplier = row.getDynamicObject("supplier");
                    String content = row.getString("content");
                    String contenTag = row.getString("content_tag");
                    if (!StringUtils.isBlank((CharSequence)contenTag)) {
                        content = contenTag;
                    }
                    String richContentKey = this.appendStr(RICHTEXT_TAG, supplier.getPkValue().toString(), needSectionName);
                    if (this.getView().getControl(richContentKey) != null) {
                        RichTextEditor richContent = (RichTextEditor)this.getView().getControl(richContentKey);
                        richContent.setText(content);
                        this.getView().updateView(richContentKey);
                    }
                    String attaKey = this.appendStr(ATTACHE_TAG, supplier.getPkValue().toString(), needSectionName);
                    AttachmentPanel panel = (AttachmentPanel)this.getView().getControl(attaKey);
                    panel.setKey(attaKey);
                    panel.setDefaultCollapse(false);
                    this.getView().updateView(attaKey);
                    if (visiFlag) continue;
                    this.visiablePanel(attaKey, visiFlag);
                }
            }
            this.getView().updateView("bidsection");
            this.getView().updateView("supplierentry");
        }
        this.visiableAnn();
    }

    public void visiableAnn() {
        CodeRuleInfo codeRule;
        boolean isNotNullCode;
        boolean subAndAutiFlag = ReWfUtil.hasEableProcess((String)(this.getAppId() + "_projectcancel"));
        if (subAndAutiFlag) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"submitandauti"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"submitandauti"});
        }
        String billstatus = this.getView().getModel().getDataEntity(true).getString("status");
        if (StringUtils.isBlank((CharSequence)billstatus) || "A".equals(billstatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_audit"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"bar_save", "bar_submit", "submitandauti"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_submit", "submitandauti"});
            if (subAndAutiFlag) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"submitandauti"});
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"unsubmit"});
            this.componseEnable(true);
        } else if (StringUtils.equals((CharSequence)billstatus, (CharSequence)"B")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_submit", "submitandauti"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_audit", "bar_submit", "submitandauti"});
            if (subAndAutiFlag) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"submitandauti"});
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{"unsubmit"});
            this.componseEnable(false);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit", "bar_audit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_submit  ", "submitandauti", "unsubmit", "bar_audit"});
            this.componseEnable(false);
        }
        String appId = this.getAppId();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        String number = dataEntity.getString("number");
        String formId = "bid_query_letters";
        if (StringUtils.equals((CharSequence)"rebm", (CharSequence)appId)) {
            formId = "rebm_query_letters_inh";
        }
        boolean bl = isNotNullCode = (codeRule = CodeRuleServiceHelper.getCodeRule((String)formId, (DynamicObject)dataEntity, null)) != null;
        if (StringUtils.isBlank((CharSequence)number) && isNotNullCode) {
            number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)dataEntity);
            dataEntity.set("number", (Object)number);
            this.getView().updateView("number");
        }
        if ((StringUtils.isBlank((CharSequence)billstatus) || "A".equals(billstatus)) && isNotNullCode) {
            Boolean isModifiable = codeRule.getIsModifiable();
            this.getView().setEnable(isModifiable, new String[]{"number"});
        }
    }

    private void componseEnable(boolean flag) {
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"number", "name", "mdelbasedata", "publishdate", "publicman"});
        this.visiablePanel("attachmentpanelap", flag);
    }

    public void visiablePanel(String key, boolean flag) {
        AttachmentPanel panel = (AttachmentPanel)this.getControl(key);
        List attachmentData = panel.getAttachmentData();
        if (attachmentData == null || attachmentData.isEmpty()) {
            return;
        }
        char visiable = '0';
        if (flag) {
            visiable = '1';
        }
        for (Map attachmentMap : attachmentData) {
            StringBuilder builder = new StringBuilder();
            char visiablePreview = visiable;
            char visiableDownload = '1';
            char visiableDelete = visiable;
            char visiableRename = visiable;
            builder.append(visiablePreview).append(visiableDownload).append(visiableDelete).append(visiableRename);
            attachmentMap.put("visible", builder.toString());
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.setEntryProperty(key, "data", (Object)attachmentData);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        QFilter fproject;
        String formId;
        String status;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"unsubmit", (CharSequence)operateKey) && StringUtils.equals((CharSequence)(status = this.getView().getModel().getDataEntity(true).getString("status")), (CharSequence)"C")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5904\u4e8e\u5ba1\u6838\u72b6\u6001\u4e0d\u80fd\u64a4\u9500\u3002", (String)"BidQueryLetterPlugin_15", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (!ENABLE_OP.contains(operateKey)) {
            return;
        }
        if ("submitandauti".equals(operateKey)) {
            formId = "";
            formId = "bid".equals(this.getAppId()) ? "bid_query_letters" : "rebm_query_letters_inh";
            if (ReWfUtil.hasEableProcess((String)formId)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u542f\u52a8\u5de5\u4f5c\u6d41\uff0c\u4e0d\u80fd\u8fdb\u884c\u63d0\u4ea4\u5e76\u5ba1\u6838\u7684\u64cd\u4f5c\u3002", (String)"BidQueryLetterPlugin_16", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        formId = "";
        formId = this.getAppId().equals("bid") ? "bid_query_letters" : "rebm_query_letters_inh";
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        String pkValue = dataEntity.getPkValue().toString();
        QFilter fname = new QFilter("name", "=", (Object)dataEntity.getString("name"));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)formId, (String)"id", (QFilter[])new QFilter[]{fname, fproject = new QFilter("bidproject", "=", dataEntity.getDynamicObject("bidproject").getPkValue())});
        if (load != null && load.length > 0) {
            if (StringUtils.isBlank((CharSequence)pkValue)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u62db\u6807\u5b58\u5728\u91cd\u590d\u7684\u8d28\u7591\u51fd\u6807\u9898\u3002", (String)"BidQueryLetterPlugin_17", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            for (DynamicObject idRow : load) {
                if (idRow.getPkValue().toString().equals(pkValue)) continue;
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u62db\u6807\u5b58\u5728\u91cd\u590d\u7684\u8d28\u7591\u51fd\u6807\u9898\u3002", (String)"BidQueryLetterPlugin_17", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        Date publishdate = dataEntity.getDate("publishdate");
        Date deadlinedate = dataEntity.getDate("endtime");
        if (deadlinedate.compareTo(publishdate) < 0) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u65f6\u95f4\u5927\u4e8e\u622a\u6b62\u65f6\u95f4\u3002", (String)"BidQueryLetterPlugin_18", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"submitandauti")) {
            boolean flag = ReWfUtil.hasEableProcess((String)(this.getAppId() + "_projectcancel"));
            if (flag) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u542f\u52a8\u5ba1\u6279\u6d41\uff0c\u65e0\u6cd5\u64cd\u4f5c\u63d0\u4ea4\u5e76\u5ba1\u6838\u3002", (String)"BidQueryLetterPlugin_19", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String billstatus = dataEntity.getString("status");
            if (!billstatus.equals("A")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u6682\u5b58\u72b6\u6001\u65e0\u6cd5\u8fdb\u884c\u63d0\u4ea4\u5e76\u5ba1\u6838\u3002", (String)"BidQueryLetterPlugin_20", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if ("unaudit".equals(operateKey)) {
            String queryid = this.getView().getFormShowParameter().getCustomParam("queryid").toString();
            DynamicObject multiquestclarify = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(queryid), (String)(this.getAppId() + "_multiquestclarify"));
            String billstatus = multiquestclarify.getString("billstatus");
            String publicstatis = multiquestclarify.getString("publicstatis");
            if ("S".equals(publicstatis)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u53d1\u5e03\u8d28\u7591\u6f84\u6e05\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidQueryLetterPlugin_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"save") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit") || "submitandauti".equals(operateKey)) {
            DynamicObjectCollection bidsections = dataEntity.getDynamicObjectCollection("bidsection");
            Iterator bidIter = bidsections.iterator();
            boolean aBoolean = dataEntity.getDynamicObject("bidproject").getBoolean("enablemultisection");
            while (bidIter.hasNext()) {
                DynamicObject bidNext = (DynamicObject)bidIter.next();
                String bidSectionName = bidNext.getString("sectionname");
                DynamicObjectCollection supplierentry = bidNext.getDynamicObjectCollection("supplierentry");
                for (DynamicObject suppluerRow : supplierentry) {
                    DynamicObject supplier = suppluerRow.getDynamicObject("supplier");
                    String richContentKey = "";
                    richContentKey = aBoolean ? this.appendStr(RICHTEXT_TAG, supplier.getPkValue().toString(), bidSectionName) : this.appendStr(RICHTEXT_TAG, supplier.getPkValue().toString());
                    RichTextEditor richText = (RichTextEditor)this.getView().getControl(richContentKey);
                    if (richText == null) continue;
                    String contentStr = richText.getText();
                    if (StringUtils.isBlank((CharSequence)contentStr)) {
                        return;
                    }
                    if (contentStr.length() > 200) {
                        suppluerRow.set("content", (Object)contentStr.substring(0, 200));
                    } else {
                        suppluerRow.set("content", (Object)contentStr);
                    }
                    suppluerRow.set("content_tag", (Object)contentStr);
                }
                this.getView().updateView("bidsection");
                this.getView().updateView("supplierentry");
            }
        }
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String args = e.getEventArgs();
        String key = e.getKey();
        this.getView().getPageCache().put(key, args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        this.visiableAnn();
        FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = formOperate.getOperateKey();
        if (afterDoOperationEventArgs.getOperationResult() != null && !afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
    }

    public void upload(UploadEvent evt) {
    }

    public void remove(UploadEvent evt) {
    }

    public void holdRichContent() {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
            return;
        }
        IDataEntityProperty pro = e.getProperty();
        String filedName = pro.getName();
        if (StringUtils.equals((CharSequence)filedName, (CharSequence)TEMPLATE_MANAGE)) {
            ChangeData[] datas = e.getChangeSet();
            ChangeData data = datas[0];
            Object newValue = data.getNewValue();
            if (newValue == null) {
                return;
            }
            if (data.getOldValue() == null && this.getQueryPkId(this.getView().getFormShowParameter()) != null) {
                return;
            }
            DynamicObject template = (DynamicObject)newValue;
            String templateContent = template.getString("content");
            StringBuilder buffer = new StringBuilder();
            buffer.append(templateContent);
            this.getNewContent(buffer);
        } else if (StringUtils.equals((CharSequence)filedName, (CharSequence)"name")) {
            String newLocal;
            ChangeData[] datas = e.getChangeSet();
            ChangeData data = datas[0];
            if (data.getNewValue() == null || data.getOldValue() == null) {
                return;
            }
            if (((LocaleDynamicObjectCollection)data.getOldValue()).size() <= 0 || ((LocaleDynamicObjectCollection)data.getNewValue()).size() <= 0) {
                return;
            }
            String oldLocal = ((DynamicObject)((LocaleDynamicObjectCollection)data.getOldValue()).get(0)).get(2).toString();
            if (oldLocal.equals(newLocal = ((DynamicObject)((LocaleDynamicObjectCollection)data.getNewValue()).get(0)).get(2).toString())) {
                return;
            }
            this.replaceName(oldLocal, newLocal);
        }
    }

    private Object getQueryPkId(FormShowParameter formShowParameter) {
        BillShowParameter billShowParameter = (BillShowParameter)formShowParameter;
        Object invitationId = billShowParameter.getPkId();
        return invitationId;
    }

    private void getNewContent(StringBuilder content) {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObject bidproject = dataEntity.getDynamicObject("bidproject");
        bidproject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(bidproject.getPkValue().toString()), (String)this.getProjectFormId());
        DynamicObjectCollection bidsection = dataEntity.getDynamicObjectCollection("bidsection");
        Iterator bidsections = bidsection.iterator();
        boolean flag = this.isMulSection();
        while (bidsections.hasNext()) {
            DynamicObject bidRow = (DynamicObject)bidsections.next();
            String sectionname = bidRow.getString("sectionname");
            String needSectionName = flag ? sectionname : "";
            DynamicObjectCollection supplierentry = bidRow.getDynamicObjectCollection("supplierentry");
            for (DynamicObject row : supplierentry) {
                DynamicObject supplier = row.getDynamicObject("supplier");
                this.updateContent(bidproject, supplier, content, row, needSectionName);
            }
        }
        this.getView().updateView("bidsection");
        this.getView().updateView("supplierentry");
    }

    private void updateContent(DynamicObject bidProject, DynamicObject supplier, StringBuilder content, DynamicObject row, String bidNametion) {
        String contentStr = "";
        String richContentKey = this.appendStr(RICHTEXT_TAG, supplier.getPkValue().toString(), bidNametion);
        if (!StringUtils.isEmpty((CharSequence)content)) {
            contentStr = this.replaceContent(bidProject, supplier, new String(content));
            if (this.getView().getControl(richContentKey) != null) {
                ((RichTextEditor)this.getView().getControl(richContentKey)).setText(contentStr);
                this.getView().updateView(richContentKey);
                String deadlinedateStr = this.getView().getModel().getDataEntity(true).getString("endtime");
                contentStr = this.replaceDeadLineDate(contentStr, null, deadlinedateStr);
                if (this.getView().getControl(richContentKey) != null) {
                    ((RichTextEditor)this.getView().getControl(richContentKey)).setText(contentStr);
                    this.getView().updateView(richContentKey);
                }
            }
        }
        if (contentStr.length() > 200) {
            row.set("content", (Object)contentStr.substring(0, 200));
        } else {
            row.set("content", (Object)contentStr);
        }
        row.set("content_tag", (Object)contentStr);
    }

    public void setValue() {
        String queryid = this.getView().getFormShowParameter().getCustomParam("queryid").toString();
        DynamicObject queryF7 = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(queryid), (String)this.getRecordF7FormId());
        DynamicObject queryRecord = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(queryid), (String)this.getRecordFormId());
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObjectCollection bidsection1 = dataEntity.getDynamicObjectCollection("bidsection");
        if (bidsection1 != null && bidsection1.size() > 0) {
            return;
        }
        DynamicObject bos_user = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
        dataEntity.set("publicman", (Object)bos_user);
        dataEntity.set("endtime", queryRecord.get("clarifydeadline"));
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("clarytype");
        ArrayList<ComboItem> modelItems = new ArrayList<ComboItem>();
        String value = queryRecord.getString("clarifytype");
        LocaleString caption = new LocaleString(this.getCaption(value));
        ComboItem item = new ComboItem(caption, value);
        modelItems.add(item);
        comboEdit.setComboItems(modelItems);
        dataEntity.set("clarytype", (Object)value);
        this.getView().updateView("clarytype");
        dataEntity.set("queryid", (Object)queryF7);
        String bidproject = (String)this.getView().getFormShowParameter().getCustomParam("bidproject");
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(bidproject), (String)this.getProjectFormId());
        dataEntity.set("bidproject", (Object)project);
        dataEntity.set("org", (Object)project.getDynamicObject("org"));
        DynamicObjectCollection newDidsections = dataEntity.getDynamicObjectCollection("bidsection");
        DynamicObjectCollection bidsections = queryRecord.getDynamicObjectCollection("bidsection");
        for (DynamicObject bidsection : bidsections) {
            DynamicObject newBidSectionRow = newDidsections.addNew();
            newBidSectionRow.set("sectionname", (Object)bidsection.getString("sectionname"));
            DynamicObjectCollection querySupplierEntity = bidsection.getDynamicObjectCollection("supplierentry");
            Iterator supplierIter = querySupplierEntity.iterator();
            DynamicObjectCollection supplierentry = newBidSectionRow.getDynamicObjectCollection("supplierentry");
            while (supplierIter.hasNext()) {
                DynamicObject entity = (DynamicObject)supplierIter.next();
                DynamicObject supplier = entity.getDynamicObject("clarifysupplier");
                DynamicObject addNew = supplierentry.addNew();
                addNew.set("supplier", (Object)supplier);
            }
        }
        this.getView().updateView("bidsection");
        this.getView().updateView("supplierentry");
    }

    public String getCaption(String value) {
        if ("TECHNICAL".equals(value)) {
            return ResManager.loadKDString((String)"\u6280\u672f\u6807", (String)"BidQueryLetterPlugin_5", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if ("BUSSINESS".equals(value)) {
            return ResManager.loadKDString((String)"\u5546\u52a1\u6807", (String)"BidQueryLetterPlugin_6", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        if ("MULTI".equals(value)) {
            return ResManager.loadKDString((String)"\u6280\u672f\u6807\u548c\u5546\u52a1\u6807", (String)"BidQueryLetterPlugin_7", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u4e0d\u9650", (String)"BidQueryLetterPlugin_8", (String)"scm-bid-formplugin", (Object[])new Object[0]);
    }

    public String getAppId() {
        return "bid";
    }

    public String getRecordF7FormId() {
        if (this.getAppId().equals("rebm")) {
            return "rebm_multiquestclarifyf7";
        }
        return this.getAppId() + "_multiquestclarify_f7";
    }

    public String getRecordFormId() {
        return this.getAppId() + "_multiquestclarify";
    }

    public String getProjectFormId() {
        if (this.getAppId().equals("bid")) {
            return "bidproject_f7";
        }
        return this.getAppId() + "_bidproject_f7";
    }

    public void beforeF7Select(BeforeF7SelectEvent paramBeforeF7SelectEvent) {
        String fieldKey = paramBeforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"mdelbasedata")) {
            String name = this.getView().getModel().getDataEntity(true).getString("name");
            if (StringUtils.isBlank((CharSequence)name)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8d28\u7591\u51fd\u6807\u9898\u3002", (String)"BidQueryLetterPlugin_21", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                paramBeforeF7SelectEvent.setCancel(true);
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)paramBeforeF7SelectEvent.getFormShowParameter();
            DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
            Set orgIds = OrgUnitHelper.getParentOrgUnitSet((Long)bidProject.getLong("org.id"));
            QFilter qFilter = new QFilter("org", "in", (Object)orgIds);
            DynamicObject[] load = BusinessDataServiceHelper.load((String)(this.getAppId() + "_templatetype"), (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)ResManager.loadKDString((String)"\u8d28\u7591\u51fd", (String)"BidQueryLetterPlugin_12", (String)"scm-bid-formplugin", (Object[])new Object[0]))});
            QFilter typeFilter = new QFilter("type", "=", load[0].getPkValue());
            ArrayList<QFilter> lists = new ArrayList<QFilter>();
            lists.add(qFilter);
            lists.add(typeFilter);
            showParameter.getListFilterParameter().setQFilters(lists);
            showParameter.setCustomParam("modelType", (Object)"query");
        }
    }

    private Map<String, Object> getMapHead(Map<String, List<DynamicObject>> bidSupplier, boolean aboolean) {
        TabAp tab = this.createDynamicTabAp(bidSupplier, aboolean);
        HashMap<String, Object> mapHead = new HashMap<String, Object>();
        mapHead.put("id", SUPPLIERTAB);
        mapHead.put("items", tab.createControl().get("items"));
        return mapHead;
    }

    private TabAp createDynamicTabAp(Map<String, List<DynamicObject>> bidSupplier, boolean aboolean) {
        TabAp tab = new TabAp();
        tab.setKey(SUPPLIERTAB + "section");
        boolean flag = aboolean;
        Set<Map.Entry<String, List<DynamicObject>>> entries = bidSupplier.entrySet();
        for (Map.Entry<String, List<DynamicObject>> entry : entries) {
            List<DynamicObject> listSuppliers = entry.getValue();
            String sectionName = entry.getKey();
            String needSectionName = flag ? sectionName : "";
            for (int i = 0; i < listSuppliers.size(); ++i) {
                DynamicObject supplier = listSuppliers.get(i);
                TabPageAp tpa = this.createTabPageAp(supplier, needSectionName);
                tab.getItems().add(tpa);
            }
        }
        return tab;
    }

    private TabPageAp createTabPageAp(DynamicObject supplier, String sectionName) {
        String supplierId = supplier.getString("id") + sectionName;
        String supplierName = supplier.getString("name") + sectionName;
        TabPageAp tpa = new TabPageAp();
        tpa.setKey(supplierId);
        tpa.setId(supplierId);
        tpa.setName(new LocaleString(supplierName));
        RichTextEditorAp richTextAp = new RichTextEditorAp();
        String richKey = RICHTEXT_TAG + supplierId;
        richTextAp.setId(richKey);
        richTextAp.setKey(richKey);
        richTextAp.setName(new LocaleString(supplierName));
        richTextAp.setLock("view");
        richTextAp.setHeight(new LocaleString("400px"));
        richTextAp.setAutoSave(true);
        tpa.getItems().add(richTextAp);
        AttachmentPanelAp attaAp = new AttachmentPanelAp();
        String attaKey = ATTACHE_TAG + supplierId;
        attaAp.setId(attaKey);
        attaAp.setKey(attaKey);
        attaAp.setLock("view");
        attaAp.setCollapsible(true);
        attaAp.setName(new LocaleString(ResManager.loadKDString((String)"\u4e13\u5c5e\u9644\u4ef6", (String)"BidQueryLetterPlugin_10", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        Style style = new Style();
        Margin margin = new Margin();
        margin.setTop("50px");
        style.setMargin(margin);
        attaAp.setStyle(style);
        Tips ctlTips = new Tips();
        ctlTips.setContent(new LocaleString(ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20\u540e\u4f1a\u663e\u793a\u5230\u9009\u4e2d\u4f9b\u5e94\u5546\u7684\u8d28\u7591\u51fd\u4e2d\u3002", (String)"BidQueryLetterPlugin_22", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        ctlTips.setTriggerType("hover");
        ctlTips.setType("text");
        ctlTips.setShowIcon(true);
        attaAp.setCtlTips(ctlTips);
        tpa.getItems().add(attaAp);
        return tpa;
    }

    private String replaceContent(DynamicObject bidProject, DynamicObject supplier, String content) {
        String supplierName = supplier.getString("name");
        String projectName = bidProject.getString("name");
        String title = this.getModel().getDataEntity().getString("name");
        String orgName = bidProject.getDynamicObject("org").getString("name");
        String clarifyType = this.getModel().getDataEntity().getString("clarytype");
        clarifyType = clarifyType.equals("MULTI") ? ResManager.loadKDString((String)"\u6280\u672f\u6807\u548c\u5546\u52a1\u6807", (String)"BidQueryLetterPlugin_7", (String)"scm-bid-formplugin", (Object[])new Object[0]) : (clarifyType.equals("TECHNICAL") ? ResManager.loadKDString((String)"\u6280\u672f\u6807", (String)"BidQueryLetterPlugin_5", (String)"scm-bid-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5546\u52a1\u6807", (String)"BidQueryLetterPlugin_6", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        DynamicObject contact = bidProject.getDynamicObject("contact");
        String contactName = contact == null ? "" : contact.getString("name");
        Date date = this.getView().getModel().getDataEntity(true).getDate("endtime");
        String dataStr = DateUtils.date2StringSimpleOrDetail(date, Boolean.FALSE);
        String contacttel = bidProject.getString("contacttel");
        String email = bidProject.getString("proemail");
        String address = bidProject.getString("proaddress");
        String[] queryList = new BidTemplateConstant().getQueryValues();
        String result = content.replace(TemplateManageHelper.getSpecialValue(new BidTemplateConstant().getQuerySupplierName()), supplierName).replace(TemplateManageHelper.getSpecialValue(new BidTemplateConstant().getProjectName()), projectName).replace(TemplateManageHelper.getSpecialValue(queryList[0]), projectName).replace(TemplateManageHelper.getSpecialValue(queryList[1]), title).replace(TemplateManageHelper.getSpecialValue(queryList[2]), orgName).replace(TemplateManageHelper.getSpecialValue(queryList[3]), dataStr).replace(TemplateManageHelper.getSpecialValue(queryList[4]), contactName).replace(TemplateManageHelper.getSpecialValue(queryList[5]), contacttel).replace(TemplateManageHelper.getSpecialValue(queryList[6]), email).replace(TemplateManageHelper.getSpecialValue(queryList[7]), address);
        OptionalColumnConstant aColumnConstant = new OptionalColumnConstant("bidproject");
        List columns = aColumnConstant.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            Map map = (Map)columns.get(i);
            for (Map.Entry entry : map.entrySet()) {
                String value = (String)entry.getValue();
                result = this.replaceOtherContent(bidProject, result, value);
            }
        }
        queryList = new BidTemplateConstant().getQueryOtherValues();
        result = result.replace(TemplateManageHelper.getSpecialValue(queryList[0]), clarifyType).replace(TemplateManageHelper.getSpecialValue(queryList[1]), dataStr);
        return result;
    }

    private String replaceOtherContent(DynamicObject bidProject, String content, String value) {
        String valueStr = TemplateManageHelper.getSpecialValue(value);
        Lang lang = RequestContext.get().getLang();
        if (!content.contains(valueStr)) {
            return content;
        }
        if (BidProjectEnum.NAME.getValue().equals(value)) {
            ILocaleString name = bidProject.getLocaleString("name");
            content = !Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang) ? content.replace(valueStr, name.getLocaleValue_en()) : content.replace(valueStr, name.getLocaleValue_zh_CN());
        } else if (BidProjectEnum.PURTYPE_NAME.getValue().equals(value)) {
            DynamicObject purtype = bidProject.getDynamicObject("purtype");
            ILocaleString name = purtype.getLocaleString("name");
            content = !Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang) ? content.replace(valueStr, name.getLocaleValue_en()) : content.replace(valueStr, name.getLocaleValue_zh_CN());
        } else if (BidProjectEnum.ENDTIME.getValue().equals(value)) {
            Date enrolldeadline = bidProject.getDate("enrolldeadline");
            content = content.replace(valueStr, DateUtils.date2String(enrolldeadline));
        } else if (BidProjectEnum.QUALIFICATIONREQUIRED.getValue().equals(value)) {
            String qualificationrequired = bidProject.getString("qualificationrequired");
            content = content.replace(valueStr, qualificationrequired);
        } else if (BidProjectEnum.ORG.getValue().equals(value)) {
            String orgName = bidProject.getString("org.name");
            content = content.replace(valueStr, orgName);
        } else if (BidProjectEnum.PURDESCRIPTION.getValue().equals(value)) {
            ILocaleString orgName = bidProject.getLocaleString("purdescription");
            content = !Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang) ? content.replace(valueStr, orgName.getLocaleValue_en()) : content.replace(valueStr, orgName.getLocaleValue_zh_CN());
        } else if (BidProjectEnum.PURENTRYPROJECT.getValue().equals(value)) {
            ILocaleString purprojects = bidProject.getLocaleString("purprojectset");
            content = !Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang) ? content.replace(valueStr, purprojects.getLocaleValue_en()) : content.replace(valueStr, purprojects.getLocaleValue_zh_CN());
        } else if (BidProjectEnum.FAX.getValue().equals(value)) {
            String fax = bidProject.getString("profax");
            content = content.replace(valueStr, fax);
        } else if (BidProjectEnum.BIDMODE.getValue().equals(value)) {
            String bidmode = bidProject.getDynamicObject("bidmode").getString("name");
            content = content.replace(valueStr, bidmode);
        } else {
            content = this.replaceDateContent(bidProject, content, BidProjectEnum.SUPPLIERINVIENDDATE.getValue(), "supplierinvienddate", value, Boolean.TRUE);
            content = this.replaceDateContent(bidProject, content, BidProjectEnum.TECHNICALDOCENDDTAE.getValue(), "technicaldocenddate", value, Boolean.TRUE);
            content = this.replaceDateContent(bidProject, content, BidProjectEnum.COMMERCIALDOCENDDATE.getValue(), "commercialdocenddate", value, Boolean.TRUE);
            content = this.replaceDateContent(bidProject, content, BidProjectEnum.BIDPUBLISHDATE.getValue(), "bidpublishdate", value, Boolean.TRUE);
            content = this.replaceDateContent(bidProject, content, BidProjectEnum.ANSWERQUESTIONTIME.getValue(), "answerquestiontime", value, Boolean.FALSE);
            content = this.replaceDateContent(bidProject, content, BidProjectEnum.APPROACHDATE.getValue(), "approachdate", value, Boolean.TRUE);
            content = this.replaceDateContent(bidProject, content, BidProjectEnum.ANSWERCOMPLETE.getValue(), "answercomplete", value, Boolean.TRUE);
            content = this.replaceDateContent(bidProject, content, BidProjectEnum.BIDOPENDEADLINE.getValue(), "bidopendeadline", value, Boolean.FALSE);
            content = this.replaceDateContent(bidProject, content, BidProjectEnum.BIDEVALUATIONDATE.getValue(), "bidevaluationdate", value, Boolean.TRUE);
            content = this.replaceDateContent(bidProject, content, BidProjectEnum.BIDDECISIONDATE.getValue(), "biddecisiondate", value, Boolean.TRUE);
            content = this.replaceDateContent(bidProject, content, BidProjectEnum.DESIGNDATE.getValue(), null, value, Boolean.TRUE);
        }
        return content;
    }

    private String replaceDateContent(DynamicObject bidProject, String content, String enumValue, String dateKey, String value, Boolean isSimple) {
        String valueStr = TemplateManageHelper.getSpecialValue(value);
        if (dateKey == null) {
            content = content.replace(valueStr, "endtime");
        } else if (enumValue.equals(value)) {
            Date date = bidProject.getDate(dateKey);
            content = content.replace(valueStr, DateUtils.date2StringSimpleOrDetail(date, isSimple));
        }
        return content;
    }

    private void replaceName(String oldValue, String name) {
        boolean flag;
        DynamicObjectCollection bidsection = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("bidsection");
        Iterator bidsections = bidsection.iterator();
        int size = bidsection.size();
        boolean bl = flag = size > 1;
        while (bidsections.hasNext()) {
            DynamicObject bidRow = (DynamicObject)bidsections.next();
            String sectionname = bidRow.getString("sectionname");
            String needSectionName = flag ? sectionname : "";
            DynamicObjectCollection supplierentry = bidRow.getDynamicObjectCollection("supplierentry");
            for (DynamicObject row : supplierentry) {
                DynamicObject supplier = row.getDynamicObject("supplier");
                String oldConten = row.getString("content_tag");
                if (StringUtils.isBlank((CharSequence)oldConten)) {
                    oldConten = row.getString("content");
                }
                if (StringUtils.isBlank((CharSequence)oldConten)) continue;
                String contentStr = oldConten.replace(oldValue, name);
                String richContentKey = this.appendStr(ATTACHE_TAG, supplier.getPkValue().toString(), needSectionName);
                if (this.getView().getControl(richContentKey) != null) {
                    ((RichTextEditor)this.getView().getControl(richContentKey)).setText(contentStr);
                    this.getView().updateView(richContentKey);
                }
                if (contentStr.length() > 200) {
                    row.set("content", (Object)contentStr.substring(0, 200));
                    row.set("content_tag", (Object)contentStr);
                    continue;
                }
                row.set("content", (Object)contentStr);
            }
        }
        this.getView().updateView("bidsection");
        this.getView().updateView("supplierentry");
    }

    private String replaceDeadLineDate(String content, String oldValue, String deadLineDate) {
        if (deadLineDate.equals("")) {
            return content;
        }
        if (oldValue == null) {
            String[] invitationList = new BidTemplateConstant().getInvitationValues();
            oldValue = TemplateManageHelper.getSpecialValue(invitationList[2]);
        }
        content = content.replace(oldValue, deadLineDate);
        return content;
    }

    private String setRichTextEditorapStr(String content, String invitationId, Object pkValue, List<Map<String, Object>> publicAttachs) {
        return content;
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        if (formShowParameter == null) {
            formShowParameter = this.getView().getFormShowParameter();
        }
        Object queryid = null;
        try {
            queryid = formShowParameter.getCustomParam("queryid");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (queryid == null) {
            Object pkId = ((BillShowParameter)formShowParameter).getPkId();
            String table = "";
            table = this.getAppId().equals("bid") ? "bid_query_letters" : "rebm_query_letters_inh";
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)table);
            formShowParameter.setCustomParam("bidProjectPk", dynamicObject.getDynamicObject("bidproject").getPkValue());
            formShowParameter.setCustomParam("queryid", dynamicObject.getDynamicObject("queryid").getPkValue());
            queryid = dynamicObject.getDynamicObject("queryid").getPkValue();
        }
        String formId = formShowParameter.getFormId();
        String appId = this.getAppId();
        DynamicObject queryRecord = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(queryid.toString()), (String)(appId + "_multiquestclarify"));
        DynamicObjectCollection bidsections = queryRecord.getDynamicObjectCollection("bidsection");
        Iterator iterator = bidsections.iterator();
        boolean aboolean = queryRecord.getDynamicObject("bidproject").getBoolean("enablemultisection");
        HashMap<String, List<DynamicObject>> bidSupplier = new HashMap<String, List<DynamicObject>>(16);
        while (iterator.hasNext()) {
            DynamicObject bidsection = (DynamicObject)iterator.next();
            DynamicObjectCollection querySupplierEntity = bidsection.getDynamicObjectCollection("supplierentry");
            Iterator supplierIter = querySupplierEntity.iterator();
            ArrayList<DynamicObject> listSuppliers = new ArrayList<DynamicObject>(16);
            while (supplierIter.hasNext()) {
                DynamicObject entity = (DynamicObject)supplierIter.next();
                DynamicObject supplier = entity.getDynamicObject("clarifysupplier");
                listSuppliers.add(supplier);
            }
            bidSupplier.put(bidsection.getString("sectionname"), listSuppliers);
        }
        Map<String, Object> mapHead = this.getMapHead(bidSupplier, aboolean);
        e.getItems().add(mapHead);
    }

    public void onGetControl(OnGetControlArgs e) {
        if (e.getKey().startsWith(RICHTEXT_TAG)) {
            RichTextEditor rechText = new RichTextEditor();
            String richKey = e.getKey();
            rechText.setKey(richKey);
            rechText.setView(this.getView());
            e.setControl((Control)rechText);
        } else if (e.getKey().startsWith(ATTACHE_TAG)) {
            AttachmentPanel panel = new AttachmentPanel();
            String key = e.getKey();
            panel.setKey(key);
            panel.setDefaultCollapse(false);
            panel.setView(this.getView());
            e.setControl((Control)panel);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("multiquestclarify", exp.getMessage()), new Object[0]);
        }
        ArrayList<DynamicObject> listSuppliers = new ArrayList<DynamicObject>(16);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String queryid = "";
        if (formShowParameter.getCustomParam("queryid") == null) {
            Object pkId = ((BillShowParameter)formShowParameter).getPkId();
            String table = "";
            table = this.getAppId().equals("bid") ? "bid_query_letters" : "rebm_query_letters_inh";
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)table);
            formShowParameter.setCustomParam("bidProjectPk", dynamicObject.getDynamicObject("bidproject").getPkValue());
            formShowParameter.setCustomParam("queryid", dynamicObject.getDynamicObject("queryid").getPkValue());
        }
        queryid = formShowParameter.getCustomParam("queryid").toString();
        String appId = this.getAppId();
        DynamicObject queryRecord = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(queryid), (String)(appId + "_multiquestclarify"));
        DynamicObjectCollection bidsections = queryRecord.getDynamicObjectCollection("bidsection");
        int size = bidsections.size();
        boolean flag = queryRecord.getDynamicObject("bidproject").getBoolean("enablemultisection");
        for (DynamicObject bidsection : bidsections) {
            String sectionname = bidsection.getString("sectionname");
            String needSectionName = flag ? sectionname : "";
            DynamicObjectCollection querySupplierEntity = bidsection.getDynamicObjectCollection("supplierentry");
            for (DynamicObject entity : querySupplierEntity) {
                DynamicObject supplier = entity.getDynamicObject("clarifysupplier");
                listSuppliers.add(supplier);
            }
            this.registDynamicProps(newMainType, listSuppliers, needSectionName);
        }
        e.setNewEntityType(newMainType);
    }

    private void registDynamicProps(MainEntityType newMainType, List<DynamicObject> listSuppliers, String sectionName) {
        for (int i = 0; i < listSuppliers.size(); ++i) {
            String supplierId = listSuppliers.get(i).getString("id") + sectionName;
            String supplierName = listSuppliers.get(i).getString("name") + sectionName;
            TextProp richTextProp = new TextProp();
            richTextProp.setName(RICHTEXT_TAG + supplierId);
            richTextProp.setDisplayName(new LocaleString(supplierName));
            richTextProp.setDbIgnore(true);
            richTextProp.setAlias(supplierName);
            newMainType.registerSimpleProperty((DynamicSimpleProperty)richTextProp);
        }
    }

    public String appendStr(String ... strings) {
        StringBuilder buffer = new StringBuilder();
        for (String s : strings) {
            buffer.append(s);
        }
        return buffer.toString();
    }

    static {
        ENABLE_OP.add("save");
        ENABLE_OP.add("submit");
        ENABLE_OP.add("submitandauti");
        ENABLE_OP.add("unaudit");
        ENABLE_OP.add("audit");
    }
}

