/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.clarify.letter;

import java.util.HashSet;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.bid.common.util.PermissionUtil;

public class QueryLetterSelect
extends AbstractListPlugin {
    public static final String CHECK_QUERY_OP = "selepublishquery";
    public static final String DELETE_QUERY_OP = "deletquery";
    public static final String NEW_QUERY_OP = "publishquery";
    public static final Set<String> PERMISSION = new HashSet<String>();

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (!PERMISSION.contains(operateKey)) {
            return;
        }
        args.setCancel(true);
        args.setCancel(true);
        ListSelectedRowCollection src = ((IListView)this.getView()).getSelectedRows();
        if (src == null) {
            return;
        }
        if (src != null && src.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u53d1\u9001\u591a\u6761\u6570\u636e\u3002", (String)"QueryLetterSelect_13", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRow data = src.get(0);
        DynamicObject mulQter = BusinessDataServiceHelper.loadSingle((Object)data.getPrimaryKeyValue(), (String)(this.getAppId() + "_multiquestclarify"));
        boolean isletter = mulQter.getBoolean("isletter");
        if (!isletter) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5f00\u542f\u53d1\u9001\u8d28\u7591\u51fd\u3002", (String)"QueryLetterSelect_14", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        if (NEW_QUERY_OP.equals(operateKey)) {
            this.newQueryLetter(mulQter);
        } else if (DELETE_QUERY_OP.equals(operateKey)) {
            this.deleteQueryLetter(mulQter);
        } else if (CHECK_QUERY_OP.equals(operateKey)) {
            this.checkQueryLetter(mulQter);
        }
    }

    public void checkQueryLetter(DynamicObject data) {
        ListShowParameter showParameter = new ListShowParameter();
        String formId = this.getLetterFormId();
        Object queryId = data.getPkValue();
        Long orgId = (Long)data.getDynamicObject("org").getPkValue();
        boolean haspermission = PermissionUtil.checkPermission((String)"QXX0001", (Long)orgId, (String)this.getAppId(), (String)formId);
        if (!haspermission) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u67e5\u770b\u8d28\u7591\u51fd\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"QueryLetterSelect_15", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter querId = new QFilter("queryid", "=", queryId);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)formId, (String)"fid", (QFilter[])new QFilter[]{querId});
        if (load == null || load.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6dfb\u52a0\u8d28\u7591\u51fd\uff0c\u8bf7\u5148\u6dfb\u52a0\u3002", (String)"QueryLetterSelect_16", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        String bidproject = data.getPkValue().toString();
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setCustomParam("bidProjectPk", (Object)bidproject);
        listShowParameter.setCustomParam("queryid", (Object)queryId.toString());
        listShowParameter.setBillFormId(formId);
        listShowParameter.setHasRight(true);
        listShowParameter.setMultiSelect(false);
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u8d28\u7591\u51fd\u5217\u8868", (String)"QueryLetterSelect_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void newQueryLetter(DynamicObject data) {
        QFilter querId;
        QFilter statusQFlter;
        String billstatus = data.getString("billstatus");
        String publicstatis = data.getString("publicstatis");
        if (!billstatus.equals("A") || !"B".equals(publicstatis)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5904\u4e8e\u5df2\u5ba1\u6838\u4e14\u672a\u53d1\u5e03\u7684\u8d28\u7591\u6f84\u6e05\u8bb0\u5f55\u624d\u80fd\u6dfb\u52a0\u8d28\u7591\u51fd\u3002", (String)"QueryLetterSelect_17", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        Object queryId = data.getPkValue();
        String formId = this.getLetterFormId();
        DynamicObject[] load = BusinessDataServiceHelper.load((String)formId, (String)"fid", (QFilter[])new QFilter[]{statusQFlter = new QFilter("status", "!=", (Object)"XX"), querId = new QFilter("queryid", "=", queryId)});
        if (load != null && load.length > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u6dfb\u52a0\u8d28\u7591\u51fd\u4e86\uff0c\u8bf7\u67e5\u770b\u8d28\u7591\u51fd\u3002", (String)"QueryLetterSelect_18", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        Object orgPk = data.getDynamicObject("org").getPkValue();
        boolean hasPermission = PermissionUtil.checkPermission((String)"QXX0196", (Long)Long.parseLong(orgPk.toString()), (String)this.getAppId(), (String)formId);
        if (!hasPermission) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u8d28\u7591\u51fd\u7684\u4fdd\u5b58\u6743\u9650\uff0c\u4e0d\u80fd\u8fdb\u884c\u65b0\u589e\u52a0\u64cd\u4f5c\u3002", (String)"QueryLetterSelect_19", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        String bidproject = data.getDynamicObject("bidproject").getPkValue().toString();
        showParameter.setFormId(formId);
        showParameter.setCustomParam("newData", (Object)"newData");
        showParameter.setCustomParam("queryid", queryId);
        showParameter.setCustomParam("bidproject", (Object)bidproject);
        showParameter.setCaption(ResManager.loadKDString((String)"\u8d28\u7591\u51fd\u53d1\u5e03", (String)"QueryLetterSelect_6", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void deleteQueryLetter(DynamicObject data) {
        Object queryId;
        QFilter filter;
        String formId = this.getLetterFormId();
        DynamicObject[] load = BusinessDataServiceHelper.load((String)formId, (String)"fid", (QFilter[])new QFilter[]{filter = new QFilter("queryid", "=", queryId = data.getPkValue())});
        if (load == null || load.length <= 0) {
            return;
        }
        DeleteServiceHelper.delete((String)this.getLetterFormId(), (QFilter[])new QFilter[]{filter});
    }

    public String getAppId() {
        return "bid";
    }

    public String getLetterFormId() {
        if (this.getAppId().equals("bid")) {
            return this.getAppId() + "_query_letters";
        }
        return "rebm_query_letters_inh";
    }

    static {
        PERMISSION.add(CHECK_QUERY_OP);
        PERMISSION.add(DELETE_QUERY_OP);
        PERMISSION.add(NEW_QUERY_OP);
    }
}

