/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.quotedetails;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.formplugin.bill.util.NumberUtil;

public class BidTenderGradingFloatScaleEdit
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Object bidOpenId = showParameter.getCustomParam("bidOpenId");
        String formId = showParameter.getServiceAppId() + "_bidopen";
        DynamicObject bidOpen = BusinessDataServiceHelper.loadSingle((Object)bidOpenId, (String)formId, (String)"sourcebillid");
        Long sourcebillid = bidOpen.getLong("sourcebillid");
        Map<String, BigDecimal> amontMap = this.getPrevTenderPrice(sourcebillid, formId);
        if (amontMap.isEmpty()) {
            return;
        }
        this.buildFloatScale(dataEntity, amontMap, showParameter);
    }

    public void buildFloatScale(DynamicObject dataEntity, Map<String, BigDecimal> amontMap, FormShowParameter showParameter) {
        String sectionName = (String)showParameter.getCustomParam("sectionName");
        DynamicObjectCollection supplierEntrys = dataEntity.getDynamicObjectCollection("tendergrading");
        supplierEntrys.forEach(row -> {
            Long supplierId = row.getLong("supplier");
            if (supplierId != null && supplierId != 0L) {
                BigDecimal prevTenderPrice = amontMap.getOrDefault(sectionName + supplierId, BigDecimal.ZERO);
                BigDecimal tenderPrice = row.getBigDecimal("supplier_tenderprice");
                BigDecimal scale = BigDecimal.ZERO;
                if (prevTenderPrice.compareTo(BigDecimal.ZERO) != 0) {
                    scale = NumberUtil.multiply(NumberUtil.divide(NumberUtil.subtract(tenderPrice, prevTenderPrice), prevTenderPrice, 4), new BigDecimal("100"), 2);
                }
                int compareResult = prevTenderPrice.compareTo(tenderPrice);
                if (prevTenderPrice.compareTo(BigDecimal.ZERO) == 0) {
                    compareResult = 0;
                }
                if (compareResult > 0) {
                    row.set("float_scale", (Object)("\u2193" + scale + "%"));
                } else if (compareResult == 0) {
                    row.set("float_scale", (Object)(scale + "%"));
                } else {
                    row.set("float_scale", (Object)("\u2191" + scale + "%"));
                }
            }
        });
        this.buildFloatScaleCellColor();
        this.getView().updateView("tendergrading");
    }

    public void buildFloatScaleCellColor() {
        DynamicObjectCollection supplierEntry = this.getModel().getEntryEntity("tendergrading");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("tendergrading");
        ArrayList<CellStyle> list = new ArrayList<CellStyle>();
        for (int i = 0; i < supplierEntry.size(); ++i) {
            CellStyle cellStyle;
            String floatScale = ((DynamicObject)supplierEntry.get(i)).getString("float_scale");
            if (floatScale.contains("\u2193")) {
                cellStyle = new CellStyle();
                cellStyle.setForeColor("#1ba854");
                cellStyle.setFieldKey("float_scale");
                cellStyle.setRow(i);
                list.add(cellStyle);
                continue;
            }
            if (!floatScale.contains("\u2191")) continue;
            cellStyle = new CellStyle();
            cellStyle.setForeColor("#fb2323");
            cellStyle.setFieldKey("float_scale");
            cellStyle.setRow(i);
            list.add(cellStyle);
        }
        entryGrid.setCellStyle(list);
    }

    public Map<String, BigDecimal> getPrevTenderPrice(Object sourcebillid, String formId) {
        HashMap<String, BigDecimal> amontMap = new HashMap<String, BigDecimal>();
        if (sourcebillid != null && QueryServiceHelper.exists((String)formId, (Object)sourcebillid)) {
            DynamicObject prevBidOpen = BusinessDataServiceHelper.loadSingle((Object)sourcebillid, (String)formId);
            DynamicObjectCollection bidSections = prevBidOpen.getDynamicObjectCollection("bidsection");
            bidSections.forEach(section -> {
                String sectionName = section.getString("sectionname");
                DynamicObjectCollection supplierEntrys = section.getDynamicObjectCollection("supplierentry");
                supplierEntrys.forEach(row -> {
                    DynamicObject supplier = row.getDynamicObject("supplier");
                    if (supplier != null) {
                        BigDecimal tenderPrice = row.getBigDecimal("supplier_tenderprice");
                        amontMap.put(sectionName + supplier.getPkValue(), tenderPrice);
                    }
                });
            });
        }
        return amontMap;
    }
}

