/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.tranfer;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.bid.business.bill.IBidTransferService;
import kd.scm.bid.business.bill.serviceImpl.BidTransferServiceImpl;
import kd.scm.bid.common.constant.entity.BidTransferConstant;
import kd.scm.bid.formplugin.util.BidTransferUtil;

public class BidTransferEditUl
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String ADDNEW = "addentry";
    private String appid = ((Object)((Object)this)).getClass().getName().split("\\.")[2];
    IBidTransferService bidTransferService = new BidTransferServiceImpl(this.appid);
    BidTransferUtil bidTransferUtil = new BidTransferUtil(this.appid);

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter;
        Object bidProjectId;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String dateStr = simpleDateFormat.format(new Date());
        dataEntity.set("billno", (Object)dateStr);
        long currUserId = RequestContext.get().getCurrUserId();
        boolean isBidAdmin = this.bidTransferUtil.checkIsBidAdmin(currUserId);
        if (!isBidAdmin) {
            DynamicObject bos_user = BusinessDataServiceHelper.loadSingle((Object)currUserId, (String)"bos_user");
            dataEntity.set("oldmenber", (Object)bos_user);
        }
        if ((bidProjectId = (formShowParameter = this.getView().getFormShowParameter()).getCustomParam("bidProjectId")) == null) {
            return;
        }
        dataEntity.set("isselectproject", (Object)Boolean.TRUE);
        dataEntity.set("bidprojectid", bidProjectId);
        this.setDefaultValueByBidPorject(bidProjectId, dataEntity);
    }

    public void setDefaultValueByBidPorject(Object bidProjectId, DynamicObject dataEntity) {
        String selectProperties = String.join((CharSequence)",", "purtype", "bidmode", "org", "setupdate", "bidsection", "projectentry", "purentryproject", "memberentity", "memberentity.user");
        DynamicObject bidProject = this.bidTransferService.getBidProjectByIdAndFields(bidProjectId, selectProperties);
        if (bidProject == null) {
            return;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        boolean isBidAdmin = this.bidTransferUtil.checkIsBidAdmin(currUserId);
        if (isBidAdmin) {
            DynamicObjectCollection memberEntityColl = bidProject.getDynamicObjectCollection("memberentity");
            DynamicObject user = ((DynamicObject)memberEntityColl.get(0)).getDynamicObject("user");
            dataEntity.set("oldmenber", (Object)user);
        }
        this.setMulBasedataValue(dataEntity, bidProject, "mulpurtype", "purtype");
        this.setMulBasedataValue(dataEntity, bidProject, "mulbidmode", "bidmode");
        this.setMulBasedataValue(dataEntity, bidProject, "mulpurorg", "org");
        dataEntity.set("startdate", (Object)bidProject.getDate("setupdate"));
        List purProjectList = this.bidTransferService.getBidProjectSubEntryPurProject(bidProject);
        purProjectList.forEach(item -> this.setMulBasedataValue(dataEntity, (DynamicObject)item, "mulpurproject", "purentryproject"));
        this.setCurBidprojectTransferEntryData(dataEntity, bidProject);
    }

    protected void setCurBidprojectTransferEntryData(DynamicObject dataEntity, DynamicObject bidProject) {
        bidProject = this.bidTransferService.getBidProjectF7ByIdAndFields(bidProject.getPkValue(), BidTransferConstant.getBidProjectSelectFields());
        this.updateTransferEntry(dataEntity, new DynamicObject[]{bidProject});
    }

    public void setMulBasedataValue(DynamicObject dataEntity, DynamicObject bidProject, String targetField, String srcField) {
        DynamicObjectCollection mulPurtype = dataEntity.getDynamicObjectCollection(targetField);
        DynamicObject purType = mulPurtype.addNew();
        purType.set("fbasedataid", (Object)bidProject.getDynamicObject(srcField));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (ADDNEW.equals(operateKey)) {
            this.addentryOperation();
        }
    }

    protected void addentryOperation() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        List<QFilter> qfilterList = BidTransferUtil.getQfilterList(dataEntity);
        List bidprojectIds = this.bidTransferService.getBidProjectIdByEditFilter(qfilterList);
        if (bidprojectIds == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u65b0\u589e\u6570\u636e\u3002", (String)"BidTransferEditUl_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        List alreadySelectIdList = dataEntity.getDynamicObjectCollection("transferentry").stream().filter(entry -> entry.getDynamicObject("entry_bidproject") != null).map(entry -> entry.getDynamicObject("entry_bidproject").getPkValue()).collect(Collectors.toList());
        bidprojectIds.removeIf(alreadySelectIdList::contains);
        if (bidprojectIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u65b0\u589e\u6570\u636e\u3002", (String)"BidTransferEditUl_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(this.appid + "_bidtransfer_addrow");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("bidProjects", (Object)bidprojectIds);
        DynamicObject oldMember = dataEntity.getDynamicObject("oldmenber");
        if (oldMember != null) {
            formShowParameter.setCustomParam("oldMemberId", oldMember.getPkValue());
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ADDNEW);
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (ADDNEW.equals(actionId)) {
            this.addNewClosedCallBack(closedCallBackEvent);
        }
    }

    public void addNewClosedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        List returnDataList = (List)returnData;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection transferEntry = dataEntity.getDynamicObjectCollection("transferentry");
        returnDataList.forEach(item -> {
            DynamicObject entry = transferEntry.addNew();
            entry.set("entry_curstepstatus", item.get("entry_curstepstatus"));
            entry.set("respbusiness", item.get("respbusiness"));
            entry.set("entry_bidproject", item.get("entry_bidproject"));
            entry.set("entry_purproject", item.get("entry_purproject"));
        });
        transferEntry.forEach(entry -> entry.getDataEntityState().setPushChanged(true));
        this.getView().updateView("transferentry");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        long currUserId = RequestContext.get().getCurrUserId();
        boolean isBidAdmin = this.bidTransferUtil.checkIsBidAdmin(currUserId);
        if (!isBidAdmin) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"oldmenber"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        ChangeData changeSet = e.getChangeSet()[0];
        String name = e.getProperty().getName();
        Object newValue = changeSet.getNewValue();
        if (newValue == (oldValue = changeSet.getOldValue())) {
            return;
        }
        if (this.getFilterFieldNames().contains(name)) {
            this.updateEntryData();
        }
    }

    public List<String> getFilterFieldNames() {
        return Arrays.asList("oldmenber", "mulbidmode", "startdate", "mulpurorg", "mulpurproject", "mulpurtype", "enddate");
    }

    public void updateEntryData() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        List<QFilter> qfilterList = BidTransferUtil.getQfilterList(dataEntity);
        List bidprojectIds = this.bidTransferService.getBidProjectIdByEditFilter(qfilterList);
        DynamicObject[] bidProjecF7s = this.bidTransferService.getBidProjectF7ByIdsAndFields(bidprojectIds, BidTransferConstant.getBidProjectSelectFields());
        this.updateTransferEntry(dataEntity, bidProjecF7s);
    }

    public void updateTransferEntry(DynamicObject dataEntity, DynamicObject[] bidProjecF7s) {
        DynamicObject oldMember = dataEntity.getDynamicObject("oldmenber");
        DynamicObjectCollection transferEntry = dataEntity.getDynamicObjectCollection("transferentry");
        transferEntry.clear();
        for (DynamicObject bidProject : bidProjecF7s) {
            DynamicObject entry2;
            DynamicObject entry3;
            DynamicObject newEntry = transferEntry.addNew();
            newEntry.set("entry_bidproject", (Object)bidProject);
            String purProjectName = this.bidTransferService.getBidProjectSubEntryPurProjectName(bidProject);
            newEntry.set("entry_purproject", (Object)purProjectName);
            String currentStepStatus = BidTransferUtil.getCurrentStepStatus(bidProject, this.appid);
            newEntry.set("entry_curstepstatus", (Object)currentStepStatus);
            if (oldMember == null) continue;
            Object oldMemberId = oldMember.getPkValue();
            Map memberLeaderEntryMap = this.bidTransferService.getBidProjectMemberLeaderEntry(bidProject);
            if (memberLeaderEntryMap != null && (entry3 = (DynamicObject)memberLeaderEntryMap.get(oldMemberId)) != null) {
                newEntry.set("respbusiness", entry3.get("respbusinessleader"));
                continue;
            }
            Map memberEntryMap = this.bidTransferService.getBidProjectMemberEntityEntry(bidProject);
            if (memberEntryMap == null || (entry2 = (DynamicObject)memberEntryMap.get(oldMemberId)) == null) continue;
            newEntry.set("respbusiness", entry2.get("respbusiness"));
        }
        transferEntry.forEach(entry -> entry.getDataEntityState().setPushChanged(true));
        this.getView().updateView("transferentry");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit oldMember = (BasedataEdit)this.getControl("oldmenber");
        oldMember.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit newMember = (BasedataEdit)this.getControl("newmenber");
        newMember.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit mulProjects = (BasedataEdit)this.getControl("mulpurproject");
        mulProjects.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit mulPurorg = (BasedataEdit)this.getControl("mulpurorg");
        mulPurorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        List customQFilters = beforeF7SelectEvent.getCustomQFilters();
        if ("oldmenber".equals(name) || "newmenber".equals(name)) {
            this.memberF7Selected(dataEntity, customQFilters);
        }
        if ("oldmenber".equals(name) && this.oldMemberF7Selected(dataEntity, customQFilters)) {
            return;
        }
        if ("mulpurproject".equals(name)) {
            this.mulProjectF7Selected(customQFilters, dataEntity);
        }
        if ("mulpurorg".equals(name)) {
            this.mulPurOrgF7Selected(customQFilters);
        }
    }

    public void mulPurOrgF7Selected(List<QFilter> customQFilters) {
        long currUserId = RequestContext.get().getCurrUserId();
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)currUserId, (boolean)true);
        if (!userHasPermOrgs.hasAllOrgPerm()) {
            List hasPermOrgs = userHasPermOrgs.getHasPermOrgs();
            List allOrgByViewNumber = OrgUnitServiceHelper.getAllOrgByViewNumber((String)"02", (boolean)true);
            hasPermOrgs.removeIf(o -> !allOrgByViewNumber.contains(o));
            customQFilters.add(new QFilter("id", "in", (Object)hasPermOrgs));
        }
    }

    public void mulProjectF7Selected(List<QFilter> customQFilters, DynamicObject dataEntity) {
        DynamicObjectCollection mulorg = dataEntity.getDynamicObjectCollection("mulpurorg");
        if (mulorg != null && mulorg.size() != 0) {
            List<Object> mulOrgIds = BidTransferUtil.getMulBaseDataIds(mulorg);
            customQFilters.add(new QFilter("org", "in", mulOrgIds));
        }
    }

    public void memberF7Selected(DynamicObject dataEntity, List<QFilter> customQFilters) {
        DynamicObject newMember;
        customQFilters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        customQFilters.add(new QFilter("usertypes.fbasedataid.category", "=", (Object)"1"));
        DynamicObject oldMember = dataEntity.getDynamicObject("oldmenber");
        if (oldMember != null) {
            customQFilters.add(new QFilter("id", "!=", oldMember.getPkValue()));
        }
        if ((newMember = dataEntity.getDynamicObject("newmenber")) != null) {
            customQFilters.add(new QFilter("id", "!=", newMember.getPkValue()));
        }
    }

    public boolean oldMemberF7Selected(DynamicObject dataEntity, List<QFilter> customQFilters) {
        boolean isSelectProject = dataEntity.getBoolean("isselectproject");
        if (!isSelectProject) {
            return true;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        boolean isBidAdmin = this.bidTransferUtil.checkIsBidAdmin(currUserId);
        if (!isBidAdmin) {
            return true;
        }
        long bidProjectId = dataEntity.getLong("bidprojectid");
        String selectProperties = String.join((CharSequence)",", "memberleaderentity", "memberentity", "userleader", "user");
        DynamicObject curbidProject = this.bidTransferService.getBidProjectByIdAndFields((Object)bidProjectId, selectProperties);
        Map bidProjectMemberEntryUserMap = this.bidTransferService.getBidProjectMemberEntryUserMap(new DynamicObject[]{curbidProject});
        List leaderUserIds = (List)bidProjectMemberEntryUserMap.get("leaderUser" + bidProjectId);
        List userIds = (List)bidProjectMemberEntryUserMap.get("user" + bidProjectId);
        ArrayList allUserIds = new ArrayList(16);
        if (leaderUserIds != null) {
            allUserIds.addAll(leaderUserIds);
        }
        if (userIds != null) {
            allUserIds.addAll(userIds);
        }
        customQFilters.add(new QFilter("id", "in", allUserIds));
        return false;
    }
}

