/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IBidBustalkService;
import kd.scm.bid.business.bill.IBidBustalkSupplierFileService;
import kd.scm.bid.business.bill.IBidDecisionService;
import kd.scm.bid.business.bill.IQuestionClarifyService;
import kd.scm.bid.business.bill.serviceImpl.BidBustalkServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidBustalkSupplierFileServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidDecisionServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.QuestionClarifyServiceImpl;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.sdk.annotation.SdkDeprecated;

public class BidBustalkUtil {
    private IBidBustalkService bidBustalkService = new BidBustalkServiceImpl();
    private IBidDecisionService bidDecisionService = new BidDecisionServiceImpl();
    private IBidBustalkSupplierFileService bidBustalkSupplierFileService = new BidBustalkSupplierFileServiceImpl();
    protected IQuestionClarifyService questionClarifyService = new QuestionClarifyServiceImpl();

    private DynamicObject getBustalk(DynamicObject bustalk) {
        if (null != bustalk) {
            Long id = (Long)bustalk.getPkValue();
            DynamicObject temp = this.bidBustalkService.getBustalkById(id);
            return temp;
        }
        return null;
    }

    @SdkDeprecated
    public void validatorSave(IFormView view, BeforeDoOperationEventArgs args, DynamicObject bustalk) {
        DynamicObject tempBusTalk = this.getBustalk(bustalk);
        if (tempBusTalk != null) {
            String billstatus = tempBusTalk.getString("billstatus");
            if (!billstatus.equals(BillStatusEnum.DISBEGIN.getVal()) && !billstatus.equals(BillStatusEnum.SAVE.getVal())) {
                view.showTipNotification(ResManager.loadKDString((String)"\u4f60\u9009\u62e9\u7684\u8bb0\u5f55\u4e0d\u4e3a\u201c\u6682\u5b58\u201d\u6216\u201c\u672a\u5f00\u59cb\u201d\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"BidBustalkUtil_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            bustalk.set("billstatus", (Object)"A");
        }
    }

    public void validatorSubmit(IFormView view, BeforeDoOperationEventArgs args, DynamicObject bustalk) {
        String billstatus;
        DynamicObject tempBusTalk = this.getBustalk(bustalk);
        if (tempBusTalk != null && !(billstatus = tempBusTalk.getString("billstatus")).equals(BillStatusEnum.DISBEGIN.getVal()) && !billstatus.equals(BillStatusEnum.SAVE.getVal())) {
            view.showTipNotification(ResManager.loadKDString((String)"\u4f60\u9009\u62e9\u7684\u8bb0\u5f55\u4e0d\u4e3a\u201c\u6682\u5b58\u201d\u6216\u201c\u672a\u5f00\u59cb\u201d\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidBustalkUtil_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (null == bustalk) {
            return;
        }
        boolean openonlinesynergy = bustalk.getBoolean("openonlinesynergy");
        if (openonlinesynergy) {
            Date offerstoptime = bustalk.getDate("offerstoptime");
            if (offerstoptime == null) {
                args.setCancel(true);
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u201d\u3002", (String)"BidBustalkUtil_12", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            if (offerstoptime.getTime() - new Date().getTime() <= 0L) {
                args.setCancel(true);
                view.showTipNotification(ResManager.loadKDString((String)"\u201c\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u201d\u5fc5\u987b\u665a\u4e8e\u670d\u52a1\u5668\u5f53\u524d\u65f6\u95f4\u3002", (String)"BidBustalkUtil_13", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        DynamicObject pro = bustalk.getDynamicObject("bidproject");
        boolean isRateBidding = pro.getBoolean("isratebidding");
        DynamicObjectCollection sections = bustalk.getDynamicObjectCollection("bidsection");
        int count = this.getSupplierEntryNotBlankCount(sections);
        for (DynamicObject s : sections) {
            DynamicObjectCollection supplierentrys = s.getDynamicObjectCollection("supplierentry");
            if (null == supplierentrys || supplierentrys.size() == 0) {
                if (count != 0) continue;
                view.showTipNotification(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BidBustalkUtil_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            for (DynamicObject e : supplierentrys) {
                DynamicObjectCollection business_new = e.getDynamicObjectCollection("business_new");
                if (business_new.isEmpty() && !openonlinesynergy) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u201c\u5546\u52a1\u6807\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidBustalkUtil_6", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Date judgedate = e.getDate("judge_date");
                if (null != judgedate) continue;
                view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5b58\u5728\u201d\u8c08\u5224\u65e5\u671f\u201c\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidBustalkUtil_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    private int getSupplierEntryNotBlankCount(DynamicObjectCollection sections) {
        int num = 0;
        for (DynamicObject s : sections) {
            DynamicObjectCollection supplierentrys = s.getDynamicObjectCollection("supplierentry");
            if (null != supplierentrys && supplierentrys.size() <= 0) continue;
            ++num;
        }
        return num;
    }

    public void validatorUnaudit(IFormView view, BeforeDoOperationEventArgs args, DynamicObject bustalk) {
        DynamicObject tempBusTalk = this.getBustalk(bustalk);
        String billstatus = "";
        if (tempBusTalk != null) {
            billstatus = tempBusTalk.getString("billstatus");
        }
        if (!billstatus.equals(BillStatusEnum.AUDITED.getVal())) {
            view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8bb0\u5f55\u4e3a\u975e\u5df2\u5ba1\u6279\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidBustalkUtil_8", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        } else {
            if (bustalk == null) {
                return;
            }
            Long bidprojectId = bustalk.getDynamicObject("bidproject").getLong("id");
            DynamicObject maxBustalk = this.bidBustalkService.findMaxJudgenumBustalk(bidprojectId);
            Long maxId = 0L;
            if (null != maxBustalk) {
                maxId = maxBustalk.getLong("id");
            }
            if (null != maxBustalk && maxId.longValue() == bustalk.getLong("id")) {
                DynamicObject bidDecision = this.getDecision(bustalk, "bid");
                bidDecision.get("billstatus");
                String billStatus = bidDecision.getString("billstatus");
                if (!BillStatusEnum.DISBEGIN.getVal().equals(billStatus)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8bb0\u5f55\u5bf9\u5e94\u7684\u5b9a\u6807\u4e0d\u4e3a\u672a\u5f00\u59cb\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidBustalkUtil_9", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                } else {
                    args.setCancel(false);
                }
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8bb0\u5f55\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidBustalkUtil_10", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            boolean existsInvite = QueryServiceHelper.exists((String)"bid_negotiate_invite", (QFilter[])new QFilter[]{new QFilter("bustalkid", "=", (Object)bustalk.getLong("id"))});
            if (existsInvite) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5173\u8054\u9080\u7ea6\u51fd\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidBustalkUtil_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    @SdkDeprecated
    public void auditSupplierToDecision(Long id, String appId) {
        DynamicObject bustalk = null;
        bustalk = appId != null && appId.equals("rebm") ? BusinessDataServiceHelper.loadSingle((Object)id, (String)"rebm_bustalk") : this.bidBustalkService.getBustalkById(id);
        this.auditSupplierToDecisionReally(bustalk, appId);
    }

    public void auditSupplierToDecisionReally(DynamicObject bustalk, String appId) {
        HashMap bustalkSupplierentryMap = new HashMap();
        DynamicObjectCollection bidsections = bustalk.getDynamicObjectCollection("bidsection");
        for (int i = 0; i < bidsections.size(); ++i) {
            DynamicObject section = (DynamicObject)bidsections.get(i);
            DynamicObjectCollection supplierentrys = section.getDynamicObjectCollection("supplierentry");
            if (supplierentrys == null || supplierentrys.size() <= 0) continue;
            ArrayList<DynamicObject> tempList = new ArrayList<DynamicObject>(supplierentrys.size());
            for (int j = 0; j < supplierentrys.size(); ++j) {
                DynamicObject supplierentry = (DynamicObject)supplierentrys.get(j);
                boolean openonlinesynergy = bustalk.getBoolean("openonlinesynergy");
                if (openonlinesynergy) {
                    boolean isoffer = supplierentry.getBoolean("isoffer");
                    if (!isoffer) continue;
                    tempList.add(supplierentry);
                    continue;
                }
                tempList.add(supplierentry);
            }
            bustalkSupplierentryMap.put(i + "", tempList);
        }
        MainEntityType decisionType = EntityMetadataCache.getDataEntityType((String)"bid_decision");
        EntityType supplierentryType = (EntityType)decisionType.getAllEntities().get("supplierentry");
        DynamicObject bidDecision = this.getDecision(bustalk, appId);
        DynamicObjectCollection dsections = bidDecision.getDynamicObjectCollection("bidsection");
        for (int i = 0; i < dsections.size(); ++i) {
            DynamicObject supplier;
            int j;
            DynamicObject section = (DynamicObject)dsections.get(i);
            DynamicObjectCollection supplierEntrys = section.getDynamicObjectCollection("supplierentry");
            List busTalkSupplierEntryList = (List)bustalkSupplierentryMap.get(i + "");
            if (supplierEntrys.size() == 0) {
                if (null == busTalkSupplierEntryList || busTalkSupplierEntryList.size() <= 0) continue;
                for (int j2 = 0; j2 < busTalkSupplierEntryList.size(); ++j2) {
                    DynamicObject bSupplierEntry = (DynamicObject)busTalkSupplierEntryList.get(j2);
                    DynamicObject supplierEntry = supplierEntrys.addNew();
                    supplierEntry.set("supplier", (Object)bSupplierEntry.getDynamicObject("supplier"));
                }
                continue;
            }
            HashMap<String, DynamicObject> dmap = new HashMap<String, DynamicObject>(16);
            for (j = 0; j < supplierEntrys.size(); ++j) {
                supplier = ((DynamicObject)supplierEntrys.get(j)).getDynamicObject("supplier");
                dmap.put(supplier.getPkValue().toString(), supplier);
            }
            for (j = 0; null != busTalkSupplierEntryList && j < busTalkSupplierEntryList.size(); ++j) {
                String supplierId;
                supplier = ((DynamicObject)busTalkSupplierEntryList.get(j)).getDynamicObject("supplier");
                if (supplier == null || null != dmap.get(supplierId = supplier.getPkValue().toString())) continue;
                DynamicObject newSupplierEntry = supplierEntrys.addNew();
                newSupplierEntry.set("supplier", (Object)supplier);
            }
        }
        bidDecision.set("modifytime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidDecision});
    }

    @SdkDeprecated
    public void auditPriceToDecision(Long id, String appId) {
        DynamicObject bustalk = null;
        bustalk = "rebm".equals(appId) ? BusinessDataServiceHelper.loadSingle((Object)id, (String)"rebm_bustalk") : this.bidBustalkService.getBustalkById(id);
        this.auditPriceToDecisionReally(bustalk, appId);
    }

    public void auditPriceToDecisionReally(DynamicObject bustalk, String appId) {
        HashMap<String, DynamicObject> supplierentryMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, DynamicObject> finalDetailMap = new HashMap<String, DynamicObject>(16);
        DynamicObjectCollection bidsections = bustalk.getDynamicObjectCollection("bidsection");
        boolean openonlinesynergy = bustalk.getBoolean("openonlinesynergy");
        for (int i = 0; i < bidsections.size(); ++i) {
            DynamicObject section = (DynamicObject)bidsections.get(i);
            DynamicObjectCollection supplierentrys = section.getDynamicObjectCollection("supplierentry");
            if (supplierentrys != null && supplierentrys.size() > 0) {
                for (int j = 0; j < supplierentrys.size(); ++j) {
                    DynamicObject supplierentry = (DynamicObject)supplierentrys.get(j);
                    DynamicObject supplier = supplierentry.getDynamicObject("supplier");
                    if (supplier == null) continue;
                    String tempKey = i + "_" + supplier.getPkValue();
                    if (openonlinesynergy) {
                        boolean isoffer = supplierentry.getBoolean("isoffer");
                        if (!isoffer) continue;
                        supplierentryMap.put(tempKey, supplierentry);
                        continue;
                    }
                    supplierentryMap.put(tempKey, supplierentry);
                }
            }
            finalDetailMap.put(i + "", section);
        }
        MainEntityType decisionType = EntityMetadataCache.getDataEntityType((String)(appId + "_decision"));
        EntityType backDetailType = (EntityType)decisionType.getAllEntities().get("supbackdetail");
        EntityType finalDetailType = (EntityType)decisionType.getAllEntities().get("supfinaldetail");
        DynamicObject bidDecision = this.getDecision(bustalk, appId);
        DynamicObjectCollection dsections = bidDecision.getDynamicObjectCollection("bidsection");
        for (int i = 0; i < dsections.size(); ++i) {
            DynamicObject section = (DynamicObject)dsections.get(i);
            DynamicObjectCollection backDetails = new DynamicObjectCollection((DynamicObjectType)backDetailType, (Object)section);
            DynamicObjectCollection finalDetails = new DynamicObjectCollection((DynamicObjectType)finalDetailType, (Object)section);
            DynamicObjectCollection dFinalDetails = section.getDynamicObjectCollection("supfinaldetail");
            if (null == dFinalDetails || dFinalDetails.size() == 0) {
                if (null != finalDetailMap.get(i + "")) {
                    DynamicObject temfinalMap = (DynamicObject)finalDetailMap.get(i + "");
                    DynamicObjectCollection purAllDetails = temfinalMap.getDynamicObjectCollection("supplierdetail");
                    for (DynamicObject purDetail : purAllDetails) {
                        DynamicObject newBackDetail = this.newBackDetail(backDetailType, purDetail);
                        DynamicObject purDecisionFinalDetail = this.newFinalDetail(finalDetailType, purDetail, appId);
                        backDetails.add((Object)newBackDetail);
                        finalDetails.add((Object)purDecisionFinalDetail);
                    }
                    section.set("supbackdetail", (Object)backDetails);
                    section.set("supfinaldetail", (Object)finalDetails);
                }
            } else {
                HashMap<String, DynamicObject> dFinalDetailMap = new HashMap<String, DynamicObject>(16);
                for (DynamicObject dFinalDetail : dFinalDetails) {
                    Object tempKey = this.getFinalDetailKey(dFinalDetail);
                    if (appId.equals("rebm")) {
                        tempKey = this.getFinalDetailKeyREBM(dFinalDetail);
                    }
                    dFinalDetailMap.put((String)tempKey, dFinalDetail);
                }
                if (null != finalDetailMap.get(i + "")) {
                    DynamicObject temfinalMap = (DynamicObject)finalDetailMap.get(i + "");
                    DynamicObjectCollection purAllDetails = temfinalMap.getDynamicObjectCollection("supplierdetail");
                    block5: for (DynamicObject purDetail : purAllDetails) {
                        DynamicObject pursupplier = purDetail.getDynamicObject("pursupplier");
                        if (pursupplier == null || supplierentryMap.get(i + "_" + pursupplier.getPkValue()) == null) continue;
                        String tempKey = this.getPurDetailKey(purDetail);
                        if (appId.equals("rebm")) {
                            tempKey = this.getPurDetailKeyREBM(purDetail);
                        }
                        if (null == dFinalDetailMap.get(tempKey)) {
                            Iterator newBackDetail = this.newBackDetail(backDetailType, purDetail);
                            DynamicObject purDecisionFinalDetail = this.newFinalDetail(finalDetailType, purDetail, appId);
                            section.getDynamicObjectCollection("supbackdetail").add((Object)newBackDetail);
                            section.getDynamicObjectCollection("supfinaldetail").add((Object)purDecisionFinalDetail);
                            continue;
                        }
                        for (DynamicObject dFinalDetail : dFinalDetails) {
                            String tempKey1 = this.getFinalDetailKey(dFinalDetail);
                            if (appId.equals("rebm")) {
                                tempKey1 = this.getFinalDetailKeyREBM(dFinalDetail);
                            }
                            if (!tempKey1.equals(tempKey)) continue;
                            dFinalDetail = this.setFinalDetail(dFinalDetail, purDetail, true, appId);
                            continue block5;
                        }
                    }
                }
            }
            DynamicObjectCollection supplierentrys = section.getDynamicObjectCollection("supplierentry");
            for (int j = 0; j < supplierentrys.size(); ++j) {
                DynamicObject supplierentry = (DynamicObject)supplierentrys.get(j);
                DynamicObject supplier = ((DynamicObject)supplierentrys.get(j)).getDynamicObject("supplier");
                String tempKey = i + "_" + supplier.getPkValue();
                if (null == supplierentryMap.get(tempKey)) continue;
                DynamicObject temMap = (DynamicObject)supplierentryMap.get(tempKey);
                supplierentry.set("finalprice", temMap.get("new_price"));
                supplierentry.set("finalexceptvat", temMap.get("bus_exceptvat"));
                supplierentry.set("finalvat", temMap.get("pricevat"));
                supplierentry.set("finaltaxrate", temMap.get("taxrate"));
                supplierentry.set("finalrate", temMap.get("newrate"));
                DynamicObject fileObject = this.bidBustalkSupplierFileService.getAttachmentFileObject(supplierentry.getPkValue());
                Long fileId = null;
                if (null != fileObject) {
                    fileId = (Long)fileObject.getPkValue();
                }
                if (!temMap.getDynamicObjectCollection("technology_new").isEmpty()) {
                    DynamicObjectCollection techfile_new = supplierentry.getDynamicObjectCollection("techfile_new");
                    techfile_new.forEach(attachment -> attachment.set("fbasedataid", null));
                    DynamicObjectCollection technology_new = (DynamicObjectCollection)temMap.get("technology_new");
                    technology_new.forEach(attachment -> {
                        if (null != attachment.get("fbasedataid")) {
                            techfile_new.addNew().set("fbasedataid", attachment.get("fbasedataid"));
                        }
                    });
                }
                DynamicObjectCollection commfile_new = supplierentry.getDynamicObjectCollection("commfile_new");
                commfile_new.forEach(attachment -> attachment.set("fbasedataid", null));
                DynamicObjectCollection business_new = (DynamicObjectCollection)temMap.get("business_new");
                business_new.forEach(attachment -> {
                    if (null != attachment.get("fbasedataid")) {
                        commfile_new.addNew().set("fbasedataid", attachment.get("fbasedataid"));
                    }
                });
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidDecision});
    }

    public void unauditPriceToDecision(IDataModel model, IFormView view, String appId) {
        DynamicObject bustalk = this.getBustalk(model, view);
        DynamicObject bidProject = bustalk.getDynamicObject("bidproject");
        int judgeNum = bustalk.getInt("judge_num");
        Long bidProjectId = bidProject.getLong("id");
        DynamicObject bidDecision = this.getDecision(bustalk, appId);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bid_decision");
        BusinessDataServiceHelper.delete((IDataEntityType)type, (Object[])new Object[]{bidDecision.getPkValue()});
        this.bidDecisionService.createByLastStep(bidProject, BidStepEnum.BidBustalk);
        this.questionClarifyService.clarifyWriteBackBidDesicion(appId, bidProject);
        if (judgeNum != 0) {
            DynamicObjectCollection list = this.bidBustalkService.findBustalkByBidprojectId(bidProjectId, "judge_num asc");
            for (DynamicObject l : list) {
                DynamicObject temp = null;
                temp = "rebm".equals(appId) ? BusinessDataServiceHelper.loadSingle((Object)l.getLong("id"), (String)"rebm_bustalk") : this.bidBustalkService.getBustalkById(Long.valueOf(l.getLong("id")));
                int tempNum = temp.getInt("judge_num");
                if (tempNum == judgeNum) continue;
                this.auditSupplierToDecisionReally(temp, appId);
                this.auditPriceToDecisionReally(temp, appId);
            }
        }
    }

    @SdkDeprecated
    public void setBustalkAuditor(long id, String auditor, Date auditDate) {
        DynamicObject bustalk = this.bidBustalkService.getBustalkById(Long.valueOf(id));
        bustalk.set("auditdate", (Object)auditDate);
        bustalk.set("auditor", (Object)auditor);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bustalk});
    }

    @SdkDeprecated
    public DynamicObject getDecision(DynamicObject bustalk, String appId) {
        DynamicObject bidProject = bustalk.getDynamicObject("bidproject");
        Long bidProjectId = bidProject.getLong("id");
        QFilter qFilter = new QFilter("bidproject.id", "=", (Object)bidProjectId);
        QFilter statusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal());
        DynamicObject bidDecisionObject = QueryServiceHelper.queryOne((String)"bid_decision", (String)"id", (QFilter[])new QFilter[]{qFilter, statusFilter});
        DynamicObject bidDecision = null;
        bidDecision = appId != null && appId.equals("rebm") ? BusinessDataServiceHelper.loadSingle((Object)bidDecisionObject.getLong("id"), (String)"rebm_decision") : this.bidDecisionService.getBidDecisionById(Long.valueOf(bidDecisionObject.getLong("id")));
        return bidDecision;
    }

    public DynamicObject getBustalk(IDataModel model, IFormView view) {
        DynamicObject bustalk = model.getDataEntity(true);
        if (null == bustalk || "bos_list[]".equals(bustalk.toString())) {
            BillList list = (BillList)view.getControl("billlistap");
            ListSelectedRowCollection rows = list.getSelectedRows();
            Long id = (Long)rows.get(0).getPrimaryKeyValue();
            bustalk = this.bidBustalkService.getBustalkById(id);
        }
        return bustalk;
    }

    public DynamicObject newBackDetail(EntityType backDetailType, DynamicObject purDetail) {
        DynamicObject newBackDetail = new DynamicObject((DynamicObjectType)backDetailType);
        newBackDetail.set("seq", newBackDetail.get("seq"));
        newBackDetail.set("pursupplier", purDetail.get("pursupplier"));
        newBackDetail.set("purentrycontent", purDetail.get("purentrycontent"));
        newBackDetail.set("purentryproject", purDetail.get("purentryproject"));
        newBackDetail.set("materialid", purDetail.get("materialid"));
        newBackDetail.set("materialdes", purDetail.get("materialdes"));
        newBackDetail.set("baseunit", purDetail.get("baseunit"));
        newBackDetail.set("qty", purDetail.get("qty"));
        newBackDetail.set("inclutaxprice", (Object)0);
        newBackDetail.set("inclutaxamount", (Object)0);
        newBackDetail.set("taxrate", (Object)0);
        newBackDetail.set("taxamount", (Object)0);
        newBackDetail.set("excepttaxamount", (Object)0);
        newBackDetail.set("costrate", (Object)0);
        return newBackDetail;
    }

    public DynamicObject newFinalDetail(EntityType finalDetailType, DynamicObject purDetail, String appId) {
        DynamicObject purDecisionFinalDetail = new DynamicObject((DynamicObjectType)finalDetailType);
        purDecisionFinalDetail.set("seq", purDecisionFinalDetail.get("seq"));
        purDecisionFinalDetail.set("lpursupplier", purDetail.get("pursupplier"));
        purDecisionFinalDetail.set("lpurentrycontent", purDetail.get("purentrycontent"));
        purDecisionFinalDetail.set("lpurentryproject", purDetail.get("purentryproject"));
        purDecisionFinalDetail.set("lmaterialid", purDetail.get("materialid"));
        purDecisionFinalDetail.set("lmaterialdes", purDetail.get("materialdes"));
        purDecisionFinalDetail.set("lbaseunit", purDetail.get("baseunit"));
        purDecisionFinalDetail.set("lqty", purDetail.get("qty"));
        purDecisionFinalDetail.set("linclutaxprice", purDetail.get("inclutaxprice"));
        purDecisionFinalDetail.set("linclutaxamount", purDetail.get("inclutaxamount"));
        purDecisionFinalDetail.set("ltaxrate", purDetail.get("staxrate"));
        purDecisionFinalDetail.set("lbd_taxrate", purDetail.get("bd_taxrate"));
        purDecisionFinalDetail.set("ltaxamount", purDetail.get("taxamount"));
        purDecisionFinalDetail.set("lexcepttaxamount", purDetail.get("excepttaxamount"));
        purDecisionFinalDetail.set("lcostrate", purDetail.get("costrate"));
        return purDecisionFinalDetail;
    }

    public DynamicObject setFinalDetail(DynamicObject dDetail, DynamicObject purDetail, boolean fromBustalk, String appId) {
        dDetail.set("linclutaxprice", purDetail.get("inclutaxprice"));
        dDetail.set("linclutaxamount", purDetail.get("inclutaxamount"));
        if (fromBustalk) {
            dDetail.set("ltaxrate", purDetail.get("staxrate"));
            dDetail.set("lbd_taxrate", purDetail.get("bd_taxrate"));
        } else {
            dDetail.set("ltaxrate", purDetail.get("taxrate"));
        }
        dDetail.set("ltaxamount", purDetail.get("taxamount"));
        dDetail.set("lexcepttaxamount", purDetail.get("excepttaxamount"));
        dDetail.set("lcostrate", purDetail.get("costrate"));
        return dDetail;
    }

    public String getFinalDetailKey(DynamicObject dFinalDetail) {
        DynamicObject dSupplier = dFinalDetail.getDynamicObject("lpursupplier");
        String ppurentrycontent = dFinalDetail.getString("lpurentrycontent") == null ? "" : dFinalDetail.getString("lpurentrycontent");
        String ppurentryprojectid = dFinalDetail.getDynamicObject("lpurentryproject") == null ? "" : dFinalDetail.getDynamicObject("lpurentryproject").getString("id");
        String pmaterialid = dFinalDetail.getDynamicObject("lmaterialid") == null ? "" : dFinalDetail.getDynamicObject("lmaterialid").getString("id");
        String pmaterialdes = dFinalDetail.getString("lmaterialdes") == null ? "" : dFinalDetail.getString("lmaterialdes");
        String tempKey = dSupplier.getPkValue().toString() + "_" + ppurentrycontent + "_" + ppurentryprojectid + "_" + pmaterialid + "_" + pmaterialdes;
        return tempKey;
    }

    public String getFinalDetailKeyREBM(DynamicObject dFinalDetail) {
        DynamicObject dSupplier = dFinalDetail.getDynamicObject("lpursupplier");
        String ppurentrycontent = dFinalDetail.getString("lpurentrycontent") == null ? "" : dFinalDetail.getString("lpurentrycontent");
        String ppurentryprojectid = dFinalDetail.getDynamicObject("lpurentryproject") == null ? "" : dFinalDetail.getDynamicObject("lpurentryproject").getString("id");
        String pmaterialid = dFinalDetail.getDynamicObject("lmaterialid") == null ? "" : dFinalDetail.getDynamicObject("lmaterialid").getString("id");
        String lresourceitemid = dFinalDetail.getDynamicObject("lresourceitem") == null ? "" : dFinalDetail.getDynamicObject("lresourceitem").getString("id");
        String pmaterialdes = dFinalDetail.getString("lmaterialdes") == null ? "" : dFinalDetail.getString("lmaterialdes");
        String tempKey = dSupplier.getPkValue().toString() + "_" + ppurentrycontent + "_" + ppurentryprojectid + "_" + pmaterialid + "_" + lresourceitemid + "_" + pmaterialdes;
        return tempKey;
    }

    public String getPurDetailKey(DynamicObject purDetail) {
        DynamicObject supplier = purDetail.getDynamicObject("pursupplier");
        String ppurentrycontent = purDetail.getString("purentrycontent") == null ? "" : purDetail.getString("purentrycontent");
        String ppurentryprojectid = purDetail.getDynamicObject("purentryproject") == null ? "" : purDetail.getDynamicObject("purentryproject").getString("id");
        String pmaterialid = purDetail.getDynamicObject("materialid") == null ? "" : purDetail.getDynamicObject("materialid").getString("id");
        String pmaterialdes = purDetail.getString("materialdes") == null ? "" : purDetail.getString("materialdes");
        String tempKey = supplier.getPkValue().toString() + "_" + ppurentrycontent + "_" + ppurentryprojectid + "_" + pmaterialid + "_" + pmaterialdes;
        return tempKey;
    }

    public String getPurDetailKeyREBM(DynamicObject purDetail) {
        DynamicObject supplier = purDetail.getDynamicObject("pursupplier");
        String ppurentrycontent = purDetail.getString("purentrycontent") == null ? "" : purDetail.getString("purentrycontent");
        String ppurentryprojectid = purDetail.getDynamicObject("purentryproject") == null ? "" : purDetail.getDynamicObject("purentryproject").getString("id");
        String pmaterialid = purDetail.getDynamicObject("materialid") == null ? "" : purDetail.getDynamicObject("materialid").getString("id");
        String resourceitemid = purDetail.getDynamicObject("resourceitem") == null ? "" : purDetail.getDynamicObject("resourceitem").getString("id");
        String pmaterialdes = purDetail.getString("materialdes") == null ? "" : purDetail.getString("materialdes");
        String tempKey = supplier.getPkValue().toString() + "_" + ppurentrycontent + "_" + ppurentryprojectid + "_" + pmaterialid + "_" + resourceitemid + "_" + pmaterialdes;
        return tempKey;
    }

    public void deleteDecision(DynamicObject bidProject, String appId) {
        Long bidProjectId = bidProject.getLong("id");
        this.bidDecisionService.createByLastStep(bidProject, null);
        this.questionClarifyService.clarifyWriteBackBidDesicion(appId, bidProject);
        DynamicObjectCollection list = this.bidBustalkService.findBustalkByBidprojectId(bidProjectId, "judge_num asc");
        for (DynamicObject l : list) {
            if ("1".equals(l.getString("is_again_ten"))) continue;
            DynamicObject temp = null;
            temp = appId != null && appId.equals("rebm") ? BusinessDataServiceHelper.loadSingle((Object)l.getLong("id"), (String)"rebm_bustalk") : this.bidBustalkService.getBustalkById(Long.valueOf(l.getLong("id")));
            String billstatus = temp.getString("billstatus");
            if (!billstatus.equals(BillStatusEnum.AUDITED.getVal())) continue;
            this.auditSupplierToDecisionReally(temp, appId);
            this.auditPriceToDecisionReally(temp, appId);
        }
    }
}

