/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.scm.bid.business.bill.IBidEvaluationService;
import kd.scm.bid.business.bill.serviceImpl.BidEvaluationServiceImpl;
import kd.scm.bid.common.enums.BidEvalMethodEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.ScoreMethod;
import kd.scm.bid.formplugin.bill.util.ExpertGradingUtil;

public class BidEvaluationUtil {
    protected IBidEvaluationService bidEvaluationService = new BidEvaluationServiceImpl();

    public Long createPriceClarify(Long bidEvaluationId) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"bid_priceclarify");
        DynamicObject priceClarify = new DynamicObject((DynamicObjectType)mainEntityType);
        priceClarify.set("bidevaluation", (Object)bidEvaluationId);
        RequestContext requestContext = RequestContext.get();
        Long orgId = requestContext.getOrgId();
        priceClarify.set("org", (Object)orgId);
        EntityType sectionEntityType = (EntityType)mainEntityType.getAllEntities().get("bidsection");
        EntityType entryEntityType = (EntityType)mainEntityType.getAllEntities().get("bid_pricclarsuppdetail");
        DynamicObjectCollection sectionColl = new DynamicObjectCollection();
        DynamicObject bidEvaluation = this.bidEvaluationService.getBidEvaluation(bidEvaluationId);
        DynamicObjectCollection bidEvaluationsectionColl = bidEvaluation.getDynamicObjectCollection("bidsection");
        for (int i = 0; i < bidEvaluationsectionColl.size(); ++i) {
            DynamicObject bidEvaluationsection = (DynamicObject)bidEvaluationsectionColl.get(i);
            DynamicObject section = new DynamicObject((DynamicObjectType)sectionEntityType);
            section.set("seq", bidEvaluationsection.get("seq"));
            section.set("sectionname", bidEvaluationsection.get("sectionname"));
            String selectFields = "id,entryseq,section,supplier.id,contact,contactphone";
            DynamicObjectCollection bidEvaluationEntryColl = this.bidEvaluationService.listBidEvalEntryBySections(Long.valueOf(bidEvaluationsection.getLong("id")), selectFields);
            DynamicObjectCollection priceClarifyEntryColl = new DynamicObjectCollection();
            for (int j = 0; j < bidEvaluationEntryColl.size(); ++j) {
                DynamicObject bidEvaluationEntry = (DynamicObject)bidEvaluationEntryColl.get(j);
                DynamicObject priceClarifyEntry = new DynamicObject((DynamicObjectType)entryEntityType);
                priceClarifyEntry.set("seq", bidEvaluationEntry.get("entryseq"));
                priceClarifyEntry.set("supplier", (Object)bidEvaluationEntry.getLong("supplier.id"));
                priceClarifyEntry.set("contact", (Object)bidEvaluationEntry.getString("contact"));
                priceClarifyEntry.set("contactphone", (Object)bidEvaluationEntry.getString("contactphone"));
                priceClarifyEntry.set("rate", (Object)0);
                priceClarifyEntryColl.add((Object)priceClarifyEntry);
            }
            section.set("bid_pricclarsuppdetail", (Object)priceClarifyEntryColl);
            sectionColl.add((Object)section);
        }
        priceClarify.set("bidsection", (Object)sectionColl);
        return this.bidEvaluationService.savePriceClarify(priceClarify);
    }

    public void saveSupplierScoreDetail(Map<Long, String> cacheExpertGradingData, String scoremethod, String evaltype) {
        ArrayList<HashMap<String, Object>> scoreDetailDataList = new ArrayList<HashMap<String, Object>>();
        ArrayList<HashMap<String, Object>> entryDataList = new ArrayList<HashMap<String, Object>>();
        this.setListData(cacheExpertGradingData, scoremethod, evaltype, scoreDetailDataList, entryDataList);
        this.bidEvaluationService.saveSupplierScoreDetail(scoreDetailDataList, entryDataList);
    }

    public void setListData(Map<Long, String> cacheExpertGradingData, String scoremethod, String evaltype, List<HashMap<String, Object>> scoreDetailDataList, List<HashMap<String, Object>> entryDataList) {
        ExpertGradingUtil expertGradingUtil = new ExpertGradingUtil();
        for (Map.Entry<Long, String> cacheExpertGrading : cacheExpertGradingData.entrySet()) {
            Long sectionId = cacheExpertGrading.getKey();
            List<String> supplierColumnKeyList = expertGradingUtil.getExpertGradingSupplierColumnKeys(sectionId);
            String cacheExpertGradingCollStr = cacheExpertGrading.getValue();
            List bidEvalScoreDetailList = (List)SerializationUtils.fromJsonString((String)cacheExpertGradingCollStr, Object.class);
            if (bidEvalScoreDetailList == null || bidEvalScoreDetailList.size() <= 0) continue;
            for (int i = 0; i < bidEvalScoreDetailList.size() - 1; ++i) {
                LinkedHashMap rowData = (LinkedHashMap)bidEvalScoreDetailList.get(i);
                Object proficientId = rowData.get("proficientid");
                if (null == proficientId || "0".equals(proficientId.toString())) continue;
                HashMap<String, Long> data = new HashMap<String, Long>(16);
                for (int j = 0; j < supplierColumnKeyList.size(); ++j) {
                    String columnKey = supplierColumnKeyList.get(j);
                    if (columnKey.startsWith("supplierid_")) {
                        data = new HashMap();
                        scoreDetailDataList.add(data);
                        data.put("section", sectionId);
                        data.put("proficientid", (Long)proficientId);
                        data.put("supplierid_", (Long)rowData.get(columnKey));
                        continue;
                    }
                    if (columnKey.startsWith("technical_")) {
                        data.put("technical_", (Long)rowData.get(columnKey));
                        continue;
                    }
                    if (!columnKey.startsWith("commercial_")) continue;
                    data.put("commercial_", (Long)rowData.get(columnKey));
                }
            }
            LinkedHashMap totalRowData = (LinkedHashMap)bidEvalScoreDetailList.get(bidEvalScoreDetailList.size() - 1);
            HashMap<String, Long> data = new HashMap<String, Long>(16);
            boolean isSpe = ScoreMethod.SPECIAL.getVal().equals(scoremethod);
            boolean istec = BidOpenTypeEnum.TECHNICAL.getValue().equals(evaltype);
            boolean flag = isSpe && istec;
            for (int i = 0; i < supplierColumnKeyList.size(); ++i) {
                String columnKey = supplierColumnKeyList.get(i);
                if (columnKey.startsWith("supplierid_")) {
                    data = new HashMap();
                    entryDataList.add(data);
                    data.put("section", sectionId);
                    data.put("supplierid_", (Long)totalRowData.get(columnKey));
                    continue;
                }
                if (flag && columnKey.startsWith("technical_")) {
                    data.put("commercial_", (Long)totalRowData.get(columnKey));
                    continue;
                }
                if (flag || !columnKey.startsWith("commercial_")) continue;
                data.put("commercial_", (Long)totalRowData.get(columnKey));
            }
        }
    }

    public static boolean getIsBussiness(String evalMethod, String evaltype, DynamicObject bidEvaluation) {
        DynamicObject bidprojectInfo;
        String doctype;
        return StringUtils.equals((CharSequence)evalMethod, (CharSequence)BidEvalMethodEnum.DX.getCode()) && evaltype.equals("BUSSINESS") && (doctype = (bidprojectInfo = bidEvaluation.getDynamicObject("bidproject")).getString("doctype")) != null && !doctype.equals("") && doctype.equals("BUSSINESS");
    }

    public boolean checkScopeBidEvalScoreData(Map<Long, String> cacheExpertGradingData, String scoremethod, String evaltype) {
        ArrayList<HashMap<String, Object>> scoreDetailDataList = new ArrayList<HashMap<String, Object>>();
        ArrayList<HashMap<String, Object>> entryDataList = new ArrayList<HashMap<String, Object>>();
        this.setListData(cacheExpertGradingData, scoremethod, evaltype, scoreDetailDataList, entryDataList);
        for (int i = 0; i < scoreDetailDataList.size(); ++i) {
            BigDecimal sorce;
            HashMap dataMap = (HashMap)scoreDetailDataList.get(i);
            Object commercialScore = dataMap.get("commercial_");
            Object technicalScore = dataMap.get("technical_");
            if (commercialScore != null && ((sorce = (BigDecimal)commercialScore).compareTo(new BigDecimal(0)) < 0 || sorce.compareTo(new BigDecimal(100)) > 0)) {
                return false;
            }
            if (technicalScore == null || (sorce = (BigDecimal)technicalScore).compareTo(new BigDecimal(0)) >= 0 && sorce.compareTo(new BigDecimal(100)) <= 0) continue;
            return false;
        }
        return true;
    }
}

