/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.util;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scm.bid.formplugin.bill.util.CommonFilterGenerator;
import kd.scm.bid.formplugin.bill.util.PartnerUserDealHelper;

public class CommonF7FilterPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private PartnerUserDealHelper helper = new PartnerUserDealHelper();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.registerF7Listener("bidmode");
        this.registerF7Listener("purtype");
        this.registerF7Listener("bidvaluation");
        this.registerF7Listener("purentryproject");
        this.registerF7Listener("evaluatedecideway");
        this.registerF7Listener("majortype");
        this.registerF7Listener("parent");
        this.registerF7Listener("projectpartner");
    }

    private void registerF7Listener(String f7Name) {
        Control control = this.getView().getControl(f7Name);
        if (control != null && BasedataEdit.class.isInstance(control)) {
            ((BasedataEdit)control).addBeforeF7SelectListener((BeforeF7SelectListener)this);
            ((BasedataEdit)control).addAfterF7SelectListener((AfterF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent paramBeforeF7SelectEvent) {
        String fieldKey = paramBeforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"bidmode") || StringUtils.equals((CharSequence)fieldKey, (CharSequence)"bidvaluation") || StringUtils.equals((CharSequence)fieldKey, (CharSequence)"evaluatedecideway") || StringUtils.equals((CharSequence)fieldKey, (CharSequence)"majortype") || StringUtils.equals((CharSequence)fieldKey, (CharSequence)"purtype") || StringUtils.equals((CharSequence)fieldKey, (CharSequence)"purentryproject") || StringUtils.equals((CharSequence)fieldKey, (CharSequence)"parent")) {
            ListShowParameter showParameter = (ListShowParameter)paramBeforeF7SelectEvent.getFormShowParameter();
            String formId = this.getView().getEntityId();
            String appId = this.getModel().getDataEntityType().getAppId();
            if (StringUtils.isNotBlank((CharSequence)formId)) {
                showParameter.getListFilterParameter().setFilter(CommonFilterGenerator.genCommonFilter(formId, appId));
            }
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"purtype")) {
            QFilter filter = new QFilter("id", "not in", (Object)1010818617006240768L);
            paramBeforeF7SelectEvent.addCustomQFilter(filter);
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"projectpartner")) {
            this.helper.dealBeforeF7Select(this, paramBeforeF7SelectEvent);
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        BasedataEdit source = (BasedataEdit)afterF7SelectEvent.getSource();
        String fieldKey = source.getFieldKey();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"projectpartner")) {
            this.helper.dealAfterF7Select(this, afterF7SelectEvent);
            this.getView().updateView("supplierentry");
        }
    }
}

