/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.util;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.scm.bid.common.util.bidabordrepair.BidAbortiveUtil;
import kd.scm.bid.formplugin.bill.util.CommonFilterGenerator;

public class CommonFilterPlugin
extends AbstractListPlugin {
    private static final String[] fieldNames = new String[]{"bidmode.name", "purtype.name", "bidproject.bidmode.name", "bidproject.purtype.name"};

    public void setFilter(SetFilterEvent e) {
        String formId;
        super.setFilter(e);
        BillList list = (BillList)e.getSource();
        String appid = null;
        EntityType type = list.getEntityType();
        if (BillEntityType.class.isInstance(type)) {
            appid = ((BillEntityType)type).getAppId();
        }
        if (StringUtils.isNotBlank((CharSequence)(formId = list.getBillFormId()))) {
            QFilter cf = CommonFilterGenerator.genCommonFilter(formId, appid);
            e.getQFilters().add(cf);
        }
        if (!this.getIngnoreFormIdList().contains(formId)) {
            String billStatusName = BidAbortiveUtil.getBillStatusName((String)formId, (String)formId.split("_")[0]);
            e.getQFilters().add(new QFilter(billStatusName, "!=", (Object)"NOT_SHOW"));
        }
    }

    protected List<String> getIngnoreFormIdList() {
        return Arrays.asList("bid_purtype", "rebm_purtype", "bid_purproject", "rebm_purproject", "bid_bidmode", "rebm_bidmode", "bid_valuationmode", "rebm_valuationmode", "bid_evaluatedecideway", "rebm_evaluatedecideway", "bid_proficienttype", "rebm_proficienttype", "bid_proficient", "rebm_proficient", "bid_proficient_f7", "rebm_proficient_f7");
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        Object source = args.getSource();
        if (CommonFilterColumn.class.isInstance(source)) {
            CommonFilterColumn cfc = (CommonFilterColumn)source;
            if (Arrays.stream(fieldNames).anyMatch(fn -> fn.equals(cfc.getFieldName()))) {
                try {
                    Field field = FilterColumn.class.getDeclaredField("bindBaseDataEntityType");
                    ReflectionUtils.makeAccessible((Field)field);
                    MainEntityType baseType = (MainEntityType)field.get(cfc);
                    if (baseType != null) {
                        String formId = baseType.getName();
                        String appId = baseType.getAppId();
                        if (StringUtils.isNotBlank((CharSequence)formId)) {
                            args.getQFilters().add(CommonFilterGenerator.genCommonFilter(formId, appId));
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

