/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.util;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.scm.bid.business.bill.IMyTenderService;
import kd.scm.bid.business.bill.serviceImpl.MyTenderServiceImpl;
import kd.scm.bid.common.util.MessageChannelUtil;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;

public class NoticeMessageUtil {
    private static final IMyTenderService myTenderService = new MyTenderServiceImpl();

    public static void sendNoticeMessage(DynamicObject bidProject, DynamicObject data, DynamicObjectCollection supplierEntryColl, String projectName, String sectionName, String appId, String entityName) {
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        if (!enable) {
            return;
        }
        Long id = NoticeMessageUtil.saveInvitationSendMessage(bidProject, data, projectName, sectionName, appId);
        for (DynamicObject supplierRow : supplierEntryColl) {
            long supplierID = (Long)supplierRow.getDynamicObject("supplier").getPkValue();
            DynamicObject myTender = myTenderService.getMyTenderByBidProjectAndSupplier((Long)bidProject.getPkValue(), Long.valueOf(supplierID));
            long myTenderId = 0L;
            if (myTender != null) {
                myTenderId = (Long)myTender.getPkValue();
            }
            NoticeMessageUtil.sendMessageToAdminUser(myTenderId, supplierID, appId, projectName, data, entityName, bidProject, sectionName, id);
        }
    }

    protected static void sendMessageToAdminUser(long myTenderId, long supplierID, String appId, String projectName, DynamicObject data, String billName, DynamicObject bidProject, String sectionName, long id) {
        DynamicObject supplier = null;
        String entityName = null;
        if ("bid".equals(appId)) {
            supplier = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"bizpartner", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)supplierID)});
            entityName = "ten_mytender";
        } else {
            supplier = QueryServiceHelper.queryOne((String)"resm_official_supplier", (String)"bizpartner", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)supplierID)});
            entityName = "resp_mytender";
        }
        if (supplier == null) {
            return;
        }
        long bizpartnerId = supplier.getLong("bizpartner");
        DynamicObject bizpartnerUser = QueryServiceHelper.queryOne((String)"bos_bizpartneruser", (String)"user", (QFilter[])new QFilter[]{new QFilter("bizpartner", "=", (Object)bizpartnerId), new QFilter("isadmin", "=", (Object)"1")});
        if (bizpartnerUser == null) {
            return;
        }
        long user = bizpartnerUser.getLong("user");
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"msg");
        if (!enable) {
            return;
        }
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setType("message");
        messageInfo.setMessageTitle(null);
        messageInfo.setMessageContent(null);
        List<Long> receiveUserIds = NoticeMessageUtil.getReceiveUserIds(bidProject, appId, supplierID, sectionName);
        receiveUserIds.add(user);
        messageInfo.setUserIds(receiveUserIds);
        messageInfo.setEntityNumber("bid_invitationsendmessage");
        messageInfo.setBizDataId(Long.valueOf(id));
        messageInfo.setOperation("send");
        String scene = null;
        scene = "winnotice".equals(billName.split("_")[1]) ? "bid_win_notice" : "bid_thanks";
        messageInfo.setTplScene(scene);
        String notifyType = MessageChannelUtil.getNotifyType((String)scene, (String)"bid_invitationsendmessage");
        messageInfo.setNotifyType(notifyType);
        StringBuilder sb = new StringBuilder();
        String contentUrl = System.getProperty("domain.contextUrl");
        String tenantCode = RequestContext.get().getTenantCode();
        contentUrl = contentUrl.replace("{tenantCode}", tenantCode);
        sb.append(contentUrl);
        String lastUrl = "?formId=" + entityName + "&pkId=" + myTenderId + "&supplierId=" + supplierID + "&targetButtonId=button_result";
        sb.append(lastUrl);
        sb.append("&checkRightAppId=");
        sb.append(appId);
        messageInfo.setContentUrl(sb.toString());
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    protected static List<Long> getReceiveUserIds(DynamicObject bidProject, String appId, long supplierID, String sectionName) {
        ArrayList<Long> receiveUserIds = new ArrayList<Long>(16);
        DynamicObject project = BusinessDataServiceHelper.loadSingle((String)(appId + "_project"), (String)"bidmode", (QFilter[])new QFilter[]{new QFilter("id", "=", bidProject.getPkValue())});
        DynamicObject bidmode = project.getDynamicObject("bidmode");
        if (bidmode == null) {
            return receiveUserIds;
        }
        DynamicObject bidPublish = BusinessDataServiceHelper.loadSingle((String)(appId + "_bidpublish"), (String)"bidsection,sectionname,supplier,projectpartner", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", project.getPkValue()), new QFilter("billstatus", "=", (Object)"P")});
        if (bidPublish == null) {
            return receiveUserIds;
        }
        DynamicObjectCollection bidSection = bidPublish.getDynamicObjectCollection("bidsection");
        block0: for (DynamicObject sectionEntry : bidSection) {
            String entrysectionname = sectionEntry.getString("sectionname");
            if (!StringUtils.equals((CharSequence)sectionName, (CharSequence)entrysectionname)) continue;
            DynamicObjectCollection supplierentry = sectionEntry.getDynamicObjectCollection("supplierentry");
            for (DynamicObject entry : supplierentry) {
                long supplierId = (Long)entry.getDynamicObject("supplier").getPkValue();
                if (supplierId != supplierID) continue;
                DynamicObject projectPartner = entry.getDynamicObject("projectpartner");
                if (projectPartner == null) continue block0;
                receiveUserIds.add((Long)projectPartner.getPkValue());
                continue block0;
            }
        }
        return receiveUserIds;
    }

    protected static Long saveInvitationSendMessage(DynamicObject bidProject, DynamicObject data, String projectName, String sectionName, String appId) {
        String bill = "";
        bill = "bid".equals(appId) ? appId + "_invitationsendmessage" : appId + "_invitationsendmessag";
        MainEntityType newOneType = EntityMetadataCache.getDataEntityType((String)bill);
        DynamicObject newOne = new DynamicObject((DynamicObjectType)newOneType);
        long id = ORM.create().genLongId(bill);
        newOne.set("id", (Object)id);
        boolean enablemultisection = bidProject.getBoolean("enablemultisection");
        newOne.set("section", (Object)(enablemultisection ? sectionName : ""));
        newOne.set("invitationid", (Object)String.valueOf(data.getPkValue()));
        newOne.set("projectname", (Object)projectName);
        SaveServiceHelper.save((IDataEntityType)newOneType, (Object[])new DynamicObject[]{newOne});
        return id;
    }
}

