/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.message;

import com.alibaba.fastjson.JSON;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.common.util.messageex.HttpMessageUtil;
import kd.scm.bid.formplugin.message.WxTemplateMsg;
import kd.scm.bid.formplugin.message.wxcache.WxgzCenterCache;

public class WxGongzhMessage {
    private static final String textMessagePath = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=";
    private static final String templateMeaagePath = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=";

    public void sendMessageByWxZhonghao(List<Long> receiveUserIds, Map<String, String> mapInfo) {
        String appId = mapInfo.get("appId");
        if (StringUtils.isBlank((CharSequence)appId) || StringUtils.equals((CharSequence)appId, (CharSequence)"bid")) {
            return;
        }
        String entityNumber = mapInfo.get("entitynumber");
        Map<String, List<String>> userByAppId = this.getAppIdByUserId(receiveUserIds, appId, entityNumber, mapInfo.get("bizdataid"));
        if (userByAppId.size() == 0) {
            BizLog.log((String)"wxgz - not wxgz opendId,please check bas_immapping");
            return;
        }
        List<String> openidList = userByAppId.get("user");
        String accesstoken = WxgzCenterCache.getAccessToken();
        if (StringUtils.isBlank((CharSequence)accesstoken)) {
            BizLog.log((String)"resp - get accesstoken faile,plase check network promble!");
            return;
        }
        String dataStr = mapInfo.get("data");
        TreeMap data = null;
        if (StringUtils.isBlank((CharSequence)dataStr)) {
            data = new TreeMap();
            data.put("first", WxTemplateMsg.item(mapInfo.get("content"), "#000000"));
            String name = ResManager.loadKDString((String)"\u6d88\u606f\u901a\u77e5", (String)"WxGongzhMessage_0", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            data.put("keyword1", WxTemplateMsg.item(name, "#000000"));
            Date date = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String format = dateFormat.format(date);
            data.put("keyword2", WxTemplateMsg.item(format, "#000000"));
        } else {
            data = (TreeMap)JSON.parseObject((String)dataStr, TreeMap.class);
        }
        String tempId = mapInfo.get("tempId");
        if (StringUtils.isBlank((CharSequence)tempId)) {
            tempId = WxgzCenterCache.getDefaultMsgId();
            BizLog.log((String)("wxgz - tempId = " + tempId));
        }
        String result = "";
        String toJSONString = "";
        String realurl = templateMeaagePath + accesstoken;
        for (String openID : openidList) {
            WxTemplateMsg wxTemplateMsg = new WxTemplateMsg();
            wxTemplateMsg.setTouser(openID);
            wxTemplateMsg.setTemplate_id(tempId);
            if (StringUtils.isNotBlank((CharSequence)mapInfo.get("url"))) {
                wxTemplateMsg.setUrl(mapInfo.get("url"));
            }
            wxTemplateMsg.setData(data);
            toJSONString = JSON.toJSONString((Object)wxTemplateMsg);
            result = WxGongzhMessage.sendTextMessage(toJSONString, realurl);
            BizLog.log((String)("wxgzmessage - " + wxTemplateMsg.getTouser() + ": " + result + ",tempId = " + wxTemplateMsg.getTemplate_id() + ",json=" + toJSONString));
        }
    }

    public void opendSendMsg(List<WxTemplateMsg> wxTemplateMsgs) {
        String accesstoken = WxgzCenterCache.getAccessToken();
        if (StringUtils.isBlank((CharSequence)accesstoken)) {
            BizLog.log((String)"resp - get accesstoken faile,plase check network promble!");
            return;
        }
        String toJSONString = "";
        String result = "";
        String realurl = templateMeaagePath + accesstoken;
        for (WxTemplateMsg wxTemplateMsg : wxTemplateMsgs) {
            toJSONString = JSON.toJSONString((Object)wxTemplateMsg);
            result = WxGongzhMessage.sendTextMessage(toJSONString, realurl);
            BizLog.log((String)("wxgzmessage - " + wxTemplateMsg.getTouser() + ": " + result + ",tempId = " + wxTemplateMsg.getTemplate_id() + ",json=" + toJSONString));
        }
    }

    public void sendMessageToAllUser(Map<String, String> mapInfo) {
        String tempId = mapInfo.get("tempId");
        if (StringUtils.isBlank((CharSequence)tempId)) {
            tempId = WxgzCenterCache.getDefaultMsgId();
        }
        if (StringUtils.isBlank((CharSequence)tempId)) {
            BizLog.log((String)"not tempId!");
            return;
        }
        QFilter innerUserQFilter = new QFilter("imtype", "!=", (Object)"-1");
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bas_immapping", (String)"id,userid,imtype,openid", (QFilter[])new QFilter[]{innerUserQFilter});
        if (load == null || load.length == 0) {
            BizLog.log((String)"the bas_immapping not data!");
            return;
        }
        String accesstoken = WxgzCenterCache.getAccessToken();
        if (StringUtils.isBlank((CharSequence)accesstoken)) {
            BizLog.log((String)"resp - get accesstoken faile,plase check network promble!");
            return;
        }
        String dataStr = mapInfo.get("data");
        TreeMap data = null;
        String entitynumber = mapInfo.get("entitynumber");
        if (StringUtils.isBlank((CharSequence)dataStr)) {
            data = new TreeMap();
            data.put("first", WxTemplateMsg.item(mapInfo.get("content"), "#000000"));
            String name = "";
            name = entitynumber.contains("_project_announcement") ? ResManager.loadKDString((String)"\u62db\u6807\u516c\u544a", (String)"WxGongzhMessage_1", (String)"scm-bid-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e2d\u6807\u516c\u544a", (String)"WxGongzhMessage_2", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            data.put("keyword1", WxTemplateMsg.item(name, "#000000"));
            Date date = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd :hh:mm:ss");
            String format = dateFormat.format(date);
            data.put("keyword2", WxTemplateMsg.item(format, "#000000"));
        } else {
            data = (TreeMap)JSON.parseObject((String)dataStr, TreeMap.class);
        }
        String toJSONString = "";
        String result = "";
        String realurl = templateMeaagePath + accesstoken;
        for (DynamicObject record : load) {
            String openid = record.getString("openid");
            WxTemplateMsg wxTemplateMsg = new WxTemplateMsg();
            wxTemplateMsg.setTouser(openid);
            wxTemplateMsg.setTemplate_id(tempId);
            if (StringUtils.isNotBlank((CharSequence)mapInfo.get("url"))) {
                wxTemplateMsg.setUrl(mapInfo.get("url"));
            }
            wxTemplateMsg.setData(data);
            toJSONString = JSON.toJSONString((Object)wxTemplateMsg);
            result = WxGongzhMessage.sendTextMessage(toJSONString, realurl);
            BizLog.log((String)("wxgzmessage - " + wxTemplateMsg.getTouser() + ": " + result + ",tempId = " + wxTemplateMsg.getTemplate_id() + ",json=" + toJSONString));
        }
    }

    public Map<String, List<String>> getAppIdByUserId(List<Long> receiveUserIds, String appId, String entityNumber, String bizdataid) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(16);
        Set<Object> tranceUserInfoSet = new HashSet();
        if (StringUtils.equals((CharSequence)"bid_invitation", (CharSequence)entityNumber) || StringUtils.equals((CharSequence)"rebm_invitation", (CharSequence)entityNumber)) {
            tranceUserInfoSet = this.getUserIdByIn(bizdataid);
        } else {
            tranceUserInfoSet = this.getAdmintUserBySupplier(receiveUserIds);
            if (tranceUserInfoSet == null) {
                tranceUserInfoSet = receiveUserIds.stream().collect(Collectors.toSet());
            }
        }
        if (tranceUserInfoSet.size() == 0) {
            BizLog.log((String)("wxgz - not wxgz tranceUserInfoSet,please check entityNumber = " + entityNumber + ",bizdataid = " + bizdataid));
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append("wxgz -  wxgz tranceUserInfoSet content = {");
            for (Long l : tranceUserInfoSet) {
                builder.append(l).append(',');
            }
            builder.append('}');
            String logData = builder.toString();
            BizLog.log((String)logData);
        }
        QFilter innerUserQFilter = new QFilter("userid", "in", tranceUserInfoSet);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bas_immapping", (String)"id,userid,imtype,openid", (QFilter[])new QFilter[]{innerUserQFilter});
        if (load == null || load.length == 0) {
            return result;
        }
        result.put("user", new ArrayList(16));
        for (DynamicObject record : load) {
            List user = (List)result.get("user");
            user.add(record.getString("openid"));
            result.put("user", user);
        }
        return result;
    }

    public Set<Long> getOpOrPublicUserIdByIn(String bizdataid, String entityNumber) {
        HashSet<Long> ids = new HashSet<Long>();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(bizdataid), (String)entityNumber);
        if (dynamicObject == null) {
            BizLog.log((String)("wxgz - get data is null entityNumber = " + entityNumber + ",bizdataid = " + bizdataid));
            return ids;
        }
        String appId = "rebm";
        String entitytypeid = dynamicObject.getString("entitytypeid");
        if (entitytypeid.startsWith("bid")) {
            appId = "bid";
        }
        QFilter enableFile = new QFilter("enable", "=", (Object)"1");
        QFilter manageFile = new QFilter("isadmin", "=", (Object)"1");
        DynamicObjectCollection bidsection = dynamicObject.getDynamicObjectCollection("bidsection");
        for (DynamicObject section : bidsection) {
            DynamicObjectCollection supplierentry = section.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierRow : supplierentry) {
                DynamicObject sRow = supplierRow.getDynamicObject("supplier");
                DynamicObject supplier = null;
                supplier = StringUtils.equals((CharSequence)appId, (CharSequence)"bid") ? BusinessDataServiceHelper.loadSingle((Object)sRow.getPkValue(), (String)"bd_supplier") : BusinessDataServiceHelper.loadSingle((Object)sRow.getPkValue(), (String)"resm_official_supplier");
                DynamicObject bizpartner = supplier.getDynamicObject("bizpartner");
                QFilter bizQFile = new QFilter("bizpartner", "=", bizpartner.getPkValue());
                DynamicObject[] bos_bizpartnerusers = BusinessDataServiceHelper.load((String)"bos_bizpartneruser", (String)"user", (QFilter[])new QFilter[]{enableFile, manageFile, bizQFile});
                String toString = bos_bizpartnerusers[0].getDynamicObject("user").getPkValue().toString();
                ids.add(Long.parseLong(toString));
            }
        }
        return ids;
    }

    public Set<Long> getUserIdByIn(String bizdataid) {
        HashSet<Long> ids = new HashSet<Long>();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(bizdataid), (String)"rebm_invitation");
        String appId = "rebm";
        String entitytypeid = dynamicObject.getString("entitytypeid");
        if (entitytypeid.startsWith("bid")) {
            appId = "bid";
        }
        QFilter enableFile = new QFilter("enable", "=", (Object)"1");
        QFilter manageFile = new QFilter("isadmin", "=", (Object)"1");
        DynamicObjectCollection supplierentry = dynamicObject.getDynamicObjectCollection("supplierentry");
        for (DynamicObject supplierRow : supplierentry) {
            DynamicObject sRow = supplierRow.getDynamicObject("supplier");
            DynamicObject supplier = null;
            supplier = StringUtils.equals((CharSequence)appId, (CharSequence)"bid") ? BusinessDataServiceHelper.loadSingle((Object)sRow.getPkValue(), (String)"bd_supplier") : BusinessDataServiceHelper.loadSingle((Object)sRow.getPkValue(), (String)"resm_official_supplier");
            DynamicObject bizpartner = supplier.getDynamicObject("bizpartner");
            QFilter bizQFile = new QFilter("bizpartner", "=", bizpartner.getPkValue());
            DynamicObject[] bos_bizpartnerusers = BusinessDataServiceHelper.load((String)"bos_bizpartneruser", (String)"user", (QFilter[])new QFilter[]{enableFile, manageFile, bizQFile});
            String toString = bos_bizpartnerusers[0].getDynamicObject("user").getPkValue().toString();
            ids.add(Long.parseLong(toString));
        }
        return ids;
    }

    public Set<Long> getAdmintUserBySupplier(List<Long> receiveUserIds) {
        HashSet<Long> idsSet = new HashSet<Long>();
        for (Long receiveUserId : receiveUserIds) {
            QFilter manageFile;
            QFilter bizpartNerFilter;
            DynamicObject[] admins;
            boolean exists = QueryServiceHelper.exists((String)"resm_official_supplier", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)receiveUserId)});
            if (!exists) {
                idsSet.add(receiveUserId);
                continue;
            }
            DynamicObject load = BusinessDataServiceHelper.loadSingle((Object)receiveUserId, (String)"resm_official_supplier");
            if (load == null) continue;
            HashSet<Object> bizparttnerIds = new HashSet<Object>();
            DynamicObject bizpartner = load.getDynamicObject("bizpartner");
            if (bizpartner != null) {
                bizparttnerIds.add(bizpartner.getPkValue());
            }
            if ((admins = BusinessDataServiceHelper.load((String)"bos_bizpartneruser", (String)"id,user,isadmin", (QFilter[])new QFilter[]{bizpartNerFilter = new QFilter("bizpartner", "in", bizparttnerIds), manageFile = new QFilter("isadmin", "=", (Object)"1")})) == null || admins.length == 0) continue;
            Long id = Long.parseLong(admins[0].getDynamicObject("user").getPkValue().toString());
            idsSet.add(id);
        }
        return idsSet;
    }

    public static String sendTextMessage(String jsonObiect, String sendPath) {
        String resp = "";
        try {
            try {
                resp = HttpMessageUtil.post((String)sendPath, (String)jsonObiect);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resp;
    }
}

