/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.mobilebill;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.bid.common.util.MobileDynamicEntryUtils;

public class BidDocumentAuditPlugin
extends AbstractMobBillPlugIn {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final Map<String, String> fieldsMap = new LinkedHashMap<String, String>();

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject data = this.getModel().getDataEntity();
        this.visibleAttachments(data);
        Map<String, String> fieldsMap = this.loadColumns();
        this.loadEntry(fieldsMap);
    }

    private Map<String, String> loadColumns() {
        return new LinkedHashMap<String, String>(fieldsMap);
    }

    private void visibleAttachments(DynamicObject data) {
        if (data.getBoolean("isseparatedoc")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"tech_attachmentpanelap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"com_attachmentpanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"attachmentpanel"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"attachmentpanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tech_attachmentpanelap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"com_attachmentpanel"});
        }
    }

    private void loadEntry(Map<String, String> fieldsMap) {
        List<Map<String, Object>> dataList;
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        DynamicObjectCollection bidsections = dynamicObject.getDynamicObjectCollection("biddocumententry");
        if (bidsections != null && bidsections.size() == 1) {
            fieldsMap.remove("sectionname");
        }
        if (!CollectionUtils.isEmpty(dataList = this.buildData(bidsections))) {
            MobileDynamicEntryUtils.rebuildGridCols((IFormView)this.getView(), (String)KEY_ENTRYENTITY, dataList, fieldsMap);
        }
    }

    private List<Map<String, Object>> buildData(DynamicObjectCollection bidsections) {
        if (CollectionUtils.isEmpty((Collection)bidsections)) {
            return null;
        }
        DecimalFormat df = new DecimalFormat("#0.00");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (DynamicObject bidsectionObj : bidsections) {
            DynamicObjectCollection projectentrys = bidsectionObj.getDynamicObjectCollection("biddocdetail");
            if (CollectionUtils.isEmpty((Collection)projectentrys)) continue;
            for (DynamicObject dy : projectentrys) {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("id", dy.getPkValue());
                map.put("sectionname", bidsectionObj.getString("sectionname"));
                map.put("purentrycontent", dy.getString("purentrycontent"));
                DynamicObject purentryproject = dy.getDynamicObject("purentryproject");
                map.put("purentryproject", purentryproject == null ? "" : purentryproject.getString("name"));
                map.put("inclutaxamount", "\u00a5" + df.format(dy.getBigDecimal("inclutaxamount")));
                map.put("taxrate", "\u00a5" + df.format(dy.getBigDecimal("taxrate")));
                map.put("taxamount", "\u00a5" + df.format(dy.getBigDecimal("taxamount")));
                map.put("excepttaxamount", "\u00a5" + df.format(dy.getBigDecimal("excepttaxamount")));
                list.add(map);
            }
        }
        return list;
    }

    static {
        fieldsMap.put("seq", ResManager.loadKDString((String)"\u5e8f\u53f7:40px", (String)"BidDocumentAuditPlugin_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("sectionname", ResManager.loadKDString((String)"\u6807\u6bb5\u540d\u79f0:120px", (String)"BidDocumentAuditPlugin_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("purentrycontent", ResManager.loadKDString((String)"\u62db\u6807\u5185\u5bb9:160px", (String)"BidDocumentAuditPlugin_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("purentryproject", ResManager.loadKDString((String)"\u91c7\u8d2d\u9879\u76ee:240px", (String)"BidDocumentAuditPlugin_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("inclutaxamount", ResManager.loadKDString((String)"\u542b\u7a0e\u603b\u4ef7:120px", (String)"BidDocumentAuditPlugin_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("taxrate", ResManager.loadKDString((String)"\u7a0e\u7387:120px", (String)"BidDocumentAuditPlugin_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("taxamount", ResManager.loadKDString((String)"\u7a0e\u989d:120px", (String)"BidDocumentAuditPlugin_6", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("excepttaxamount", ResManager.loadKDString((String)"\u4e0d\u542b\u7a0e\u603b\u4ef7:120px", (String)"BidDocumentAuditPlugin_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
    }
}

