/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.mobilebill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.scm.bid.common.enums.InvitationStatusEnum;
import kd.scm.bid.common.util.MobileDynamicEntryUtils;

public class BidShortlistedAuditPlugin
extends AbstractMobBillPlugIn {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_SIGNENTITY = "signentity";
    private static final String SIGN_SUPPLIER_FLEX = "flexpanelap2";
    private static final Map<String, String> fieldsMap = new LinkedHashMap<String, String>();

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject data = this.getModel().getDataEntity();
        this.visibleSignSupplierTabPage(data);
    }

    private void visibleSignSupplierTabPage(DynamicObject data) {
        boolean flag = false;
        String bidmodeName = data.getString("bidproject.bidmode.name");
        if (!StringUtils.isEmpty((Object)bidmodeName)) {
            flag = bidmodeName.contains(ResManager.loadKDString((String)"\u516c\u5f00\u62db\u6807", (String)"BidShortlistedAuditPlugin_12", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        }
        if (flag) {
            this.getView().setVisible(Boolean.TRUE, new String[]{SIGN_SUPPLIER_FLEX});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{SIGN_SUPPLIER_FLEX});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map<String, String> fieldsMap = this.loadColumns();
        this.loadEntry(fieldsMap);
    }

    private Map<String, String> loadColumns() {
        return new LinkedHashMap<String, String>(fieldsMap);
    }

    private void loadEntry(Map<String, String> fieldsMap) {
        DynamicObjectCollection bidenrollsection;
        List<Map<String, Object>> dataList;
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        DynamicObjectCollection bidsections = dynamicObject.getDynamicObjectCollection("bidsection");
        if (bidsections != null && bidsections.size() == 1) {
            fieldsMap.remove("sectionname");
        }
        if (!CollectionUtils.isEmpty(dataList = this.buildData(bidsections, false))) {
            MobileDynamicEntryUtils.rebuildGridCols((IFormView)this.getView(), (String)KEY_ENTRYENTITY, dataList, fieldsMap);
        }
        if (!CollectionUtils.isEmpty((Collection)(bidenrollsection = dynamicObject.getDynamicObjectCollection("bidenrollsection")))) {
            fieldsMap.remove("invitationstatus");
            fieldsMap.remove("suppliercomment");
            fieldsMap.put("isinvitation", ResManager.loadKDString((String)"\u662f\u5426\u63a8\u8350\u5165\u56f4:120px", (String)"BidShortlistedAuditPlugin_13", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            fieldsMap.put("suppliercomment", ResManager.loadKDString((String)"\u539f\u56e0\u8bf4\u660e:200px", (String)"BidShortlistedAuditPlugin_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            List<Map<String, Object>> signList = this.buildData(bidenrollsection, true);
            if (!CollectionUtils.isEmpty(signList)) {
                MobileDynamicEntryUtils.rebuildGridCols((IFormView)this.getView(), (String)KEY_SIGNENTITY, signList, fieldsMap);
            }
        }
    }

    private List<Map<String, Object>> buildData(DynamicObjectCollection bidsections, boolean isSign) {
        if (CollectionUtils.isEmpty((Collection)bidsections)) {
            return null;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (DynamicObject bidsectionObj : bidsections) {
            DynamicObjectCollection projectentrys = null;
            projectentrys = isSign ? bidsectionObj.getDynamicObjectCollection("supplierenrollentry") : bidsectionObj.getDynamicObjectCollection("supplierentry");
            if (CollectionUtils.isEmpty((Collection)projectentrys)) continue;
            for (DynamicObject dy : projectentrys) {
                DynamicObject supplier;
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("id", dy.getPkValue());
                if (isSign) {
                    map.put("sectionname", bidsectionObj.getString("entrysectionname"));
                    supplier = dy.getDynamicObject("enrollsupplier");
                    map.put("supplier", supplier == null ? "" : supplier.getString("name"));
                    map.put("suppliercontact", dy.getString("enrollsuppliercontact"));
                    map.put("contactphone", dy.getString("enrollcontactphone"));
                    map.put("email", dy.getString("enrollemail"));
                    map.put("address", dy.getString("enrolladdress"));
                    map.put("fax", dy.getString("enrollfax"));
                    DynamicObject statistic = dy.getDynamicObject("enrollsupplierstatistic");
                    map.put("invitedqty", statistic == null ? "" : statistic.getString("invitedqty"));
                    map.put("wonqty", statistic == null ? "" : statistic.getString("wonqty"));
                    map.put("isinvitation", dy.getBoolean("isinvitation") ? ResManager.loadKDString((String)"\u662f", (String)"BidShortlistedAuditPlugin_14", (String)"scm-bid-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"BidShortlistedAuditPlugin_15", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    map.put("suppliercomment", dy.getString("enrollsuppliercomment"));
                } else {
                    map.put("sectionname", bidsectionObj.getString("sectionname"));
                    supplier = dy.getDynamicObject("supplier");
                    map.put("supplier", supplier == null ? "" : supplier.getString("name"));
                    map.put("suppliercontact", dy.getString("suppliercontact"));
                    map.put("contactphone", dy.getString("contactphone"));
                    map.put("email", dy.getString("email"));
                    map.put("address", dy.getString("address"));
                    map.put("fax", dy.getString("fax"));
                    String invitationstatus = dy.getString("invitationstatus");
                    if (InvitationStatusEnum.ACCEPTED.getCode().equals(invitationstatus)) {
                        invitationstatus = InvitationStatusEnum.ACCEPTED.getText();
                    } else if (InvitationStatusEnum.REJECTED.getCode().equals(invitationstatus)) {
                        invitationstatus = InvitationStatusEnum.REJECTED.getText();
                    } else if (InvitationStatusEnum.UNCONFIRM.getCode().equals(invitationstatus)) {
                        invitationstatus = InvitationStatusEnum.UNCONFIRM.getText();
                    } else if (InvitationStatusEnum.UNSEND.getCode().equals(invitationstatus)) {
                        invitationstatus = InvitationStatusEnum.UNSEND.getText();
                    }
                    map.put("invitationstatus", invitationstatus);
                    DynamicObject statistic = dy.getDynamicObject("supplierstatistic");
                    map.put("invitedqty", statistic == null ? "" : statistic.getString("invitedqty"));
                    map.put("wonqty", statistic == null ? "" : statistic.getString("wonqty"));
                    map.put("suppliercomment", dy.getString("suppliercomment"));
                }
                list.add(map);
            }
        }
        return list;
    }

    static {
        fieldsMap.put("seq", ResManager.loadKDString((String)"\u5e8f\u53f7:40px", (String)"BidShortlistedAuditPlugin_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("sectionname", ResManager.loadKDString((String)"\u6807\u6bb5\u540d\u79f0:120px", (String)"BidShortlistedAuditPlugin_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("supplier", ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u540d\u79f0:240px", (String)"BidShortlistedAuditPlugin_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("suppliercontact", ResManager.loadKDString((String)"\u8054\u7cfb\u4eba:120px", (String)"BidShortlistedAuditPlugin_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("contactphone", ResManager.loadKDString((String)"\u8054\u7cfb\u7535\u8bdd:120px", (String)"BidShortlistedAuditPlugin_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("email", ResManager.loadKDString((String)"\u7535\u5b50\u90ae\u4ef6:200px", (String)"BidShortlistedAuditPlugin_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("address", ResManager.loadKDString((String)"\u8054\u7cfb\u5730\u5740:300px", (String)"BidShortlistedAuditPlugin_6", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("fax", ResManager.loadKDString((String)"\u4f20\u771f:120px", (String)"BidShortlistedAuditPlugin_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("invitationstatus", ResManager.loadKDString((String)"\u9080\u8bf7\u51fd\u72b6\u6001:120px", (String)"BidShortlistedAuditPlugin_8", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("invitedqty", ResManager.loadKDString((String)"\u5165\u56f4\u6b21\u6570:120px", (String)"BidShortlistedAuditPlugin_9", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("wonqty", ResManager.loadKDString((String)"\u4e2d\u6807\u6b21\u6570:120px", (String)"BidShortlistedAuditPlugin_10", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("suppliercomment", ResManager.loadKDString((String)"\u539f\u56e0\u8bf4\u660e:200px", (String)"BidShortlistedAuditPlugin_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
    }
}

