/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.repair;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.helper.BidFileHelper;

public class BidBusTalkFileRepair
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bidOpenF7 = (BasedataEdit)this.getView().getControl("bidopen");
        bidOpenF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit busTalkF7 = (BasedataEdit)this.getView().getControl("bustalk");
        busTalkF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit questionClarifyF7 = (BasedataEdit)this.getView().getControl("questionclarify");
        questionClarifyF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"bustalk")) {
            this.getModel().setValue("bidopen", null);
            this.getModel().setValue("questionclarify", null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey = event.getProperty().getName();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObject busTalk = dataEntity.getDynamicObject("bustalk");
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"bidopen")) {
            if (busTalk == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u52a1\u8c08\u5224\u3002", (String)"BidBusTalkFileRepair_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            DynamicObject bidProject = busTalk.getDynamicObject("bidproject");
            QFilter qFilter = new QFilter("bidproject", "=", bidProject.getPkValue());
            showParameter.getListFilterParameter().setFilter(qFilter);
        } else if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"questionclarify")) {
            if (busTalk == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u52a1\u8c08\u5224\u3002", (String)"BidBusTalkFileRepair_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            DynamicObject bidProject = busTalk.getDynamicObject("bidproject");
            QFilter qFilter = new QFilter("bidproject", "=", bidProject.getPkValue());
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("audit".equals(operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObject busTalk = dataEntity.getDynamicObject("bustalk");
            String fileSource = dataEntity.getString("filesource");
            DynamicObject bidOpen = dataEntity.getDynamicObject("bidopen");
            DynamicObject questionClarify = dataEntity.getDynamicObject("questionclarify");
            String entityTypeId = busTalk.getString("entitytypeid");
            String appId = entityTypeId.split("_")[0];
            if ("bidopen".equals(fileSource)) {
                DynamicObject realBusTalk;
                HashMap<String, Object> supplierFileMap = new HashMap<String, Object>();
                DynamicObject realBidOpen = BusinessDataServiceHelper.loadSingle((Object)bidOpen.getPkValue(), (String)(appId + "_bidopen"));
                if (realBidOpen != null) {
                    DynamicObjectCollection bidSectionCol = realBidOpen.getDynamicObjectCollection("bidsection");
                    for (Object bidSection : bidSectionCol) {
                        String sectionName = bidSection.getString("sectionname");
                        DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                        for (Object supplierEntry : supplierEntryCol) {
                            DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                            if (supplier == null) continue;
                            String key = String.format("%s_%s", sectionName, supplier.getPkValue());
                            supplierFileMap.put(key, supplierEntry);
                        }
                    }
                }
                if ((realBusTalk = BusinessDataServiceHelper.loadSingle((Object)busTalk.getPkValue(), (String)(appId + "_bustalk"))) != null) {
                    DynamicObjectCollection bidSectionCol = realBusTalk.getDynamicObjectCollection("bidsection");
                    for (DynamicObject bidSection : bidSectionCol) {
                        String sectionName = bidSection.getString("sectionname");
                        DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                        for (DynamicObject supplierEntry : supplierEntryCol) {
                            DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                            if (supplier == null) continue;
                            String key = String.format("%s_%s", sectionName, supplier.getPkValue());
                            DynamicObject supplierFile = supplierFileMap.getOrDefault(key, null);
                            this.copyToEntryAttach(supplierFile, "supplier_techattach", supplierEntry, "technology_new");
                            this.copyToEntryAttach(supplierFile, "supplier_comattach", supplierEntry, "business_new");
                            this.copyToEntryAttach(supplierFile, "supplier_otherattach", supplierEntry, "otherfile_new");
                        }
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{realBusTalk});
                }
            } else if ("bidquestionclarify".equals(fileSource)) {
                String clarifyFormIde = appId + "_questionclarify";
                DynamicObject clarifyQuestion = BusinessDataServiceHelper.loadSingle((Object)questionClarify.getPkValue(), (String)clarifyFormIde);
                if (clarifyQuestion != null) {
                    DynamicObjectCollection sectionColl = clarifyQuestion.getDynamicObjectCollection("bidsection");
                    String clarifySectionName = ((DynamicObject)sectionColl.get(0)).getString("sectionname");
                    String clarifySupplier = clarifyQuestion.getString("clarifysupplier");
                    String[] values = clarifySupplier.split("&&");
                    String clarifySupplierId = values[0];
                    List techList = AttachmentServiceHelper.getAttachments((String)clarifyFormIde, (Object)clarifyQuestion.getPkValue(), (String)"techattachment");
                    List comList = AttachmentServiceHelper.getAttachments((String)clarifyFormIde, (Object)clarifyQuestion.getPkValue(), (String)"commercattachment");
                    List otherList = AttachmentServiceHelper.getAttachments((String)clarifyFormIde, (Object)clarifyQuestion.getPkValue(), (String)"otherattachment");
                    DynamicObject realBusTalk = BusinessDataServiceHelper.loadSingle((Object)busTalk.getPkValue(), (String)(appId + "_bustalk"));
                    if (realBusTalk != null) {
                        DynamicObjectCollection bidSectionCol = realBusTalk.getDynamicObjectCollection("bidsection");
                        for (DynamicObject bidSection : bidSectionCol) {
                            String sectionName = bidSection.getString("sectionname");
                            if (!clarifySectionName.equals(sectionName)) continue;
                            DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                            for (DynamicObject supplierEntry : supplierEntryCol) {
                                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                                if (supplier == null || !clarifySupplierId.equals(supplier.getString("id"))) continue;
                                this.copyToEntryAttachByAttachList(techList, supplierEntry, "technology_new");
                                this.copyToEntryAttachByAttachList(comList, supplierEntry, "business_new");
                                this.copyToEntryAttachByAttachList(otherList, supplierEntry, "otherfile_new");
                            }
                        }
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{realBusTalk});
                    }
                }
            } else if ("bidbustalk".equals(fileSource)) {
                BizLog.log((String)ResManager.loadKDString((String)"\u5546\u52a1\u8c08\u5224\u9644\u4ef6\u4fee\u590d\u5f00\u59cb", (String)"BidBusTalkFileRepair_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                DynamicObject realBusTalk = BusinessDataServiceHelper.loadSingle((Object)busTalk.getPkValue(), (String)(appId + "_bustalk"));
                if (realBusTalk != null) {
                    ArrayList<Object> entryIdList = new ArrayList<Object>(16);
                    DynamicObjectCollection bidSectionCol = realBusTalk.getDynamicObjectCollection("bidsection");
                    for (DynamicObject bidSection : bidSectionCol) {
                        DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                        for (DynamicObject supplierEntry : supplierEntryCol) {
                            entryIdList.add(supplierEntry.getPkValue());
                        }
                    }
                    BizLog.log((String)(ResManager.loadKDString((String)"\u5546\u52a1\u8c08\u5224\u9644\u4ef6\uff0c\u4f9b\u5e94\u5546\u5206\u5f55id\u6570\u91cf: ", (String)"BidBusTalkFileRepair_3", (String)"scm-bid-formplugin", (Object[])new Object[0]) + entryIdList.size()));
                    String clarifyFormIde = "bid_bustalk_file";
                    DynamicObject[] busTalkFileArray = BusinessDataServiceHelper.load((String)clarifyFormIde, (String)"id,type,sectionid,supplierid", (QFilter[])new QFilter[]{new QFilter("sectionid", "in", entryIdList)});
                    if (busTalkFileArray != null && busTalkFileArray.length > 0) {
                        BizLog.log((String)(ResManager.loadKDString((String)"\u5546\u52a1\u8c08\u5224\u9644\u4ef6\uff0c\u9644\u4ef6\u6570\u91cf: ", (String)"BidBusTalkFileRepair_4", (String)"scm-bid-formplugin", (Object[])new Object[0]) + busTalkFileArray.length));
                        HashMap<String, Long> fileMap = new HashMap<String, Long>(16);
                        for (DynamicObject busTalkFile : busTalkFileArray) {
                            String key = busTalkFile.getString("sectionid") + "_" + busTalkFile.getString("supplierid") + "_" + busTalkFile.getString("type");
                            fileMap.put(key, busTalkFile.getLong("id"));
                        }
                        for (DynamicObject bidSection : bidSectionCol) {
                            DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                            for (DynamicObject supplierEntry : supplierEntryCol) {
                                String otherFileKey;
                                Long otherFileId;
                                String techFileKey;
                                Long techFileId;
                                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                                String comFileKey = supplierEntry.getString("id") + "_" + supplier.getString("id") + "_comFile";
                                Long comFileId = (Long)fileMap.get(comFileKey);
                                if (comFileId != null) {
                                    List comList = AttachmentServiceHelper.getAttachments((String)"bid_bustalk_file", (Object)comFileId, (String)"attachmentpanelap", (boolean)false);
                                    this.copyToEntryAttachByAttachList(comList, supplierEntry, "business_new");
                                }
                                if ((techFileId = (Long)fileMap.get(techFileKey = supplierEntry.getString("id") + "_" + supplier.getString("id") + "_techFile")) != null) {
                                    List techList = AttachmentServiceHelper.getAttachments((String)"bid_bustalk_file", (Object)techFileId, (String)"attachmentpanelap", (boolean)false);
                                    this.copyToEntryAttachByAttachList(techList, supplierEntry, "technology_new");
                                }
                                if ((otherFileId = (Long)fileMap.get(otherFileKey = supplierEntry.getString("id") + "_" + supplier.getString("id") + "_otherFile")) == null) continue;
                                List otherList = AttachmentServiceHelper.getAttachments((String)"bid_bustalk_file", (Object)techFileId, (String)"attachmentpanelap", (boolean)false);
                                this.copyToEntryAttachByAttachList(otherList, supplierEntry, "otherfile_new");
                            }
                        }
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{realBusTalk});
                        BizLog.log((String)ResManager.loadKDString((String)"\u5546\u52a1\u8c08\u5224\u9644\u4ef6\u4fee\u590d\u5b8c\u6210", (String)"BidBusTalkFileRepair_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    }
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("audit".equals(operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            if (operationResult.isSuccess()) {
                dataEntity.set("bizstatus", (Object)"success");
            } else {
                dataEntity.set("bizstatus", (Object)"fail");
            }
            this.getView().updateView("bizstatus");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
        }
    }

    protected void copyToEntryAttach(DynamicObject bidOpenSupplierEntry, String bidOpenEntryProperty, DynamicObject supplierEntry, String entryProperty) {
        DynamicObjectCollection bidOpenFileCol = bidOpenSupplierEntry.getDynamicObjectCollection(bidOpenEntryProperty);
        DynamicObjectCollection inviteAttachFiles = supplierEntry.getDynamicObjectCollection(entryProperty);
        inviteAttachFiles.clear();
        bidOpenFileCol.stream().forEach(item -> {
            DynamicObject oldAttachment = item.getDynamicObject("fbasedataid");
            DynamicObject inviteAttach = inviteAttachFiles.addNew();
            DynamicObject newAttachment = BidFileHelper.copyBdAttachment((DynamicObject)oldAttachment);
            if (newAttachment != null) {
                inviteAttach.set("fbasedataid", (Object)newAttachment);
            } else {
                inviteAttach.set("fbasedataid", (Object)oldAttachment);
            }
        });
        supplierEntry.set(entryProperty, (Object)inviteAttachFiles);
    }

    protected void copyToEntryAttachByAttachList(List<Map<String, Object>> attachList, DynamicObject supplierEntry, String entryProperty) {
        if (attachList != null && attachList.size() > 0) {
            List attachments = BidFileHelper.copyToEntryAttachment(attachList);
            DynamicObjectCollection inviteAttachFiles = supplierEntry.getDynamicObjectCollection(entryProperty);
            inviteAttachFiles.clear();
            attachments.stream().forEach(item -> {
                DynamicObject inviteAttach = inviteAttachFiles.addNew();
                inviteAttach.set("fbasedataid", item);
            });
            supplierEntry.set(entryProperty, (Object)inviteAttachFiles);
        }
    }
}

