/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.repair;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.helper.BidFileHelper;
import kd.scm.bid.common.util.BidDynamicObjectUtil;

public class BidOpenFileRepair
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String TECH_SUFFIX = "_tech";
    private static final String BUS_SUFFIX = "_bus";
    private static final String OTHER_SUFFIX = "_other";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bidProjectF7 = (BasedataEdit)this.getView().getControl("bidproject");
        bidProjectF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bidOpenF7 = (BasedataEdit)this.getView().getControl("bidopen");
        bidOpenF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit onlineBidF7 = (BasedataEdit)this.getView().getControl("onlinebid");
        onlineBidF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("audit".equals(operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObject selectBidProject = dataEntity.getDynamicObject("bidproject");
            DynamicObject selectBidOpen = dataEntity.getDynamicObject("bidopen");
            DynamicObject selectOnlineBid = dataEntity.getDynamicObject("onlinebid");
            String appId = selectBidProject.getString("entitytypeid").split("_")[0];
            String tenAppId = BidOpenFileRepair.getTenAppId(appId);
            DynamicObject onlineBid = BusinessDataServiceHelper.loadSingle((Object)selectOnlineBid.getPkValue(), (String)(tenAppId + "_online_bid"));
            if (onlineBid != null) {
                DynamicObject[] onlineBidDetailArray = BusinessDataServiceHelper.load((String)(tenAppId + "_online_bid_detail"), (String)BidDynamicObjectUtil.getAllSelectProperties((String)(tenAppId + "_online_bid_detail")), (QFilter[])new QFilter[]{new QFilter("onlinebidid", "=", onlineBid.getPkValue())});
                if (onlineBidDetailArray == null || onlineBidDetailArray.length == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5728\u7ebf\u6295\u6807\u8be6\u60c5\u6570\u636e\uff0c\u6570\u636e\u5f02\u5e38\u3002", (String)"BidOpenFileRepair_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                }
                DynamicObject bidOpen = BusinessDataServiceHelper.loadSingle((Object)selectBidOpen.getPkValue(), (String)(appId + "_bidopen"));
                if (bidOpen == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5f00\u6807\u6570\u636e\uff0c\u6570\u636e\u5f02\u5e38\u3002", (String)"BidOpenFileRepair_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                }
                this.saveBidOpenData(appId, onlineBid, onlineBidDetailArray, bidOpen);
            }
        } else if ("unaudit".equals(operateKey)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4fee\u590d\u6570\u636e\u4e0d\u652f\u6301\u53cd\u5ba1\u6838\u3002", (String)"BidOpenFileRepair_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("audit".equals(operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            if (operationResult.isSuccess()) {
                dataEntity.set("bizstatus", (Object)"success");
            } else {
                dataEntity.set("bizstatus", (Object)"fail");
            }
            this.getView().updateView("bizstatus");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
        }
    }

    /*
     * WARNING - void declaration
     */
    public void saveBidOpenData(String appId, DynamicObject onlineBid, DynamicObject[] onlineBidDetailArray, DynamicObject bidOpen) {
        void var17_31;
        Map map;
        Map busFileMap;
        Map techFileMap;
        String tenAppId = BidOpenFileRepair.getTenAppId(appId);
        DynamicObject supplier = onlineBid.getDynamicObject("supplier");
        if (supplier == null) {
            return;
        }
        String supplierId = supplier.getString("id");
        ArrayList<Object> onlineBidDetailPkList = new ArrayList<Object>(16);
        HashMap<String, DynamicObject> onlineBidDetailMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject onlineBidDetail : onlineBidDetailArray) {
            String sectionName = onlineBidDetail.getString("sectionname");
            onlineBidDetailMap.put(sectionName, onlineBidDetail);
            onlineBidDetailPkList.add(onlineBidDetail.getPkValue());
        }
        String onlineBidDetailFormId = tenAppId + "_online_bid_detail";
        HashMap<String, List> fileMap = new HashMap<String, List>(5);
        List inviteFileList = AttachmentServiceHelper.getAttachments((String)(tenAppId + "_online_bid"), (Object)onlineBid.getPkValue(), (String)"inviteattachment", (boolean)false);
        if (!CollectionUtils.isEmpty((Collection)inviteFileList)) {
            fileMap.put(onlineBid.getPkValue().toString(), inviteFileList);
        }
        if (!CollectionUtils.isEmpty((Map)(techFileMap = AttachmentServiceHelper.getAttachments((String)onlineBidDetailFormId, (Object[])onlineBidDetailPkList.toArray(), (String)"techattachment", (boolean)false)))) {
            for (Map.Entry entry : techFileMap.entrySet()) {
                List list = (List)entry.getValue();
                if (CollectionUtils.isEmpty((Collection)list)) continue;
                fileMap.put((String)entry.getKey() + TECH_SUFFIX, list);
            }
        }
        if (!CollectionUtils.isEmpty((Map)(busFileMap = AttachmentServiceHelper.getAttachments((String)onlineBidDetailFormId, (Object[])onlineBidDetailPkList.toArray(), (String)"busattachment", (boolean)false)))) {
            for (Map.Entry entry : busFileMap.entrySet()) {
                List list = (List)entry.getValue();
                if (CollectionUtils.isEmpty((Collection)list)) continue;
                fileMap.put((String)entry.getKey() + BUS_SUFFIX, list);
            }
        }
        if (!CollectionUtils.isEmpty((Map)(map = AttachmentServiceHelper.getAttachments((String)onlineBidDetailFormId, (Object[])onlineBidDetailPkList.toArray(), (String)"otherattachment", (boolean)false)))) {
            for (Map.Entry entry : map.entrySet()) {
                List fileList = (List)entry.getValue();
                if (CollectionUtils.isEmpty((Collection)fileList)) continue;
                fileMap.put((String)entry.getKey() + OTHER_SUFFIX, fileList);
            }
        }
        DynamicObjectCollection dynamicObjectCollection = bidOpen.getDynamicObjectCollection("bidsection");
        boolean bl = false;
        while (var17_31 < dynamicObjectCollection.size()) {
            DynamicObject bidSection = (DynamicObject)dynamicObjectCollection.get((int)var17_31);
            String sectionName = bidSection.getString("sectionname");
            DynamicObjectCollection supplierEntryColl = bidSection.getDynamicObjectCollection("supplierentry");
            for (int j = 0; j < supplierEntryColl.size(); ++j) {
                DynamicObject supplierEntry = (DynamicObject)supplierEntryColl.get(j);
                DynamicObject bidOpenSupplier = supplierEntry.getDynamicObject("supplier");
                DynamicObject onlineBidDetail = (DynamicObject)onlineBidDetailMap.get(sectionName);
                boolean supplierFlag = supplierId.equals(bidOpenSupplier.getString("id"));
                if (onlineBidDetail == null || !supplierFlag) continue;
                this.copyToEntryAttach((List)fileMap.get(onlineBid.getPkValue().toString()), supplierEntry, "supplier_tenattach");
                this.copyToEntryAttach((List)fileMap.get(onlineBidDetail.getPkValue() + OTHER_SUFFIX), supplierEntry, "supplier_otherattach");
                this.copyToEntryAttach((List)fileMap.get(onlineBidDetail.getPkValue() + TECH_SUFFIX), supplierEntry, "supplier_techattach");
                this.copyToEntryAttach((List)fileMap.get(onlineBidDetail.getPkValue() + BUS_SUFFIX), supplierEntry, "supplier_comattach");
                BizLog.log((String)(ResManager.loadKDString((String)"\u6295\u6807\u53cd\u5199-- \u9644\u4ef6\u4fe1\u606f\uff1a", (String)"BidOpenFileRepair_4", (String)"scm-bid-formplugin", (Object[])new Object[0]) + sectionName + ResManager.loadKDString((String)" \u4f9b\u5e94\u5546\u540d\u79f0\uff1a", (String)"BidOpenFileRepair_5", (String)"scm-bid-formplugin", (Object[])new Object[0]) + bidOpenSupplier.getString("name") + ResManager.loadKDString((String)" \u6807\u6bb5id: ", (String)"BidOpenFileRepair_6", (String)"scm-bid-formplugin", (Object[])new Object[0]) + bidSection.getPkValue()));
            }
            ++var17_31;
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidOpen});
    }

    protected void copyToEntryAttach(List<Map<String, Object>> attachList, DynamicObject supplierEntry, String entryProperty) {
        List attachments = BidFileHelper.copyToEntryAttachment(attachList);
        DynamicObjectCollection inviteAttachFiles = supplierEntry.getDynamicObjectCollection(entryProperty);
        inviteAttachFiles.clear();
        attachments.stream().forEach(item -> {
            DynamicObject inviteAttach = inviteAttachFiles.addNew();
            inviteAttach.set("fbasedataid", item);
        });
        supplierEntry.set(entryProperty, (Object)inviteAttachFiles);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"bidproject")) {
            this.getModel().setValue("bidopen", null);
            this.getModel().setValue("onlinebid", null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey = event.getProperty().getName();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"bidopen")) {
            DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
            if (bidProject == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u62db\u6807\u7acb\u9879\u3002", (String)"BidOpenFileRepair_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            QFilter qFilter = new QFilter("bidproject", "=", bidProject.getPkValue());
            showParameter.getListFilterParameter().setFilter(qFilter);
        } else if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"onlinebid")) {
            DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
            if (bidProject == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u62db\u6807\u7acb\u9879\u3002", (String)"BidOpenFileRepair_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            QFilter qFilter = new QFilter("bidproject", "=", bidProject.getPkValue());
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public static String getBidAppId(String appId) {
        return "ten".equals(appId) ? "bid" : "rebm";
    }

    public static String getTenAppId(String appId) {
        return "bid".equals(appId) ? "ten" : "resp";
    }
}

