/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.repair;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BidOrgRepairOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        if ("change_org".equalsIgnoreCase(e.getOperationKey())) {
            Arrays.stream(e.getDataEntities()).forEach(dataEntity -> this.changeOrg((DynamicObject)dataEntity));
        }
    }

    public void changeOrg(DynamicObject dataEntity) {
        String appId = "bid";
        if (dataEntity.getDataEntityType().getName().startsWith("rebm_")) {
            appId = "rebm";
        }
        DynamicObjectCollection orgEntry = dataEntity.getDynamicObjectCollection("org_entry");
        Map<Object, DynamicObject> bidMap = orgEntry.stream().collect(Collectors.toMap(item -> item.getDynamicObject("bidpeoject").getPkValue(), item -> item.getDynamicObject("new_org"), (k1, k2) -> k1));
        Set<Object> bidProjectIdSet = bidMap.keySet();
        this.cBidProject(appId, bidMap, bidProjectIdSet);
        this.cSupplierinvitation(appId, bidMap, bidProjectIdSet);
        this.cInvitation(appId, bidMap, bidProjectIdSet);
        this.cBiddocumentEdit(appId, bidMap, bidProjectIdSet);
        this.cClarificaiton(appId, bidMap, bidProjectIdSet);
        this.cBottomMake(appId, bidMap, bidProjectIdSet);
        this.cBidpublish(appId, bidMap, bidProjectIdSet);
        this.cAnswerquestion(appId, bidMap, bidProjectIdSet);
        this.cAnswerquestionReco(appId, bidMap, bidProjectIdSet);
        this.cOpen(appId, bidMap, bidProjectIdSet);
        this.cBidassinvitesum(appId, bidMap, bidProjectIdSet);
        this.cProficien(appId, bidMap, bidProjectIdSet);
        this.cOnlinebideval(appId, bidMap, bidProjectIdSet);
        this.cBidevaluation(appId, bidMap, bidProjectIdSet);
        this.cSupplierinvalid(appId, bidMap, bidProjectIdSet);
        this.cRebackbid(appId, bidMap, bidProjectIdSet);
        this.cBustalk(appId, bidMap, bidProjectIdSet);
        this.cNegotiateInvite(appId, bidMap, bidProjectIdSet);
        this.cOpenquerycla(appId, bidMap, bidProjectIdSet);
        this.cMultiquestclarify(appId, bidMap, bidProjectIdSet);
        this.cQueryLettersInh(appId, bidMap, bidProjectIdSet);
        this.cQuestionclarify(appId, bidMap, bidProjectIdSet);
        this.cDecision(appId, bidMap, bidProjectIdSet);
        appId = appId.equalsIgnoreCase("rebm") ? "resp" : "ten";
        this.cApply(appId, bidMap, bidProjectIdSet);
        this.cMytender(appId, bidMap, bidProjectIdSet);
        this.cOnlieBustalk(appId, bidMap, bidProjectIdSet);
    }

    public void cRebackbid(String appId, Map<Object, DynamicObject> bidMap, Set<Object> bidProjectIdSet) {
        this.sameQuery(appId + "_rebackbid", bidMap, bidProjectIdSet);
    }

    public void cSupplierinvalid(String appId, Map<Object, DynamicObject> bidMap, Set<Object> bidProjectIdSet) {
        this.sameQuery(appId + "_supplierinvalid", bidMap, bidProjectIdSet);
    }

    public void cBottomMake(String appId, Map<Object, DynamicObject> bidMap, Set<Object> bidProjectIdSet) {
        this.sameQuery(appId + "_bottom_make", bidMap, bidProjectIdSet);
    }

    public void cClarificaiton(String appId, Map<Object, DynamicObject> bidMap, Set<Object> bidProjectIdSet) {
        this.sameQuery(appId + "_clarificaiton", bidMap, bidProjectIdSet);
    }

    public void cOnlieBustalk(String appId, Map<Object, DynamicObject> bidMap, Set<Object> bidProjectIdSet) {
        this.sameQuery(appId + "_onlie_bustalk", bidMap, bidProjectIdSet);
    }

    public void sameQuery(String formId, Map<Object, DynamicObject> bidMap, Set<Object> bidProjectIdSet) {
        QFilter qFilter = new QFilter("bidproject", "in", bidProjectIdSet);
        DynamicObject[] dataArr = BusinessDataServiceHelper.load((String)formId, (String)"org,bidproject", (QFilter[])qFilter.toArray());
        if (dataArr.length == 0) {
            return;
        }
        Arrays.stream(dataArr).forEach(data -> {
            DynamicObject bidProject = data.getDynamicObject("bidproject");
            DynamicObject newOrg = (DynamicObject)bidMap.get(bidProject.getPkValue());
            if (newOrg != null) {
                data.set("org", (Object)newOrg);
            }
        });
        SaveServiceHelper.save((DynamicObject[])dataArr);
    }

    public void cMytender(String appId, Map<Object, DynamicObject> bidMap, Set<Object> bidProjectIdSet) {
        this.sameQuery(appId + "_mytender", bidMap, bidProjectIdSet);
    }

    public void cApply(String appId, Map<Object, DynamicObject> bidMap, Set<Object> bidProjectIdSet) {
        List bidProjectIdSetList = bidProjectIdSet.stream().map(item -> item.toString()).collect(Collectors.toList());
        QFilter qFilter = new QFilter("project", "in", bidProjectIdSetList);
        DynamicObject[] dataArr = BusinessDataServiceHelper.load((String)(appId + "_apply"), (String)"org,project", (QFilter[])qFilter.toArray());
        if (dataArr.length == 0) {
            return;
        }
        Arrays.stream(dataArr).forEach(data -> {
            DynamicObject bidProject = data.getDynamicObject("project");
            DynamicObject newOrg = (DynamicObject)bidMap.get(bidProject.getPkValue());
            if (newOrg != null) {
                data.set("org", (Object)newOrg);
            }
        });
        SaveServiceHelper.save((DynamicObject[])dataArr);
    }

    public void cDecision(String appId, Map<Object, DynamicObject> bidMap, Set<Object> bidProjectIdSet) {
        this.sameQuery(appId + "_decision", bidMap, bidProjectIdSet);
    }

    public void cQuestionclarify(String appId, Map<Object, DynamicObject> bidMap, Set<Object> bidProjectIdSet) {
        this.sameQuery(appId + "_questionclarify", bidMap, bidProjectIdSet);
    }

    public void cQueryLettersInh(String appId, Map<Object, DynamicObject> bidMap, Set<Object> bidProjectIdSet) {
        String formId = "bid_query_letters";
        if (appId.equalsIgnoreCase("rebm")) {
            formId = "rebm_query_letters_inh";
        }
        this.sameQuery(formId, bidMap, bidProjectIdSet);
    }

    public void cMultiquestclarify(String appId, Map<Object, DynamicObject> bidMap, Set<Object> bidProjectIdSet) {
        this.sameQuery(appId + "_multiquestclarify", bidMap, bidProjectIdSet);
    }

    public void cOpenquerycla(String appId, Map<Object, DynamicObject> bidMap, Set<Object> bidProjectIdSet) {
        this.sameQuery(appId + "_openquerycla", bidMap, bidProjectIdSet);
    }

    public void cNegotiateInvite(String appId, Map<Object, DynamicObject> bidMap, Set<Object> bidProjectIdSet) {
        this.sameQuery(appId + "_negotiate_invite", bidMap, bidProjectIdSet);
    }

    public void cBustalk(String appId, Map<Object, DynamicObject> bidMap, Set<Object> bidProjectIdSet) {
        this.sameQuery(appId + "_bustalk", bidMap, bidProjectIdSet);
    }

    public void cBidevaluation(String appId, Map<Object, DynamicObject> bidMap, Set<Object> bidProjectIdSet) {
        this.sameQuery(appId + "_bidevaluation", bidMap, bidProjectIdSet);
    }

    public void cOnlinebideval(String appId, Map<Object, DynamicObject> bidMap, Set<Object> bidProjectIdSet) {
        this.sameQuery(appId + "_onlinebideval", bidMap, bidProjectIdSet);
    }

    public void cProficien(String appId, Map<Object, DynamicObject> bidMap, Set<Object> bidProjectIdSet) {
        QFilter qFilter = new QFilter("bidprojectname", "in", bidProjectIdSet);
        DynamicObject[] dataArr = BusinessDataServiceHelper.load((String)(appId + "_proficient_extract"), (String)"org,bidprojectname", (QFilter[])qFilter.toArray());
        if (dataArr.length == 0) {
            return;
        }
        Arrays.stream(dataArr).forEach(data -> {
            DynamicObject bidProject = data.getDynamicObject("bidprojectname");
            DynamicObject newOrg = (DynamicObject)bidMap.get(bidProject.getPkValue());
            if (newOrg != null) {
                data.set("org", (Object)newOrg);
            }
        });
        SaveServiceHelper.save((DynamicObject[])dataArr);
    }

    public void cBidassinvitesum(String appId, Map<Object, DynamicObject> bidMap, Set<Object> bidProjectIdSet) {
        this.sameQuery(appId + "_bidassinvitesum", bidMap, bidProjectIdSet);
        QFilter qFilter = new QFilter("name", "in", bidProjectIdSet);
        DynamicObject[] dataArr = BusinessDataServiceHelper.load((String)(appId + "_bidassinvite"), (String)"org,name", (QFilter[])qFilter.toArray());
        if (dataArr.length == 0) {
            return;
        }
        Arrays.stream(dataArr).forEach(data -> {
            DynamicObject bidProject = data.getDynamicObject("name");
            DynamicObject newOrg = (DynamicObject)bidMap.get(bidProject.getPkValue());
            if (newOrg != null) {
                data.set("org", (Object)newOrg);
            }
        });
        SaveServiceHelper.save((DynamicObject[])dataArr);
    }

    public void cOpen(String appId, Map<Object, DynamicObject> bidMap, Set<Object> bidProjectIdSet) {
        this.sameQuery(appId + "_bidopen", bidMap, bidProjectIdSet);
    }

    public void cAnswerquestionReco(String appId, Map<Object, DynamicObject> bidMap, Set<Object> bidProjectIdSet) {
        this.sameQuery(appId + "_answerquestion_reco", bidMap, bidProjectIdSet);
    }

    public void cAnswerquestion(String appId, Map<Object, DynamicObject> bidMap, Set<Object> bidProjectIdSet) {
        this.sameQuery(appId + "_answerquestion", bidMap, bidProjectIdSet);
    }

    public void cBidpublish(String appId, Map<Object, DynamicObject> bidMap, Set<Object> bidProjectIdSet) {
        this.sameQuery(appId + "_bidpublish", bidMap, bidProjectIdSet);
    }

    public void cBiddocumentEdit(String appId, Map<Object, DynamicObject> bidMap, Set<Object> bidProjectIdSet) {
        this.sameQuery(appId + "_biddocument_edit", bidMap, bidProjectIdSet);
    }

    public void cInvitation(String appId, Map<Object, DynamicObject> bidMap, Set<Object> bidProjectIdSet) {
        this.sameQuery(appId + "_invitation", bidMap, bidProjectIdSet);
    }

    public void cBidProject(String appId, Map<Object, DynamicObject> bidMap, Set<Object> bidProjectIdSet) {
        QFilter qFilter = new QFilter("id", "in", bidProjectIdSet);
        DynamicObject[] bidProjectArr = BusinessDataServiceHelper.load((String)(appId + "_project"), (String)"org,entrustmentorgunit", (QFilter[])qFilter.toArray());
        if (bidProjectArr.length == 0) {
            return;
        }
        Arrays.stream(bidProjectArr).forEach(bidProject -> {
            DynamicObject newOrg = (DynamicObject)bidMap.get(bidProject.getPkValue());
            DynamicObject entrustmentorgunit = bidProject.getDynamicObject("entrustmentorgunit");
            DynamicObject org = bidProject.getDynamicObject("org");
            if (newOrg != null) {
                if (entrustmentorgunit != null && org != null && entrustmentorgunit.getPkValue().equals(org.getPkValue())) {
                    bidProject.set("entrustmentorgunit", (Object)newOrg);
                }
                bidProject.set("org", (Object)newOrg);
            }
        });
        SaveServiceHelper.save((DynamicObject[])bidProjectArr);
    }

    public void cSupplierinvitation(String appId, Map<Object, DynamicObject> bidMap, Set<Object> bidProjectIdSet) {
        this.sameQuery(appId + "_supplierinvitation", bidMap, bidProjectIdSet);
    }
}

