/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.repair;

import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BidPublishDataRepair
extends AbstractFormPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("audit".equals(operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObject bidPublishF7 = dataEntity.getDynamicObject("bidpublish");
            if (bidPublishF7 == null) {
                return;
            }
            String entityTypeId = bidPublishF7.getString("entitytypeid");
            String appId = entityTypeId.split("_")[0];
            HashMap<String, String> tenderStrategyMap = new HashMap<String, String>();
            DynamicObjectCollection currentBidSectionCol = dataEntity.getDynamicObjectCollection("bidsection");
            for (DynamicObject bidSection : currentBidSectionCol) {
                String sectionName = bidSection.getString("sectionname");
                DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierEntry : supplierEntryCol) {
                    DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                    if (supplier == null) continue;
                    String key = String.format("%s_%s", sectionName, supplier.getPkValue());
                    tenderStrategyMap.put(key, supplierEntry.getString("tenderstrategy"));
                }
            }
            DynamicObject bidPublish = BusinessDataServiceHelper.loadSingle((Object)bidPublishF7.getPkValue(), (String)(appId + "_bidpublish"));
            if (bidPublish != null) {
                DynamicObjectCollection bidSectionCol = bidPublish.getDynamicObjectCollection("bidsection");
                for (DynamicObject bidSection : bidSectionCol) {
                    String sectionName = bidSection.getString("sectionname");
                    DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                    for (DynamicObject supplierEntry : supplierEntryCol) {
                        DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                        if (supplier == null) continue;
                        String key = String.format("%s_%s", sectionName, supplier.getPkValue());
                        String tenderStrategy = tenderStrategyMap.getOrDefault(key, null);
                        supplierEntry.set("tenderstrategy", (Object)tenderStrategy);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidPublish});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        ChangeData cd = e.getChangeSet()[0];
        Object newVal = cd.getNewValue();
        Object oldVal = cd.getOldValue();
        if ("bidpublish".equals(fieldKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection currentBidSectionCol = dataEntity.getDynamicObjectCollection("bidsection");
            for (DynamicObject bidSection : currentBidSectionCol) {
                DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                supplierEntryCol.clear();
            }
            currentBidSectionCol.clear();
            if (newVal == null) {
                return;
            }
            DynamicObject bidPublishF7 = (DynamicObject)newVal;
            String entityTypeId = bidPublishF7.getString("entitytypeid");
            String appId = entityTypeId.split("_")[0];
            DynamicObject bidPublish = BusinessDataServiceHelper.loadSingle((Object)bidPublishF7.getPkValue(), (String)(appId + "_bidpublish"));
            DynamicObjectCollection bidSectionCol = bidPublish.getDynamicObjectCollection("bidsection");
            for (DynamicObject bidSection : bidSectionCol) {
                DynamicObject newSection = currentBidSectionCol.addNew();
                newSection.set("sectionname", (Object)bidSection.getString("sectionname"));
                DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                DynamicObjectCollection currentSupplierEntryCol = newSection.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierEntry : supplierEntryCol) {
                    DynamicObject newSupplierEntry = currentSupplierEntryCol.addNew();
                    newSupplierEntry.set("supplier", supplierEntry.get("supplier"));
                    newSupplierEntry.set("tenderstrategy", supplierEntry.get("tenderstrategy"));
                    newSupplierEntry.set("tenderstatus", supplierEntry.get("tenderstatus"));
                }
            }
            this.getView().updateView("bidsection");
            this.getView().updateView("supplierentry");
        }
    }
}

