/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.repair.amount;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.formplugin.repair.amount.AmountEntity;

public class BidAmountRepairOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        if ("execute".equals(e.getOperationKey())) {
            Arrays.stream(e.getDataEntities()).forEach(dataEntity -> this.updateData((DynamicObject)dataEntity));
        }
    }

    public void updateData(DynamicObject dataEntity) {
        DynamicObject bidproject = dataEntity.getDynamicObject("bidproject");
        String appId = "bid";
        if (bidproject.getDataEntityType().getName().startsWith("rebm")) {
            appId = "rebm";
        }
        bidproject = BusinessDataServiceHelper.loadSingle((Object)bidproject.getPkValue(), (String)(appId + "_project"));
        Table<String, String, AmountEntity> tableMap = this.getUpdateResultMap(dataEntity);
        this.updateBidProject(bidproject, tableMap, dataEntity);
        this.updateBidDocumentEdit(bidproject, tableMap, appId);
        this.updateBidPublish(bidproject, tableMap, appId);
        this.updateBidOpen(bidproject, tableMap, appId);
        this.updateDecision(bidproject, tableMap, appId, dataEntity);
    }

    public void updateDecision(DynamicObject bidproject, Table<String, String, AmountEntity> tableMap, String appId, DynamicObject dataEntity) {
        QFilter qFilter;
        String formId = appId + "_decision";
        DynamicObject[] objArr = BusinessDataServiceHelper.load((String)formId, (String)"id", (QFilter[])(qFilter = new QFilter("bidproject", "=", bidproject.getPkValue())).toArray());
        if (objArr.length == 0) {
            return;
        }
        Object[] objIdArr = Arrays.stream(objArr).map(item -> item.getPkValue()).toArray();
        objArr = BusinessDataServiceHelper.load((Object[])objIdArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId));
        Arrays.stream(objArr).forEach(item -> {
            DynamicObjectCollection bidsections = item.getDynamicObjectCollection("bottomsection");
            bidsections.forEach(row -> {
                String sectionname = row.getString("botsectionname");
                DynamicObjectCollection projectentry = row.getDynamicObjectCollection("bottomentry");
                projectentry.forEach(subRow -> {
                    String purentrycontent = subRow.getString("botpurentrycontent");
                    purentrycontent = purentrycontent == null ? "" : purentrycontent;
                    DynamicObject materialid = subRow.getDynamicObject("botmaterialid");
                    if (materialid != null) {
                        purentrycontent = purentrycontent + materialid.getPkValue();
                    }
                    AmountEntity amountEntity = (AmountEntity)tableMap.get((Object)sectionname, (Object)purentrycontent);
                    subRow.set("botqty", (Object)amountEntity.getQty());
                    subRow.set("botcontrolamount", (Object)amountEntity.getControlamount());
                    subRow.set("botcontrolvat", (Object)amountEntity.getControlvat());
                    subRow.set("botctrlamtexceptvat", (Object)amountEntity.getCtrlamtexceptvat());
                });
            });
            item.set("controlamount", dataEntity.get("totalcontrol"));
            item.set("exctaxcontrolamount", dataEntity.get("totalctrlexcvat"));
        });
        SaveServiceHelper.save((DynamicObject[])objArr);
    }

    public void updateBidOpen(DynamicObject bidproject, Table<String, String, AmountEntity> tableMap, String appId) {
        QFilter qFilter;
        String formId = appId + "_bidopen";
        DynamicObject[] objArr = BusinessDataServiceHelper.load((String)formId, (String)"id", (QFilter[])(qFilter = new QFilter("bidproject", "=", bidproject.getPkValue())).toArray());
        if (objArr.length == 0) {
            return;
        }
        Object[] objIdArr = Arrays.stream(objArr).map(item -> item.getPkValue()).toArray();
        objArr = BusinessDataServiceHelper.load((Object[])objIdArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId));
        Arrays.stream(objArr).forEach(item -> {
            DynamicObjectCollection bidsections = item.getDynamicObjectCollection("bottomsection");
            bidsections.forEach(row -> {
                String sectionname = row.getString("botsectionname");
                DynamicObjectCollection projectentry = row.getDynamicObjectCollection("bottomentry");
                projectentry.forEach(subRow -> {
                    String purentrycontent = subRow.getString("botpurentrycontent");
                    purentrycontent = purentrycontent == null ? "" : purentrycontent;
                    DynamicObject materialid = subRow.getDynamicObject("botmaterialid");
                    if (materialid != null) {
                        purentrycontent = purentrycontent + materialid.getPkValue();
                    }
                    AmountEntity amountEntity = (AmountEntity)tableMap.get((Object)sectionname, (Object)purentrycontent);
                    subRow.set("botqty", (Object)amountEntity.getQty());
                    subRow.set("botcontrolamount", (Object)amountEntity.getControlamount());
                    subRow.set("botcontrolvat", (Object)amountEntity.getControlvat());
                    subRow.set("botctrlamtexceptvat", (Object)amountEntity.getCtrlamtexceptvat());
                });
            });
        });
        SaveServiceHelper.save((DynamicObject[])objArr);
    }

    public void updateBidPublish(DynamicObject bidproject, Table<String, String, AmountEntity> tableMap, String appId) {
        QFilter qFilter;
        String formId = appId + "_bidpublish";
        DynamicObject[] objArr = BusinessDataServiceHelper.load((String)formId, (String)"id", (QFilter[])(qFilter = new QFilter("bidproject", "=", bidproject.getPkValue())).toArray());
        if (objArr.length == 0) {
            return;
        }
        Object[] objIdArr = Arrays.stream(objArr).map(item -> item.getPkValue()).toArray();
        objArr = BusinessDataServiceHelper.load((Object[])objIdArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId));
        Arrays.stream(objArr).forEach(item -> {
            DynamicObjectCollection bidsections = item.getDynamicObjectCollection("fakebidsection");
            bidsections.forEach(row -> {
                String sectionname = row.getString("fakebidsectionname");
                DynamicObjectCollection projectentry = row.getDynamicObjectCollection("projectdetail");
                projectentry.forEach(subRow -> {
                    String purentrycontent = subRow.getString("purentrycontent");
                    purentrycontent = purentrycontent == null ? "" : purentrycontent;
                    DynamicObject materialid = subRow.getDynamicObject("materialid");
                    if (materialid != null) {
                        purentrycontent = purentrycontent + materialid.getPkValue();
                    }
                    AmountEntity amountEntity = (AmountEntity)tableMap.get((Object)sectionname, (Object)purentrycontent);
                    subRow.set("qty", (Object)amountEntity.getQty());
                    subRow.set("controlamount", (Object)amountEntity.getControlamount());
                });
            });
        });
        SaveServiceHelper.save((DynamicObject[])objArr);
    }

    public void updateBidDocumentEdit(DynamicObject bidproject, Table<String, String, AmountEntity> tableMap, String appId) {
        QFilter qFilter;
        String formId = appId + "_biddocument_edit";
        DynamicObject[] documentArr = BusinessDataServiceHelper.load((String)formId, (String)"id", (QFilter[])(qFilter = new QFilter("bidproject", "=", bidproject.getPkValue())).toArray());
        if (documentArr.length == 0) {
            return;
        }
        Object[] documentIdArr = Arrays.stream(documentArr).map(item -> item.getPkValue()).toArray();
        documentArr = BusinessDataServiceHelper.load((Object[])documentIdArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId));
        Arrays.stream(documentArr).forEach(document -> {
            DynamicObjectCollection bidsections = document.getDynamicObjectCollection("biddocumententry");
            bidsections.forEach(row -> {
                String sectionname = row.getString("sectionname");
                DynamicObjectCollection projectentry = row.getDynamicObjectCollection("biddocdetail");
                projectentry.forEach(subRow -> {
                    String purentrycontent = subRow.getString("purentrycontent");
                    purentrycontent = purentrycontent == null ? "" : purentrycontent;
                    DynamicObject materialid = subRow.getDynamicObject("materialid");
                    if (materialid != null) {
                        purentrycontent = purentrycontent + materialid.getPkValue();
                    }
                    AmountEntity amountEntity = (AmountEntity)tableMap.get((Object)sectionname, (Object)purentrycontent);
                    subRow.set("qty", (Object)amountEntity.getQty());
                    subRow.set("controlamount", (Object)amountEntity.getControlamount());
                });
            });
        });
        SaveServiceHelper.save((DynamicObject[])documentArr);
    }

    public Table<String, String, AmountEntity> getUpdateResultMap(DynamicObject dataEntity) {
        HashBasedTable tableMap = HashBasedTable.create();
        DynamicObjectCollection newBidsections = dataEntity.getDynamicObjectCollection("bidsection");
        newBidsections.forEach(arg_0 -> BidAmountRepairOp.lambda$getUpdateResultMap$18((Table)tableMap, arg_0));
        return tableMap;
    }

    public void updateBidProject(DynamicObject bidproject, Table<String, String, AmountEntity> tableMap, DynamicObject dataEntity) {
        DynamicObjectCollection bidsections = bidproject.getDynamicObjectCollection("bidsection");
        bidsections.forEach(row -> {
            String sectionname = row.getString("sectionname");
            DynamicObjectCollection projectentry = row.getDynamicObjectCollection("projectentry");
            projectentry.forEach(subRow -> {
                String purentrycontent = subRow.getString("purentrycontent");
                purentrycontent = purentrycontent == null ? "" : purentrycontent;
                DynamicObject materialid = subRow.getDynamicObject("materialid");
                if (materialid != null) {
                    purentrycontent = purentrycontent + materialid.getPkValue();
                }
                AmountEntity amountEntity = (AmountEntity)tableMap.get((Object)sectionname, (Object)purentrycontent);
                subRow.set("qty", (Object)amountEntity.getQty());
                subRow.set("controlamount", (Object)amountEntity.getControlamount());
                subRow.set("controlvat", (Object)amountEntity.getControlvat());
                subRow.set("ctrlamtexceptvat", (Object)amountEntity.getCtrlamtexceptvat());
            });
        });
        bidproject.set("totalcontrol", dataEntity.get("totalcontrol"));
        bidproject.set("totalctrlexcvat", dataEntity.get("totalctrlexcvat"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidproject});
    }

    private static /* synthetic */ void lambda$getUpdateResultMap$18(Table tableMap, DynamicObject row) {
        String sectionname = row.getString("sectionname");
        DynamicObjectCollection projectentry = row.getDynamicObjectCollection("projectentry");
        projectentry.forEach(subRow -> {
            String purentrycontent = subRow.getString("purentrycontent");
            purentrycontent = purentrycontent == null ? "" : purentrycontent;
            DynamicObject materialid = subRow.getDynamicObject("materialid");
            if (materialid != null) {
                purentrycontent = purentrycontent + materialid.getPkValue();
            }
            AmountEntity amountEntity = new AmountEntity();
            amountEntity.setQty(subRow.getBigDecimal("qty"));
            amountEntity.setControlamount(subRow.getBigDecimal("controlamount"));
            amountEntity.setControlvat(subRow.getBigDecimal("controlvat"));
            amountEntity.setCtrlamtexceptvat(subRow.getBigDecimal("ctrlamtexceptvat"));
            tableMap.put((Object)sectionname, (Object)purentrycontent, (Object)amountEntity);
        });
    }
}

