/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.repair.bidqty;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.formplugin.bill.util.DateUtils;

public class BidQtyChangeRepair
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getView().getControl("toolbar");
        toolbar.addItemClickListener((ItemClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (parameter.getStatus().equals((Object)OperationStatus.ADDNEW)) {
            SimpleDateFormat formater = new SimpleDateFormat("yyyyMMdd-HHmmss");
            this.getModel().setValue("billno", (Object)DateUtils.date2String(new Date(), formater));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (evt.getItemKey().equals("btn_query_ct")) {
            DynamicObjectCollection bidEntry = dataEntity.getDynamicObjectCollection("bid_entry");
            bidEntry.clear();
            Date bidCreatetime = dataEntity.getDate("bidcreatetime");
            if (bidCreatetime != null) {
                QFilter qFilter = new QFilter("createtime", "<=", (Object)bidCreatetime);
                qFilter.and("bidtype", "!=", (Object)"0");
                DynamicObject[] bidProjectArr = BusinessDataServiceHelper.load((String)"bidproject_f7", (String)"name,billno,bidtype,is_qty_change", (QFilter[])qFilter.toArray());
                if (bidProjectArr.length > 0) {
                    Arrays.stream(bidProjectArr).forEach(bidProject -> bidEntry.addNew().set("bidproject", bidProject));
                }
            }
            this.getView().updateView("bid_entry");
        } else if (evt.getItemKey().equals("btn_query_qty")) {
            DynamicObjectCollection bidEntry = dataEntity.getDynamicObjectCollection("bid_entry");
            bidEntry.clear();
            QFilter qFilter = new QFilter("is_qty_change", "=", (Object)true);
            qFilter.and("bidtype", "!=", (Object)"0");
            DynamicObject[] bidProjectArr = BusinessDataServiceHelper.load((String)"bidproject_f7", (String)"name,billno", (QFilter[])qFilter.toArray());
            if (bidProjectArr.length > 0) {
                Arrays.stream(bidProjectArr).forEach(bidProject -> bidEntry.addNew().set("bidproject", bidProject));
            }
            this.getView().updateView("bid_entry");
        }
    }
}

