/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.report.biddetailquery;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CellStyleRule;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.formplugin.bill.util.BidHistoryUtil;
import kd.scm.bid.formplugin.util.BidCenterCommonUtil;

public class BidDetailQueryExtEdit
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
SearchEnterListener,
ListRowClickListener {
    public static final String BID_PROCESS = "currentstep";
    public static final String BID_CENTER = "projectname";
    public static String[] BID_VIATION = new String[]{"gdeviation", "purprojecteviation"};
    public static String[] REBM_VIATION = new String[]{"gdeviation", "purprojecteviation", "toltalplanamount"};
    public static final Map<String, Object> DEFAULT_VALUE = new HashMap<String, Object>();
    protected static final String[] CURRENTKEYS;
    protected static final String[] CURRENTNAMES;
    protected static final Map<String, String> MAP_TABLE;
    protected static final Map<String, String> PAGE_MAP;

    public void registerListener(EventObject eventobject) {
        super.registerListener(eventobject);
        ReportList billList = (ReportList)this.getView().getControl("reportlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
        Container flexPanel91 = (Container)this.getView().getControl("flexpanelap91");
        flexPanel91.addClickListener((ClickListener)this);
        Container flexPanel = (Container)this.getView().getControl("flexpanelap");
        flexPanel.addClickListener((ClickListener)this);
        Container flexPanel3 = (Container)this.getView().getControl("flexpanelap3");
        flexPanel3.addClickListener((ClickListener)this);
        Container flexPanel4 = (Container)this.getView().getControl("flexpanelap4");
        flexPanel4.addClickListener((ClickListener)this);
        Container flexPanel82 = (Container)this.getView().getControl("flexpanelap82");
        flexPanel82.addClickListener((ClickListener)this);
        Container flexPanel5 = (Container)this.getView().getControl("flexpanelap5");
        flexPanel5.addClickListener((ClickListener)this);
        Container flexPanel6 = (Container)this.getView().getControl("flexpanelap6");
        flexPanel6.addClickListener((ClickListener)this);
        Container flexPanel7 = (Container)this.getView().getControl("flexpanelap7");
        flexPanel7.addClickListener((ClickListener)this);
        Container flexPanel71 = (Container)this.getView().getControl("flexpanelap71");
        flexPanel71.addClickListener((ClickListener)this);
        Container flexPanel8 = (Container)this.getView().getControl("flexpanelap8");
        flexPanel8.addClickListener((ClickListener)this);
        Container flexPanel81 = (Container)this.getView().getControl("flexpanelap81");
        flexPanel81.addClickListener((ClickListener)this);
        Container flexPanel9 = (Container)this.getView().getControl("flexpanelap9");
        flexPanel9.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        String str = ctrl.getKey();
        if (str.contains("flexpanelap")) {
            String bidcurrentstep = this.getCurrentStep(str);
            this.getPageCache().put("isstep", "1");
            this.getPageCache().put("bidcurrentstep", bidcurrentstep);
            this.getView().invokeOperation("refresh");
        }
    }

    public String getCurrentStep(String str) {
        String step = "all";
        switch (str) {
            case "flexpanelap91": {
                step = "ALL";
                break;
            }
            case "flexpanelap": {
                step = "_project";
                break;
            }
            case "flexpanelap3": {
                step = "_supplierinvitation";
                break;
            }
            case "flexpanelap4": {
                step = "_biddocument_edit";
                break;
            }
            case "flexpanelap71": {
                step = "_bottom_make";
                break;
            }
            case "flexpanelap82": {
                step = "_clarificaiton";
                break;
            }
            case "flexpanelap5": {
                step = "_bidpublish";
                break;
            }
            case "flexpanelap6": {
                step = "_answerquestion";
                break;
            }
            case "flexpanelap7": {
                step = "_bidopen";
                break;
            }
            case "flexpanelap8": {
                step = "_bidevaluation";
                break;
            }
            case "flexpanelap81": {
                step = "_bustalk";
                break;
            }
            case "flexpanelap9": {
                step = "_decision";
                break;
            }
            default: {
                step = "all";
            }
        }
        return step;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        String bidcurrentstep = this.getPageCache().get("bidcurrentstep");
        if (bidcurrentstep != null) {
            ReportQueryParam reportQueryParam = this.getView().getQueryParam();
            Map customParam = reportQueryParam.getCustomParam();
            customParam.put("bidcurrentstep", bidcurrentstep);
            this.getPageCache().remove("bidcurrentstep");
        } else {
            this.getPageCache().remove("isstep");
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getPageCache().put("billtype", this.getAppId() + "_newdetailquery");
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        this.getView().setVisible(Boolean.TRUE, new String[]{"detailquantityflex"});
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        this.initDetailQuantityNum(queryParam);
        ArrayList<String> list = new ArrayList<String>(16);
        list.add("totalpurentryname");
        list.add("totalbidsupplier");
        if (StringUtils.equals((CharSequence)"rebm", (CharSequence)this.getAppId())) {
            list.add("contractstatus");
            list.add("purproplanname");
            list.add("rulename");
            list.add("hetongnumber");
            list.add("hetongname");
        }
        rowData.forEach(row -> {
            this.setDefaultValue((DynamicObject)row, (List<String>)list);
            BigDecimal toltalfinalprice = row.getBigDecimal("toltalfinalprice");
            BigDecimal toltalcontrolamount = row.getBigDecimal("toltalcontrolamount");
            BigDecimal tfinalauditamount = row.getBigDecimal("tfinalauditamount");
            if (toltalfinalprice != null && toltalcontrolamount != null) {
                this.setAndEva(toltalfinalprice, toltalcontrolamount, (DynamicObject)row, "gdeviation");
            }
            if (toltalfinalprice != null && tfinalauditamount != null) {
                this.setAndEva(toltalfinalprice, tfinalauditamount, (DynamicObject)row, "purprojecteviation");
            }
            if (StringUtils.equals((CharSequence)this.getAppId(), (CharSequence)"rebm")) {
                BigDecimal toltalplanamount = row.getBigDecimal("toltalplanamount");
                this.setAndEva(toltalfinalprice, toltalplanamount, (DynamicObject)row, "toltalplanamount");
                row.set("toltalplanamount", (Object)toltalplanamount);
            }
            this.setProjectreach((DynamicObject)row);
        });
        Collections.sort(rowData, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                DynamicObject org1 = o1.getDynamicObject("org");
                DynamicObject org2 = o2.getDynamicObject("org");
                if (org1.getPkValue() == org2.getPkValue()) {
                    Date date1 = o1.getDate("setupdateview");
                    Date date2 = o2.getDate("setupdateview");
                    if (date1 == null && date2 == null) {
                        return 0;
                    }
                    if (date1 == null) {
                        return 1;
                    }
                    if (date2 == null) {
                        return -1;
                    }
                    return date2.compareTo(date1);
                }
                Long org1Long = Long.parseLong(org1.getPkValue().toString());
                Long org2Long = Long.parseLong(org2.getPkValue().toString());
                return org2Long.compareTo(org1Long);
            }
        });
    }

    public void setDefaultValue(DynamicObject row, List<String> propertyName) {
        for (String s : propertyName) {
            Object inf = row.get(s);
            if (inf instanceof String && StringUtils.isNotBlank((CharSequence)inf.toString())) continue;
            String value = "-";
            Object data = DEFAULT_VALUE.get(s);
            if (data != null) {
                value = (String)data;
            }
            row.set(s, (Object)value);
        }
    }

    public void setCellStyleRules(List<CellStyleRule> cellStyleRules) {
        super.setCellStyleRules(cellStyleRules);
        String[] array = BID_VIATION;
        if (StringUtils.equals((CharSequence)this.getAppId(), (CharSequence)"rebm")) {
            array = REBM_VIATION;
        }
        for (String flag : array) {
            String calinfo = flag + "calinfo";
            String calFlag = flag + "cal";
            String tempStr = flag + "str";
            CellStyleRule c2 = new CellStyleRule();
            c2.setFieldKey(tempStr);
            c2.setForeColor("#40bd6e");
            c2.setCondition(calinfo + " < 0.00");
            CellStyleRule c3 = new CellStyleRule();
            c3.setFieldKey(tempStr);
            c3.setForeColor("#fb2323");
            c3.setCondition(calinfo + " > 0.00");
            CellStyleRule c5 = new CellStyleRule();
            c5.setFieldKey(calFlag);
            c5.setForeColor("#40bd6e");
            c5.setCondition(calinfo + " < 0.00");
            CellStyleRule c6 = new CellStyleRule();
            c6.setFieldKey(calFlag);
            c6.setForeColor("#fb2323");
            c6.setCondition(calinfo + " > 0.00");
            cellStyleRules.add(c2);
            cellStyleRules.add(c3);
            cellStyleRules.add(c5);
            cellStyleRules.add(c6);
        }
        CellStyleRule c2 = new CellStyleRule();
        c2.setFieldKey("projectreach");
        c2.setForeColor("#40bd6e");
        c2.setCondition("projectreach  < 0 ");
        CellStyleRule c3 = new CellStyleRule();
        c3.setFieldKey("projectreach");
        c3.setForeColor("#fb2323");
        c3.setCondition("projectreach  > 0 ");
        cellStyleRules.add(c2);
        cellStyleRules.add(c3);
    }

    public void setAndEva(BigDecimal dividend, BigDecimal divisor, DynamicObject row, String flag) {
        BigDecimal subtract = dividend.subtract(divisor).setScale(2, 4);
        if (divisor.compareTo(BigDecimal.ZERO) == 0) {
            row.set(flag, (Object)BigDecimal.ZERO);
            row.set(flag + "str", (Object)"0.00%");
            row.set(flag + "cal", (Object)"0.00");
        } else {
            BigDecimal divide = subtract.divide(divisor, 4, 4).multiply(new BigDecimal("100")).setScale(2, 4);
            row.set(flag, (Object)divide);
            if (divide.compareTo(BigDecimal.ZERO) > 0) {
                row.set(flag + "str", (Object)(divide.toString() + "% \u2191"));
                row.set(flag + "cal", (Object)(subtract.toString() + "\u2191"));
                row.set(flag + "calinfo", (Object)1.2);
            } else if (divide.compareTo(BigDecimal.ZERO) < 0) {
                row.set(flag + "str", (Object)(divide.toString() + "% \u2193"));
                row.set(flag + "cal", (Object)(subtract.toString() + "\u2193"));
                row.set(flag + "calinfo", (Object)-1);
            } else {
                row.set(flag + "str", (Object)"0.00%");
                row.set(flag + "cal", (Object)"0.00");
                row.set(flag + "calinfo", (Object)0);
            }
        }
    }

    public void setProjectreach(DynamicObject row) {
        Long projectreach = row.getLong("planprojectperiod");
        if (projectreach == 0L) {
            row.set("projectreach", (Object)0);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("qingview".equals(operateKey)) {
            String formId = this.getAppId() + "_report_data";
            ListShowParameter formShowParameter = new ListShowParameter();
            formShowParameter.setBillFormId(formId);
            formShowParameter.setCustomParam("entitytypeid", (Object)formId);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        String fieldName = args.getFieldName();
        if ("flexpanelap".equals(fieldName)) {
            this.getView().refresh();
        }
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)BID_PROCESS)) {
            this.handleBidProcessHyperLinkClick(args);
        }
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)BID_CENTER)) {
            this.handleBidProjectNameHyperLinkClick(args);
        }
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"totalsectionname")) {
            this.handleSectionName(args);
        }
    }

    public void handleSectionName(HyperLinkClickEvent evt) {
        ReportList reportList = (ReportList)evt.getSource();
        int rowIndex = evt.getRowIndex();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        long bidid = rowData.getLong("bidid");
        String formId = this.getAppId() + "_newquery_section";
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setAppId(this.getAppId());
        showParameter.setFormId(formId);
        ReportQueryParam queryParam = new ReportQueryParam();
        HashMap<String, Long> customParam = new HashMap<String, Long>();
        customParam.put("id", bidid);
        queryParam.setCustomParam(customParam);
        showParameter.setQueryParam(queryParam);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.ADDNEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void handleBidProcessHyperLinkClick(HyperLinkClickEvent evt) {
        ReportList reportList = (ReportList)evt.getSource();
        int rowIndex = evt.getRowIndex();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        Object id = rowData.get("projectid");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(this.getOpenFormId("projectprocess"));
        showParameter.setCustomParam("bidProjectId", id);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm(showParameter);
    }

    public void handleBidProjectNameHyperLinkClick(HyperLinkClickEvent args) {
        ReportList reportList = (ReportList)args.getSource();
        int rowIndex = args.getRowIndex();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        Object id = rowData.get("projectid");
        long currUserId = RequestContext.get().getCurrUserId();
        String message = new BidCenterCommonUtil().checkProjectPermission(id, this.getAppId(), currUserId);
        if (!StringUtils.equals((CharSequence)"true", (CharSequence)message)) {
            this.getView().showErrorNotification(message);
            return;
        }
        this.showNewBid(id);
    }

    public void initDetailQuantityNum(ReportQueryParam queryParam) {
        String bidcurrentstep = this.getPageCache().get("isstep");
        if (bidcurrentstep != null) {
            return;
        }
        Map customParam = queryParam.getCustomParam();
        HashSet value = (HashSet)customParam.get("myfilterbidprojectid");
        if (value == null || value.size() == 0 || value.contains(-1L)) {
            for (Map.Entry<String, String> entry : MAP_TABLE.entrySet()) {
                String common_key = entry.getKey();
                String page_nums = PAGE_MAP.get(common_key);
                this.getModel().setValue(page_nums, (Object)0);
            }
            this.getModel().setValue("bidallprojectnum", (Object)0);
            return;
        }
        this.setBidProcessNum(value);
    }

    public void showNewBid(Object primaryKeyValue) {
        BillShowParameter showParameter = new BillShowParameter();
        String formId = this.getOpenFormId("bidcenter");
        showParameter.setFormId(formId);
        showParameter.setPkId(primaryKeyValue);
        showParameter.setCustomParam("opKeyFromList", (Object)"bidproject");
        showParameter.setCustomParam("bidProjectId", primaryKeyValue);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public String getOpenFormId(String formType) {
        switch (formType) {
            case "project": {
                return this.getAppId() + "_" + "project";
            }
            case "projectprocess": {
                return this.getAppId() + "_" + "projectprocess";
            }
            case "bidcenter": {
                return this.getAppId() + "_" + "bidcenter";
            }
        }
        return null;
    }

    public String getAppId() {
        return "bid";
    }

    public void search(SearchEnterEvent searchEnterEvent) {
    }

    public void setBidProcessNum(Set<Long> projectIds) {
        QFilter status = new QFilter("billstatus", "!=", (Object)"XX");
        QFilter bidprojects = new QFilter("bidproject", "in", projectIds);
        for (Map.Entry<String, String> entry : MAP_TABLE.entrySet()) {
            String common_key = entry.getKey();
            String table_name = entry.getValue();
            String page_nums = PAGE_MAP.get(common_key);
            if (StringUtils.equals((CharSequence)"bidproject", (CharSequence)common_key)) {
                this.getModel().setValue(page_nums, (Object)projectIds.size());
                this.getModel().setValue("bidallprojectnum", (Object)projectIds.size());
                continue;
            }
            DynamicObject[] ids = new DynamicObject[]{};
            if (StringUtils.equals((CharSequence)"bidpublish", (CharSequence)common_key)) {
                QFilter publishListQFilter = BidHistoryUtil.getPublishListQFilter();
                ids = BusinessDataServiceHelper.load((String)table_name, (String)"id", (QFilter[])new QFilter[]{bidprojects, publishListQFilter});
            } else {
                ids = BusinessDataServiceHelper.load((String)table_name, (String)"id", (QFilter[])new QFilter[]{status, bidprojects});
            }
            this.getModel().setValue(page_nums, (Object)ids.length);
        }
    }

    static {
        DEFAULT_VALUE.put("contractstatus", "C");
        CURRENTKEYS = new String[]{"bidProjectNum", "supplierInvitationNum", "bidDocumentNum", "bottommakenum", "clarificaitonnum", "bidPublishNum", "bidAnswerQuestionNum", "bidOpenNum", "bidEvaluationNum", "bidBustalkNum", "bidDecisionNum"};
        CURRENTNAMES = new String[]{"BidProject", "SupplierInvitation", "BidDocument", "Clarificaiton", "BidPublish", "BidAnswerQuestion", "BidOpen", "BidEvaluation", "BidBustalk", "BidDecision"};
        MAP_TABLE = new HashMap<String, String>(16);
        PAGE_MAP = new HashMap<String, String>();
        MAP_TABLE.put("bidproject", "bid_project");
        MAP_TABLE.put("supplierinvitation", "bid_supplierinvitation");
        MAP_TABLE.put("biddocument", "bid_biddocument_edit");
        MAP_TABLE.put("bidbottommake", "bid_bottom_make");
        MAP_TABLE.put("clarificaiton", "bid_clarificaiton");
        MAP_TABLE.put("bidpublish", "bid_bidpublish");
        MAP_TABLE.put("bidanswerquestion", "bid_answerquestion");
        MAP_TABLE.put("bidopen", "bid_bidopen");
        MAP_TABLE.put("bidevaluation", "bid_bidevaluation");
        MAP_TABLE.put("bidbustalk", "bid_bustalk");
        MAP_TABLE.put("biddecision", "bid_decision");
        PAGE_MAP.put("bidproject", "bidprojectnum");
        PAGE_MAP.put("supplierinvitation", "supplierinvitationnum");
        PAGE_MAP.put("biddocument", "biddocumentnum");
        PAGE_MAP.put("bidbottommake", "bottommakenum");
        PAGE_MAP.put("clarificaiton", "clarificaitonnum");
        PAGE_MAP.put("bidpublish", "bidpublishnum");
        PAGE_MAP.put("bidanswerquestion", "bidanswerquestionnum");
        PAGE_MAP.put("bidopen", "bidopennum");
        PAGE_MAP.put("bidevaluation", "bidevaluationnum");
        PAGE_MAP.put("bidbustalk", "bidbustalknum");
        PAGE_MAP.put("biddecision", "biddecisionnum");
    }
}

