/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.report.biddetailquery;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.report.RptFilterUtil;

public class BidDetailQueryList
extends AbstractReportListDataPlugin {
    private String ROW_BIDMODE = "bidmode";
    private String ROW_PURTYPE = "purtype";
    private String ROW_PURMODEL = "purmodel";
    private String ROW_BILLSTATUS = "billstatus";
    private String ROW_SETUPDATE = "setupdate";
    private String ROW_AUDITDATE = "auditdate";
    private String ROW_PURPROJECTSET = "purprojectset";

    public DataSet query(ReportQueryParam queryParam, Object arg1) throws Throwable {
        FilterInfo filterInfo = queryParam.getFilter();
        List<QFilter> bidFilter = this.getBidFilter(filterInfo);
        String bidFormId = FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass());
        QFilter bidentitytypefilter = new QFilter("EntityTypeId", "=", (Object)bidFormId);
        bidFilter.add(bidentitytypefilter);
        QFilter[] bidQFilters = bidFilter.toArray(new QFilter[bidFilter.size()]);
        String selectFieldInBid = "id as bidid,billstatus,currentstep,billno,name,purprojectset,setupdate,purmodel,bidmode,purtype,org";
        DataSet bidDataSet = QueryServiceHelper.queryDataSet((String)bidFormId, (String)bidFormId, (String)selectFieldInBid, (QFilter[])bidQFilters, null);
        String formId = FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass());
        String selectFieldInDecision = "id as decisionid,bidproject,amount,auditdate,billstatus as contractstatus";
        List<QFilter> decisionFilter = this.getDecisionFilter(filterInfo);
        QFilter entitytypefilter = new QFilter("EntityTypeId", "=", (Object)formId);
        decisionFilter.add(entitytypefilter);
        QFilter statusQFilterInDecision = new QFilter("billstatus", "=", (Object)"C").or(new QFilter("billstatus", "=", (Object)"S")).or(new QFilter("billstatus", "=", (Object)"R"));
        decisionFilter.add(statusQFilterInDecision);
        QFilter[] decisionQFilters = decisionFilter.toArray(new QFilter[decisionFilter.size()]);
        DataSet disionDataSet = QueryServiceHelper.queryDataSet((String)formId, (String)formId, (String)selectFieldInDecision, (QFilter[])decisionQFilters, null);
        String statusSql = "case when billstatus ='X' then 'N' else 'Y' end as billstatus";
        String[] leftFields = new String[]{statusSql, "bidid", "currentstep", "billno", "name", "purprojectset", "setupdate", "purmodel", "bidmode", "purtype", "org"};
        String contractstatusSql = "case when contractstatus ='S' then 'S' when contractstatus ='R' then 'R' else 'C' end as contractstatus";
        String[] rightFields = new String[]{contractstatusSql, "decisionid", "amount", "auditdate"};
        DataSet result = bidDataSet.leftJoin(disionDataSet).on("bidid", "bidproject").select(leftFields, rightFields).finish();
        String dateFilter = RptFilterUtil.getNotNullDateFilter((FilterInfo)filterInfo, (String)(this.ROW_AUDITDATE + RptFilterUtil.FLAG_FILTER + RptFilterUtil.FLAG_STARTDATE), (String)this.ROW_AUDITDATE);
        if (StringUtils.isNotEmpty((CharSequence)dateFilter)) {
            result = result.filter(dateFilter);
        }
        result = result.orderBy(new String[]{"setupdate desc"});
        return result;
    }

    private List<QFilter> getDecisionFilter(FilterInfo filterInfo) {
        ArrayList<QFilter> decisionFilter = new ArrayList<QFilter>();
        RptFilterUtil.addTimeRangFilter((FilterInfo)filterInfo, (String)(this.ROW_AUDITDATE + RptFilterUtil.FLAG_FILTER), (String)this.ROW_AUDITDATE, decisionFilter);
        return decisionFilter;
    }

    public List<QFilter> getBidFilter(FilterInfo filterInfo) {
        DynamicObjectCollection orgmultiplefilter;
        String billstatusfield;
        ArrayList<QFilter> bidFilter = new ArrayList<QFilter>();
        RptFilterUtil.addBasicDataEqualsFilter((FilterInfo)filterInfo, (String)(RptFilterUtil.ROW_ORG + RptFilterUtil.FLAG_FILTER), (String)RptFilterUtil.ROW_ORG, bidFilter);
        RptFilterUtil.addMultipleBasicDataEqualsFilter((FilterInfo)filterInfo, (String)(this.ROW_PURTYPE + RptFilterUtil.FLAG_FILTER), (String)this.ROW_PURTYPE, bidFilter);
        DynamicObjectCollection multiplefilter = filterInfo.getDynamicObjectCollection(this.ROW_BIDMODE + RptFilterUtil.FLAG_FILTER);
        if (multiplefilter != null && multiplefilter.size() > 0) {
            HashSet<Object> idPks = new HashSet<Object>();
            for (int i = 0; i < multiplefilter.size(); ++i) {
                DynamicObject coll = (DynamicObject)multiplefilter.get(i);
                if (StringUtils.equals((CharSequence)ResManager.loadKDString((String)"\u516c\u5f00\u62db\u6807", (String)"BidDetailQueryList_0", (String)"scm-bid-formplugin", (Object[])new Object[0]), (CharSequence)coll.getString("name"))) {
                    DynamicObject[] bidload = BusinessDataServiceHelper.load((String)"bid_bidmode", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "like", (Object)ResManager.loadKDString((String)"%\u516c\u5f00\u62db\u6807%", (String)"BidDetailQueryList_1", (String)"scm-bid-formplugin", (Object[])new Object[0]))});
                    DynamicObject[] rebmload = BusinessDataServiceHelper.load((String)"rebm_bidmode", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "like", (Object)ResManager.loadKDString((String)"%\u516c\u5f00\u62db\u6807%", (String)"BidDetailQueryList_1", (String)"scm-bid-formplugin", (Object[])new Object[0]))});
                    for (DynamicObject d : bidload) {
                        idPks.add(d.getPkValue());
                    }
                    for (DynamicObject d : rebmload) {
                        idPks.add(d.getPkValue());
                    }
                    continue;
                }
                idPks.add(coll.getPkValue());
            }
            bidFilter.add(new QFilter(this.ROW_BIDMODE, "in", idPks));
        }
        if (StringUtils.isNotEmpty((CharSequence)(billstatusfield = filterInfo.getString(this.ROW_BILLSTATUS + RptFilterUtil.FLAG_FILTER)))) {
            if (StringUtils.equals((CharSequence)billstatusfield, (CharSequence)"Y")) {
                QFilter statusFilter = new QFilter(this.ROW_BILLSTATUS, "!=", (Object)"X");
                QFilter cancelFilter = new QFilter(this.ROW_BILLSTATUS, "!=", (Object)"XX");
                bidFilter.add(statusFilter);
                bidFilter.add(cancelFilter);
            } else if (StringUtils.equals((CharSequence)billstatusfield, (CharSequence)"N")) {
                QFilter statusFilter = new QFilter(this.ROW_BILLSTATUS, "=", (Object)"X");
                bidFilter.add(statusFilter);
            }
        }
        if ((orgmultiplefilter = filterInfo.getDynamicObjectCollection(RptFilterUtil.ROW_ORG + RptFilterUtil.FLAG_MULTIPLE + RptFilterUtil.FLAG_FILTER)) != null && orgmultiplefilter.size() > 0) {
            Object[] orgIds = RptFilterUtil.getBaseDataPkIds((DynamicObjectCollection)orgmultiplefilter);
            bidFilter.add(new QFilter(RptFilterUtil.ROW_ORG, "in", (Object)orgIds).or(this.getEntrustmentorgunitQFilter(orgIds)));
        } else {
            List orgList = RptFilterUtil.getHasPermOrgs();
            bidFilter.add(new QFilter(RptFilterUtil.ROW_ORG, "in", (Object)orgList).or(this.getEntrustmentorgunitQFilter(orgList)));
        }
        RptFilterUtil.addComboEqualsFilter((FilterInfo)filterInfo, (String)(this.ROW_PURMODEL + RptFilterUtil.FLAG_FILTER), (String)this.ROW_PURMODEL, bidFilter);
        RptFilterUtil.addDateRangFilter((FilterInfo)filterInfo, (String)(this.ROW_SETUPDATE + RptFilterUtil.FLAG_FILTER), (String)this.ROW_SETUPDATE, bidFilter);
        RptFilterUtil.addTextFilter((FilterInfo)filterInfo, (String)(this.ROW_PURPROJECTSET + RptFilterUtil.FLAG_FILTER), (String)this.ROW_PURPROJECTSET, bidFilter);
        return bidFilter;
    }

    public QFilter getEntrustmentorgunitQFilter(Object value) {
        return new QFilter("entrustmentorgunit", "in", value);
    }
}

