/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.report.biddetailquery;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.events.CellStyleRule;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.formplugin.util.BidCenterCommonUtil;

public class BidSectionDeatilQueryEdit
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
ListRowClickListener {
    public static final String BID_PROCESS = "currentstep";
    public static final String BID_CENTER = "projectname";
    private static final String CQ = "REMD";
    private static final String CRQ = "crq";
    private static final String EC = "ec";
    private static String[] BID_STYLE = new String[]{"gdeviation", "tfinalauditamount"};
    private static String[] REBM_STYLE = new String[]{"gdeviation", "tfinalauditamount", "toltalplanamount"};
    private static final Set<String> CONCTRACT = new HashSet<String>();

    public void registerListener(EventObject eventobject) {
        super.registerListener(eventobject);
        ReportList billList = (ReportList)this.getView().getControl("reportlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getPageCache().put("billtype", this.getAppId() + "_newquerysection");
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        String fieldName = args.getFieldName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)BID_PROCESS)) {
            this.handleBidProcessHyperLinkClick(args);
        }
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)BID_CENTER)) {
            this.handleBidProjectNameHyperLinkClick(args);
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        if (rowData == null || rowData.size() <= 0) {
            return;
        }
        DynamicObject rowIndex = (DynamicObject)rowData.get(0);
        if (rowIndex == null) {
            return;
        }
        long bidid = rowIndex.getLong("bidid");
        String formId = this.getAppId() + "_report_data";
        DynamicObject reportData = BusinessDataServiceHelper.loadSingle((Object)bidid, (String)formId);
        rowData.clear();
        this.makeSectionReport(reportData, rowData, bidid);
    }

    public void makeSectionReport(DynamicObject reportData, DynamicObjectCollection rowData, long bidid) {
        String projectformId = this.getAppId() + "_project";
        DynamicObject org = reportData.getDynamicObject("org");
        DynamicObject bidproject = BusinessDataServiceHelper.loadSingle((Object)reportData.getDynamicObject("bidproject").getPkValue(), (String)projectformId);
        DynamicObject purtype = reportData.getDynamicObject("purtype");
        this.getPageCache().put(this.getPageCache().getPageId(), bidproject.getPkValue().toString());
        DynamicObject decition = this.getDecition(bidproject);
        Map<String, Map<String, Object>> stringStringMap = null;
        DynamicObject[] contracts = new DynamicObject[]{};
        String conctractType = "";
        if (decition != null) {
            stringStringMap = this.hasDecisionInfo(decition);
            if (StringUtils.equals((CharSequence)this.getAppId(), (CharSequence)"rebm")) {
                for (String flag : CONCTRACT) {
                    contracts = this.getContractData(flag, decition.getPkValue(), bidproject.getPkValue());
                    if (contracts == null || contracts.length <= 0) continue;
                    conctractType = flag;
                    break;
                }
            }
        }
        DynamicObjectCollection bidsection = reportData.getDynamicObjectCollection("bidsection");
        Iterator bidsectionIter = bidsection.iterator();
        HashSet<String> purebtryNameBuilder = new HashSet<String>();
        while (bidsectionIter.hasNext()) {
            Object substring;
            String value;
            StringBuilder builder;
            DynamicObject next = (DynamicObject)bidsectionIter.next();
            DynamicObject rowNew = rowData.addNew();
            rowNew.set("bidid", (Object)bidid);
            rowNew.set("projectid", (Object)Long.parseLong(bidproject.getPkValue().toString()));
            rowNew.set("orgname", org.get("name"));
            rowNew.set("purtype", (Object)purtype);
            rowNew.set(BID_CENTER, bidproject.get("name"));
            rowNew.set(BID_PROCESS, bidproject.get(BID_PROCESS));
            String sectionname = next.getString("sectionname");
            rowNew.set("sectionname", (Object)sectionname);
            Map<String, Object> decitionInfo = null;
            if (stringStringMap != null && stringStringMap.size() > 0) {
                decitionInfo = stringStringMap.get(sectionname);
            }
            HashSet<String> planNameSet = new HashSet<String>();
            HashSet<String> ruleNameSet = new HashSet<String>();
            purebtryNameBuilder.clear();
            DynamicObjectCollection projectentry = next.getDynamicObjectCollection("projectentry");
            for (Object purpertyRow : projectentry) {
                DynamicObject programcontract;
                DynamicObject cqprogcon;
                String name;
                DynamicObject purentryproject = purpertyRow.getDynamicObject("purentryproject");
                if (purentryproject != null) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)purentryproject.getPkValue(), (String)(this.getAppId() + "_purproject"));
                    purebtryNameBuilder.add(dynamicObject.getString("fullname"));
                }
                if (!StringUtils.equals((CharSequence)this.getAppId(), (CharSequence)"rebm")) continue;
                DynamicObject purprojectplan = purpertyRow.getDynamicObject("purprojectplan");
                if (purprojectplan != null) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)purprojectplan.getPkValue(), (String)(this.getAppId() + "_purplan"));
                    name = dynamicObject.getString("name");
                    planNameSet.add(name);
                }
                if ((cqprogcon = purpertyRow.getDynamicObject("cqprogcon")) != null) {
                    name = cqprogcon.getString("name");
                    ruleNameSet.add(name);
                }
                if ((programcontract = purpertyRow.getDynamicObject("programcontract")) == null) continue;
                String name2 = programcontract.getString("name");
                ruleNameSet.add(name2);
            }
            if (purebtryNameBuilder.size() > 0) {
                Object purpertyRow;
                StringBuilder substring2 = new StringBuilder();
                purpertyRow = purebtryNameBuilder.iterator();
                while (purpertyRow.hasNext()) {
                    String s = (String)purpertyRow.next();
                    String value2 = s + ";";
                    substring2.append(value2);
                }
                rowNew.set("purentryprojects", (Object)substring2.substring(0, substring2.length() - 1));
            }
            BigDecimal purprojecteviationcal = next.getBigDecimal("sectcontrolamount");
            rowNew.set("gdeviation", (Object)purprojecteviationcal);
            BigDecimal sfinalauditamount = next.getBigDecimal("sfinalauditamount");
            if (decitionInfo != null && decitionInfo.get("finalauditamount") != null) {
                sfinalauditamount = (BigDecimal)decitionInfo.get("finalauditamount");
            }
            rowNew.set("tfinalauditamount", (Object)sfinalauditamount);
            BigDecimal decimal = BigDecimal.ZERO;
            if (decitionInfo != null) {
                BigDecimal temp;
                String s;
                if (decitionInfo.get("supplier") != null && StringUtils.isNotBlank((CharSequence)(s = decitionInfo.get("supplier").toString()))) {
                    rowNew.set("supplier", (Object)s);
                }
                if (decitionInfo.get("recommendBig") != null && (temp = (BigDecimal)decitionInfo.get("recommendBig")) != null) {
                    decimal = temp;
                }
                if (decitionInfo.get("recommendBig") != null && (temp = (BigDecimal)decitionInfo.get("recommendBig")) != null) {
                    decimal = temp;
                }
            }
            rowNew.set("finalprice", (Object)decimal);
            this.setAndEva(decimal, purprojecteviationcal, rowNew, "gdeviation");
            this.setAndEva(decimal, sfinalauditamount, rowNew, "tfinalauditamount");
            if (!StringUtils.equals((CharSequence)this.getAppId(), (CharSequence)"rebm")) continue;
            BigDecimal sectplanamount = next.getBigDecimal("sectplanamount");
            rowNew.set("toltalplanamount", (Object)sectplanamount);
            BigDecimal sectsignamount = next.getBigDecimal("sectsignamount");
            rowNew.set("totalsignamount", (Object)sectsignamount);
            this.setAndEva(decimal, sectplanamount, rowNew, "toltalplanamount");
            if (decitionInfo != null && decitionInfo.get("signstatus") != null) {
                String signstatus = decitionInfo.get("signstatus").toString();
                rowNew.set("contractstatus", (Object)signstatus);
            }
            if (planNameSet != null && planNameSet.size() > 0) {
                builder = new StringBuilder();
                for (String s : planNameSet) {
                    value = s + ";";
                    builder.append(value);
                }
                if (builder.length() > 0) {
                    substring = builder.substring(0, builder.length() - 1);
                    rowNew.set("purproplanname", substring);
                }
            }
            if (ruleNameSet != null && ruleNameSet.size() > 0) {
                builder = new StringBuilder();
                for (String s : ruleNameSet) {
                    value = s + ";";
                    builder.append(value);
                }
                if (builder.length() > 0) {
                    substring = builder.substring(0, builder.length() - 1);
                    rowNew.set("rulename", substring);
                }
            }
            if (contracts == null || contracts.length == 0 || decitionInfo == null) continue;
            String sectionId = decitionInfo.get("sectionId").toString();
            String billname = "";
            String billno = "";
            Date bizdate = null;
            BigDecimal bizBig = BigDecimal.ZERO;
            String decisionsectionid = "";
            for (DynamicObject contract : contracts) {
                if (StringUtils.equals((CharSequence)EC, (CharSequence)conctractType) ? !StringUtils.equals((CharSequence)sectionname, (CharSequence)(decisionsectionid = contract.getString("bidsection"))) : !StringUtils.equals((CharSequence)sectionId, (CharSequence)(decisionsectionid = contract.get("decisionsectionid").toString()))) continue;
                billname = contract.getString("billname");
                billno = contract.getString("billno");
                bizdate = StringUtils.equals((CharSequence)EC, (CharSequence)conctractType) ? contract.getDate("auditdate") : contract.getDate("bizdate");
                BigDecimal amount = BigDecimal.ZERO;
                amount = StringUtils.equals((CharSequence)EC, (CharSequence)conctractType) ? contract.getBigDecimal("originaloftaxamount") : contract.getBigDecimal("amount");
                bizBig = bizBig.add(amount).setScale(2, 4);
            }
            rowNew.set("hetongname", (Object)billname);
            rowNew.set("hetonganumber", (Object)billno);
            if (bizdate != null) {
                rowNew.set("hetongautidate", bizdate);
            }
            rowNew.set("totalsignamount", (Object)bizBig);
        }
    }

    public DynamicObject[] getContractData(String type, Object decisionId, Object bidProjectId) {
        DynamicObject[] contracts = null;
        if (CQ.equals(type)) {
            contracts = BusinessDataServiceHelper.load((String)"recon_contractbill", (String)"billno,billname,createtime,partyaname,partybname,amount,decisionsectionid,billstatus,bizstatus,decisionsectionid,bizdate", (QFilter[])new QFilter[]{new QFilter("decisionbillid", "=", decisionId), new QFilter("billstatus", "=", (Object)"C")});
        } else if (CRQ.equals(type)) {
            contracts = BusinessDataServiceHelper.load((String)"npecon_contractbill", (String)"billname,billno,partya,partyb,bizdate,decisionsectionid,amount,billstatus,bizstatus,amount", (QFilter[])new QFilter[]{new QFilter("decision", "=", decisionId), new QFilter("billstatus", "=", (Object)"C")});
        } else if (EC.equals(type)) {
            contracts = BusinessDataServiceHelper.load((String)"ec_out_contract", (String)"billname,billno,createtime,parta,partb,originaloftaxamount,bidsection,billstatus,contstatus,signdate,auditdate,", (QFilter[])new QFilter[]{new QFilter("bidprojectf7", "=", bidProjectId), new QFilter("billstatus", "=", (Object)"C")});
        }
        return contracts;
    }

    public void setAndEva(BigDecimal dividend, BigDecimal divisor, DynamicObject row, String flag) {
        BigDecimal subtract = dividend.subtract(divisor).setScale(2, 4);
        row.set(flag + "cal", (Object)subtract.toString());
        if (divisor.compareTo(BigDecimal.ZERO) == 0) {
            row.set(flag + "str", (Object)"0.00%");
            row.set(flag + "calinfo", (Object)0.0);
        } else {
            BigDecimal divide = subtract.divide(divisor, 4, 4).multiply(new BigDecimal("100")).setScale(2, 4);
            if (divide.compareTo(BigDecimal.ZERO) > 0) {
                row.set(flag + "str", (Object)(divide.toString() + "% \u2191"));
                row.set(flag + "calinfo", (Object)1.5);
            } else if (divide.compareTo(BigDecimal.ZERO) < 0) {
                row.set(flag + "str", (Object)(divide.toString() + "% \u2193"));
                row.set(flag + "calinfo", (Object)-1);
            } else {
                row.set(flag + "str", (Object)"0.00%");
                row.set(flag + "calinfo", (Object)0);
            }
        }
    }

    public DynamicObject getDecition(DynamicObject project) {
        StringBuilder decisionFormId = new StringBuilder();
        decisionFormId.append(this.getAppId());
        decisionFormId.append("_decision");
        HashSet<String> statusFilter = new HashSet<String>();
        statusFilter.add("C");
        statusFilter.add("S");
        statusFilter.add("R");
        DynamicObject[] currentData = BusinessDataServiceHelper.load((String)decisionFormId.toString(), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", project.getPkValue()), new QFilter("billstatus", "in", statusFilter)});
        if (currentData == null || currentData.length == 0) {
            return null;
        }
        DynamicObject currentDatum = currentData[0];
        currentDatum = BusinessDataServiceHelper.loadSingle((Object)currentDatum.getPkValue(), (String)decisionFormId.toString());
        return currentDatum;
    }

    public Map<String, Map<String, Object>> hasDecisionInfo(DynamicObject currentDatum) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        DynamicObjectCollection bidsection = currentDatum.getDynamicObjectCollection("bidsection");
        for (DynamicObject next : bidsection) {
            String sectionname = next.getString("sectionname");
            DynamicObjectCollection supplierentry = next.getDynamicObjectCollection("supplierentry");
            Iterator iterator = supplierentry.iterator();
            StringBuilder builder = new StringBuilder();
            BigDecimal recommendBig = BigDecimal.ZERO;
            BigDecimal signMenoy = BigDecimal.ZERO;
            while (iterator.hasNext()) {
                DynamicObject supplierInfo = (DynamicObject)iterator.next();
                boolean isrecommended = supplierInfo.getBoolean("isrecommended");
                if (!isrecommended) continue;
                DynamicObject supplier = supplierInfo.getDynamicObject("supplier");
                if (supplier != null) {
                    String value = supplier.getString("name") + ";";
                    builder.append(value);
                }
                recommendBig = recommendBig.add(supplierInfo.getBigDecimal("finalprice")).setScale(2, 5);
            }
            HashMap<String, Object> setctionMap = new HashMap<String, Object>();
            setctionMap.put("sectionId", next.getPkValue().toString());
            if (builder.length() > 0) {
                String substring = builder.substring(0, builder.length() - 1);
                setctionMap.put("supplier", substring);
            }
            setctionMap.put("recommendBig", recommendBig);
            if (StringUtils.equals((CharSequence)this.getAppId(), (CharSequence)"rebm")) {
                String signstatus = next.getString("signstatus");
                setctionMap.put("signstatus", signstatus);
            }
            result.put(sectionname, setctionMap);
        }
        bidsection = currentDatum.getDynamicObjectCollection("bottomsection");
        for (DynamicObject bottomNext : bidsection) {
            String botsectionname = bottomNext.getString("botsectionname");
            Map stringObjectMap = (Map)result.get(botsectionname);
            BigDecimal finalauditamount = BigDecimal.ZERO;
            DynamicObjectCollection bottomentry = bottomNext.getDynamicObjectCollection("bottomentry");
            for (DynamicObject next : bottomentry) {
                BigDecimal finalauditamount1 = next.getBigDecimal("finalauditamount");
                finalauditamount = finalauditamount.add(finalauditamount1).setScale(2, 5);
            }
            stringObjectMap.put("finalauditamount", finalauditamount);
        }
        return result;
    }

    public void setCellStyleRules(List<CellStyleRule> cellStyleRules) {
        super.setCellStyleRules(cellStyleRules);
        String[] array = BID_STYLE;
        if (StringUtils.equals((CharSequence)this.getAppId(), (CharSequence)"rebm")) {
            array = REBM_STYLE;
        }
        for (String flag : array) {
            String infFlag = flag + "calinfo";
            String calFlag = flag + "cal";
            String tempStr = flag + "str";
            CellStyleRule c2 = new CellStyleRule();
            c2.setFieldKey(tempStr);
            c2.setForeColor("#40bd6e");
            c2.setCondition(infFlag + " < 0.00");
            CellStyleRule c3 = new CellStyleRule();
            c3.setFieldKey(tempStr);
            c3.setForeColor("#fb2323");
            c3.setCondition(infFlag + " > 0.00");
            CellStyleRule c5 = new CellStyleRule();
            c5.setFieldKey(calFlag);
            c5.setForeColor("#40bd6e");
            c5.setCondition(infFlag + " < 0.00");
            CellStyleRule c6 = new CellStyleRule();
            c6.setFieldKey(calFlag);
            c6.setForeColor("#fb2323");
            c6.setCondition(infFlag + " > 0.00");
            cellStyleRules.add(c2);
            cellStyleRules.add(c3);
            cellStyleRules.add(c5);
            cellStyleRules.add(c6);
        }
    }

    public void handleBidProcessHyperLinkClick(HyperLinkClickEvent evt) {
        ReportList reportList = (ReportList)evt.getSource();
        int rowIndex = evt.getRowIndex();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        String id = this.getPageCache().get(this.getPageCache().getPageId());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(this.getOpenFormId("projectprocess"));
        showParameter.setCustomParam("bidProjectId", (Object)id);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm(showParameter);
    }

    public void handleBidProjectNameHyperLinkClick(HyperLinkClickEvent args) {
        ReportList reportList = (ReportList)args.getSource();
        int rowIndex = args.getRowIndex();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        String id = this.getPageCache().get(this.getPageCache().getPageId());
        long currUserId = RequestContext.get().getCurrUserId();
        String message = new BidCenterCommonUtil().checkProjectPermission(id, this.getAppId(), currUserId);
        if (!StringUtils.equals((CharSequence)"true", (CharSequence)message)) {
            this.getView().showErrorNotification(message);
            return;
        }
        this.showNewBid(id);
    }

    public void showNewBid(Object primaryKeyValue) {
        BillShowParameter showParameter = new BillShowParameter();
        String formId = this.getOpenFormId("bidcenter");
        showParameter.setFormId(formId);
        showParameter.setPkId(primaryKeyValue);
        showParameter.setCustomParam("opKeyFromList", (Object)"bidproject");
        showParameter.setCustomParam("bidProjectId", primaryKeyValue);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public String getOpenFormId(String formType) {
        switch (formType) {
            case "project": {
                return this.getAppId() + "_" + "project";
            }
            case "projectprocess": {
                return this.getAppId() + "_" + "projectprocess";
            }
            case "bidcenter": {
                return this.getAppId() + "_" + "bidcenter";
            }
        }
        return null;
    }

    public String getAppId() {
        return "bid";
    }

    static {
        CONCTRACT.add(CQ);
        CONCTRACT.add(CRQ);
        CONCTRACT.add(EC);
    }
}

