/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.report.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.CustomBaseDataFilterColumn;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class CommonFilter
extends AbstractReportFormPlugin {
    public static Set<String> FIELDNAME = new HashSet<String>(16);

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        super.filterContainerInit(contInitEvent, queryParam);
        List commonFilterColumns = contInitEvent.getCommonFilterColumns();
        List<Long> allHasPermPurOrgIds = this.getAllHasPermPurOrgIds();
        commonFilterColumns.forEach(e -> {
            String fieldName;
            switch (fieldName = e.getFieldName()) {
                case "orgfilter": {
                    HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId());
                    if (userHasPermOrgs.hasAllOrgPerm()) break;
                    this.reSetOrgFilterValue((CustomBaseDataFilterColumn)e, allHasPermPurOrgIds);
                    break;
                }
                case "purprojectset": {
                    HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId());
                    QFilter orgQfilter = new QFilter("org", "!=", (Object)-1);
                    if (!userHasPermOrgs.hasAllOrgPerm()) {
                        orgQfilter = new QFilter("org", "in", (Object)allHasPermPurOrgIds);
                    }
                    String appId = this.getModel().getDataEntityType().getAppId();
                    String entityId = appId + "_purproject";
                    this.reSetPurprojectFilterValue((CustomBaseDataFilterColumn)e, entityId, orgQfilter);
                    break;
                }
            }
        });
    }

    protected void reSetOrgFilterValue(CustomBaseDataFilterColumn e, List<Long> purOrgs) {
        DynamicObjectCollection orgs = this.getAllHasPermPurOrgs(purOrgs);
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(orgs.size());
        for (DynamicObject org : orgs) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(org.getString("name")));
            item.setValue(String.valueOf(org.getLong("id")));
            combos.add(item);
        }
        e.setMulti(false);
        e.getComboItems().clear();
        e.setComboItems(combos);
    }

    protected void reSetPurprojectFilterValue(CustomBaseDataFilterColumn e, String formId, QFilter orgsQfilter) {
        DynamicObject[] load = BusinessDataServiceHelper.load((String)formId, (String)"id,fullname,number", (QFilter[])new QFilter[]{new QFilter("entitytypeid", "=", (Object)formId), orgsQfilter}, (String)"number asc");
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(load.length);
        for (DynamicObject org : load) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(org.getString("fullname")));
            item.setValue(String.valueOf(org.getLong("id")));
            combos.add(item);
        }
        e.setMulti(false);
        e.getComboItems().clear();
        e.setComboItems(combos);
    }

    protected DynamicObjectCollection getAllHasPermPurOrgs(List<Long> purOrgs) {
        return QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE), new QFilter("id", "in", purOrgs)}, (String)"number asc");
    }

    protected List<Long> getAllHasPermPurOrgIds() {
        long currUserId = RequestContext.get().getCurrUserId();
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)currUserId);
        List<Long> purOrgIds = new ArrayList<Long>();
        if (!userHasPermOrgs.hasAllOrgPerm()) {
            List hasPermOrgIds = userHasPermOrgs.getHasPermOrgs();
            purOrgIds = OrgUnitServiceHelper.filterOrgDuty((List)hasPermOrgIds, (String)"02");
        }
        return purOrgIds;
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId());
        if (fieldName.contains("org")) {
            if (userHasPermOrgs.hasAllOrgPerm()) {
                return;
            }
            List<Long> allHasPermPurOrgIds = this.getAllHasPermPurOrgIds();
            ArrayList<QFilter> qfilters = args.getQfilters();
            if (qfilters == null) {
                qfilters = new ArrayList<QFilter>();
            }
            qfilters.add(new QFilter("id", "in", allHasPermPurOrgIds));
            args.setQfilters(qfilters);
        }
        if (fieldName.contains("purprojectset")) {
            ArrayList<QFilter> qfilters = args.getQfilters();
            if (qfilters == null) {
                qfilters = new ArrayList<QFilter>();
            }
            if (userHasPermOrgs.hasAllOrgPerm()) {
                return;
            }
            QFilter orgQfilter = new QFilter("org", "!=", (Object)-1);
            if (!userHasPermOrgs.hasAllOrgPerm()) {
                List<Long> allHasPermPurOrgIds = this.getAllHasPermPurOrgIds();
                orgQfilter = new QFilter("org", "in", allHasPermPurOrgIds);
            }
            qfilters.add(orgQfilter);
            args.setQfilters(qfilters);
        }
    }

    static {
        FIELDNAME.add("orgfilter");
        FIELDNAME.add("purprojectset");
    }
}

