/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.common.enums.BidReBackBidEnum;

public class ReBackBidUtil {
    private String appId;
    public String[] exceptStatus = new String[]{"X", "XX"};
    public static final Set<String> ALLOW_OP = new HashSet<String>();

    public ReBackBidUtil() {
    }

    public ReBackBidUtil(String appId) {
        this.appId = appId;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public boolean checkDecisionStart(Object bidProjectId) {
        DynamicObject decison = QueryServiceHelper.queryOne((String)this.getBillName("_decision"), (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectId), new QFilter("billstatus", "not in", (Object)this.exceptStatus)});
        if (decison == null) {
            return false;
        }
        String billstatus = decison.getString("billstatus");
        return !"D".equals(billstatus);
    }

    public String checkOtherBidProcessFinished(Object bidProjectId) {
        boolean exists;
        List ids;
        List<QFilter> qFilters = this.getCommonFilters(bidProjectId);
        String warnTips = null;
        String supplierBillName = this.getBillName("_supplierinvitation");
        warnTips = this.getWarnTips("_supplierinvitation", this.getProcessBillstatus(supplierBillName, this.getFiltesByBillName(qFilters, supplierBillName)));
        if (warnTips != null) {
            return warnTips;
        }
        String bidDocumentEditStr = this.getBillName("_biddocument_edit");
        warnTips = this.getWarnTips("_biddocument_edit", this.getProcessBillstatus(bidDocumentEditStr, this.getFiltesByBillName(qFilters, bidDocumentEditStr)));
        if (warnTips != null) {
            return warnTips;
        }
        String bidPublishStr = this.getBillName("_bidpublish");
        warnTips = this.getWarnTips("_bidpublish", this.getProcessBillstatus(bidPublishStr, this.getFiltesByBillName(qFilters, bidPublishStr)));
        if (warnTips != null) {
            return warnTips;
        }
        warnTips = this.getWarnTips("_supplierinvalid", this.getProcessBillstatus(this.getBillName("_supplierinvalid"), qFilters));
        if (warnTips != null) {
            return warnTips;
        }
        warnTips = this.getWarnTips("_onlinebideval", this.getProcessBillstatus(this.getBillName("_onlinebideval"), qFilters));
        if (warnTips != null) {
            return warnTips;
        }
        warnTips = this.getWarnTips("_bidevaluation", this.getProcessBillstatus(this.getBillName("_bidevaluation"), qFilters));
        if (warnTips != null) {
            return warnTips;
        }
        warnTips = this.getWarnTips("_multiquestclarify", this.getProcessBillstatus(this.getBillName("_multiquestclarify"), qFilters));
        if (warnTips != null) {
            return warnTips;
        }
        DynamicObjectCollection bills = QueryServiceHelper.query((String)this.getBillName("_multiquestclarify"), (String)"publicstatis", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (bills.size() > 0) {
            for (DynamicObject bill : bills) {
                String publicstatis = bill.getString("publicstatis");
                if ("S".equals(publicstatis)) continue;
                StringBuilder sb = new StringBuilder();
                sb.append(this.getEntityNameMap().get("_multiquestclarify"));
                sb.append('\n');
                sb.append(ResManager.loadKDString((String)"\u72b6\u6001\u4e3a\uff1a\u672a\u53d1\u5e03", (String)"ReBackBidUtil_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return sb.toString();
            }
        }
        if ((warnTips = this.getWarnTips("_questionclarify", this.getProcessBillstatus(this.getBillName("_questionclarify"), qFilters))) != null) {
            return warnTips;
        }
        warnTips = this.getWarnTips("_bustalk", this.getProcessBillstatus(this.getBillName("_bustalk"), qFilters));
        if (warnTips != null) {
            return warnTips;
        }
        DynamicObjectCollection proficientExtracts = QueryServiceHelper.query((String)this.getBillName("_proficient_extract"), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidprojectname", "=", bidProjectId), new QFilter("billstatus", "not in", (Object)new String[]{"X", "XX"})});
        if (proficientExtracts != null && proficientExtracts.size() > 0 && (ids = proficientExtracts.stream().map(item -> item.getLong("id")).collect(Collectors.toList())).size() > 0 && (exists = QueryServiceHelper.exists((String)this.getBillName("_bidassinvitesum"), (QFilter[])new QFilter[]{new QFilter("publishstatus", "=", (Object)"10"), new QFilter("billstatus", "not in", (Object)new String[]{"X", "XX"}), new QFilter("linkexpertextract", "in", ids)}))) {
            StringBuilder sb = new StringBuilder();
            sb.append(ResManager.loadKDString((String)"\u8bc4\u6807\u9080\u8bf7\u51fd", (String)"ReBackBidUtil_12", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            sb.append('\n');
            sb.append(ResManager.loadKDString((String)"\u72b6\u6001\u4e3a\uff1a\u672a\u53d1\u5e03", (String)"ReBackBidUtil_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return sb.toString();
        }
        qFilters.clear();
        qFilters.add(new QFilter("status", "not in", (Object)this.exceptStatus));
        qFilters.add(new QFilter("bidproject", "=", bidProjectId));
        warnTips = this.getWarnTips("_negotiate_invite", this.getProcessBillstatus(this.getBillName("_negotiate_invite"), qFilters));
        if (warnTips != null) {
            return warnTips;
        }
        DynamicObjectCollection bills2 = QueryServiceHelper.query((String)this.getBillName("_negotiate_invite"), (String)"publishstatus", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (bills2.size() > 0) {
            for (DynamicObject bill : bills2) {
                String publicstatis = bill.getString("publishstatus");
                if ("1".equals(publicstatis)) continue;
                StringBuilder sb = new StringBuilder();
                sb.append(this.getEntityNameMap().get("_negotiate_invite"));
                sb.append('\n');
                sb.append(ResManager.loadKDString((String)"\u72b6\u6001\u4e3a\uff1a\u672a\u53d1\u5e03", (String)"ReBackBidUtil_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return sb.toString();
            }
        }
        qFilters.clear();
        qFilters.add(new QFilter("name", "=", bidProjectId));
        qFilters.add(new QFilter("billstatus", "not in", (Object)this.exceptStatus));
        warnTips = this.getWarnTips("_bidassinvite", this.getProcessBillstatus(this.getBillName("_bidassinvite"), qFilters));
        if (warnTips != null) {
            return warnTips;
        }
        qFilters.clear();
        qFilters.add(new QFilter("bidproject", "=", bidProjectId));
        String entityName = "_query_letters";
        if ("rebm".equals(this.appId)) {
            entityName = "_query_letters_inh";
        }
        if ((warnTips = this.getWarnTips("_query_letters", this.getProcessBillstatus(this.getBillName(entityName), qFilters))) != null) {
            return warnTips;
        }
        return null;
    }

    public List<QFilter> getCommonFilters(Object bidProjectId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("billstatus", "not in", (Object)this.exceptStatus));
        qFilters.add(new QFilter("bidproject", "=", bidProjectId));
        return qFilters;
    }

    protected String getWarnTips(String entityName, String billstatus) {
        if (billstatus == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getEntityNameMap().get(entityName));
        sb.append(ResManager.loadKDString((String)"\u72b6\u6001\u4e3a\uff1a", (String)"ReBackBidUtil_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        if (billstatus.equals(BidReBackBidEnum.B.getValue())) {
            sb.append(BidReBackBidEnum.B.getAlias());
        } else if (billstatus.equals(BidReBackBidEnum.I.getValue())) {
            sb.append(BidReBackBidEnum.I.getAlias());
        } else if ("_questionclarify".equals(entityName)) {
            sb.append(ResManager.loadKDString((String)"\u5f85\u6f84\u6e05", (String)"ReBackBidUtil_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        } else {
            sb.append(BidReBackBidEnum.A.getAlias());
        }
        return sb.toString();
    }

    public Map<String, String> getEntityNameMap() {
        HashMap<String, String> entityNameMap = new HashMap<String, String>(16);
        entityNameMap.put("_supplierinvitation", BidReBackBidEnum.SUPPLIERINVITATION.getAlias());
        entityNameMap.put("_biddocument_edit", BidReBackBidEnum.BIDOCUMENTEDIT.getAlias());
        entityNameMap.put("_bidpublish", BidReBackBidEnum.BIDPUBLISH.getAlias());
        entityNameMap.put("_supplierinvalid", BidReBackBidEnum.SUPPLIERINVALID.getAlias());
        entityNameMap.put("_onlinebideval", BidReBackBidEnum.ONLINEBIDEVAL.getAlias());
        entityNameMap.put("_bidevaluation", BidReBackBidEnum.BIDEVALUATION.getAlias());
        entityNameMap.put("_multiquestclarify", BidReBackBidEnum.MULTIQUESTCLARIFY.getAlias());
        entityNameMap.put("_bustalk", BidReBackBidEnum.BUSTALK.getAlias());
        entityNameMap.put("_query_letters", BidReBackBidEnum.QUERYLETTERS.getAlias());
        entityNameMap.put("_bidassinvite", BidReBackBidEnum.BIDASSINITE.getAlias());
        entityNameMap.put("_questionclarify", ResManager.loadKDString((String)"\u5f85\u6f84\u6e05\u95ee\u9898", (String)"ReBackBidUtil_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        entityNameMap.put("_negotiate_invite", ResManager.loadKDString((String)"\u5546\u52a1\u8c08\u5224\u9080\u7ea6\u51fd", (String)"ReBackBidUtil_6", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        return entityNameMap;
    }

    public List<QFilter> getFiltesByBillName(List<QFilter> qFilters, String billname) {
        switch (billname) {
            case "_supplierinvitation": {
                qFilters.add(new QFilter("sourcebillid", "!=", (Object)0L));
                break;
            }
            case "_biddocument_edit": {
                qFilters.add(new QFilter("parent", "!=", (Object)0L));
                break;
            }
            case "_bidpublish": {
                qFilters.add(new QFilter("source", "!=", (Object)"new"));
                qFilters.add(new QFilter("isnewbill", "=", (Object)Boolean.TRUE));
                break;
            }
            case "_query_letters": {
                qFilters.add(new QFilter("status", "not in", (Object)this.exceptStatus));
            }
        }
        return qFilters;
    }

    public boolean checkBackBidFinished(Object bidProjectId) {
        return QueryServiceHelper.exists((String)this.getBillName("_rebackbid"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectId), new QFilter("billstatus", "!=", (Object)"C")});
    }

    public boolean checkBackBidFinished(Object bidProjectId, String type) {
        DynamicObject bidOpen = QueryServiceHelper.queryOne((String)this.getBillName("_bidopen"), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectId), new QFilter("billstatus", "=", (Object)"O"), new QFilter("opentype", "=", (Object)type)});
        if (bidOpen == null) {
            return false;
        }
        return QueryServiceHelper.exists((String)this.getBillName("_rebackbid"), (QFilter[])new QFilter[]{new QFilter("sourceid", "=", (Object)bidOpen.getLong("id")), new QFilter("billstatus", "!=", (Object)"C")});
    }

    public String getBillName(String name) {
        return this.appId + name;
    }

    protected String getProcessBillstatus(String entityId, List<QFilter> qFilters) {
        String billsStatusName = this.getSpecialStatusBill().contains(entityId) ? "status" : "billstatus";
        DynamicObjectCollection bills = QueryServiceHelper.query((String)entityId, (String)billsStatusName, (QFilter[])qFilters.toArray(new QFilter[0]));
        if (bills == null || bills.isEmpty()) {
            return null;
        }
        for (DynamicObject bill : bills) {
            String billstatus = bill.getString(billsStatusName);
            if (!(this.getBillName("_multiquestclarify").equals(entityId) ? this.getMulClearfyCheckingBillstatus().contains(billstatus) : (this.getBillName("_questionclarify").equals(entityId) ? "UNCLARIFIED".equals(billstatus) : this.getCheckingBillstatus().contains(billstatus)))) continue;
            return billstatus;
        }
        return null;
    }

    public List<String> getCheckingBillstatus() {
        return Arrays.asList("A", "B", "I");
    }

    public List<String> getMulClearfyCheckingBillstatus() {
        return Arrays.asList("SAVED", "B", "I");
    }

    public List<String> getSpecialStatusBill() {
        return Arrays.asList("bid_query_letters", "rebm_query_letters_inh", "rebm_negotiate_invite", "bid_negotiate_invite");
    }

    public boolean getBillstatus(String entityId, List<QFilter> qFilters) {
        boolean flag = false;
        DynamicObjectCollection bills = QueryServiceHelper.query((String)entityId, (String)"billstatus", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (bills == null || bills.isEmpty()) {
            return flag;
        }
        for (DynamicObject bill : bills) {
            String billstatus = bill.getString("billstatus");
            if (!this.getCheckingBillstatus().contains(billstatus)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public void openReBackBidEdit(Object bidOpenId, IFormView view, String source) {
        boolean isOtherBidOpenInProcess;
        DynamicObject bidOpen = QueryServiceHelper.queryOne((String)(this.appId + "_bidopen"), (String)"bidproject,billstatus,opentype", (QFilter[])new QFilter[]{new QFilter("id", "=", bidOpenId)});
        String billStatus = bidOpen.getString("billstatus");
        if (!"O".equals(billStatus)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u5df2\u786e\u8ba4\u5f00\u6807\u7684\u5f00\u6807\u5355\u8fdb\u884c\u91cd\u65b0\u56de\u6807\u64cd\u4f5c\u3002", (String)"ReBackBidUtil_13", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        long bidproject = bidOpen.getLong("bidproject");
        boolean decisionStartFlag = this.checkDecisionStart(bidproject);
        if (decisionStartFlag) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u62db\u6807\u7acb\u9879\u5df2\u8fdb\u5165\u5b9a\u6807\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u91cd\u65b0\u56de\u6807\u3002", (String)"ReBackBidUtil_14", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        String tips = this.checkOtherBidProcessFinished(bidproject);
        if (tips != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u529e\u7406\u5b8c\u6210\u7684\u4e1a\u52a1\u5355\u636e\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u91cd\u65b0\u56de\u6807\u3002", (String)"ReBackBidUtil_18", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            sb.append('\n');
            sb.append(tips);
            view.showMessage(sb.toString());
            return;
        }
        boolean otherBidOpenRebackNoFinish = this.isOtherBidOpenRebackFinish(bidproject, bidOpenId);
        if (otherBidOpenRebackNoFinish) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u6709\u91cd\u65b0\u56de\u6807\uff0c\u4e0d\u80fd\u91cd\u590d\u53d1\u8d77\u3002", (String)"ReBackBidUtil_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject queryBidProject = QueryServiceHelper.queryOne((String)(this.appId + "_project"), (String)"bidopentype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bidproject)});
        String opentype = bidOpen.getString("opentype");
        if ("TECHBUSINESS".equals(queryBidProject.getString("bidopentype")) && "TECHNICAL".equals(opentype) && (isOtherBidOpenInProcess = this.isOtherBidOpenInProcess(bidproject))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5546\u52a1\u6807\u5df2\u5f00\u59cb\uff0c\u4e0d\u5141\u8bb8\u91cd\u56de\u6280\u672f\u6807\u3002", (String)"ReBackBidUtil_19", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean exists = QueryServiceHelper.exists((String)(this.appId + "_rebackbid"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidproject), new QFilter("billstatus", "!=", (Object)"C")});
        if (exists) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5728\u672a\u5ba1\u6838\u7684\u91cd\u65b0\u56de\u6807\u6570\u636e\uff0c\u8bf7\u5904\u7406\u540e\u518d\u91cd\u65b0\u56de\u6807\u3002", (String)"ReBackBidUtil_16", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId(this.appId + "_rebackbid");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("bidOpenId", bidOpenId);
        formShowParameter.setCustomParam("source", (Object)source);
        formShowParameter.setStatus(OperationStatus.EDIT);
        view.showForm((FormShowParameter)formShowParameter);
    }

    private boolean isOtherBidOpenInProcess(long bidprojectId) {
        return QueryServiceHelper.exists((String)(this.appId + "_bidopen"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidprojectId), new QFilter("billstatus", "not in", (Object)this.exceptStatus), new QFilter("billstatus", "not in", (Object)new String[]{"A", "D"}), new QFilter("opentype", "=", (Object)"BUSSINESS")});
    }

    public boolean isOtherBidOpenRebackFinish(long bidproject, Object bidOpenId) {
        DynamicObjectCollection opens = QueryServiceHelper.query((String)(this.appId + "_bidopen"), (String)"billstatus,id", (QFilter[])new QFilter[]{new QFilter("id", "!=", bidOpenId), new QFilter("bidproject", "=", (Object)bidproject), new QFilter("billstatus", "not in", (Object)this.exceptStatus)});
        if (opens == null || opens.size() == 0) {
            return false;
        }
        List openIdList = opens.stream().filter(open -> "D".equals(open.getString("billstatus"))).map(open -> open.getLong("id")).collect(Collectors.toList());
        return QueryServiceHelper.exists((String)(this.appId + "_rebackbid"), (QFilter[])new QFilter[]{new QFilter("createopenid", "in", openIdList)});
    }

    public void openReBackBidList(Object bidOpenId, IFormView view) {
        boolean exists = QueryServiceHelper.exists((String)(this.appId + "_rebackbid"), (QFilter[])new QFilter[]{new QFilter("sourceid", "=", bidOpenId)});
        if (!exists) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u5f00\u6807\u5355\u4e0d\u5b58\u5728\u5386\u53f2\u91cd\u65b0\u56de\u6807\u5355\u3002", (String)"ReBackBidUtil_17", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(this.appId + "_rebackbid");
        listShowParameter.setCustomParam("bidOpenId", bidOpenId);
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm((FormShowParameter)listShowParameter);
    }

    public boolean judgeOp(String op) {
        return ALLOW_OP.contains(op);
    }

    public boolean checkEvalutionOp(String opCode, Object bidproject) {
        if (!ALLOW_OP.contains(opCode)) {
            return false;
        }
        return this.checkBackBidFinished(bidproject);
    }

    static {
        ALLOW_OP.add("save");
        ALLOW_OP.add("submit");
        ALLOW_OP.add("unsubmit");
        ALLOW_OP.add("audit");
        ALLOW_OP.add("unaudit");
        ALLOW_OP.add("questionclarifylist");
        ALLOW_OP.add("questionclarify");
        ALLOW_OP.add("rebackbid");
        ALLOW_OP.add("newbidevaluationdoc");
        ALLOW_OP.add("delete");
    }
}

