/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.cloudkingdee;

import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.api.client.ApiClientFactory;
import kd.bos.api.client.ApiRequest;
import kd.bos.api.client.ApiResult;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.cloudkingdee.CloudKingdeeApiContext;
import kd.scm.common.cloudkingdee.CloudKingdeeApiUtil;
import kd.scm.common.cloudkingdee.ICloudKingdeeApiService;
import kd.scm.common.cloudkingdee.config.CloudKingdeeConfigration;
import kd.scm.common.cloudkingdee.errorcode.CloudKingdeeErrorCode;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.JacksonJsonUtil;

public class CloudKingdeeApiService
implements ICloudKingdeeApiService {
    private static Log log = LogFactory.getLog(CloudKingdeeApiService.class);
    private IAppCache cache = AppCache.get((String)"scm");
    private String api = null;
    private Map<String, Object> param = null;
    private static final Date GET_TOKEN_TIME = DateUtil.str2dateByLocalDateTime("1990-12-12 00:00:00", "yyyy-MM-dd HH:mm:ss");
    private static final int TOKEN_EXPIRED_TIME_HOUR = 0;
    private static final int TOKEN_EXPIRED_TIME_MINUTE = 1;

    @Override
    public Object process(CloudKingdeeApiContext context) {
        CloudKingdeeConfigration.initConfig(null);
        this.api = context.getApi();
        this.param = context.getParam();
        this.checkParams();
        ApiResult result = this.invokeApi(this.getRequestContext());
        return this.handleResult(result);
    }

    protected void checkParams() {
    }

    protected String getUrl() {
        StringBuilder sb = new StringBuilder();
        String urlStr = "";
        sb.append(CloudKingdeeConfigration.getHOST());
        if (this.api.equals("/auth/user/access_token")) {
            this.getToken();
            urlStr = this.api;
            sb.append(urlStr);
        } else if (this.api.equals("/auth/user/auth_code?access_token=%s") || this.api.equals("/passport/user/orgs?access_token=%s")) {
            urlStr = String.format(this.api, this.getToken());
            sb.append(urlStr);
        }
        return sb.toString();
    }

    protected String getMethod() {
        return "post";
    }

    protected ApiRequest getRequestContext() {
        ApiRequest request = new ApiRequest(this.getMethod(), this.getUrl());
        if (this.param != null && !this.param.isEmpty() && this.getMethod().equals("post")) {
            request.setPostData(this.param);
        }
        return request;
    }

    private ApiResult invokeApi(ApiRequest request) {
        return ApiClientFactory.getInternal().execute(request);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object handleResult(ApiResult result) {
        String msg = null;
        String errorMsg = null;
        if (result.isOk()) {
            Object json = JacksonJsonUtil.fromJson(result.getData(), Object.class);
            if (json instanceof Map) {
                Map map = (Map)json;
                if (map.get("errcode").equals(0)) {
                    if (this.api.equals("/auth/user/access_token")) {
                        Map data = (Map)map.get("data");
                        return data.get("access_token").toString();
                    }
                    if (this.api.equals("/auth/user/auth_code?access_token=%s")) {
                        Map data = (Map)map.get("data");
                        return data.get("auth_code").toString();
                    }
                    if (!this.api.equals("/passport/user/orgs?access_token=%s")) return msg;
                    List data = (List)map.get("data");
                    Iterator iterator = data.iterator();
                    while (iterator.hasNext()) {
                        Object obj = iterator.next();
                        Map detail = (Map)obj;
                        msg = detail.get("tid").toString();
                    }
                    return msg;
                }
                MessageFormat.format(ResManager.loadKDString((String)"\u8c03\u7528\u91d1\u8776\u4e91\u5e73\u53f0\u63a5\u53e3\uff1a{0}\u91d1\u8776\u4e91\u5e73\u53f0\u8fd4\u56de\u6d88\u606f\uff1a{1}", (String)"CloudKingdeeApiService_0", (String)"scm-common", (Object[])new Object[0]), this.getUrl(), map.get("description").toString());
                log.error(String.format(CloudKingdeeErrorCode.INVOKE_FAILED.getMessage(), errorMsg));
                throw new KDException(CloudKingdeeErrorCode.INVOKE_FAILED, new Object[]{errorMsg});
            }
            String url = this.getUrl();
            MessageFormat.format(ResManager.loadKDString((String)"\u8c03\u7528\u91d1\u8776\u4e91\u5e73\u53f0\u63a5\u53e3\uff1a{0}", (String)"CloudKingdeeApiService_1", (String)"scm-common", (Object[])new Object[0]), url);
            log.error(String.format(CloudKingdeeErrorCode.RETURNDATA_FORMAT_ERROR.getMessage(), errorMsg));
            throw new KDException(CloudKingdeeErrorCode.RETURNDATA_FORMAT_ERROR, new Object[]{url});
        }
        String url = this.getUrl();
        MessageFormat.format(ResManager.loadKDString((String)"\u8c03\u7528\u91d1\u8776\u4e91\u5e73\u53f0\u63a5\u53e3\uff1a{0}", (String)"CloudKingdeeApiService_1", (String)"scm-common", (Object[])new Object[0]), url);
        log.error(errorMsg);
        throw new KDException(CloudKingdeeErrorCode.CONT_CONNECT_SERVER, new Object[]{url});
    }

    private String getToken() {
        String tokenKey = CloudKingdeeConfigration.getHOST() + "_token";
        String token = (String)this.cache.get(tokenKey, String.class);
        if (token == null || token.isEmpty() || this.isTokenExpired()) {
            HashMap<String, Object> map = new HashMap<String, Object>(20);
            map.put("client_id", CloudKingdeeConfigration.getClient_id());
            map.put("client_secret", CloudKingdeeConfigration.getClient_secret());
            map.put("username", CloudKingdeeConfigration.getUSER());
            map.put("password", CloudKingdeeConfigration.getPdMa());
            token = CloudKingdeeApiUtil.getToken(map);
        }
        return token;
    }

    private boolean isTokenExpired() {
        Date currDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(GET_TOKEN_TIME);
        calendar.add(10, 0);
        calendar.add(12, 1);
        return currDate.after(calendar.getTime());
    }
}

