/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.datahandle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.impt.SheetHandler;
import kd.scm.common.util.RegExpUtil;

public class DataImportSheetHandler
extends SheetHandler {
    private Map<Integer, Map<Integer, String>> rows = new HashMap<Integer, Map<Integer, String>>(8);
    private Map<Integer, String> columnKeyMap = new HashMap<Integer, String>(8);
    private Map<Integer, String> columnKeyIndexMap = new HashMap<Integer, String>(8);
    private List<String> importColumnKeyList = new ArrayList<String>();
    private String uniqueColumnName;
    private List<String> uniqueColumnList;
    private boolean isTemplate = true;
    private int startImportRowIndex = 1;

    public Map<Integer, Map<Integer, String>> getRows() {
        return this.rows;
    }

    public void setRows(Map<Integer, Map<Integer, String>> rows) {
        this.rows = rows;
    }

    public int getStartImportRowIndex() {
        return this.startImportRowIndex;
    }

    public void setStartImportRowIndex(int startImportRowIndex) {
        this.startImportRowIndex = startImportRowIndex;
    }

    public void handleRow(SheetHandler.ParsedRow row) {
        this.rows.put(row.getRowNum(), row.getData());
    }

    public Map<Integer, String> setColumnKeyMap() {
        if (this.columnKeyMap.size() > 0) {
            return this.columnKeyMap;
        }
        String reg = "(?<=(?<!\\\\)\\$\\{)(.*?)(?=(?<!\\\\)\\})";
        Map<Integer, String> columnMap = this.rows.get(0);
        for (Map.Entry<Integer, String> column : columnMap.entrySet()) {
            String columnKey = RegExpUtil.findString(reg, column.getValue(), 1);
            if (this.isTemplate && null == columnKey) {
                this.isTemplate = false;
            }
            this.columnKeyMap.put(column.getKey(), columnKey);
        }
        return this.columnKeyMap;
    }

    public String getColumnName(int index) {
        if (this.columnKeyMap.size() == 0) {
            this.setColumnKeyMap();
        }
        return this.columnKeyMap.get(index);
    }

    @Deprecated
    public String getUniqueColumnName() {
        return this.uniqueColumnName;
    }

    @Deprecated
    public void setUniqueColumnName(String uniqueColumnName) {
        this.uniqueColumnName = uniqueColumnName;
        if (null == this.uniqueColumnList) {
            this.uniqueColumnList = new ArrayList<String>();
        }
        this.uniqueColumnList.add(uniqueColumnName);
    }

    public List<String> getUniqueColumnList() {
        return this.uniqueColumnList;
    }

    public void setUniqueColumnList(List<String> uniqueColumnList) {
        this.uniqueColumnList = uniqueColumnList;
    }

    public String getColumnVal(Integer index) {
        if (this.columnKeyIndexMap.size() == 0) {
            this.setIndexColumnVal();
        }
        return this.columnKeyIndexMap.get(index);
    }

    public void setIndexColumnVal() {
        if (null == this.uniqueColumnList) {
            return;
        }
        int columSize = this.rows.get(0).size();
        int startImportRowIndex = this.getStartImportRowIndex();
        for (Map.Entry<Integer, Map<Integer, String>> row : this.rows.entrySet()) {
            int rowIndex = row.getKey();
            if (rowIndex < startImportRowIndex) continue;
            this.columnKeyIndexMap.put(rowIndex, this.getUniqueColumnValStr(row.getValue(), columSize));
        }
    }

    public String getUniqueColumnValStr(Map<Integer, String> row, int columSize) {
        StringBuilder uniqueColumnValSb = new StringBuilder();
        HashMap<String, String> columnValMap = new HashMap<String, String>(4);
        for (int j = 0; j < columSize; ++j) {
            String columnKey = this.getColumnName(j);
            if (!this.uniqueColumnList.contains(columnKey)) continue;
            String rowVal = row.get(j);
            if (null != rowVal) {
                rowVal = rowVal.replaceFirst("'", "");
            }
            columnValMap.put(columnKey, rowVal);
        }
        for (String column : this.uniqueColumnList) {
            if (uniqueColumnValSb.length() > 0) {
                uniqueColumnValSb.append('_');
                uniqueColumnValSb.append((String)columnValMap.get(column));
                continue;
            }
            uniqueColumnValSb.append((String)columnValMap.get(column));
        }
        return uniqueColumnValSb.toString();
    }

    public Map<Integer, String> getColumnKeyMap() {
        return this.columnKeyMap;
    }

    public boolean isTemplate() {
        String reg = "(?<=(?<!\\\\)\\$\\{)(.*?)(?=(?<!\\\\)\\})";
        Map<Integer, String> columnMap = this.rows.get(this.startImportRowIndex - 1);
        if (null == columnMap) {
            return false;
        }
        for (Map.Entry<Integer, String> column : columnMap.entrySet()) {
            String columnKey = RegExpUtil.findString(reg, column.getValue(), 1);
            if (this.isTemplate && null == columnKey) {
                this.isTemplate = false;
                break;
            }
            this.importColumnKeyList.add(columnKey);
        }
        return this.isTemplate;
    }

    public void setTemplate(boolean isTemplate) {
        this.isTemplate = isTemplate;
    }

    public List<String> getImportColumnKeyList() {
        return this.importColumnKeyList;
    }

    public void setImportColumnKeyList(List<String> importColumnKeyList) {
        this.importColumnKeyList = importColumnKeyList;
    }
}

