/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.ecapi.config;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.scm.common.ecapi.EcApiContext;
import kd.scm.common.ecapi.EcApiUrlMapping;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.errorcode.EcApiCheckErrorCode;
import kd.scm.common.ecapi.exception.EcApiException;
import kd.scm.common.ecapi.jd.JDAccessTokenUtil;
import kd.scm.common.ecapi.util.EcDateUtil;

public final class EcConfigration {
    private EcApiContext context = new EcApiContext();

    public EcConfigration(String platformType, Map<String, String> param, String apiName, String orgId) {
        this.initConfig(platformType, param, apiName, orgId);
    }

    public EcApiContext getContext() {
        return this.context;
    }

    public void setContext(EcApiContext context) {
        this.context = context;
    }

    public void initConfig(String platformType, Map<String, String> param, String apiName, String orgId) {
        try {
            if (StringUtils.isBlank((CharSequence)platformType)) {
                throw new EcApiException(EcApiCheckErrorCode.PARAM_MISSING_ERROR, new Object[0]);
            }
            HashMap<String, String> sysParams = new HashMap<String, String>();
            this.context.setUrl(EcApiUrlMapping.getEcApiUrl(platformType));
            this.context.setApi(apiName);
            if (StringUtils.equals((CharSequence)platformType, (CharSequence)EcPlatformEnum.ECPLATFORM_JD.getVal())) {
                if (!param.containsKey("token")) {
                    sysParams.put("token", StringUtils.isNotBlank((CharSequence)orgId) ? JDAccessTokenUtil.getJDAccessTokenWithCompany(orgId) : JDAccessTokenUtil.getAccessToken());
                }
                this.context.setPlatformType(EcPlatformEnum.ECPLATFORM_JD.getVal());
            } else if (StringUtils.equals((CharSequence)platformType, (CharSequence)EcPlatformEnum.ECPLATFORM_SUNING.getVal())) {
                sysParams.put("appMethod", apiName);
                sysParams.put("appRequestTime", EcDateUtil.getFormatCurrentTime());
                sysParams.put("versionNo", "v1.2");
                sysParams.put("format", "json");
                sysParams.put("appKey", "123123");
                sysParams.put("signInfo", "");
                sysParams.put("token", "");
                this.context.setPlatformType(EcPlatformEnum.ECPLATFORM_SUNING.getVal());
            } else if (StringUtils.equals((CharSequence)platformType, (CharSequence)EcPlatformEnum.ECPLATFORM_DL.getVal())) {
                sysParams.put("token", "");
                this.context.setPlatformType(EcPlatformEnum.ECPLATFORM_DL.getVal());
            }
            this.context.setSysParam(sysParams);
            this.context.setApiParam(param);
        }
        catch (KDException kDException) {
            // empty catch block
        }
    }
}

