/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.ecapi.jd;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.constant.JdConstant;
import kd.scm.common.ecapi.entity.GoodsInfo;
import kd.scm.common.ecapi.entity.PriceInfo;
import kd.scm.common.ecapi.entity.SaleAttrInfo;
import kd.scm.common.ecapi.entity.SkuGoodsInfo;
import kd.scm.common.ecapi.jd.JdApiUtil;
import kd.scm.common.ecapi.jd.entity.JdPictureInfo;
import kd.scm.common.ecapi.jd.entity.JdStockInfo;
import kd.scm.common.enums.PlatformEnums;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.common.enums.StockEnum;
import kd.scm.common.util.MalOrderUtil;
import net.sf.json.JSONObject;

public class JdProdUtil {
    private static Map<String, String> cacheMap = new HashMap<String, String>();
    private static double PI = Math.PI;

    public static GoodsInfo getJdProductInfo(JSONObject sku) {
        GoodsInfo jdProInfo = new GoodsInfo();
        jdProInfo.setProductId(sku.getString("wareId"));
        jdProInfo.setProductImgPath("http://img13.360buyimg.com/n1/" + sku.getString("imageUrl"));
        jdProInfo.setProductName(sku.getString("wareName"));
        jdProInfo.setProductModel("");
        jdProInfo.setSupplier(JdConstant.SUPPLIERNAME);
        jdProInfo.setProductSource(ProductSourceEnum.PRODUCTSOURCE_JD.getName());
        jdProInfo.setCentralpurtype("1");
        jdProInfo.setCategoryNumber(sku.getString("catId"));
        String catName = sku.getString("catName");
        if ("null".equals(catName)) {
            catName = JdProdUtil.getCatNameFromJDapi(sku.getString("catId"));
        }
        jdProInfo.setCategoryName(catName);
        return jdProInfo;
    }

    public static String getCatNameFromJDapi(String catId) {
        String catName = cacheMap.get(catId);
        if (catName != null) {
            return catName;
        }
        String res = JdApiUtil.getJdCatogry(catId);
        JSONObject joRes = JSONObject.fromObject((Object)res);
        catName = joRes.getString("name");
        cacheMap.put(catId, catName);
        return catName;
    }

    public static GoodsInfo getJdProductInfo4Detail(JSONObject sku) {
        GoodsInfo jdProInfo = new GoodsInfo();
        jdProInfo.setProductId(sku.getString("sku"));
        jdProInfo.setProductImgPath("http://img13.360buyimg.com/n1/" + sku.getString("imagePath"));
        jdProInfo.setProductName(sku.getString("name"));
        jdProInfo.setProductModel("");
        jdProInfo.setSupplier(JdConstant.SUPPLIERNAME);
        String catId = sku.getString("category").split(";")[2];
        jdProInfo.setProductSource(ProductSourceEnum.PRODUCTSOURCE_JD.getName());
        String catName = JdProdUtil.getCatNameFromJDapi(catId);
        jdProInfo.setCategoryName(catName);
        jdProInfo.setCategoryNumber(catId);
        jdProInfo.setCentralpurtype("1");
        if (sku.containsKey((Object)"isJDLogistics")) {
            jdProInfo.setIsJDLogistics(sku.getString("isJDLogistics"));
        }
        return jdProInfo;
    }

    public static void setJdProductInfoPrice(List<GoodsInfo> jdProductList, Map<String, PriceInfo> priceMap) {
        for (int i = 0; i < jdProductList.size(); ++i) {
            String sku = jdProductList.get(i).getProductId();
            PriceInfo priceInfo = priceMap.get(sku);
            if (priceInfo != null) {
                jdProductList.get(i).setShopPrice(priceInfo.getShowprice());
                continue;
            }
            jdProductList.get(i).setShopPrice(BigDecimal.ZERO.setScale(2));
        }
    }

    public static GoodsInfo getJdProdInfo4Detail(String detail) {
        JSONObject sku = JSONObject.fromObject((Object)detail);
        GoodsInfo jdProInfo = new GoodsInfo();
        String skuId = sku.getString("sku");
        PriceInfo price = JdApiUtil.getJdPriceBySku(skuId);
        String area = "19_1607_3155";
        JdStockInfo stockInfo = JdApiUtil.getJdStockBySku(skuId, area);
        jdProInfo.setProductId(skuId);
        jdProInfo.setProductImgPath("http://img13.360buyimg.com/n1/" + sku.getString("imagePath"));
        jdProInfo.setProductName(sku.getString("name"));
        jdProInfo.setProductSource(ProductSourceEnum.PRODUCTSOURCE_JD.getVal());
        if (stockInfo.getDesc() != null) {
            jdProInfo.setProductDesc(stockInfo.getDesc());
        } else {
            jdProInfo.setProductDesc(StockEnum.SOLDOUT.getName());
        }
        jdProInfo.setProductModel("");
        jdProInfo.setRemark(sku.getString("sku"));
        jdProInfo.setSupplier("486095512240421888");
        String jdUnit = MalOrderUtil.getJDUnit();
        if (null != jdUnit) {
            jdProInfo.setProductUnitID(jdUnit);
        } else {
            jdProInfo.setProductUnitID("11");
        }
        jdProInfo.setProductCurrID("1");
        if (price != null) {
            jdProInfo.setPrice(price.getPrice());
            jdProInfo.setTaxPrice(price.getTaxPrice());
            jdProInfo.setShopPrice(price.getShowprice());
            jdProInfo.setTaxRate(price.getTaxRate());
        } else {
            jdProInfo.setPrice(BigDecimal.ZERO.setScale(2));
            jdProInfo.setTaxPrice(BigDecimal.ZERO.setScale(2));
            jdProInfo.setShopPrice(BigDecimal.ZERO.setScale(2));
        }
        jdProInfo.setStockQty(new BigDecimal("1000.00"));
        jdProInfo.setStockState("1");
        jdProInfo.setProductDetail(sku.getString("introduction"));
        jdProInfo.setSpecification(sku.getString("param"));
        jdProInfo.setPackinglist(sku.getString("wareQD"));
        String shouhou = "<div>\u5177\u4f53\u552e\u540e\u4fe1\u606f\u89c1\u4eac\u4e1c\u5546\u54c1\u9875\u9762</div><div><a  href=\"https://item.jd.com/" + jdProInfo.getProductId() + ".html\" target=\"_blank\" >" + jdProInfo.getProductName() + "</a></div>";
        jdProInfo.setGuarantee(shouhou);
        List<JdPictureInfo> pics = JdApiUtil.getJdPictureListBySku(jdProInfo.getProductId());
        int index = 0;
        for (int i = 0; i < pics.size(); ++i) {
            JdPictureInfo pic = pics.get(i);
            if (index >= 4) continue;
            if (pic.isPrimary() == 1) {
                jdProInfo.setProductImgPath("http://img13.360buyimg.com/n1/" + pic.getPath());
                continue;
            }
            if (index == 0) {
                jdProInfo.setPicture1("http://img13.360buyimg.com/n1/" + pic.getPath());
                ++index;
                continue;
            }
            if (index == 1) {
                jdProInfo.setPicture2("http://img13.360buyimg.com/n1/" + pic.getPath());
                ++index;
                continue;
            }
            if (index == 2) {
                jdProInfo.setPicture3("http://img13.360buyimg.com/n1/" + pic.getPath());
                ++index;
                continue;
            }
            if (index != 3) continue;
            jdProInfo.setPicture4("http://img13.360buyimg.com/n1/" + pic.getPath());
            ++index;
        }
        String cid = sku.getString("category").split(";")[2];
        jdProInfo.setCategoryName(JdProdUtil.getCatNameFromJDapi(cid));
        jdProInfo.setCategoryNumber(cid);
        jdProInfo.setCentralpurtype("1");
        jdProInfo.setIsJDLogistics(sku.getString("isJDLogistics"));
        return jdProInfo;
    }

    public static String convertList2JdJson(List<String> skus) {
        StringBuilder skuNums = new StringBuilder();
        skuNums.append('[');
        for (int i = 0; i < skus.size(); ++i) {
            skuNums.append('{');
            skuNums.append("\"skuId\":").append(skus.get(i)).append(",\"num\":1");
            skuNums.append("},");
        }
        String tempSku = skuNums.substring(0, skuNums.lastIndexOf(","));
        tempSku = tempSku + "]";
        return tempSku;
    }

    public static String convertMap2JdJson(Map<String, Integer> skuNumMap) {
        StringBuilder skuStr = new StringBuilder();
        skuStr.append('[');
        skuNumMap.keySet().forEach(sku -> {
            skuStr.append('{');
            skuStr.append("\"skuId\":").append((String)sku).append(",\"num\":").append(skuNumMap.get(sku));
            skuStr.append("},");
        });
        String tempSku = skuStr.substring(0, skuStr.lastIndexOf(","));
        tempSku = tempSku + "]";
        return tempSku;
    }

    public static String[] adjustLngAndLat(double lng, double lat) {
        String[] result = new String[2];
        double x = lng - 0.0065;
        double y = lat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * PI);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * PI);
        double gg_lon = z * Math.cos(theta);
        double gg_lat = z * Math.sin(theta);
        result[0] = Double.toString(gg_lon);
        result[1] = Double.toString(gg_lat);
        return result;
    }

    public static boolean isJdConfigExist() {
        QFilter platformFilter = new QFilter("platform", "=", (Object)PlatformEnums.JD.getValue());
        QFilter ClientIDFilter = new QFilter("client_id", "!=", (Object)" ");
        QFilter secretFilter = new QFilter("client_secret", "!=", (Object)" ");
        return QueryServiceHelper.exists((String)"pmm_ecadmit", (QFilter[])new QFilter[]{platformFilter, ClientIDFilter, secretFilter});
    }

    public static void clearCacheMap() {
        cacheMap.clear();
    }

    public static List<SkuGoodsInfo> getJdInfoSimilarSku(String skuStr) {
        JSONArray skustr = JSONArray.parseArray((String)skuStr);
        ArrayList<SkuGoodsInfo> skustrList = new ArrayList<SkuGoodsInfo>(skustr.size());
        for (int i = 0; i < skustr.size(); ++i) {
            com.alibaba.fastjson.JSONObject skujson = JSON.parseObject((String)skustr.get(i).toString());
            JSONArray skuLists = skujson.getJSONArray("saleAttrList");
            SkuGoodsInfo skuGoodsInfo = new SkuGoodsInfo();
            skuGoodsInfo.setDim(skujson.getInteger("dim"));
            skuGoodsInfo.setSaleName(skujson.getString("saleName"));
            ArrayList<SaleAttrInfo> saleAttrList = new ArrayList<SaleAttrInfo>(skuLists.size());
            for (int j = 0; j < skuLists.size(); ++j) {
                SaleAttrInfo saleAttrInfo = new SaleAttrInfo();
                com.alibaba.fastjson.JSONObject jsonObject = JSON.parseObject((String)skuLists.getString(j));
                saleAttrInfo.setSaleValue(jsonObject.getString("saleValue"));
                JSONArray skuIdsArray = jsonObject.getJSONArray("skuIds");
                HashSet<Object> setSkuIds = new HashSet<Object>((int)((double)skuIdsArray.size() / 0.75));
                for (int k = 0; k < skuIdsArray.size(); ++k) {
                    setSkuIds.add(skuIdsArray.getLong(k));
                }
                saleAttrInfo.setSkuIds(setSkuIds);
                saleAttrList.add(saleAttrInfo);
                skuGoodsInfo.setSaleAttrList(saleAttrList);
            }
            skustrList.add(skuGoodsInfo);
        }
        return skustrList;
    }
}

