/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.ecapi.util;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;

public class AddressUtil {
    private static final String ADDRESS_ENTITY = "pbd_emaladdress";
    private static final String MALADDRESSREL_ENTITY = "pbd_maladdressrel";
    private static final String BD_ADMINDIVISION = "bd_admindivision";
    private static final String EMALTYPE = "emaltype";
    private static final String ADDRESS = "addressid";
    private static final String MATCH_STATUS = "matchstatus";

    private static DynamicObject getEmalAddressRelDObj(Long addressId, String emalType) {
        QFilter filter = new QFilter(EMALTYPE, "=", (Object)(StringUtils.equals((CharSequence)emalType, (CharSequence)EcPlatformEnum.ECPLATFORM_JDPRO.getVal()) ? EcPlatformEnum.ECPLATFORM_JD.getVal() : emalType));
        filter.and(new QFilter(MATCH_STATUS, "=", (Object)Character.valueOf('2')));
        DynamicObject dyo = QueryServiceHelper.queryOne((String)MALADDRESSREL_ENTITY, (String)"longnumber, emaladdress", (QFilter[])new QFilter[]{filter, new QFilter(ADDRESS, "=", (Object)addressId)});
        if (dyo == null && AddressUtil.isNeedFindParent(emalType)) {
            DynamicObject parentDyo = QueryServiceHelper.queryOne((String)BD_ADMINDIVISION, (String)"parent", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)addressId)});
            if (parentDyo == null) {
                return null;
            }
            return QueryServiceHelper.queryOne((String)MALADDRESSREL_ENTITY, (String)"longnumber, emaladdress", (QFilter[])new QFilter[]{filter, new QFilter(ADDRESS, "=", (Object)parentDyo.getLong("parent"))});
        }
        return dyo;
    }

    private static boolean isNeedFindParent(String emalType) {
        return EcPlatformEnum.ECPLATFORM_XFS.getVal().equals(emalType) || EcPlatformEnum.ECPLATFORM_XY.getVal().equals(emalType) || EcPlatformEnum.ECPLATFORM_CG.getVal().equals(emalType) || EcPlatformEnum.ECPLATFORM_SUNING.getVal().equals(emalType) || EcPlatformEnum.ECPLATFORM_DL.getVal().equals(emalType);
    }

    private static DynamicObject getEmalAddressDObj(Long addressId, String emalType) {
        DynamicObject emalAddressRelDObj = AddressUtil.getEmalAddressRelDObj(addressId, emalType);
        if (emalAddressRelDObj == null) {
            return null;
        }
        QFilter filter = new QFilter("id", "=", (Object)emalAddressRelDObj.getString("emaladdress"));
        return QueryServiceHelper.queryOne((String)ADDRESS_ENTITY, (String)"name,fullname,longnumber", (QFilter[])new QFilter[]{filter});
    }

    public static String getLongNumber(Long addressId, String emalType) {
        DynamicObject obj = AddressUtil.getEmalAddressRelDObj(addressId, emalType);
        if (obj != null) {
            return obj.getString("longnumber");
        }
        return "";
    }

    public static String[] getNumberArr(Long addressId, String emalType) {
        String longNumber = AddressUtil.getLongNumber(addressId, emalType);
        if (longNumber.isEmpty()) {
            return null;
        }
        return longNumber.split("\\.");
    }

    public static String getNumber(Long addressId, String emalType) {
        String longNumber = AddressUtil.getLongNumber(addressId, emalType);
        if (longNumber.isEmpty()) {
            return null;
        }
        String[] arr = AddressUtil.getNumberArr(addressId, emalType);
        if (arr == null || arr.length == 0) {
            return "";
        }
        return arr[arr.length - 1];
    }

    public static String getFullName(Long addressId, String emalType) {
        DynamicObject obj = AddressUtil.getEmalAddressDObj(addressId, emalType);
        if (obj != null) {
            return obj.getString("fullname");
        }
        return "";
    }

    public static String getName(Long addressId, String emalType) {
        DynamicObject obj = AddressUtil.getEmalAddressDObj(addressId, emalType);
        if (obj != null) {
            return obj.getString("name");
        }
        return "";
    }
}

