/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.scm.common.eip.IEipApiService;
import kd.scm.common.eip.errorcode.EipErrorCode;
import kd.scm.common.eip.impl.BotpService;
import kd.scm.common.eip.impl.CurrencyService;
import kd.scm.common.eip.impl.DataCompareService;
import kd.scm.common.eip.impl.DeliverAddressService;
import kd.scm.common.eip.impl.DeliverTypeService;
import kd.scm.common.eip.impl.ExpenseTypeService;
import kd.scm.common.eip.impl.LocationService;
import kd.scm.common.eip.impl.LoginService;
import kd.scm.common.eip.impl.MaterialGroupService;
import kd.scm.common.eip.impl.MaterialService;
import kd.scm.common.eip.impl.MaterialStandardService;
import kd.scm.common.eip.impl.MeasureUnitGroupService;
import kd.scm.common.eip.impl.MeasureUnitService;
import kd.scm.common.eip.impl.OperationTypeService;
import kd.scm.common.eip.impl.OrgService;
import kd.scm.common.eip.impl.PayCondService;
import kd.scm.common.eip.impl.ProjectService;
import kd.scm.common.eip.impl.RowTypeService;
import kd.scm.common.eip.impl.SettlementTypeService;
import kd.scm.common.eip.impl.SupplierGroupService;
import kd.scm.common.eip.impl.SupplierService;
import kd.scm.common.eip.impl.SupplierStandardService;
import kd.scm.common.eip.impl.TrackService;
import kd.scm.common.eip.impl.UserService;
import kd.scm.common.eip.impl.WarehouseService;

public class EipMappingService {
    private static final Map<String, Object> apiMap = new HashMap<String, Object>(64);

    public static void registerService(String apiName, String pluginService) {
        if (apiName == null) {
            throw new KDBizException(ResManager.loadKDString((String)"apiName\u63a5\u53e3\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EipMappingService_0", (String)"scm-common", (Object[])new Object[0]));
        }
        if (pluginService == null) {
            throw new KDBizException(ResManager.loadKDString((String)"pluginService\u63a5\u53e3\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EipMappingService_1", (String)"scm-common", (Object[])new Object[0]));
        }
        apiMap.put(apiName, pluginService);
    }

    public static IEipApiService getServiceClass(String apiName) {
        Object service = apiMap.get(apiName);
        IEipApiService apiService = null;
        if (service == null) {
            throw new KDException(EipErrorCode.NOT_FIND_CLASS, new Object[]{apiName});
        }
        if (service instanceof String) {
            try {
                apiService = (IEipApiService)Class.forName(service.toString()).newInstance();
            }
            catch (InstantiationException e) {
                throw new KDBizException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new KDBizException(e.getMessage());
            }
            catch (ClassNotFoundException e) {
                throw new KDBizException(e.getMessage());
            }
        } else if (service instanceof IEipApiService) {
            apiService = (IEipApiService)service;
        } else {
            throw new KDException(EipErrorCode.NOT_IMPLCORRECT_INTERFACE, new Object[]{"IEipApiService"});
        }
        return apiService;
    }

    public static void clearApiMap() {
        apiMap.clear();
    }

    static {
        apiMap.put("login", new LoginService());
        apiMap.put("NEXT_FullOrgUnit_Query", new OrgService());
        apiMap.put("NEXT_User_Query", new UserService());
        apiMap.put("NEXT_Currency_Query", new CurrencyService());
        apiMap.put("NEXT_MeasureUnitGroup_Query", new MeasureUnitGroupService());
        apiMap.put("NEXT_MeasureUnit_Query", new MeasureUnitService());
        apiMap.put("NEXT_SettlementType_Query", new SettlementTypeService());
        apiMap.put("NEXT_PayCondition_Query", new PayCondService());
        apiMap.put("NEXT_PurchaseGroup_Query", "kd.scm.common.eip.impl.PurchasePersonGroupService");
        apiMap.put("NEXT_PurchasePerson_Query", "kd.scm.common.eip.impl.PurchasePersonService");
        apiMap.put("NEXT_Warehouse_Query", new WarehouseService());
        apiMap.put("NEXT_CSSPGroup_Query", new SupplierGroupService());
        apiMap.put("NEXT_Supplier_Query", new SupplierService());
        apiMap.put("NEXT_MaterialGroup_Query", new MaterialGroupService());
        apiMap.put("NEXT_Material_Query", new MaterialService());
        apiMap.put("NEXT_DeliveryType_Query", new DeliverTypeService());
        apiMap.put("", new DeliverAddressService());
        apiMap.put("NEXT_Location_Query", new LocationService());
        apiMap.put("NEXT_Project_Query", new ProjectService());
        apiMap.put("NEXT_TrackNum_Query", new TrackService());
        apiMap.put("Next_ExpenseType_Query", new ExpenseTypeService());
        apiMap.put("Next_OperationType_Query", new OperationTypeService());
        apiMap.put("NEXT_MaterialStandard_Query", new MaterialStandardService());
        apiMap.put("NEXT_SupplierStanard_Query", new SupplierStandardService());
        apiMap.put("NEXT_PurOrder_Query", "kd.scm.common.eip.impl.PurOrderService");
        apiMap.put("NEXT_PurInWarehsBill_Query", "kd.scm.common.eip.impl.PurInstockService");
        apiMap.put("NEXT_PurReceivalBill_Query", "kd.scm.common.eip.impl.PurReceiptService");
        apiMap.put("NEXT_PurReturns_Query", "kd.scm.common.eip.impl.PurRequestService");
        apiMap.put("NEXT_IerpPurReturns_Query", "kd.scm.common.eip.impl.PurReturnService");
        apiMap.put("NEXT_PaymentBill_Query", "kd.scm.common.eip.impl.PurPayService");
        apiMap.put("NEXT_PurOrder_Confirm_Rec", "kd.scm.common.eip.impl.PurOrderConfirmService");
        apiMap.put("NEXT_PurOrder_UnConfirm_Rec", "kd.scm.common.eip.impl.PurOrderUnConfirmService");
        apiMap.put("NEXT_PurOrder_Reject_Rec", "kd.scm.common.eip.impl.PurOrderRejectService");
        apiMap.put("NEXT_PurInvoice_Confirm_Rec", "kd.scm.common.eip.impl.PurInvoiceConfirmService");
        apiMap.put("NEXT_PurSalout_Audit_Rec", "kd.scm.common.eip.impl.PurSaloutAuditService");
        apiMap.put("NEXT_PurSalout_UnAudit_Rec", "kd.scm.common.eip.impl.PurSaloutUnauditService");
        apiMap.put("NEXT_PurSalout_toInWare_Rec", "kd.scm.common.eip.impl.PurSaloutToInwareService");
        apiMap.put("NEXT_PurSalout_toRec_Rec", "kd.scm.common.eip.impl.PurSaloutToRecService");
        apiMap.put("NEXT_PurOrderAlert_Confirm_Rec", "kd.scm.common.eip.impl.PurOrderChangeConfirmService");
        apiMap.put("NEXT_PurOrderAlert_Reject_Rec", "kd.scm.common.eip.impl.PurOrderChangeRejectService");
        apiMap.put("NEXT_SouCompare_ToOrder_Rec", "kd.scm.common.eip.impl.SouCompareToOrderService");
        apiMap.put("NEXT_SouCompare_ToContract_Rec", "kd.scm.common.eip.impl.SouCompareToContractService");
        apiMap.put("NEXT_SouCompare_UpdateAppr_Rec", "kd.scm.common.eip.impl.SouCompareToUpdateApprService");
        apiMap.put("NEXT_SouCompare_UpdateSupp_Rec", "kd.scm.common.eip.impl.SouCompareToUpdateSuppService");
        apiMap.put("NEXT_BOTP_Query_Rec", new BotpService());
        apiMap.put("NEXT_InvoiceOperate_Rec", "kd.scm.common.eip.impl.InvoiceOperateService");
        apiMap.put("NEXT_PurInvoice_Creat_AP_Rec", "kd.scm.common.eip.impl.InvoiceToApInvoiceService");
        apiMap.put("NEXT_RowType_Query", new RowTypeService());
        apiMap.put("NEXT_SouBidToPurOrder_Rec", "kd.scm.common.eip.impl.SouBidToOrderService");
        apiMap.put("NEXT_IerpToPurOrder_Add_Rec", "kd.scm.common.eip.impl.PurOrderToOrderService");
        apiMap.put("NEXT_SrmToSupplier_Add_Rec", "kd.scm.common.eip.impl.SrmSupplierToEASSupplier");
        apiMap.put("NEXT_Supplier_Operate_Rec", "kd.scm.common.eip.impl.SrmSupplierOperateEASSupplier");
        apiMap.put("NEXT_IERPPURREQUEST_Add_Rec", "kd.scm.common.eip.impl.MalOrderToPurRequestService");
        apiMap.put("NEXT_DataCompare_Query_Rec", new DataCompareService());
        apiMap.put("NEXT_SouDeleteBillno_Rec", "kd.scm.common.eip.impl.SouBillDeletePurReqService");
    }
}

