/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip.helper;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.eip.IHerlperService;
import kd.scm.common.eip.config.EipConfigration;
import kd.scm.common.eip.util.EipUtils;
import kd.scm.common.enums.BillEntryStatusEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.BizTypeEnum;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.AttachmentUtil;
import kd.scm.common.util.DataTransterLogUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.common.util.LowTimer;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public abstract class BillCoreHelper
implements IHerlperService {
    private static Log log = LogFactory.getLog(BillCoreHelper.class);
    protected static final String ENTRY_KEY = "materialentry";
    private static final String AUDIT_DATE = "auditdate";
    private static final String MODIFY_TIME = "modifytime";
    private static final String SEQ = "seq";
    private Map<String, Object> returnVal = new HashMap<String, Object>();
    private long defaultTypeId = 0L;
    protected static ThreadLocal<DynamicObject> logInfo = new ThreadLocal();

    protected abstract String getEntityKey();

    protected String getEntryKey() {
        return ENTRY_KEY;
    }

    protected String getBillNumber() {
        return "billno";
    }

    public Map<String, Object> getReturnVal() {
        return this.returnVal;
    }

    public void setReturnVal(Map<String, Object> returnVal) {
        this.returnVal = returnVal;
    }

    @Override
    public String addEntity(Map<String, Object> dataMap) {
        StringBuilder timerBuilder;
        block48: {
            timerBuilder = new StringBuilder();
            LowTimer timer = new LowTimer();
            log.info("### billCoreHelper start addEntity--------------------------------------");
            this.returnVal.put("code", "200");
            try {
                boolean isProcess;
                ArrayList<DynamicObject> newAndChangedObjs;
                HashMap<String, Map<String, Object>> entryDataMap;
                HashMap<String, Map<String, Object>> headDataMap;
                block49: {
                    Object dyObjs;
                    Object data = dataMap.get("data");
                    if (data == null || StringUtils.isEmpty((String)data.toString())) {
                        return null;
                    }
                    this.logInputData(String.valueOf(data));
                    JSONArray list = JSONArray.fromObject((Object)data);
                    headDataMap = new HashMap<String, Map<String, Object>>(list.size());
                    entryDataMap = new HashMap<String, Map<String, Object>>();
                    newAndChangedObjs = new ArrayList<DynamicObject>();
                    List<DynamicObject> needNew = new ArrayList<DynamicObject>();
                    ArrayList<DynamicObject> changedObjs = new ArrayList<DynamicObject>();
                    ArrayList<Object> needUpdateNumber = new ArrayList<Object>();
                    JSONObject entity = null;
                    HashMap<String, Map<String, Object>> param = new HashMap(2);
                    for (int i = 0; i < list.size(); ++i) {
                        entity = JSONObject.fromObject(list.get(i));
                        String number = entity.get(this.getBillNumber()).toString().toLowerCase();
                        headDataMap.put(number, (Map<String, Object>)entity);
                        if (this.isExist((Map<String, Object>)entity)) {
                            needUpdateNumber.add(number);
                            needUpdateNumber.add(entity.get(this.getBillNumber()).toString());
                            if (null == this.getEntryKey()) continue;
                            JSONArray entryList = JSONArray.fromObject(entity.get("entryentity"));
                            for (Object e : entryList) {
                                JSONObject entry = JSONObject.fromObject(e);
                                entryDataMap.put(number + "_" + entry.get(SEQ), (Map<String, Object>)entry);
                            }
                            continue;
                        }
                        DynamicObject obj = EipUtils.map2DynamicObject((Map<String, Object>)entity, this.getEntityKey());
                        obj = this.setHeadProperties(obj);
                        if (null == this.getEntryKey()) {
                            needNew.add(obj);
                            continue;
                        }
                        DynamicObjectCollection entryCol = obj.getDynamicObjectCollection(this.getEntryKey());
                        JSONArray throwable = JSONArray.fromObject(entity.get("entryentity"));
                        for (Object object : throwable) {
                            JSONObject entryMap = JSONObject.fromObject(object);
                            entryDataMap.put(number + "_" + entryMap.get(SEQ), (Map<String, Object>)entryMap);
                            DynamicObject entry = EipUtils.map2DynamicObject((Map<String, Object>)entryMap, this.getEntityKey() + "." + this.getEntryKey());
                            entry = this.setEntryProperties(entry);
                            entryCol.add((Object)entry);
                        }
                        obj.set(this.getEntryKey(), (Object)entryCol);
                        needNew.add(obj);
                    }
                    if (!needUpdateNumber.isEmpty()) {
                        param = this.getParamForUpdate(needUpdateNumber);
                        String firstNumber = needUpdateNumber.get(0).toString().toLowerCase();
                        String selectFields = this.getSelectfields(((Map)headDataMap.get(firstNumber)).keySet());
                        boolean flag = false;
                        if (null != this.getEntryKey() && entryDataMap.size() > 0) {
                            for (Map.Entry entry : entryDataMap.entrySet()) {
                                if (flag) break;
                                selectFields = this.getEntrySelectfields(((Map)entry.getValue()).keySet(), selectFields);
                                flag = true;
                            }
                        }
                        dyObjs = ORMUtil.load(this.getEntityKey(), selectFields, param);
                        for (DynamicObject dynamicObject : dyObjs) {
                            String billNumber = dynamicObject.get(this.getBillNumber()).toString().toLowerCase();
                            if (this.isNotUpdated(dynamicObject, (Map)headDataMap.get(billNumber))) continue;
                            dynamicObject = EipUtils.map2DynamicObject((Map<String, Object>)((Map)headDataMap.get(billNumber)), dynamicObject);
                            dynamicObject = EipUtils.setBDProperties(dynamicObject);
                            dynamicObject = EipUtils.setAssistantDataProperties(dynamicObject);
                            dynamicObject = this.setHeadSpecialProperties(dynamicObject);
                            if (null == this.getEntryKey()) continue;
                            DynamicObjectCollection entryCol = dynamicObject.getDynamicObjectCollection(this.getEntryKey());
                            int seq = 1;
                            for (DynamicObject entry : entryCol) {
                                Map entryMap = (Map)entryDataMap.get(billNumber + "_" + seq);
                                entry = EipUtils.map2DynamicObject((Map<String, Object>)entryMap, entry);
                                entry = EipUtils.setBDProperties(entry);
                                entry = EipUtils.setAssistantDataProperties(entry);
                                ++seq;
                            }
                            changedObjs.add(dynamicObject);
                        }
                    }
                    timerBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"\u89e3\u6790\u65f6\u95f4\uff1a{0}", (String)"BillCoreHelper_0", (String)"scm-common", (Object[])new Object[0]), timer.msValue()));
                    timer.reset();
                    if (!needNew.isEmpty()) {
                        newAndChangedObjs.addAll(needNew);
                    }
                    if (!changedObjs.isEmpty()) {
                        newAndChangedObjs.addAll(changedObjs);
                    }
                    isProcess = true;
                    if (newAndChangedObjs.isEmpty()) break block48;
                    String lockKey = "/scm/common/billCoreHelper/addEntity/" + this.getEntityKey();
                    try {
                        DLock lock = DLock.create((String)lockKey);
                        dyObjs = null;
                        try {
                            boolean bl;
                            this.beforeAddEntity(newAndChangedObjs, headDataMap, entryDataMap);
                            boolean bl2 = false;
                            if (EipConfigration.isISLOCK() && !needNew.isEmpty()) {
                                bl = true;
                            }
                            if (bl ? lock.tryLock(60000L) : !bl) {
                                try (TXHandle h = TX.requiresNew();){
                                    try {
                                        this.beforeAddEntityTransaction(newAndChangedObjs, headDataMap, entryDataMap);
                                        timerBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"\uff0cbeforeAddEntity\u6267\u884c\u65f6\u95f4\uff1a{0}", (String)"BillCoreHelper_1", (String)"scm-common", (Object[])new Object[0]), timer.msValue()));
                                        timer.reset();
                                        if (!needNew.isEmpty()) {
                                            needNew = this.validSaveDataAgain(needNew);
                                            newAndChangedObjs.clear();
                                            newAndChangedObjs.addAll(needNew);
                                            newAndChangedObjs.addAll(changedObjs);
                                            if (!needNew.isEmpty()) {
                                                Object[] newObjs = SRMStoreDataTraceHelper.saveStoreData(needNew.toArray(new DynamicObject[0]));
                                                log.info("### billCoreHelper add success:" + Arrays.toString(newObjs));
                                            }
                                        }
                                        Object[] updateObjs = SRMStoreDataTraceHelper.saveStoreData(changedObjs.toArray(new DynamicObject[0]));
                                        log.info("### billCoreHelper update success:" + Arrays.toString(updateObjs));
                                        timerBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"\uff0c\u4fdd\u5b58\u6267\u884c\u65f6\u95f4\uff1a{0}", (String)"BillCoreHelper_2", (String)"scm-common", (Object[])new Object[0]), timer.msValue()));
                                        timer.reset();
                                        this.afterAddEntityTransaction(newAndChangedObjs, headDataMap, entryDataMap);
                                    }
                                    catch (Exception e) {
                                        isProcess = false;
                                        String exceptionStr = ExceptionUtil.getStackTrace(e);
                                        log.error(exceptionStr);
                                        this.returnVal.put("msg", exceptionStr);
                                        this.returnVal.put("code", "500");
                                        h.markRollback();
                                    }
                                    break block49;
                                }
                            }
                            throw new KDBizException("### billCoreHelper can not get the lock:" + lockKey);
                        }
                        catch (Throwable throwable) {
                            dyObjs = throwable;
                            throw throwable;
                        }
                        finally {
                            if (lock != null) {
                                if (dyObjs != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)dyObjs).addSuppressed(throwable);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        isProcess = false;
                        String exceptionStr = ExceptionUtil.getStackTrace(e);
                        log.error(exceptionStr);
                        this.returnVal.put("msg", exceptionStr);
                        this.returnVal.put("code", "500");
                    }
                }
                if (isProcess) {
                    this.afterAddEntity(newAndChangedObjs, headDataMap, entryDataMap);
                }
                timerBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"\uff0cafterAddEntity\u6267\u884c\u65f6\u95f4\uff1a{0}", (String)"BillCoreHelper_3", (String)"scm-common", (Object[])new Object[0]), timer.msValue()));
                timer.reset();
            }
            catch (Exception e) {
                String exceptionStr = ExceptionUtil.getStackTrace(e);
                log.error(exceptionStr);
                this.returnVal.put("msg", exceptionStr);
                this.returnVal.put("code", "500");
            }
        }
        log.info("### billCoreHelper end addentity----------------------------------------");
        String outPutData = JacksonJsonUtil.toJSON(this.returnVal);
        this.logOutputData(logInfo.get(), outPutData + "------" + timerBuilder);
        return outPutData;
    }

    protected boolean isExist(Map<String, Object> entity) {
        HashMap<String, Map<String, Object>> paramMap = new HashMap<String, Map<String, Object>>(1);
        String number = entity.get(this.getBillNumber()).toString();
        ArrayList<String> numberList = new ArrayList<String>();
        numberList.add(number);
        numberList.add(number.toLowerCase());
        HashMap<String, ArrayList<String>> numberMap = new HashMap<String, ArrayList<String>>(1);
        numberMap.put("in", numberList);
        paramMap.put(this.getBillNumber(), numberMap);
        return ORMUtil.isExist4MultiQFilter(this.getEntityKey(), paramMap);
    }

    protected void beforeAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> headDataMap, Map<String, Map<String, Object>> entryDataMap) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject dynamicObjectBiz;
            long dynamicObjectSupplier = 0L;
            Object supplierValue = dynamicObject.get("supplier");
            if (supplierValue instanceof Long) {
                dynamicObjectSupplier = (Long)supplierValue;
            } else if (supplierValue instanceof DynamicObject) {
                dynamicObjectSupplier = dynamicObject.getDynamicObject("supplier").getLong("id");
            }
            if (dynamicObjectSupplier == 0L || null == (dynamicObjectBiz = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"id,name,bizpartner", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dynamicObjectSupplier)}))) continue;
            dynamicObject.set("bizpartner", (Object)dynamicObjectBiz.getLong("bizpartner"));
        }
    }

    protected void beforeAddEntityTransaction(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> headDataMap, Map<String, Map<String, Object>> entryDataMap) {
    }

    protected void afterAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> headDataMap, Map<String, Map<String, Object>> entryDataMap) {
        log.info("###after addEntity!!!");
        List<DynamicObject> attachList = this.getAttachments(dynamicObjects, headDataMap, entryDataMap);
        if (attachList.size() == 0) {
            return;
        }
        try (TXHandle h = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])attachList.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                h.markRollback();
                log.error((Throwable)e);
                throw new KDBizException(ExceptionUtil.getStackTrace(e));
            }
        }
    }

    protected void afterAddEntityTransaction(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> headDataMap, Map<String, Map<String, Object>> entryDataMap) {
    }

    public List<DynamicObject> getAttachments(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> headDataMap, Map<String, Map<String, Object>> entryDataMap) {
        ArrayList<DynamicObject> attachList = new ArrayList<DynamicObject>();
        ArrayList<Long> ids = new ArrayList<Long>(dynamicObjects.size());
        for (DynamicObject bill : dynamicObjects) {
            ids.add(bill.getLong("id"));
        }
        AttachmentUtil.deleteAttachements(dynamicObjects.get(0).getDataEntityType().getName(), ids, "attachmentpanel");
        for (DynamicObject bill : dynamicObjects) {
            Map<String, Object> billMap = headDataMap.get(bill.getString(this.getBillNumber()).toLowerCase());
            if (null == billMap || null == billMap.get("attachment")) continue;
            JSONArray attachMentList = JSONArray.fromObject((Object)billMap.get("attachment"));
            for (Object attachMent : attachMentList) {
                String attachMentStr;
                if (attachMent == null || (attachMentStr = attachMent.toString()).isEmpty() || "null".equals(attachMentStr)) continue;
                JSONObject attachMap = JSONObject.fromObject(attachMent);
                attachMap.put("uid", UUID.randomUUID().toString());
                String url = AttachmentUtil.getUrl(String.valueOf(attachMap.get("id")));
                InputStream in = AttachmentUtil.getFile(url);
                String fileUrl = AttachmentUtil.uploadFile(in, (Map<String, Object>)attachMap);
                attachMap.put("url", fileUrl);
                DynamicObject attatch = AttachmentUtil.createAttachmentData(bill, (Map<String, Object>)attachMap);
                attachList.add(attatch);
            }
        }
        return attachList;
    }

    protected String getSelectfields(Set<String> keySet) {
        DynamicObject obj = ORMUtil.newDynamicObject(this.getEntityKey());
        Map<String, List<String>> allProsMap = DynamicObjectUtil.getDifferDynamicProperties(obj);
        List<String> allProsList = allProsMap.get("allProList");
        List<String> bdList = allProsMap.get("bdList");
        StringBuilder sb = new StringBuilder();
        for (String key : keySet) {
            if (!allProsList.contains(key)) continue;
            if (bdList.contains(key)) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(key).append(".id");
                continue;
            }
            if (StringUtils.equals((String)this.getEntryKey(), (String)key)) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(key);
        }
        sb.append(",bizpartner,creator,modifier,auditor");
        return sb.toString();
    }

    protected String getEntrySelectfields(Set<String> keySet, String str) {
        DynamicObject entry = ORMUtil.newDynamicObject(this.getEntityKey() + "." + this.getEntryKey());
        Map<String, List<String>> allProsMap = DynamicObjectUtil.getDifferDynamicProperties(entry);
        List<String> allProsList = allProsMap.get("allProList");
        List<String> bdList = allProsMap.get("bdList");
        StringBuilder sb = new StringBuilder();
        sb.append(str);
        for (String key : keySet) {
            if (!allProsList.contains(key)) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            if (bdList.contains(key)) {
                sb.append(key).append(".id");
                continue;
            }
            sb.append(key);
        }
        sb.append(",srcentryid,sumreceiptqty");
        return sb.toString();
    }

    protected DynamicObject setHeadProperties(DynamicObject obj) {
        obj = EipUtils.setBDProperties(obj);
        obj = EipUtils.setAssistantDataProperties(obj);
        obj = this.setHeadSpecialProperties(obj);
        obj = this.setHeadDefaultProperties(obj);
        return obj;
    }

    protected DynamicObject setEntryProperties(DynamicObject obj) {
        obj = EipUtils.setBDProperties(obj);
        obj = EipUtils.setAssistantDataProperties(obj);
        obj = this.setEntrySpecialProperties(obj);
        obj = this.setEntryDefaultProperties(obj);
        return obj;
    }

    protected DynamicObject setHeadSpecialProperties(DynamicObject obj) {
        obj.set("biztype", (Object)BizTypeEnum.PUR_STANDARD.getVal());
        return obj;
    }

    protected DynamicObject setHeadDefaultProperties(DynamicObject obj) {
        obj.set("billstatus", (Object)BillStatusEnum.AUDIT.getVal());
        obj.set("origin", (Object)"2");
        return obj;
    }

    protected DynamicObject setEntrySpecialProperties(DynamicObject obj) {
        return obj;
    }

    protected DynamicObject setEntryDefaultProperties(DynamicObject obj) {
        obj.set("entrystatus", (Object)BillEntryStatusEnum.COMMON.getVal());
        return obj;
    }

    protected boolean isNotUpdated(DynamicObject obj, Map<String, Object> dataMap) {
        if (dataMap.get(AUDIT_DATE) != null && obj.getDate(AUDIT_DATE) != null && obj.getDate(AUDIT_DATE).compareTo(DateUtil.string2date(dataMap.get(AUDIT_DATE).toString(), null)) >= 0) {
            return true;
        }
        return dataMap.get(MODIFY_TIME) != null && obj.getDate(MODIFY_TIME) != null && obj.getDate(MODIFY_TIME).compareTo(DateUtil.string2date(dataMap.get(MODIFY_TIME).toString(), null)) >= 0;
    }

    protected DynamicObject logInputData(String data) {
        DynamicObject log = null;
        EipConfigration.initConfig();
        if (EipConfigration.isISLOG()) {
            log = DataTransterLogUtil.logInputData(EipConfigration.getAPICONFIGID(), "", this.getEntityKey(), data);
            logInfo.set(log);
        }
        return log;
    }

    protected void logOutputData(DynamicObject logInfo, String data) {
        if (EipConfigration.isISLOG()) {
            DataTransterLogUtil.logOutputData(logInfo, data);
        }
    }

    protected Map<String, Map<String, Object>> getParamForUpdate(List<Object> needUpdateNumber) {
        HashMap<String, Map<String, Object>> param = new HashMap<String, Map<String, Object>>(1);
        HashMap<String, List<Object>> cpVal = new HashMap<String, List<Object>>(1);
        cpVal.put("in", needUpdateNumber);
        param.put(this.getBillNumber(), cpVal);
        return param;
    }

    protected List<DynamicObject> validSaveDataAgain(List<DynamicObject> dataList) {
        ArrayList<Object> needNewNumberList = new ArrayList<Object>();
        DynamicObject obj = null;
        Object bullNo = null;
        String billNoKey = this.getBillNumber();
        for (int i = 0; i < dataList.size(); ++i) {
            obj = dataList.get(i);
            if (null != obj.getPkValue() && 0L != (Long)obj.getPkValue()) continue;
            bullNo = obj.get(billNoKey);
            needNewNumberList.add(bullNo);
        }
        QFilter filter = new QFilter(this.getBillNumber(), "in", needNewNumberList);
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)this.getEntityKey(), (String)("id," + billNoKey), (QFilter[])new QFilter[]{filter});
        ArrayList<String> existBillNo = new ArrayList<String>(datas.length);
        for (DynamicObject data2 : datas) {
            existBillNo.add(data2.getString(this.getBillNumber()));
        }
        ArrayList<DynamicObject> newDataList = new ArrayList<DynamicObject>();
        dataList.forEach(data -> {
            if (!existBillNo.contains(data.getString(billNoKey))) {
                newDataList.add((DynamicObject)data);
            }
        });
        return newDataList;
    }

    protected long getDefaultBillType(String formId) {
        if (this.defaultTypeId != 0L) {
            return this.defaultTypeId;
        }
        QFilter qFilter = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        qFilter.and("billformid", "=", (Object)formId);
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("status", "=", (Object)"C");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_billtype", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObject != null) {
            return dynamicObject.getLong("id");
        }
        return 0L;
    }
}

