/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip.helper;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.eip.IOperationService;
import kd.scm.common.eip.args.OperationArgs;
import kd.scm.common.eip.config.EipConfigration;
import kd.scm.common.isc.util.ISCUtil;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;
import kd.scm.common.util.DataTransterLogUtil;
import kd.scm.common.util.ExceptionUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public abstract class BillOpration
implements IOperationService {
    protected static final String BILLNO = "billno";
    private final Log log = LogFactory.getLog((String)this.getClass().getName());
    protected Map<String, Object> param = null;

    @Override
    public String doOperation(Map<String, Object> param) {
        this.param = param;
        DynamicObject logInfo = this.logInputData(param);
        Map<String, Object> retData = new HashMap<String, Object>();
        retData.put("code", "200");
        StringBuilder msg = new StringBuilder(ResManager.loadKDString((String)"\u534f\u540c\u7aef", (String)"BillOpration_0", (String)"scm-common", (Object[])new Object[0]));
        String entityKey = this.getEntityKey();
        StringBuilder exceptionStr = new StringBuilder();
        if (entityKey == null) {
            msg.append(ResManager.loadKDString((String)"\u5355\u636e\u6807\u8bc6\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u64cd\u4f5c\uff01", (String)"BillOpration_1", (String)"scm-common", (Object[])new Object[0]));
        } else {
            OperationArgs opArgs = new OperationArgs();
            opArgs.setReturnData(retData).setMsg(msg).setParam(param);
            String operation = this.getOperationKey();
            DynamicObject[] objs = this.getExecuteData();
            if (objs != null && objs.length > 0) {
                opArgs.setDynamicObjects(objs);
                try {
                    switch (operation) {
                        case "delete": {
                            this.beforeDelete(opArgs);
                            this.delete(opArgs);
                            this.afterDelete(opArgs);
                            break;
                        }
                        case "alert": {
                            this.beforeAlert(opArgs);
                            this.alert(opArgs);
                            this.afterAlert(opArgs);
                            break;
                        }
                        case "save": {
                            this.beforeSave(opArgs);
                            this.save(opArgs);
                            this.afterSave(opArgs);
                            break;
                        }
                        default: {
                            exceptionStr.append(MessageFormat.format(ResManager.loadKDString((String)"\u64cd\u4f5c\uff1a{0}\u672a\u5b9a\u4e49\uff01", (String)"BillOpration_3", (String)"scm-common", (Object[])new Object[0]), operation));
                            break;
                        }
                    }
                }
                catch (Throwable e) {
                    String errorTitle = ResManager.loadKDString((String)"SRM\u7cfb\u7edf\u5728\u5904\u7406\u6570\u636e\u8fc7\u7a0b\u4e2d\uff0c\u53d1\u751f\u4e86\u610f\u6599\u4e4b\u5916\u7684\u60c5\u51b5\uff0c\u8bf7\u53ca\u65f6\u8054\u7cfb\u6280\u672f\u652f\u6301\u5206\u6790\u3002", (String)"BillOpration_6", (String)"scm-common", (Object[])new Object[0]);
                    String errorMessage = ExceptionUtil.getStackTrace(e);
                    SRMStoreExceptionTraceHelper.saveExceptionData(e);
                    throw new KDException(new ErrorCode("SRMDATAERROR002", errorTitle), errorMessage, e);
                }
            }
            retData = opArgs.getReturnData();
            msg = opArgs.getMsg();
            msg.append((CharSequence)exceptionStr);
        }
        retData.put("msg", msg.toString());
        this.logOutputData(logInfo, retData);
        return com.alibaba.fastjson.JSONObject.toJSONString(retData);
    }

    protected void beforeDelete(OperationArgs opArgs) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void delete(OperationArgs opArgs) {
        Map<String, Object> retData;
        HashSet<Object> successData;
        block20: {
            DynamicObject[] objs = opArgs.getDynamicObjects();
            HashSet<Object> pks = new HashSet<Object>(objs.length);
            successData = new HashSet<Object>(objs.length);
            retData = opArgs.getReturnData();
            for (DynamicObject object : objs) {
                Object billno = "pur_ordchange".equals(this.getEntityKey()) ? object.get("pobillno") : object.get(BILLNO);
                this.log.info("@@@" + object.getString("id") + "/" + object.getPkValue());
                pks.add(object.get("id"));
                successData.add(billno);
            }
            this.log.info("@@@delete pks:" + pks + "/objs:" + objs.length);
            if (pks.size() > 0) {
                retData.put("code", "200");
                try (TXHandle h = TX.required();){
                    StringBuilder errorTitle = new StringBuilder();
                    try {
                        if (ISCUtil.isISC()) {
                            OperateOption option = OperateOption.create();
                            option.setVariableValue("isStrict", "false");
                            option.setVariableValue("ishasright", "true");
                            OperationResult unAuditResullt = OperationServiceHelper.executeOperate((String)"unaudit", (String)objs[0].getDataEntityType().getName(), (Object[])pks.toArray(), (OperateOption)option);
                            if (!unAuditResullt.isSuccess()) {
                                errorTitle.append(unAuditResullt.getMessage());
                                errorTitle.append(ExceptionUtil.getErrorInfoDetails(unAuditResullt.getAllErrorOrValidateInfo()));
                                throw new KDBizException(errorTitle.toString());
                            }
                            OperationResult deleteResullt = OperationServiceHelper.executeOperate((String)"delete", (String)objs[0].getDataEntityType().getName(), (Object[])pks.toArray(), (OperateOption)option);
                            if (!deleteResullt.isSuccess()) {
                                errorTitle.append(deleteResullt.getMessage());
                                errorTitle.append(ExceptionUtil.getErrorInfoDetails(deleteResullt.getAllErrorOrValidateInfo()));
                                throw new KDBizException(errorTitle.toString());
                            }
                            break block20;
                        } else {
                            DeleteServiceHelper.delete((IDataEntityType)objs[0].getDataEntityType(), (Object[])pks.toArray());
                        }
                        break block20;
                    }
                    catch (Throwable e) {
                        StringBuilder errorMessage = new StringBuilder(ExceptionUtil.getStackTrace(e));
                        retData.put("errorMessage", errorMessage.toString());
                        retData.put("errorCode", "500");
                        h.markRollback();
                        throw new KDException(new ErrorCode("SRMDATAERROR003", errorTitle.toString()), new Object[]{errorMessage, e});
                    }
                }
            }
            retData.put("code", "500");
        }
        retData.put(this.getEntityKey(), successData);
        opArgs.setReturnData(retData);
    }

    protected void afterDelete(OperationArgs opArgs) {
    }

    protected void beforeAlert(OperationArgs opArgs) {
    }

    protected void alert(OperationArgs opArgs) {
    }

    protected void afterAlert(OperationArgs opArgs) {
    }

    protected void beforeSave(OperationArgs opArgs) {
    }

    protected void save(OperationArgs opArgs) {
    }

    protected void afterSave(OperationArgs opArgs) {
    }

    protected Map<String, Map<String, Object>> buildCondition() {
        HashMap<String, Map<String, Object>> conditions = new HashMap<String, Map<String, Object>>();
        HashMap billNoMap = new HashMap(1);
        JSONArray list = JSONArray.fromObject((Object)this.param.get("data"));
        HashSet billnoSet = new HashSet();
        list.forEach(object -> {
            JSONObject map = JSONObject.fromObject((Object)object);
            billnoSet.add(map.get(BILLNO));
        });
        billNoMap.put("in", billnoSet);
        conditions.put(BILLNO, billNoMap);
        return conditions;
    }

    protected String getSelectFields() {
        return "id,billno,cfmstatus,billstatus";
    }

    protected String getOrderby() {
        return BILLNO;
    }

    protected abstract String getOperationKey();

    protected abstract String getEntityKey();

    protected DynamicObject logInputData(Object data) {
        DynamicObject logInfo = null;
        EipConfigration.initConfig(null);
        if (EipConfigration.isISLOG()) {
            logInfo = DataTransterLogUtil.logInputData(EipConfigration.getAPICONFIGID(), this.getOperationKey(), this.getEntityKey(), data);
        }
        return logInfo;
    }

    protected void logOutputData(DynamicObject logInfo, Object data) {
        if (EipConfigration.isISLOG()) {
            DataTransterLogUtil.logOutputData(logInfo, data);
        }
    }

    protected StringBuilder buildErrorMessage(OperationResult unAuditResult) {
        StringBuilder message = new StringBuilder(unAuditResult.getMessage());
        message.append(ExceptionUtil.getErrorInfoDetails(unAuditResult.getAllErrorOrValidateInfo()));
        return message;
    }

    protected DynamicObject[] getExecuteData() {
        DynamicObject[] objs = ORMUtil.load(this.getEntityKey(), this.getSelectFields(), this.buildCondition(), this.getOrderby());
        this.storeException(objs);
        return objs;
    }

    protected final String assembleNoDataMessage() {
        String errorMessage = ResManager.loadKDString((String)"SRM\u7cfb\u7edf\u4e0d\u5b58\u5728\u8fd9\u4e2a\u6570\u636e\u6216\u8005\u4e0d\u6ee1\u8db3\u64cd\u4f5c\u6761\u4ef6\u3002\u83b7\u53d6\u6570\u636e\u6761\u4ef6\u662f", (String)"BillOpration_5", (String)"scm-common", (Object[])new Object[0]);
        return errorMessage + "entityKey\uff1a" + this.getEntityKey() + "conditions\uff1a" + SerializationUtils.toJsonString(this.buildCondition());
    }

    protected final void throwException(DynamicObject[] dynamicObjects) {
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            String exceptionString = this.assembleNoDataMessage();
            throw new KDException(new ErrorCode("SRMDATAERROR001", exceptionString), new Object[]{exceptionString});
        }
    }

    protected final void storeException(DynamicObject[] dynamicObjects) {
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            String exceptionString = this.assembleNoDataMessage();
            SRMStoreExceptionTraceHelper.saveExceptionData(new KDException(new ErrorCode("SRMDATAERROR001", exceptionString), new Object[]{exceptionString}));
        }
    }
}

