/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip.helper;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.eip.IHerlperService;
import kd.scm.common.eip.config.EipConfigration;
import kd.scm.common.eip.util.EipUtils;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.DataTransterLogUtil;
import kd.scm.common.util.ExceptionUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public class CoreHelper
implements IHerlperService {
    private static Log log = LogFactory.getLog(CoreHelper.class);
    protected static final String NUMBER = "number";
    protected IAppCache redisBdCache = AppCache.get((String)"scm");
    protected static ThreadLocal<DynamicObject> logInfo = new ThreadLocal();

    public ThreadLocal<DynamicObject> getLogInfo() {
        return logInfo;
    }

    protected String getEntityKey() {
        return null;
    }

    protected Map<String, String> getPageIdentification() {
        return new HashMap<String, String>();
    }

    protected List<String> getProperties() {
        return new ArrayList<String>();
    }

    @Override
    public String addEntity(Map<String, Object> map) {
        HashMap<String, String> returnVal;
        Date startDate;
        block26: {
            startDate = new Date();
            if (map.get("data") == null || StringUtils.isEmpty((String)map.get("data").toString())) {
                return null;
            }
            returnVal = new HashMap<String, String>(2);
            returnVal.put("code", "200");
            try {
                ArrayList<DynamicObject> newAndChangedObjs;
                ArrayList<Object> changedObjs;
                HashMap<String, Map<String, Object>> dataMap;
                block27: {
                    Object dyObjs;
                    String number;
                    this.logInputData(String.valueOf(map.get("data")));
                    JSONArray list = JSONArray.fromObject((Object)map.get("data"));
                    dataMap = new HashMap<String, Map<String, Object>>();
                    List<DynamicObject> needNewObjs = new ArrayList<DynamicObject>();
                    changedObjs = new ArrayList<Object>();
                    ArrayList<Object> needUpdateNumber = new ArrayList<Object>();
                    newAndChangedObjs = new ArrayList<DynamicObject>();
                    for (Object object : list) {
                        JSONObject entity = JSONObject.fromObject(object);
                        number = entity.get(NUMBER).toString().toLowerCase();
                        dataMap.put(number, (Map<String, Object>)entity);
                        if (this.isExist((Map<String, Object>)entity)) {
                            needUpdateNumber.add(number);
                            needUpdateNumber.add(entity.get(NUMBER).toString());
                            continue;
                        }
                        DynamicObject obj = EipUtils.map2DynamicObject((Map<String, Object>)entity, this.getEntityKey());
                        obj = this.setProperties(obj);
                        ORMUtil.setPrimaryKey(obj);
                        needNewObjs.add(obj);
                    }
                    if (!needUpdateNumber.isEmpty()) {
                        Map<String, Map<String, Object>> param = this.getParamForUpdate(needUpdateNumber);
                        String selectFields = this.getSelectfields(((Map)dataMap.get(needUpdateNumber.get(0).toString().toLowerCase())).keySet(), this.getProperties());
                        dyObjs = ORMUtil.load(this.getEntityKey(), selectFields, param);
                        number = null;
                        for (int i = 0; i < ((DynamicObject[])dyObjs).length; ++i) {
                            number = dyObjs[i].get(NUMBER).toString().toLowerCase();
                            dyObjs[i] = EipUtils.map2DynamicObject((Map<String, Object>)((Map)dataMap.get(number)), (DynamicObject)dyObjs[i]);
                            dyObjs[i] = EipUtils.setBDProperties((DynamicObject)dyObjs[i]);
                            changedObjs.add(dyObjs[i]);
                        }
                    }
                    if (!needNewObjs.isEmpty()) {
                        newAndChangedObjs.addAll(needNewObjs);
                    }
                    if (!changedObjs.isEmpty()) {
                        newAndChangedObjs.addAll(changedObjs);
                    }
                    if (newAndChangedObjs.isEmpty()) break block26;
                    this.beforeAddEntity(newAndChangedObjs, dataMap);
                    String lockKey = "/scm/common/coreHelper/addEntity/" + this.getEntityKey();
                    try {
                        DLock lock = DLock.create((String)lockKey);
                        dyObjs = null;
                        try {
                            boolean isNeedLock = false;
                            if (EipConfigration.isISLOCK() && !needNewObjs.isEmpty()) {
                                isNeedLock = true;
                            }
                            if (isNeedLock ? lock.tryLock(60000L) : !isNeedLock) {
                                if (!needNewObjs.isEmpty()) {
                                    needNewObjs = this.validSaveDataAgain(needNewObjs);
                                    newAndChangedObjs.clear();
                                    newAndChangedObjs.addAll(needNewObjs);
                                    newAndChangedObjs.addAll(changedObjs);
                                }
                                Object[] newObjs = SRMStoreDataTraceHelper.saveStoreData(needNewObjs.toArray(new DynamicObject[0]));
                                log.info("###coreHelper add success:" + Arrays.toString(newObjs));
                                break block27;
                            }
                            throw new KDBizException("###coreHelper can not get the lock:" + lockKey);
                        }
                        catch (Throwable throwable) {
                            dyObjs = throwable;
                            throw throwable;
                        }
                        finally {
                            if (lock != null) {
                                if (dyObjs != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)dyObjs).addSuppressed(throwable);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        String exceptionStr = ExceptionUtil.getStackTrace(e);
                        log.error(exceptionStr);
                    }
                }
                Object[] updateObjs = SRMStoreDataTraceHelper.saveStoreData(changedObjs.toArray(new DynamicObject[0]));
                log.info("update success:" + Arrays.toString(updateObjs));
                this.afterAddEntity(newAndChangedObjs, dataMap);
            }
            catch (Exception e) {
                String exceptionStr = ExceptionUtil.getStackTrace(e);
                returnVal.put("msg", exceptionStr);
                returnVal.put("code", "500");
            }
        }
        String returnStr = com.alibaba.fastjson.JSONObject.toJSONString(returnVal);
        Date endDate = new Date();
        long processTime = endDate.getTime() - startDate.getTime();
        this.logOutputData(logInfo.get(), MessageFormat.format(ResManager.loadKDString((String)"\u6267\u884c\u65f6\u95f4\uff1a{0}", (String)"CoreHelper_0", (String)"scm-common", (Object[])new Object[0]), processTime));
        return returnStr;
    }

    protected boolean isExist(Map<String, Object> entity) {
        if (EipConfigration.isISCACHE() && this.isCache(entity)) {
            return true;
        }
        HashMap<String, Map<String, Object>> paramMap = new HashMap<String, Map<String, Object>>(1);
        String number = entity.get(NUMBER).toString();
        ArrayList<String> numberList = new ArrayList<String>();
        numberList.add(number);
        numberList.add(number.toLowerCase());
        HashMap<String, ArrayList<String>> numberMap = new HashMap<String, ArrayList<String>>(1);
        numberMap.put("in", numberList);
        paramMap.put(NUMBER, numberMap);
        return ORMUtil.isExist4MultiQFilter(this.getEntityKey(), paramMap);
    }

    protected boolean isCache(Map<String, Object> entity) {
        String number = entity.get(NUMBER).toString().toLowerCase();
        String cacheKey = this.getCacheKey(number);
        String cacheObj = (String)this.redisBdCache.get(cacheKey, String.class);
        return null != cacheObj;
    }

    protected void cacheData(List<DynamicObject> dynamicObjects) {
        for (DynamicObject obj : dynamicObjects) {
            BaseDataServiceHelper.clearCache((DynamicObject)obj);
            if (!EipConfigration.isISCACHE()) continue;
            String cacheKey = this.getCacheKey(obj.getString(NUMBER));
            String cacheObj = (String)this.redisBdCache.get(cacheKey, String.class);
            if (null == obj.getPkValue() || null != cacheObj) continue;
            this.redisBdCache.put(cacheKey, (Object)obj.getPkValue().toString(), 3000);
        }
    }

    protected String getCacheKey(String val) {
        StringBuilder cacheKeySb = new StringBuilder();
        cacheKeySb.append("pur_eip_").append(this.getEntityKey()).append('_').append(val);
        return cacheKeySb.toString();
    }

    protected void beforeAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> dataMap) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            dynamicObject.set("masterid", dynamicObject.getPkValue());
        }
    }

    protected void afterAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> dataMap) {
        this.cacheData(dynamicObjects);
    }

    protected String getSelectfields(Set<String> keySet, List<String> bd_properties) {
        StringBuilder sb = new StringBuilder();
        for (String key : keySet) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            if (bd_properties.contains(key)) {
                sb.append(key).append(".*");
                continue;
            }
            sb.append(key);
        }
        return sb.toString();
    }

    protected DynamicObject setProperties(DynamicObject obj) {
        obj = EipUtils.setBDProperties(obj);
        obj = this.setDefaultProperties(obj);
        return obj;
    }

    protected DynamicObject setDefaultProperties(DynamicObject obj) {
        obj.set("status", (Object)"C");
        obj.set("enable", (Object)"1");
        return obj;
    }

    protected List<String> getDateProperties() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("createtime");
        list.add("modifytime");
        return list;
    }

    protected DynamicObject logInputData(String data) {
        DynamicObject log = null;
        if (EipConfigration.isISLOG()) {
            try (TXHandle h = TX.notSupported();){
                log = DataTransterLogUtil.logInputData(EipConfigration.getAPICONFIGID(), "", this.getEntityKey(), data);
                logInfo.set(log);
            }
        }
        return log;
    }

    protected void logOutputData(DynamicObject logInfo, String data) {
        if (EipConfigration.isISLOG()) {
            DataTransterLogUtil.logOutputData(logInfo, data);
        }
    }

    protected Map<String, Map<String, Object>> getParamForUpdate(List<Object> needUpdateNumber) {
        HashMap<String, Map<String, Object>> param = new HashMap<String, Map<String, Object>>(1);
        HashMap<String, List<Object>> cpVal = new HashMap<String, List<Object>>(1);
        cpVal.put("in", needUpdateNumber);
        param.put(NUMBER, cpVal);
        return param;
    }

    protected List<DynamicObject> validSaveDataAgain(List<DynamicObject> dataList) {
        ArrayList<Object> needNewNumberList = new ArrayList<Object>();
        DynamicObject obj = null;
        Object number = null;
        for (int i = 0; i < dataList.size(); ++i) {
            obj = dataList.get(i);
            if (null != obj.getPkValue() && 0L != (Long)obj.getPkValue()) continue;
            number = obj.get(NUMBER);
            needNewNumberList.add(number);
        }
        QFilter filter = new QFilter(NUMBER, "in", needNewNumberList);
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)this.getEntityKey(), (String)"id,number", (QFilter[])new QFilter[]{filter});
        ArrayList<String> existBillNo = new ArrayList<String>(datas.length);
        for (DynamicObject data2 : datas) {
            existBillNo.add(data2.getString(NUMBER));
        }
        ArrayList<DynamicObject> newDataList = new ArrayList<DynamicObject>();
        dataList.forEach(data -> {
            if (!existBillNo.contains(data.getString(NUMBER))) {
                newDataList.add((DynamicObject)data);
            }
        });
        return newDataList;
    }
}

