/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.model.OrgSaveModel;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.eip.helper.CoreHelper;

public class OrgUnitHelper
extends CoreHelper {
    private static final String ENTITY_KEY = "bos_org";

    @Override
    protected String getEntityKey() {
        return ENTITY_KEY;
    }

    @Override
    protected DynamicObject setDefaultProperties(DynamicObject obj) {
        obj = super.setDefaultProperties(obj);
        obj.set("fisinventory", (Object)"1");
        if (obj.getBoolean("fissettlement")) {
            obj.set("fisbankroll", (Object)"1");
            obj.set("fisaccounting", (Object)"1");
        }
        obj.set("fyzjimorted", (Object)"0");
        return obj;
    }

    @Override
    protected void afterAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> dataMap) {
        OrgServiceHelper orgServiceHelper = new OrgServiceHelper();
        OrgSaveModel orgSaveModel = new OrgSaveModel();
        List<Object> bizList = new ArrayList();
        DynamicObject dynaObj = null;
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            dynaObj = dynamicObjects.get(i);
            orgSaveModel.setOrgId(String.valueOf(dynaObj.getPkValue()));
            orgSaveModel.setParentorgId(StringUtils.getStringValue((Object)OrgUnitServiceHelper.getRootOrgId()));
            orgSaveModel.setOrgNumber(String.valueOf(dynaObj.get("number")));
            orgSaveModel.setOrgName(String.valueOf(dynaObj.get("name")));
            bizList = this.getBizList(dynaObj);
            orgServiceHelper.autoBuildBizTree(bizList, orgSaveModel);
        }
    }

    private List<Long> getBizList(DynamicObject dynaObj) {
        ArrayList<Long> bizList = new ArrayList<Long>();
        if (dynaObj.getBoolean("fisadministrative")) {
            bizList.add(1L);
        }
        if (dynaObj.getBoolean("fispurchase")) {
            bizList.add(2L);
        }
        if (dynaObj.getBoolean("fissale")) {
            bizList.add(3L);
        }
        if (dynaObj.getBoolean("fisinventory")) {
            bizList.add(5L);
        }
        if (dynaObj.getBoolean("fissettlement")) {
            bizList.add(7L);
            bizList.add(10L);
        }
        if (dynaObj.getBoolean("fisbankroll")) {
            bizList.add(8L);
        }
        return bizList;
    }
}

