/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.eip.helper.CoreHelper;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.DynamicObjectUtil;

public class ProjectHelper
extends CoreHelper {
    private static final String ENTITY_KEY = "pur_project";

    @Override
    protected String getEntityKey() {
        return ENTITY_KEY;
    }

    @Override
    protected String getSelectfields(Set<String> keySet, List<String> bd_properties) {
        StringBuilder strBuffer = new StringBuilder();
        strBuffer.append(super.getSelectfields(keySet, bd_properties));
        strBuffer.append(",number,name,enable,status,creator,createtime,createorg");
        return strBuffer.toString();
    }

    @Override
    protected void beforeAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> dataMap) {
        super.beforeAddEntity(dynamicObjects, dataMap);
        for (DynamicObject project : dynamicObjects) {
            String number;
            Map<String, Object> projectMap;
            Object tracks;
            String status;
            if (0L == project.getLong("auditor")) {
                project.set("auditor", (Object)RequestContext.get().getUserId());
            }
            if (0L == project.getLong("creator")) {
                project.set("creator", (Object)RequestContext.get().getUserId());
            }
            if (0L == project.getLong("modifier")) {
                project.set("modifier", (Object)RequestContext.get().getUserId());
            }
            if ("4".equals(status = project.getString("status"))) {
                project.set("enable", (Object)"1");
                project.set("status", (Object)"C");
            } else if ("50".equals(status) || "7".equals(status)) {
                project.set("enable", (Object)"0");
                project.set("status", (Object)"C");
            } else if ("1".equals(status)) {
                project.set("enable", (Object)"0");
                project.set("status", (Object)"A");
            }
            if (!((tracks = (projectMap = dataMap.get((number = project.getString("number")).toLowerCase())).get("tracks")) instanceof List)) continue;
            List trackNos = (List)projectMap.get("tracks");
            StringBuilder trackNoSb = new StringBuilder();
            for (Object trackNo : trackNos) {
                if (trackNo == null || String.valueOf(trackNo).equals("null")) continue;
                if (trackNoSb.length() > 0) {
                    trackNoSb.append(',').append('\'').append(String.valueOf(trackNo)).append('\'');
                    continue;
                }
                trackNoSb.append('\'').append(String.valueOf(trackNo)).append('\'');
            }
            if (trackNoSb.length() <= 0) continue;
            ApiUtil.syncTrack(trackNoSb.toString());
        }
    }

    @Override
    protected void afterAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> dataMap) {
        super.afterAddEntity(dynamicObjects, dataMap);
        ArrayList<DynamicObject> needNew = new ArrayList<DynamicObject>();
        ArrayList<String> projectIdList = new ArrayList<String>(dynamicObjects.size());
        Object bdProject = null;
        HashSet<DynamicObject> bdProjectSet = new HashSet<DynamicObject>();
        HashSet<Long> idSet = new HashSet<Long>(dynamicObjects.size());
        for (DynamicObject project : dynamicObjects) {
            projectIdList.add(project.getString("id"));
            String number = project.getString("number");
            Map<String, Object> projectMap = dataMap.get(number.toLowerCase());
            Object tracks = projectMap.get("tracks");
            if (tracks instanceof List) {
                List trackNos = (List)projectMap.get("tracks");
                if (trackNos.size() == 1 && "null".equals(trackNos.get(0).toString())) continue;
                HashMap<String, Map<String, Object>> param = new HashMap<String, Map<String, Object>>(1);
                HashMap<String, List> cpVal = new HashMap<String, List>(1);
                cpVal.put("in", trackNos);
                param.put("number", cpVal);
                DynamicObjectCollection cols = ORMUtil.queryDynamicObjectCollection("pur_trace", "id", param);
                for (DynamicObject col : cols) {
                    DynamicObject obj = ORMUtil.newDynamicObject("pur_projecttrace");
                    obj.set("trace", col.get("id"));
                    obj.set("project", project.get("id"));
                    needNew.add(obj);
                }
            }
            idSet.add(project.getLong("id"));
        }
        HashMap<String, Map<String, Object>> param = new HashMap<String, Map<String, Object>>(1);
        HashMap<String, ArrayList<String>> cpVal = new HashMap<String, ArrayList<String>>(1);
        cpVal.put("in", projectIdList);
        param.put("project", cpVal);
        ORMUtil.delete("pur_projecttrace", param);
        SaveServiceHelper.save((DynamicObject[])needNew.toArray(new DynamicObject[0]));
        for (DynamicObject project : dynamicObjects) {
            this.addBdProject(bdProjectSet, project);
        }
        ProjectHelper.setTraceAddProject(idSet);
        if (bdProjectSet.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])bdProjectSet.toArray(new DynamicObject[0]));
        }
    }

    private void addBdProject(Set<DynamicObject> bdProjectSet, DynamicObject project) {
        DynamicObject bdProject = ORMUtil.newDynamicObject("bd_project");
        bdProject.set("number", (Object)project.getString("number"));
        bdProject.set("name", (Object)project.getString("name"));
        bdProject.set("enable", (Object)project.getString("enable"));
        bdProject.set("status", (Object)project.getString("status"));
        bdProject.set("id", project.getPkValue());
        bdProject.set("masterid", project.getPkValue());
        bdProject.set("creator", (Object)project.getLong("creator"));
        bdProject.set("createorg", (Object)project.getLong("createorg"));
        bdProject.set("useorg", (Object)project.getLong("createorg"));
        bdProject.set("ctrlstrategy", (Object)5);
        bdProject.set("createtime", (Object)project.getDate("createtime"));
        bdProjectSet.add(bdProject);
    }

    @Override
    protected DynamicObject setDefaultProperties(DynamicObject obj) {
        obj = super.setDefaultProperties(obj);
        obj.set("org", (Object)RequestContext.get().getOrgId());
        obj.set("auditdate", (Object)new Date());
        if (0L == obj.getLong("auditor")) {
            obj.set("auditor", (Object)RequestContext.get().getUserId());
        }
        if (0L == obj.getLong("creator")) {
            obj.set("creator", (Object)RequestContext.get().getUserId());
        }
        if (0L == obj.getLong("modifier")) {
            obj.set("modifier", (Object)RequestContext.get().getUserId());
        }
        obj.set("createorg", (Object)RequestContext.get().getOrgId());
        obj.set("ctrlstrategy", (Object)"5");
        return obj;
    }

    private static void setTraceAddProject(Set<Long> idSet) {
        QFilter filter = new QFilter("project", "in", idSet);
        DynamicObject[] projectTrace = BusinessDataServiceHelper.load((String)"pur_projecttrace", (String)"project.id,trace.id,trace.number", (QFilter[])new QFilter[]{filter});
        DynamicObject project = null;
        DynamicObject trace = null;
        HashMap<Long, Long> projectTraceMap = new HashMap<Long, Long>();
        HashSet<Long> traceSet = new HashSet<Long>();
        for (int i = 0; i < projectTrace.length; ++i) {
            project = projectTrace[i].getDynamicObject("project");
            trace = projectTrace[i].getDynamicObject("trace");
            if (null == project || null == trace) continue;
            projectTraceMap.put(trace.getLong("id"), project.getLong("id"));
            traceSet.add(trace.getLong("id"));
        }
        QFilter tracefilter = new QFilter("id", "in", traceSet);
        DynamicObject[] traceArr = BusinessDataServiceHelper.load((String)"pur_trace", (String)DynamicObjectUtil.getSelectfields("pur_trace", false), (QFilter[])new QFilter[]{tracefilter});
        HashSet<DynamicObject> traceDynSet = new HashSet<DynamicObject>(traceArr.length);
        for (int i = 0; i < traceArr.length; ++i) {
            trace = traceArr[i];
            trace.set("project", projectTraceMap.get(trace.getLong("id")));
            traceDynSet.add(trace);
        }
        if (traceDynSet.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])traceDynSet.toArray(new DynamicObject[0]));
        }
    }
}

