/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip.helper;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scm.common.eip.helper.CoreHelper;

public class TrackHelper
extends CoreHelper {
    private static final String ENTITY_KEY = "pur_trace";

    @Override
    protected String getEntityKey() {
        return ENTITY_KEY;
    }

    @Override
    protected void beforeAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> dataMap) {
        super.beforeAddEntity(dynamicObjects, dataMap);
        for (DynamicObject track : dynamicObjects) {
            String status = track.getString("status");
            if ("10".equals(status)) {
                track.set("enable", (Object)"1");
                track.set("status", (Object)"C");
            } else if ("80".equals(status)) {
                track.set("enable", (Object)"0");
                track.set("status", (Object)"C");
            }
            String name = track.getString("name");
            if (null == name || name.trim().length() == 0) {
                track.set("name", (Object)track.getString("number"));
            }
            if (0L == track.getLong("auditor")) {
                track.set("auditor", (Object)RequestContext.get().getUserId());
            }
            if (0L == track.getLong("creator")) {
                track.set("creator", (Object)RequestContext.get().getUserId());
            }
            if (0L != track.getLong("modifier")) continue;
            track.set("modifier", (Object)RequestContext.get().getUserId());
        }
    }

    @Override
    protected DynamicObject setDefaultProperties(DynamicObject obj) {
        obj = super.setDefaultProperties(obj);
        obj.set("org", (Object)1L);
        obj.set("auditdate", (Object)new Date());
        if (0L == obj.getLong("auditor")) {
            obj.set("auditor", (Object)RequestContext.get().getUserId());
        }
        if (0L == obj.getLong("creator")) {
            obj.set("creator", (Object)RequestContext.get().getUserId());
        }
        if (0L == obj.getLong("modifier")) {
            obj.set("modifier", (Object)RequestContext.get().getUserId());
        }
        obj.set("createorg", (Object)RequestContext.get().getOrgId());
        obj.set("ctrlstrategy", (Object)"5");
        return obj;
    }
}

