/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.enums;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;

public enum StockEnum {
    SPOT(StockEnum.getMsgFaileds(), "33"),
    SOLDOUT(StockEnum.getMsgMap(), "34"),
    BOOK(StockEnum.getMsgData(), "36"),
    INTRANSIT(StockEnum.getMsgOperation(), "39"),
    PICKING(StockEnum.getMsgError(), "40"),
    SOLDOUTBOOK(StockEnum.getMsgInvoice(), "99"),
    SALE(StockEnum.getMsgRow(), "01"),
    UNKNOW(StockEnum.getMsgAge(), "00");

    private String name;
    private String val;
    private String localeid;

    private static String getMsgFaileds() {
        return ResManager.loadKDString((String)"\u6709\u8d27\uff1a\u73b0\u8d27-\u4e0b\u5355\u7acb\u5373\u53d1\u8d27", (String)"StockEnum_0", (String)"scm-common", (Object[])new Object[0]);
    }

    private static String getMsgMap() {
        return ResManager.loadKDString((String)"\u65e0\u8d27", (String)"StockEnum_1", (String)"scm-common", (Object[])new Object[0]);
    }

    private static String getMsgData() {
        return ResManager.loadKDString((String)"\u9884\u8ba2", (String)"StockEnum_2", (String)"scm-common", (Object[])new Object[0]);
    }

    private static String getMsgOperation() {
        return ResManager.loadKDString((String)"\u6709\u8d27\uff1a\u5728\u9014-\u6b63\u5728\u5185\u90e8\u914d\u8d27\uff0c\u9884\u8ba12~6\u5929\u5230\u8fbe\u672c\u4ed3\u5e93", (String)"StockEnum_3", (String)"scm-common", (Object[])new Object[0]);
    }

    private static String getMsgError() {
        return ResManager.loadKDString((String)"\u6709\u8d27\uff1a\u53ef\u914d\u8d27-\u4e0b\u5355\u540e\u4ece\u6709\u8d27\u4ed3\u5e93\u914d\u8d27", (String)"StockEnum_4", (String)"scm-common", (Object[])new Object[0]);
    }

    private static String getMsgInvoice() {
        return ResManager.loadKDString((String)"\u65e0\u8d27\u5f00\u9884\u5b9a", (String)"StockEnum_5", (String)"scm-common", (Object[])new Object[0]);
    }

    private static String getMsgRow() {
        return ResManager.loadKDString((String)"\u6709\u8d27", (String)"StockEnum_6", (String)"scm-common", (Object[])new Object[0]);
    }

    private static String getMsgAge() {
        return ResManager.loadKDString((String)"\u672a\u77e5", (String)"StockEnum_7", (String)"scm-common", (Object[])new Object[0]);
    }

    private String getEnumName(String val) {
        String name = "";
        switch (val) {
            case "33": {
                name = StockEnum.getMsgFaileds();
                break;
            }
            case "34": {
                name = StockEnum.getMsgMap();
                break;
            }
            case "36": {
                name = StockEnum.getMsgData();
                break;
            }
            case "39": {
                name = StockEnum.getMsgOperation();
                break;
            }
            case "40": {
                name = StockEnum.getMsgError();
                break;
            }
            case "90": {
                name = StockEnum.getMsgInvoice();
                break;
            }
            case "01": {
                name = StockEnum.getMsgRow();
                break;
            }
            case "00": {
                name = StockEnum.getMsgAge();
            }
        }
        return name;
    }

    private StockEnum(String name, String val) {
        this.name = name;
        this.val = val;
    }

    private StockEnum(String name, String val, String localeid) {
        this.name = name;
        this.val = val;
        this.localeid = localeid;
    }

    public String getName() {
        if (RequestContext.get().getLang().name().equals(this.localeid)) {
            return this.name;
        }
        return this.getEnumName(this.val);
    }

    public String getVal() {
        return this.val;
    }

    public String toString() {
        return this.name + ":" + this.val;
    }

    public StockEnum fromVal(String val) {
        for (StockEnum status : StockEnum.values()) {
            if (!val.equals(status.getVal())) continue;
            return status;
        }
        return UNKNOW;
    }
}

