/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.es.storage;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.lang.Lang;
import kd.scm.common.es.storage.EsDataType;
import kd.scm.common.es.storage.EsTokenizerType;

public class EsMappingProperty {
    String propertyName;
    EsDataType dataType;
    EsTokenizerType tokenizerType = EsTokenizerType.STANDARD;
    Lang lang;
    boolean withPinyin;
    long propertySize = 1024L;
    private String indexEntityNumber;
    private String mappingField;
    private boolean primaryKey;
    private BigDecimal boost;
    private String defaultValue;
    private final List<EsMappingProperty> nests = new ArrayList<EsMappingProperty>();

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String getIndexEntityNumber() {
        return this.indexEntityNumber;
    }

    public void setIndexEntityNumber(String indexEntityNumber) {
        this.indexEntityNumber = indexEntityNumber;
    }

    public String getMappingField() {
        return this.mappingField;
    }

    public void setMappingField(String mappingField) {
        this.mappingField = mappingField;
    }

    public BigDecimal getBoost() {
        return this.boost;
    }

    public void setBoost(BigDecimal boost) {
        this.boost = boost;
    }

    public void addNest(EsMappingProperty esMappingProperty) {
        this.nests.add(esMappingProperty);
    }

    public void addNests(List<EsMappingProperty> esMappingProperties) {
        this.nests.addAll(esMappingProperties);
    }

    public List<EsMappingProperty> getNests() {
        return this.nests;
    }

    public EsMappingProperty(String propertyName, Lang lang, boolean withPinyin) {
        this.propertyName = propertyName;
        this.dataType = EsDataType.STRING;
        this.lang = lang;
        this.withPinyin = withPinyin;
    }

    public EsMappingProperty(String propertyName, boolean withPinyin) {
        this.propertyName = propertyName;
        this.dataType = EsDataType.STRING;
        this.lang = null;
        this.withPinyin = withPinyin;
    }

    public EsMappingProperty(String propertyName, EsDataType dataType) {
        this.propertyName = propertyName;
        this.dataType = dataType;
        this.lang = null;
        this.withPinyin = false;
    }

    public EsMappingProperty(String propertyName, EsDataType dataType, EsTokenizerType tokenizerType) {
        this.propertyName = propertyName;
        this.dataType = dataType;
        this.lang = null;
        this.withPinyin = false;
        this.tokenizerType = tokenizerType;
    }

    public EsMappingProperty(String propertyName, EsDataType dataType, EsTokenizerType tokenizerType, boolean withPinyin) {
        this.propertyName = propertyName;
        this.dataType = dataType;
        this.lang = null;
        this.withPinyin = withPinyin;
        this.tokenizerType = tokenizerType;
    }

    public EsMappingProperty setTokenizerType(EsTokenizerType tokenizerType) {
        this.tokenizerType = tokenizerType;
        return this;
    }

    public void setDataType(EsDataType dataType) {
        this.dataType = dataType;
    }

    public EsMappingProperty setSize(long propertySize) {
        this.propertySize = propertySize > 32766L ? 32766L : propertySize;
        return this;
    }

    public long getPropertySize() {
        return this.propertySize;
    }

    public EsDataType getDataType() {
        return this.dataType;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Lang getLang() {
        return this.lang;
    }

    public boolean isWithPinyin() {
        return this.withPinyin;
    }

    public EsTokenizerType getTokenizerType() {
        return this.tokenizerType;
    }

    public String toString() {
        return "EsMappingProperty{propertyName='" + this.propertyName + '\'' + ", dataType=" + (Object)((Object)this.dataType) + ", tokenizerType=" + (Object)((Object)this.tokenizerType) + ", lang=" + this.lang + ", withPinyin=" + this.withPinyin + ", propertySize=" + this.propertySize + ", indexEntityNumber='" + this.indexEntityNumber + '\'' + ", mappingField='" + this.mappingField + '\'' + ", boost=" + this.boost + ", nests=" + this.nests + '}';
    }
}

