/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.es.storage.highlevel;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.scm.common.es.storage.BizEsErrorCode;
import kd.scm.common.es.storage.EsResultVo;
import kd.scm.common.es.storage.EsSortField;
import kd.scm.common.util.ExceptionUtil;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.GetMappingsResponse;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.NestedSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.elasticsearch.search.suggest.SuggestionBuilder;
import org.elasticsearch.search.suggest.completion.CompletionSuggestion;
import org.elasticsearch.search.suggest.completion.CompletionSuggestionBuilder;

public class EsAccess {
    private static final Log logger = LogFactory.getLog(EsAccess.class);
    private static final String RETRY_ON_CONFLICT_KEY = "fulltext.retryonconflict";
    private static final ErrorCode ioError = new ErrorCode("bos.dts IoError", "%s io error");
    private static final long MAX_BULK_SIZE = 10000000L;

    private EsAccess() {
    }

    public static boolean isIndexExist(RestHighLevelClient client, String index) {
        GetIndexRequest req = new GetIndexRequest(new String[]{index});
        try {
            return client.indices().exists(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BizEsErrorCode.esException, new Object[0]);
        }
    }

    public static void createIndex(RestHighLevelClient client, String index, Map<String, Object> settings) {
        CreateIndexRequest req = new CreateIndexRequest(index);
        req.settings(settings);
        try {
            client.indices().create(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BizEsErrorCode.esException, new Object[0]);
        }
    }

    public static Map<String, MappingMetaData> getIndexMapping(RestHighLevelClient client, String ... indices) {
        GetMappingsRequest req = new GetMappingsRequest().indices(indices);
        try {
            GetMappingsResponse res = client.indices().getMapping(req, RequestOptions.DEFAULT);
            return res.mappings();
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BizEsErrorCode.esException, new Object[0]);
        }
    }

    public static void createIndexMapping(RestHighLevelClient client, String index, String type, XContentBuilder fieldsMapping) {
        PutMappingRequest req = new PutMappingRequest(new String[]{index});
        req.type(type);
        req.source(fieldsMapping);
        AcknowledgedResponse res = null;
        try {
            logger.info("createIndexMapping:" + req.source());
            res = client.indices().putMapping(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BizEsErrorCode.esException, new Object[0]);
        }
        if (!res.isAcknowledged()) {
            StringBuilder msg = new StringBuilder("Failed to create index:").append(index).append(res);
            throw new KDException(BizEsErrorCode.esException, new Object[]{msg});
        }
    }

    public static Map<String, Object> getIndexSettings(RestHighLevelClient client, String[] indexs) {
        try {
            GetSettingsResponse settings = client.indices().getSettings(new GetSettingsRequest().indices(indexs), RequestOptions.DEFAULT);
            return JSON.parseObject((String)settings.toString());
        }
        catch (IOException e) {
            logger.warn("kd.scm.common.es.storage.highlevel.EsAccess#getIndexSettings:" + ExceptionUtil.getStackTrace(e));
            throw new KDBizException(e.getMessage());
        }
    }

    public static void updateIndexSettings(RestHighLevelClient client, String[] indexs, Map<String, Object> indexSettings) {
        String shardsNum = "number_of_shards";
        indexSettings.remove(shardsNum);
        UpdateSettingsRequest req = new UpdateSettingsRequest(indexs);
        req.settings(indexSettings);
        AcknowledgedResponse res = null;
        try {
            res = client.indices().putSettings(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BizEsErrorCode.esException, new Object[0]);
        }
        if (!res.isAcknowledged()) {
            StringBuilder msg = new StringBuilder("failed to update indexs settings:").append(res);
            throw new KDException(BizEsErrorCode.esException, new Object[]{msg});
        }
    }

    public static List<BulkItemResponse> batchSave(RestHighLevelClient client, String index, String type, List<Map<String, Object>> listMap) {
        if (CollectionUtils.isEmpty(listMap)) {
            return new ArrayList<BulkItemResponse>();
        }
        BulkRequest req = new BulkRequest();
        req.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        ArrayList<BulkRequest> listBulkRequest = new ArrayList<BulkRequest>();
        int count = 0;
        Object id = null;
        for (Map<String, Object> map : listMap) {
            id = map.get("_id");
            map.remove("_id", id);
            IndexRequest indexRequest = new IndexRequest(index, type, String.valueOf(id)).source(map);
            UpdateRequest updateRequest = new UpdateRequest(index, type, String.valueOf(id)).upsert(indexRequest);
            updateRequest.doc(indexRequest);
            updateRequest.retryOnConflict(Integer.parseInt(System.getProperty(RETRY_ON_CONFLICT_KEY, "5")));
            req.add(updateRequest);
            long size = req.estimatedSizeInBytes();
            ++count;
            if (size < 10000000L) continue;
            listBulkRequest.add(req);
            count = 0;
            req = new BulkRequest();
            req.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        }
        if (count > 0) {
            listBulkRequest.add(req);
        }
        ArrayList<BulkItemResponse> failureRes = new ArrayList<BulkItemResponse>();
        BulkResponse res = null;
        for (BulkRequest bulkRequest : listBulkRequest) {
            try {
                res = client.bulk(bulkRequest, RequestOptions.DEFAULT);
                logger.info("ES batch save data success! index name: {}, last line of batch data id: {}, batch size: {}", new Object[]{index, String.valueOf(id), String.valueOf(listMap.size())});
            }
            catch (IOException e) {
                logger.error("ES batch save data failure! index name: {}, last line of batch data id: {}, batch size: {}", new Object[]{index, String.valueOf(id), String.valueOf(listMap.size())});
                throw new KDException((Throwable)e, BizEsErrorCode.esException, new Object[0]);
            }
            if (!res.hasFailures()) continue;
            for (BulkItemResponse resp : res.getItems()) {
                if (!resp.isFailed()) continue;
                failureRes.add(resp);
            }
        }
        return failureRes;
    }

    public static List<BulkItemResponse> batchUpdate(RestHighLevelClient client, String index, String type, List<Map<String, Object>> listMap) {
        if (CollectionUtils.isEmpty(listMap)) {
            return new ArrayList<BulkItemResponse>();
        }
        BulkRequest req = new BulkRequest();
        req.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        ArrayList<BulkRequest> listBulkRequest = new ArrayList<BulkRequest>();
        int count = 0;
        Object id = null;
        for (Map<String, Object> map : listMap) {
            id = map.get("_id");
            UpdateRequest updateRequest = new UpdateRequest(index, type, String.valueOf(id));
            map.remove("_id", id);
            updateRequest.doc(map);
            updateRequest.docAsUpsert(false);
            updateRequest.scriptedUpsert(false);
            updateRequest.retryOnConflict(Integer.parseInt(System.getProperty(RETRY_ON_CONFLICT_KEY, "5")));
            req.add(updateRequest);
            long size = req.estimatedSizeInBytes();
            ++count;
            if (size < 10000000L) continue;
            listBulkRequest.add(req);
            count = 0;
            req = new BulkRequest();
            req.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        }
        if (count > 0) {
            listBulkRequest.add(req);
        }
        ArrayList<BulkItemResponse> failureRes = new ArrayList<BulkItemResponse>();
        BulkResponse res = null;
        for (BulkRequest bulkRequest : listBulkRequest) {
            try {
                res = client.bulk(bulkRequest, RequestOptions.DEFAULT);
                logger.info("ES batch update data success! index name: {}, last line of batch data id: {}, batch size: {}", new Object[]{index, String.valueOf(id), String.valueOf(listMap.size())});
            }
            catch (IOException e) {
                logger.error("ES batch update data failure! index name: {}, last line of batch data id: {}, batch size: {}", new Object[]{index, String.valueOf(id), String.valueOf(listMap.size())});
                throw new KDException((Throwable)e, BizEsErrorCode.esException, new Object[0]);
            }
            if (!res.hasFailures()) continue;
            for (BulkItemResponse resp : res.getItems()) {
                if (!resp.isFailed()) continue;
                failureRes.add(resp);
            }
        }
        return failureRes;
    }

    public static long updateByQuery(RestHighLevelClient client, String index, String type, QueryBuilder filterQb, Map<String, Object> updateData) {
        BulkByScrollResponse res;
        UpdateByQueryRequest req = new UpdateByQueryRequest(new String[]{index});
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        queryBuilder.must((QueryBuilder)QueryBuilders.typeQuery((String)type));
        queryBuilder.must(filterQb);
        req.setQuery((QueryBuilder)queryBuilder);
        int upFlag = 0;
        int upSize = updateData.size();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : updateData.entrySet()) {
            String key = entry.getKey();
            sb.append("ctx._source.").append(key).append(" = params.").append(key);
            if (++upFlag >= upSize) continue;
            sb.append(';');
        }
        ((UpdateByQueryRequest)((UpdateByQueryRequest)req.setScript(new Script(ScriptType.INLINE, "painless", sb.toString(), updateData))).setRefresh(true)).indices(new String[]{index});
        try {
            res = client.updateByQuery(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BizEsErrorCode.esException, new Object[0]);
        }
        return res.getUpdated();
    }

    public static long deleteByQuery(RestHighLevelClient client, String index, String type, QueryBuilder filterQb) {
        DeleteByQueryRequest req = new DeleteByQueryRequest(new String[]{index});
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        queryBuilder.must((QueryBuilder)QueryBuilders.typeQuery((String)type));
        queryBuilder.must(filterQb);
        ((DeleteByQueryRequest)req.setQuery((QueryBuilder)queryBuilder).setRefresh(true)).indices(new String[]{index});
        BulkByScrollResponse res = null;
        try {
            res = client.deleteByQuery(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BizEsErrorCode.esException, new Object[0]);
        }
        return res.getDeleted();
    }

    public static void bulkDelete(RestHighLevelClient client, String index, String type, List<String> docIdList) {
        BulkRequest bulkRequest = new BulkRequest();
        for (String docId : docIdList) {
            DeleteRequest deleteRequest = new DeleteRequest(index, type, docId);
            bulkRequest.add(deleteRequest);
        }
        try {
            BulkResponse bulkResponse = client.bulk(bulkRequest, RequestOptions.DEFAULT);
            if (bulkResponse.hasFailures()) {
                logger.warn("bulk fail,message:" + bulkResponse.buildFailureMessage());
                throw new KDBizException(bulkResponse.buildFailureMessage());
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BizEsErrorCode.esException, new Object[0]);
        }
    }

    public static void refreshIndex(RestHighLevelClient client, String index) {
        RefreshRequest req = new RefreshRequest(new String[]{index});
        try {
            RefreshResponse refreshResponse = client.indices().refresh(req, RequestOptions.DEFAULT);
            if (refreshResponse.getFailedShards() > 0) {
                StringBuilder msg = new StringBuilder("refresh failed:").append(refreshResponse);
                throw new KDException(BizEsErrorCode.esException, new Object[]{msg});
            }
        }
        catch (IOException e) {
            throw new KDException(BizEsErrorCode.esException, new Object[]{e});
        }
    }

    public static EsResultVo query(RestHighLevelClient client, String index, String type, String[] selectFields, QueryBuilder filterQb, EsSortField[] sortFields, List<AggregationBuilder> aggregationBuilders, int start, int size, Object[] objSortValues) {
        SearchHit[] hits = EsAccess.querySearchHits(client, index, type, selectFields, filterQb, sortFields, aggregationBuilders, start, size, objSortValues);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        for (SearchHit hit : hits) {
            result.add(hit.getSourceAsMap());
        }
        Object[] objSortValuesResult = null;
        if (hits.length > 0) {
            objSortValuesResult = hits[hits.length - 1].getSortValues();
        }
        EsResultVo esResultVo = new EsResultVo();
        esResultVo.setResultData(result);
        esResultVo.setObjSortValues(objSortValuesResult);
        return esResultVo;
    }

    private static SearchHit[] querySearchHits(RestHighLevelClient client, String index, String type, String[] selectFields, QueryBuilder filterQb, EsSortField[] sortFields, List<AggregationBuilder> aggregationBuilders, int start, int size, Object[] objSortValues) {
        SearchResponse searchResponse = EsAccess.search(client, index, type, selectFields, filterQb, sortFields, aggregationBuilders, start, size, objSortValues);
        return searchResponse.getHits().getHits();
    }

    public static SearchResponse search(RestHighLevelClient client, String index, String type, String[] selectFields, QueryBuilder filterQb, EsSortField[] sortFields, List<AggregationBuilder> aggregationBuilders, int start, int size, Object[] objSortValues) {
        Object queryBuilder = null;
        queryBuilder = null == filterQb ? QueryBuilders.matchAllQuery() : filterQb;
        SearchRequest req = new SearchRequest(new String[]{index});
        if (StringUtils.isNotEmpty((String)type)) {
            req.types(new String[]{type});
        }
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)queryBuilder).from(start).size(size).fetchSource(selectFields, null);
        if (objSortValues != null) {
            sourceBuilder.searchAfter(objSortValues);
        }
        EsAccess.sort(sortFields, sourceBuilder);
        EsAccess.aggs(aggregationBuilders, sourceBuilder);
        logger.info("kd.scm.common.es.storage.highlevel.EsAccess.search.dsl:" + sourceBuilder);
        req.source(sourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = client.search(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException(BizEsErrorCode.esException, new Object[]{e});
        }
        return searchResponse;
    }

    private static void sort(EsSortField[] sortFields, SearchSourceBuilder builder) {
        if (sortFields == null || sortFields.length == 0) {
            return;
        }
        for (EsSortField info : sortFields) {
            FieldSortBuilder sortBuilderOrder;
            FieldSortBuilder sortBuilderOrder2;
            NestedSortBuilder nestedSort;
            if (null == info) continue;
            if (info.isAsc()) {
                if (!StringUtils.isBlank((String)info.getPath())) {
                    nestedSort = new NestedSortBuilder(info.getPath());
                    sortBuilderOrder2 = ((FieldSortBuilder)SortBuilders.fieldSort((String)info.getName()).order(SortOrder.ASC)).setNestedSort(nestedSort).missing((Object)"_first");
                    builder.sort((SortBuilder)sortBuilderOrder2);
                    continue;
                }
                sortBuilderOrder = ((FieldSortBuilder)SortBuilders.fieldSort((String)info.getName()).order(SortOrder.ASC)).missing((Object)"_first");
                builder.sort((SortBuilder)sortBuilderOrder);
                continue;
            }
            if (!StringUtils.isBlank((String)info.getPath())) {
                nestedSort = new NestedSortBuilder(info.getPath());
                sortBuilderOrder2 = ((FieldSortBuilder)SortBuilders.fieldSort((String)info.getName()).order(SortOrder.DESC)).setNestedSort(nestedSort).missing((Object)"_last");
                builder.sort((SortBuilder)sortBuilderOrder2);
                continue;
            }
            sortBuilderOrder = ((FieldSortBuilder)SortBuilders.fieldSort((String)info.getName()).order(SortOrder.DESC)).missing((Object)"_last");
            builder.sort((SortBuilder)sortBuilderOrder);
        }
    }

    private static void aggs(List<AggregationBuilder> aggregationBuilders, SearchSourceBuilder sourceBuilder) {
        for (AggregationBuilder aggregationBuilder : aggregationBuilders) {
            sourceBuilder.aggregation(aggregationBuilder);
        }
    }

    public static List<Map<String, Object>> queryHighLight(RestHighLevelClient client, String index, String type, String[] selectFields, QueryBuilder filterQB, EsSortField[] sortFields, boolean score, String preTag, String postTag, int start, int size) {
        ConstantScoreQueryBuilder queryBuilder = QueryBuilders.constantScoreQuery((QueryBuilder)filterQB);
        SearchRequest req = new SearchRequest(new String[]{index});
        if (StringUtils.isNotEmpty((String)type)) {
            req.types(new String[]{type});
        }
        SearchSourceBuilder ssb = new SearchSourceBuilder();
        ssb.query((QueryBuilder)queryBuilder).from(start).size(size).fetchSource(selectFields, null);
        EsAccess.sort(sortFields, ssb);
        List<String> highLightFields = EsAccess.highLighMatch(selectFields, preTag, postTag, ssb);
        req.source(ssb);
        SearchResponse searchResponse = null;
        try {
            searchResponse = client.search(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException(BizEsErrorCode.esException, new Object[]{e});
        }
        return EsAccess.queryResult(type, highLightFields, searchResponse);
    }

    private static List<Map<String, Object>> queryResult(String type, List<String> highLightFields, SearchResponse searchResponse) {
        SearchHit[] hits = searchResponse.getHits().getHits();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        for (SearchHit hit : hits) {
            Map source = hit.getSourceAsMap();
            Map highlightFields = hit.getHighlightFields();
            for (String field : highLightFields) {
                HighlightField nameField = (HighlightField)highlightFields.get(field);
                if (nameField == null) continue;
                Text[] fragments = nameField.fragments();
                StringBuilder nameTmp = new StringBuilder();
                for (Text text : fragments) {
                    nameTmp.append(text);
                }
                source.put(field, nameTmp);
            }
            result.add(source);
        }
        return result;
    }

    private static List<String> highLighMatch(String[] selectFields, String preTag, String postTag, SearchSourceBuilder ssb) {
        ArrayList<String> highLightFields = new ArrayList<String>(Arrays.asList(selectFields));
        HighlightBuilder hb = new HighlightBuilder();
        ((HighlightBuilder)hb.preTags(new String[]{preTag})).postTags(new String[]{postTag});
        for (String field : highLightFields) {
            hb.field(field);
        }
        ssb.highlighter(hb);
        return highLightFields;
    }

    public static long getCount(RestHighLevelClient client, String index, String type, QueryBuilder filterQb) {
        Object queryBuilder = null;
        queryBuilder = null == filterQb ? QueryBuilders.matchAllQuery() : QueryBuilders.constantScoreQuery((QueryBuilder)filterQb);
        SearchRequest req = new SearchRequest(new String[]{index});
        if (StringUtils.isNotEmpty((String)type)) {
            req.types(new String[]{type});
        }
        SearchSourceBuilder builder = new SearchSourceBuilder();
        builder.query((QueryBuilder)queryBuilder).size(0);
        req.source(builder);
        try {
            SearchResponse searchResponse = client.search(req, RequestOptions.DEFAULT);
            return searchResponse.getHits().getTotalHits();
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BizEsErrorCode.esException, new Object[0]);
        }
    }

    public static boolean deleteIndex(RestHighLevelClient client, String indexName) {
        DeleteIndexRequest request = new DeleteIndexRequest(indexName);
        request.timeout(TimeValue.timeValueMinutes((long)5L));
        request.masterNodeTimeout(TimeValue.timeValueMinutes((long)1L));
        request.indicesOptions(IndicesOptions.lenientExpandOpen());
        try {
            AcknowledgedResponse deleteIndexResponse = client.indices().delete(request, RequestOptions.DEFAULT);
            return deleteIndexResponse.isAcknowledged();
        }
        catch (ElasticsearchException exception) {
            if (exception.status() == RestStatus.NOT_FOUND) {
                logger.warn("HighLevelAccess not found deleteIndex: " + indexName);
            }
            throw new KDException((Throwable)exception, ioError, new Object[]{"deleteIndex error"});
        }
        catch (IOException exception) {
            throw new KDException((Throwable)exception, ioError, new Object[]{"deleteIndex error"});
        }
        return false;
    }

    public static List<String> suggest(RestHighLevelClient client, String index, String type, CompletionSuggestionBuilder completionSuggestionBuilder) {
        ArrayList<String> res = new ArrayList<String>();
        SuggestBuilder suggestBuilder = new SuggestBuilder().addSuggestion(completionSuggestionBuilder.field() + "suggest", (SuggestionBuilder)completionSuggestionBuilder);
        SearchSourceBuilder builder = new SearchSourceBuilder();
        builder.suggest(suggestBuilder);
        SearchRequest req = new SearchRequest(new String[]{index});
        if (StringUtils.isNotEmpty((String)type)) {
            req.types(new String[]{type});
        }
        logger.info("kd.scm.common.es.storage.highlevel.EsAccess.suggest.dsl:" + builder);
        req.source(builder);
        try {
            CompletionSuggestion.Entry entry;
            List options;
            Object suggestObject;
            SearchResponse suggestResponse = client.search(req, RequestOptions.DEFAULT);
            Suggest suggest = suggestResponse.getSuggest();
            Suggest.Suggestion suggestSuggestion = suggest.getSuggestion(completionSuggestionBuilder.field() + "suggest");
            List entries = suggestSuggestion.getEntries();
            if (entries.size() > 0 && (suggestObject = entries.get(0)) instanceof CompletionSuggestion.Entry && (options = (entry = (CompletionSuggestion.Entry)suggestObject).getOptions()).size() > 0) {
                for (CompletionSuggestion.Entry.Option option : options) {
                    res.add(option.getText().toString());
                }
            }
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BizEsErrorCode.esException, new Object[0]);
        }
        return res;
    }
}

