/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.extension;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Pattern;
import kd.bos.extension.Holder;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.scm.common.extension.DefaultExtension;
import kd.scm.common.extension.ExtensionItem;
import kd.scm.common.extension.IExtensionClassesProvider;
import kd.scm.common.extension.InternalExtensionClassesProvider;
import kd.scm.common.util.ExceptionUtil;

public class ScmExtensionFactory<T> {
    private static final Log log = LogFactory.getLog(ScmExtensionFactory.class);
    private static final String EXTENSION_DIRECTORY = "META-INF/kd/scm/extension/";
    private static final ConcurrentMap<Class<?>, ScmExtensionFactory<?>> EXTENSION_FACTORYS = new ConcurrentHashMap();
    private Class<?> type;
    private final Holder<Map<String, Class<?>>> cachedClasses = new Holder();
    private final ConcurrentMap<String, Holder<Object>> cachedInstances = new ConcurrentHashMap<String, Holder<Object>>();
    private static final ConcurrentMap<Class<?>, Object> EXTENSION_INSTANCES = new ConcurrentHashMap();
    private Set<Class<?>> cachedWrapperClasses;
    private String cachedDefaultName;
    private static final Pattern NAME_SEPARATOR = Pattern.compile("\\s*[,]+\\s*");

    private ScmExtensionFactory(Class<?> type) {
        this.type = type;
    }

    public static <T> ScmExtensionFactory<T> getExtensionFacotry(Class<T> type) {
        ScmExtensionFactory<T> extensionFactory = (ScmExtensionFactory<T>)EXTENSION_FACTORYS.get(type);
        if (extensionFactory == null) {
            extensionFactory = new ScmExtensionFactory<T>(type);
            EXTENSION_FACTORYS.put(type, extensionFactory);
        }
        return extensionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getExtension(String name) {
        Holder<Object> holder = this.cachedInstances.getOrDefault(name, (Holder<Object>)new Holder());
        this.cachedInstances.putIfAbsent(name, holder);
        Object instance = holder.get();
        if (instance == null) {
            Holder<Object> holder2 = holder;
            synchronized (holder2) {
                instance = this.createExtension(name);
                holder.set(instance);
            }
        }
        return (T)holder.get();
    }

    public T getExtension(String name, boolean fromCache) {
        if (fromCache) {
            return this.getExtension(name);
        }
        Class<?> clazz = this.getExtensionClasses().get(name);
        if (clazz == null) {
            throw new RuntimeException("can't find class for name " + name);
        }
        try {
            return (T)clazz.newInstance();
        }
        catch (Throwable t) {
            throw new IllegalStateException("Extension instance(name: " + name + ", class: " + this.type + ")  could not be instantiated: " + t.getMessage(), t);
        }
    }

    public static void clearCache() {
        EXTENSION_FACTORYS.clear();
    }

    public T getDefaultExtension() {
        this.getExtensionClasses();
        if (StringUtils.isEmpty((String)this.cachedDefaultName) || StringUtils.isBlank((String)this.cachedDefaultName)) {
            return null;
        }
        return this.getExtension(this.cachedDefaultName);
    }

    private void cacheDefaultExtensionName() {
        DefaultExtension defaultAnnotation = this.type.getAnnotation(DefaultExtension.class);
        if (defaultAnnotation != null) {
            String value = defaultAnnotation.value();
            if ((value = value.trim()).length() > 0) {
                Object[] names = NAME_SEPARATOR.split(value);
                if (names.length > 1) {
                    throw new IllegalStateException("More than 1 default extension name on extension " + this.type.getName() + ": " + Arrays.toString(names));
                }
                if (names.length == 1) {
                    this.cachedDefaultName = names[0];
                }
            }
        }
    }

    public boolean existsExtension(String name) {
        Class<?> clazz = this.getExtensionClasses().get(name);
        return clazz != null;
    }

    private T createExtension(String name) {
        Class<?> clazz = this.getExtensionClasses().get(name);
        if (clazz == null) {
            throw new RuntimeException("can't find class for extention " + this.type.getName() + "/" + name);
        }
        try {
            Set<Class<?>> wrapperClasses;
            Object instance = EXTENSION_INSTANCES.getOrDefault(clazz, clazz.newInstance());
            if (instance == null) {
                instance = clazz.newInstance();
                EXTENSION_INSTANCES.putIfAbsent(clazz, instance);
            }
            if ((wrapperClasses = this.cachedWrapperClasses) != null && wrapperClasses.size() > 0) {
                for (Class<?> wrapperClass : wrapperClasses) {
                    instance = wrapperClass.getConstructor(this.type).newInstance(instance);
                }
            }
            return (T)instance;
        }
        catch (Throwable t) {
            throw new IllegalStateException("Extension instance(name: " + name + ", class: " + this.type + ")  could not be instantiated: " + t.getMessage(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Class<?>> getExtensionClasses() {
        Map<String, Class<?>> classes = (Map<String, Class<?>>)this.cachedClasses.get();
        if (classes == null) {
            Holder<Map<String, Class<?>>> holder = this.cachedClasses;
            synchronized (holder) {
                classes = this.loadExtensionClasses();
                this.cachedClasses.set(classes);
            }
        }
        return classes;
    }

    private Map<String, Class<?>> loadExtensionClasses() {
        this.cacheDefaultExtensionName();
        HashMap extensionClasses = new HashMap();
        this.loadFile(extensionClasses, EXTENSION_DIRECTORY);
        List<IExtensionClassesProvider> extensionClassesProviders = ScmExtensionFactory.getExtensionFacotry(IExtensionClassesProvider.class).getLoadedExtensions();
        extensionClassesProviders.add(new InternalExtensionClassesProvider());
        for (IExtensionClassesProvider extensionClassesProvider : extensionClassesProviders) {
            ExtensionItem extensionItem = extensionClassesProvider.loadExtensionClasses(this.type.getName());
            this.batchLoadResources(extensionClasses, extensionItem.getExtensionClasses());
            if (StringUtils.isEmpty((String)extensionItem.getDefaultKey())) continue;
            this.cachedDefaultName = extensionItem.getDefaultKey();
        }
        return extensionClasses;
    }

    public List<T> getLoadedExtensions() {
        ArrayList<T> res = new ArrayList<T>(16);
        for (String key : this.getLoadedExtensionKeys()) {
            res.add(this.getExtension(key));
        }
        return res;
    }

    public Set<String> getLoadedExtensionKeys() {
        return Collections.unmodifiableSet(new TreeSet(this.cachedInstances.keySet()));
    }

    private static ClassLoader findClassLoader() {
        return ScmExtensionFactory.class.getClassLoader();
    }

    private void loadFile(Map<String, Class<?>> extensionClasses, String dir) {
        block17: {
            String fileName = dir + this.type.getName();
            try {
                ClassLoader classLoader = ScmExtensionFactory.findClassLoader();
                Enumeration<URL> urls = classLoader != null ? classLoader.getResources(fileName) : ClassLoader.getSystemResources(fileName);
                if (urls == null) break block17;
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    log.info("load extension class from " + url);
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
                        Throwable throwable = null;
                        try {
                            String line;
                            while ((line = reader.readLine()) != null) {
                                int ci = line.indexOf(35);
                                if (ci >= 0 || (line = line.trim()).length() <= 0) continue;
                                String name = null;
                                int i = line.indexOf(61);
                                if (i > 0) {
                                    name = line.substring(0, i).trim();
                                    line = line.substring(i + 1).trim();
                                }
                                if (line.length() <= 0) continue;
                                this.loadResource(extensionClasses, line, name);
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            reader.close();
                        }
                    }
                    catch (Throwable t) {
                        log.warn("Exception when load extension class(interface: " + this.type + ", class file: " + url + ") in " + url + ", message:" + t.getMessage(), t);
                    }
                }
            }
            catch (Throwable t) {
                log.warn("Exception when load extension class(interface: " + this.type + ", description file: " + fileName + ").", t);
            }
        }
    }

    private void loadResource(Map<String, Class<?>> extensionClasses, String name, String interfaceFullName) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(interfaceFullName, true, ScmExtensionFactory.findClassLoader());
            if (StringUtils.isEmpty((String)name)) {
                name = interfaceFullName.substring(interfaceFullName.lastIndexOf(".") + 1);
            }
            try {
                clazz.getConstructor(this.type);
                Set<Class<?>> wrappers = this.cachedWrapperClasses;
                if (wrappers == null) {
                    this.cachedWrapperClasses = new CopyOnWriteArraySet();
                    wrappers = this.cachedWrapperClasses;
                }
                wrappers.add(clazz);
            }
            catch (NoSuchMethodException e) {
                Class<?> c = extensionClasses.get(name);
                if (c == null) {
                    extensionClasses.put(name, clazz);
                } else if (c != clazz) {
                    throw new IllegalStateException("Duplicate extension " + this.type.getName() + " name " + name + " on " + c.getName() + " and " + clazz.getName(), e);
                }
            }
        }
        catch (ClassNotFoundException e) {
            log.warn(ExceptionUtil.getStackTrace(e));
        }
    }

    private void batchLoadResources(Map<String, Class<?>> extensionClasses, Map<String, String> keyImplMap) {
        for (Map.Entry<String, String> entry : keyImplMap.entrySet()) {
            this.loadResource(extensionClasses, entry.getKey(), entry.getValue());
        }
    }

    public static String viewCache() {
        return "instance:" + Instance.getInstanceId() + "\r\n" + EXTENSION_FACTORYS;
    }

    public String toString() {
        return "ScmExtensionFactory{type=" + this.type + ", cachedClasses=" + this.cachedClasses.get() + ", cachedInstances=" + this.cachedInstances + ", cachedWrapperClasses=" + this.cachedWrapperClasses + ", cachedDefaultName='" + this.cachedDefaultName + '\'' + '}';
    }
}

