/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.operate.botp.Push;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.form.CustomBotpExcutor;
import kd.scm.common.form.CustomBotpSourceBill;

public class PbdBotpSwitchFun {
    public static final char STANDARD = '1';
    public static final char PBD_BOTP = '2';
    public static final char UN_KNOW = '3';
    public static final char NO_NORMAL = '4';
    private List<CustomBotpSourceBill> sourceBills = new ArrayList<CustomBotpSourceBill>(1);

    protected char isNormalPush(Push push) {
        boolean souApplyBotp = QueryServiceHelper.exists((String)"pur_updateparamconfig", (QFilter[])new QFilter[]{new QFilter("paramkey", "=", (Object)"souApplyBotp").and(new QFilter("paramvalue", "=", (Object)"Y"))});
        if (push != null && souApplyBotp) {
            IFormView view = push.getView();
            ListSelectedRowCollection rows = new ListSelectedRowCollection();
            if (view instanceof IListView) {
                ListSelectedRowCollection selectedRows = ((IListView)view).getSelectedRows();
                rows.addAll((Collection)selectedRows);
            } else if (view instanceof IBillView) {
                IBillView billView = (IBillView)view;
                IBillModel billModel = (IBillModel)billView.getModel();
                ListSelectedRow row = new ListSelectedRow(billModel.getPKValue(), Boolean.valueOf(true));
                rows.add((Object)row);
            }
            if (rows.size() > 0) {
                return this.normalTargetRows(push, rows);
            }
        }
        return '1';
    }

    protected char normalTargetRows(Push push, ListSelectedRowCollection rows) {
        Map<String, Boolean> resultMap = this.validateSourceData(rows);
        Boolean flag = resultMap.get("flag");
        Boolean flag1 = resultMap.get("flag1");
        Boolean noformal = resultMap.get("noformal");
        if (noformal != null && noformal.booleanValue()) {
            return '4';
        }
        if (flag.booleanValue() && flag1.booleanValue()) {
            return '3';
        }
        if (!flag.booleanValue() && flag1.booleanValue()) {
            Map parameter = push.getParameter();
            CustomBotpSourceBill customBotpSourceBill = new CustomBotpSourceBill();
            customBotpSourceBill.setSourceBill("pm_purapplybill");
            customBotpSourceBill.setTargetBill("pm_purorderbill");
            this.addCustomBotpSourceBill(customBotpSourceBill);
            if (parameter != null) {
                List<CustomBotpSourceBill> customBotpSourceBills = this.getSourceBills();
                parameter.put("customBotpSourceBills", customBotpSourceBills);
            }
            return '2';
        }
        return '1';
    }

    private Map<String, Boolean> validateSourceData(ListSelectedRowCollection rows) {
        HashMap<String, Character> wholeBill = new HashMap<String, Character>();
        HashSet<Object> pramaryKeys = new HashSet<Object>();
        HashMap<String, Character> entityKeys = new HashMap<String, Character>();
        CustomBotpExcutor.fillWholeAndEntityKeys(pramaryKeys, wholeBill, entityKeys, (List<ListSelectedRow>)rows);
        return this.getSourceDataFromDb(pramaryKeys, wholeBill, entityKeys);
    }

    protected Map<String, Boolean> getSourceDataFromDb(Set<Object> pramaryKeys, Map<String, Character> wholeBill, Map<String, Character> entityKeys) {
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(2);
        resultMap.put("flag", Boolean.FALSE);
        resultMap.put("flag1", Boolean.FALSE);
        DynamicObjectCollection storeRows = QueryServiceHelper.query((String)"sou_compare", (String)"id,materialentry.id,materialentry.prentryid,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", pramaryKeys)});
        for (DynamicObject row : storeRows) {
            this.dealResultMap(wholeBill, row, "id", "materialentry.prentryid", resultMap);
            this.dealResultMap(entityKeys, row, "materialentry.id", "materialentry.prentryid", resultMap);
        }
        return resultMap;
    }

    protected void dealResultMap(Map<String, Character> wholeBill, DynamicObject row, String idstr, String prentryid, Map<String, Boolean> resultMap) {
        Character id = wholeBill.get(row.getString(idstr));
        if (id != null) {
            if (StringUtils.isBlank((CharSequence)row.getString(prentryid))) {
                resultMap.put("flag", Boolean.TRUE);
            } else {
                resultMap.put("flag1", Boolean.TRUE);
            }
            if (!StringUtils.equals((CharSequence)"C", (CharSequence)row.getString("billstatus"))) {
                resultMap.put("noformal", Boolean.TRUE);
            }
        }
    }

    public void addCustomBotpSourceBill(CustomBotpSourceBill customBotpSourceBill) {
        this.sourceBills.add(customBotpSourceBill);
    }

    public List<CustomBotpSourceBill> getSourceBills() {
        return this.sourceBills;
    }
}

