/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillView;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertBill;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOpParameter;
import kd.bos.entity.botp.runtime.ConvertOpProgressCache;
import kd.bos.entity.botp.runtime.ConvertOpRule;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.botp.runtime.GetTargetOptionalOrgsArgs;
import kd.bos.entity.botp.runtime.GetTargetOptionalOrgsResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.Plugin;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.botp.ReleaseConvertDataMutexPlugin;
import kd.bos.lang.Lang;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.scm.common.form.CustomBotpExcutor;
import kd.scm.common.form.CustomBotpSourceBill;

public class ScmPushConvertEdit
extends AbstractFormPlugin {
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    public static final String CustParam_OpParam = "opparam";
    private static final String KEY_FBILL = "fbill";
    private static final String KEY_FRULE = "frule";
    private static final String KEY_FRELATIONORG = "frelationorg";
    private static final String KEY_SHOWREPORT = "showreport";
    private static final String KEY_OUTFORMULA = "outformula";
    private static final String KEY_OK = "btnok";
    private static final String CLOSECALLACTIONID_DRAW = "draw";
    private static final String CLOSECALLACTIONID_CONVERTPROGRESS = "convertprogress";
    private static final String ALLRULE = "@all";
    private ConvertOpParameter opParameter;

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_OK});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.fillBillCombo();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getConvertOpParamter().getOpType().compareTo((Enum)ConvertOpType.Push) != 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_SHOWREPORT, KEY_OUTFORMULA});
        }
    }

    public void click(EventObject evt) {
        ConvertOpParameter opParameter;
        super.click(evt);
        Control srcCtrl = (Control)evt.getSource();
        if (KEY_OK.equalsIgnoreCase(srcCtrl.getKey()) && (opParameter = this.getConvertOpParamter()).getOpType() == ConvertOpType.Push) {
            this.doPush(opParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equalsIgnoreCase(KEY_FBILL)) {
            this.fillRuleCombo(null);
            this.fillOrgCombo(null);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equalsIgnoreCase(CLOSECALLACTIONID_DRAW)) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            this.doDraw(rows);
        } else if (closedCallBackEvent.getActionId().equalsIgnoreCase(CLOSECALLACTIONID_CONVERTPROGRESS)) {
            String taskId = (String)closedCallBackEvent.getReturnData();
            this.showPushBigDataResult(taskId);
        }
    }

    private void doPush(ConvertOpParameter opParameter) {
        String targetEntityNumber = (String)this.getModel().getValue(KEY_FBILL);
        String ruleId = (String)this.getModel().getValue(KEY_FRULE);
        String defOrgId = (String)this.getModel().getValue(KEY_FRELATIONORG);
        Boolean showReport = (Boolean)this.getModel().getValue(KEY_SHOWREPORT);
        PushArgs args = new PushArgs();
        if (StringUtils.isNotBlank((CharSequence)opParameter.getAppId())) {
            args.setAppId(opParameter.getAppId());
        } else {
            args.setAppId(this.getView().getFormShowParameter().getCheckRightAppId());
        }
        args.setSourceEntityNumber(opParameter.getEntityNumber());
        args.setTargetEntityNumber(targetEntityNumber);
        args.setHasRight(opParameter.isHasRight());
        args.addCustomParam("botp_requiredatamutex", String.valueOf(true));
        args.setAutoSave(true);
        for (ConvertBill bill : opParameter.getBills()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)targetEntityNumber, (CharSequence)bill.getEntityNumber())) continue;
            for (ConvertOpRule rule : bill.getRules()) {
                args.getRuleIds().add(rule.getRuleId());
            }
        }
        if (!ALLRULE.equals(ruleId)) {
            args.setRuleId(ruleId);
        } else if (this.getConvertOpParamter().isMustSelectRule()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8f6c\u6362\u89c4\u5219\uff01", (String)"ConvertOpFormEdit_5", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        if (!StringUtils.isBlank((CharSequence)defOrgId) && !StringUtils.equals((CharSequence)"0", (CharSequence)defOrgId)) {
            args.setDefOrgId(Long.valueOf(defOrgId));
        }
        args.setSelectedRows((List)opParameter.getSelectedRows());
        args.setBuildConvReport(true);
        args.getCustomParams().putAll(opParameter.getCustomParams());
        if (this.getModel().getProperty(KEY_OUTFORMULA) != null) {
            Boolean outFormula = (Boolean)this.getModel().getValue(KEY_OUTFORMULA);
            args.addCustomParam("botp_outformula", String.valueOf(outFormula));
        }
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        Object customSourceBill = this.getView().getFormShowParameter().getCustomParams().get("customSourceBill");
        List customSourceBills = SerializationUtils.fromJsonStringToList((String)String.valueOf(customSourceBill), CustomBotpSourceBill.class);
        ArrayList<ConvertOperationResult> results = new ArrayList<ConvertOperationResult>();
        boolean flag = true;
        ConvertOperationResult mergeResult = new ConvertOperationResult();
        CustomBotpExcutor excutor = new CustomBotpExcutor();
        if (customSourceBills != null) {
            for (CustomBotpSourceBill custom : customSourceBills) {
                if (!StringUtils.equals((CharSequence)targetEntityNumber, (CharSequence)custom.getTargetBill())) continue;
                results.addAll(excutor.doPush(parentView, args, custom));
                flag = false;
            }
        }
        if (flag) {
            Push.addPushByBillOption((IFormView)parentView, (AbstractConvertServiceArgs)args);
            mergeResult = ConvertServiceHelper.push((PushArgs)args);
        }
        if (results.size() > 0) {
            mergeResult = (ConvertOperationResult)results.get(0);
            for (ConvertOperationResult result : results) {
                if (mergeResult == result) continue;
                mergeResult.setMessage(mergeResult.getMessage() + result.getMessage());
                mergeResult.setSuccess(mergeResult.isSuccess() && result.isSuccess());
                mergeResult.getCachePageIds().addAll(result.getCachePageIds());
                mergeResult.getCacheTargetObjStr().putAll(result.getCacheTargetObjStr());
                mergeResult.getTargetBillIds().addAll(result.getTargetBillIds());
                mergeResult.getDataMutexSrcBillIds().addAll(result.getDataMutexSrcBillIds());
                mergeResult.getBillReports().addAll(result.getBillReports());
                mergeResult.setFinishedTime(result.getFinishedTime());
            }
        }
        if (!mergeResult.isSuccess() || mergeResult.getCachePageIds().size() + mergeResult.getTargetBillIds().size() == 0) {
            Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)args, (ConvertOperationResult)mergeResult);
        } else if (mergeResult.getCachePageIds().size() + mergeResult.getTargetBillIds().size() == 1) {
            Push.showTargetBill((IFormView)parentView, (PushArgs)args, (ConvertOperationResult)mergeResult, (boolean)showReport);
            this.getView().sendFormAction(parentView);
            this.getView().close();
        } else {
            Push.showMultiTargetBills((IFormView)parentView, (PushArgs)args, (ConvertOperationResult)mergeResult, (boolean)showReport);
            this.getView().sendFormAction(parentView);
            this.getView().close();
        }
    }

    private void showPushBigDataResult(String taskId) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        ConvertOperationResult result = ConvertOpProgressCache.getCacheOperateResult((String)taskId);
        if (result != null) {
            boolean fail = false;
            for (SourceBillReport billReport : result.getBillReports()) {
                if (billReport.isFullSuccess()) continue;
                fail = true;
                break;
            }
            if (!fail && !result.getTargetBillIds().isEmpty()) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5927\u5355\u4e0b\u63a8\u6267\u884c\u5b8c\u6bd5\uff0c\u81ea\u52a8\u751f\u6210\u4e86%s\u5f20\u76ee\u6807\u5355\uff0c\u5171\u8017\u8d39%s\u79d2", (String)"ConvertOpFormEdit_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), result.getTargetBillIds().size(), result.getRunSecond()));
            } else {
                String argJson = ConvertOpProgressCache.getConvertArgs((String)taskId);
                PushArgs args = (PushArgs)SerializationUtils.fromJsonString((String)argJson, PushArgs.class);
                Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)args, (ConvertOperationResult)result);
            }
        }
        ConvertOpProgressCache.clearCache((String)taskId);
    }

    private void doDraw(ListSelectedRowCollection rows) {
        if (rows == null || rows.size() == 0) {
            return;
        }
        ConvertOpParameter opParameter = this.getConvertOpParamter();
        String sourceEntityNumber = (String)this.getModel().getValue(KEY_FBILL);
        String ruleId = (String)this.getModel().getValue(KEY_FRULE);
        DrawArgs args = new DrawArgs();
        args.setSourceEntityNumber(sourceEntityNumber);
        args.setTargetEntityNumber(opParameter.getEntityNumber());
        args.addCustomParam("botp_requiredatamutex", String.valueOf(true));
        args.getSelectedRows().addAll(rows);
        args.setTargetPageId(opParameter.getTargetBillPageId());
        args.setRuleId(ruleId);
        args.setBuildConvReport(true);
        args.getClearEntrys().addAll(opParameter.getClearEntrys());
        args.getCustomParams().putAll(opParameter.getCustomParams());
        ConvertOperationResult result = ConvertServiceHelper.draw((DrawArgs)args);
        if (!result.isSuccess() || result.getCachePageIds().size() == 0) {
            Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)args, (ConvertOperationResult)result);
        } else {
            IBillView billView = (IBillView)this.getView().getView(opParameter.getTargetBillPageId());
            IRefrencedataProvider refProvider = new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dataEntitys, IDataEntityType type) {
                    BusinessDataReader.loadRefence((Object[])dataEntitys, (IDataEntityType)type);
                }
            };
            List dataEntitys = result.loadTargetDataObjects(refProvider, (MainEntityType)((BillEntityType)billView.getModel().getDataEntityType()));
            this.addReleaseSourceDataMutexPlugin((IFormView)billView, result);
            ((IBillModel)billView.getModel()).push(dataEntitys.get(0));
            billView.updateView();
            this.getView().sendFormAction((IFormView)billView);
            this.getView().close();
            result.release(refProvider, (MainEntityType)((BillEntityType)billView.getModel().getDataEntityType()));
        }
    }

    private void addReleaseSourceDataMutexPlugin(IFormView billView, ConvertOperationResult drawResult) {
        boolean exist = false;
        String plugInName = ReleaseConvertDataMutexPlugin.class.getName();
        for (Plugin plugin : billView.getFormShowParameter().getFormConfig().getPlugins()) {
            if (!StringUtils.equals((CharSequence)plugin.getClassName(), (CharSequence)plugInName)) continue;
            exist = true;
            break;
        }
        if (!exist) {
            billView.getFormShowParameter().addCustPlugin(plugInName);
            billView.cacheFormShowParameter();
        }
        ReleaseConvertDataMutexPlugin.addConvertDataMutex((IFormView)billView, (String)drawResult.getSourceEntityNumber(), (Collection)drawResult.getDataMutexSrcBillIds());
    }

    private void fillBillCombo() {
        ConvertOpParameter opParameter = this.getConvertOpParamter();
        ConvertBill defTargetBill = null;
        ArrayList<ComboItem> billItems = new ArrayList<ComboItem>(10);
        ComboItem blankItem = new ComboItem();
        blankItem.setValue("");
        blankItem.setCaption(new LocaleString());
        billItems.add(blankItem);
        if (opParameter != null) {
            HashMap<String, Integer> entityNameCounts = new HashMap<String, Integer>(opParameter.getBills().size());
            for (ConvertBill bill : opParameter.getBills()) {
                Integer count;
                if (StringUtils.isBlank((CharSequence)bill.getEntityName())) {
                    bill.setEntityName(bill.getEntityNumber());
                }
                if ((count = (Integer)entityNameCounts.get(bill.getEntityName())) == null) {
                    entityNameCounts.put(bill.getEntityName(), 1);
                    continue;
                }
                entityNameCounts.put(bill.getEntityName(), count + 1);
            }
            for (ConvertBill bill : opParameter.getBills()) {
                ComboItem billItem = new ComboItem();
                billItem.setValue(bill.getEntityNumber());
                if (StringUtils.isBlank((CharSequence)bill.getEntityName())) {
                    billItem.setCaption(new LocaleString(Lang.get().getLocale().toString(), bill.getEntityNumber()));
                } else if ((Integer)entityNameCounts.get(bill.getEntityName()) > 1) {
                    billItem.setCaption(new LocaleString(Lang.get().getLocale().toString(), bill.getEntityName() + " (" + bill.getEntityNumber() + ")"));
                } else {
                    billItem.setCaption(new LocaleString(Lang.get().getLocale().toString(), bill.getEntityName()));
                }
                billItems.add(billItem);
                if (!StringUtils.equalsIgnoreCase((CharSequence)bill.getEntityNumber(), (CharSequence)opParameter.getDefTargetBill()) && !StringUtils.equalsIgnoreCase((CharSequence)bill.getEntityNumber(), (CharSequence)opParameter.getDefSourceBill())) continue;
                defTargetBill = bill;
            }
            ComboEdit billEditor = (ComboEdit)this.getView().getControl(KEY_FBILL);
            billEditor.setComboItems(billItems);
            if (opParameter.getBills().size() > 0) {
                if (defTargetBill == null) {
                    defTargetBill = (ConvertBill)opParameter.getBills().get(0);
                }
                this.getModel().setValue(KEY_FBILL, (Object)defTargetBill.getEntityNumber());
            }
            this.fillRuleCombo(defTargetBill);
            this.fillOrgCombo(defTargetBill);
        }
    }

    private void fillRuleCombo(ConvertBill bill) {
        ConvertBill currBill = bill;
        if (currBill == null) {
            currBill = this.getCurrConvertBill();
        }
        boolean isPush = false;
        if (this.opParameter.getOpType() == ConvertOpType.Push || this.opParameter.getOpType() == ConvertOpType.SpecPush) {
            isPush = true;
        }
        ArrayList<Object> ruleItems = new ArrayList<Object>();
        String defRuleId = "";
        boolean isDefTargetBill = false;
        if (isPush) {
            ComboItem blankItem = new ComboItem();
            blankItem.setValue(ALLRULE);
            blankItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u81ea\u52a8\u5339\u914d\u89c4\u5219", (String)"ConvertOpFormEdit_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0])));
            ruleItems.add(blankItem);
            if (currBill != null) {
                isDefTargetBill = StringUtils.equalsIgnoreCase((CharSequence)currBill.getEntityNumber(), (CharSequence)this.opParameter.getDefTargetBill());
            }
        }
        if (this.opParameter.getOpType() == ConvertOpType.Draw) {
            isDefTargetBill = StringUtils.equalsIgnoreCase((CharSequence)currBill.getEntityNumber(), (CharSequence)this.opParameter.getDefSourceBill());
        }
        if (currBill != null) {
            for (ConvertOpRule rule : currBill.getRules()) {
                if (!rule.isVisibled()) continue;
                ComboItem ruleItem = new ComboItem();
                ruleItem.setValue(rule.getRuleId());
                ruleItem.setCaption(new LocaleString(rule.getRuleName()));
                ruleItems.add(ruleItem);
                if (!isDefTargetBill || !StringUtils.equalsIgnoreCase((CharSequence)rule.getRuleId(), (CharSequence)this.opParameter.getDefRuleId())) continue;
                defRuleId = rule.getRuleId();
            }
        }
        ComboEdit billEditor = (ComboEdit)this.getView().getControl(KEY_FRULE);
        billEditor.setComboItems(ruleItems);
        if (ruleItems.size() == 0) {
            this.getModel().setValue(KEY_FRULE, (Object)"");
        } else {
            if (StringUtils.isBlank((CharSequence)defRuleId)) {
                defRuleId = ((ComboItem)ruleItems.get(0)).getValue();
            }
            this.getModel().setValue(KEY_FRULE, (Object)defRuleId);
        }
    }

    private void fillOrgCombo(ConvertBill bill) {
        ConvertBill currBill = bill;
        if (currBill == null) {
            currBill = this.getCurrConvertBill();
        }
        if (currBill == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_FRELATIONORG});
            return;
        }
        ConvertOpParameter opParameter = this.getConvertOpParamter();
        ArrayList orgIds = new ArrayList();
        String sourceType = opParameter.getEntityNumber();
        if (opParameter.getOpType() == ConvertOpType.Push) {
            String s;
            Map customParams;
            List rules = currBill.getRules();
            if (rules != null && rules.size() > 0 && (customParams = opParameter.getCustomParams()) != null && StringUtils.isNotBlank((CharSequence)(s = (String)customParams.get(rules.get(0))))) {
                sourceType = s;
            }
            String targetEntityNumber = currBill.getEntityNumber();
            String ruleId = (String)this.getModel().getValue(KEY_FRULE);
            GetTargetOptionalOrgsArgs args = new GetTargetOptionalOrgsArgs();
            args.setAppId(opParameter.getAppId());
            args.setSourceEntityNumber(sourceType);
            args.setTargetEntityNumber(targetEntityNumber);
            for (ConvertOpRule rule : currBill.getRules()) {
                args.getRuleIds().add(rule.getRuleId());
            }
            if (!ALLRULE.equals(ruleId)) {
                args.setRuleId(ruleId);
            }
            args.setSelectedRows((List)opParameter.getSelectedRows());
            GetTargetOptionalOrgsResult orgsResult = ConvertServiceHelper.getTargetOptionalOrgs((GetTargetOptionalOrgsArgs)args);
            if (!orgsResult.isSuccess() || !orgsResult.isHasMainOrg()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_FRELATIONORG});
            } else if (!orgsResult.isShowTargetOrgCombo()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_FRELATIONORG});
            } else {
                orgIds.addAll(orgsResult.getOrgIds());
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_FRELATIONORG});
            return;
        }
        ArrayList<ComboItem> orgItems = new ArrayList<ComboItem>();
        ComboItem blankItem = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u81ea\u52a8\u8ba1\u7b97", (String)"ConvertOpFormEdit_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0])), "0");
        orgItems.add(blankItem);
        if (orgIds.isEmpty()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_FRELATIONORG});
        } else {
            Object[] arrOrgIds;
            this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_FRELATIONORG});
            if (orgIds.size() > 10) {
                arrOrgIds = new Object[10];
                for (int i = 0; i < 10; ++i) {
                    arrOrgIds[i] = orgIds.get(i);
                }
            } else {
                arrOrgIds = orgIds.toArray();
            }
            DynamicObjectType orgMainType = EntityMetadataCache.getSubDataEntityType((String)"bos_org", new ArrayList());
            Map orgs = BusinessDataServiceHelper.loadFromCache((Object[])arrOrgIds, (DynamicObjectType)orgMainType);
            for (Map.Entry orgItem : orgs.entrySet()) {
                ComboItem ruleItem = new ComboItem();
                ruleItem.setValue(orgItem.getKey().toString());
                ruleItem.setCaption(new LocaleString(((DynamicObject)orgItem.getValue()).get("name").toString()));
                orgItems.add(ruleItem);
            }
        }
        ComboEdit billEditor = (ComboEdit)this.getView().getControl(KEY_FRELATIONORG);
        billEditor.setComboItems(orgItems);
        if (orgItems.size() == 0) {
            this.getModel().setValue(KEY_FRELATIONORG, (Object)"");
        } else {
            this.getModel().setValue(KEY_FRELATIONORG, (Object)blankItem.getValue());
        }
    }

    private ConvertBill getCurrConvertBill() {
        ConvertBill currBill = null;
        ConvertOpParameter opParameter = this.getConvertOpParamter();
        String fldValue = (String)this.getModel().getValue(KEY_FBILL);
        if (opParameter == null || StringUtils.isBlank((CharSequence)fldValue)) {
            return null;
        }
        for (ConvertBill convertBill : opParameter.getBills()) {
            if (!StringUtils.equals((CharSequence)fldValue, (CharSequence)convertBill.getEntityNumber())) continue;
            currBill = convertBill;
            break;
        }
        return currBill;
    }

    private ConvertOpParameter getConvertOpParamter() {
        if (this.opParameter == null) {
            String opParamJson = (String)this.getView().getFormShowParameter().getCustomParam(CustParam_OpParam);
            if (StringUtils.isNotBlank((CharSequence)opParamJson)) {
                this.opParameter = (ConvertOpParameter)SerializationUtils.fromJsonString((String)opParamJson, ConvertOpParameter.class);
            } else {
                this.opParameter = new ConvertOpParameter();
                this.opParameter.setOpType(ConvertOpType.Push);
            }
        }
        return this.opParameter;
    }
}

