/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.usernumber;

import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.helper.usernumber.CreateUserNumberDefault;
import kd.scm.common.helper.usernumber.CreateUserStrategyEnum;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.ParamUtil;
import kd.sdk.scm.common.extpoint.ICreateUserNumberSupport;

public final class CreateUserNumberHelper {
    private static final Log log = LogFactory.getLog((String)CreateUserNumberHelper.class.getName());

    public static String getStrategyUserNumber() {
        String userNumber = "";
        String strategy = ParamUtil.getSysCtrlParam("eae607fb000143ac", "createuserstrategy");
        if (strategy == null || strategy.isEmpty()) {
            userNumber = ApiConfigUtil.assembleCurrencyUserNumber();
        } else if (CreateUserStrategyEnum.CURRENCYUSER.getValue().equalsIgnoreCase(strategy)) {
            userNumber = ApiConfigUtil.assembleCurrencyUserNumber();
        } else if (CreateUserStrategyEnum.ISCPROXYUSER.getValue().equalsIgnoreCase(strategy)) {
            userNumber = ApiConfigUtil.assembleISCProxyUserNumber();
        }
        return userNumber;
    }

    public static String getStrategyUserNumber(String proxyFormId) {
        String userNumber = "";
        Object createuserstrategy = null;
        try {
            createuserstrategy = ParamUtil.getBillParam(proxyFormId, "createuserstrategy");
        }
        catch (RuntimeException exception) {
            SRMStoreExceptionTraceHelper.saveWarnData(exception);
        }
        if (createuserstrategy == null) {
            userNumber = CreateUserNumberHelper.getStrategyUserNumber();
        } else {
            String strategy = createuserstrategy.toString();
            if (CreateUserStrategyEnum.CURRENCYUSER.getValue().equalsIgnoreCase(strategy)) {
                userNumber = ApiConfigUtil.assembleCurrencyUserNumber();
            } else if (CreateUserStrategyEnum.ISCPROXYUSER.getValue().equalsIgnoreCase(strategy)) {
                userNumber = ApiConfigUtil.assembleISCProxyUserNumber();
            }
        }
        return userNumber;
    }

    public static String getCreateUserNumber(String proxyFormId, DynamicObject[] dynamicObjects) {
        String userNumber = "";
        Object createuserstrategy = null;
        try {
            createuserstrategy = ParamUtil.getBillParam(proxyFormId, "createuserstrategy");
        }
        catch (RuntimeException exception) {
            SRMStoreExceptionTraceHelper.saveWarnData(exception);
        }
        String strategy = createuserstrategy == null ? ParamUtil.getSysCtrlParam("eae607fb000143ac", "createuserstrategy") : createuserstrategy.toString();
        if (strategy == null || strategy.isEmpty() || CreateUserStrategyEnum.ISCPROXYUSER.getValue().equalsIgnoreCase(strategy) || CreateUserStrategyEnum.CURRENCYUSER.getValue().equalsIgnoreCase(strategy)) {
            userNumber = CreateUserNumberHelper.getStrategyUserNumber(proxyFormId);
        } else if (CreateUserStrategyEnum.CUSTOMUSER.getValue().equalsIgnoreCase(strategy)) {
            String extCase = "SCM_PUR_CREATEUSERNUMBER_SUPPORT";
            Class<CreateUserNumberDefault> defaultClass = CreateUserNumberDefault.class;
            Class<ICreateUserNumberSupport> classz = ICreateUserNumberSupport.class;
            Class customClassz = CreateUserNumberDefault.class;
            if (!proxyFormId.isEmpty()) {
                Object createuserextplugin = null;
                try {
                    createuserextplugin = ParamUtil.getBillParam(proxyFormId, "createuserextplugin");
                }
                catch (Exception exception) {
                    SRMStoreExceptionTraceHelper.saveExceptionData(exception);
                }
                if (createuserextplugin != null && !createuserextplugin.toString().isEmpty()) {
                    try {
                        customClassz = TypesContainer.getOrRegister((String)createuserextplugin.toString());
                    }
                    catch (Throwable throwable) {
                        log.error(throwable);
                    }
                }
            }
            PluginProxy pluginProxy = PluginProxy.create(defaultClass, classz, (String)extCase, null);
            for (ICreateUserNumberSupport support : pluginProxy.getPlugins()) {
                try {
                    if (!support.getClass().equals(customClassz)) continue;
                    userNumber = support.assembleCustomUserNumber(dynamicObjects);
                }
                catch (Throwable throwable) {
                    SRMStoreExceptionTraceHelper.saveExceptionData(throwable);
                    userNumber = CreateUserNumberHelper.getStrategyUserNumber(proxyFormId);
                }
            }
        }
        return userNumber.isEmpty() ? CreateUserNumberHelper.getStrategyUserNumber(proxyFormId) : userNumber;
    }
}

