/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.isc.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.eip.config.EipConfigration;
import kd.scm.common.isc.util.IIscSend;
import kd.scm.common.isc.util.IerpIscEasSend;
import kd.scm.common.isc.util.SupplierIscToIerp;
import kd.scm.common.k3cloud.util.K3CloudUtil;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;
import kd.scm.common.systemjoint.HttpJointSystemHelper;
import kd.scm.common.util.DataTransterLogUtil;
import kd.scm.common.util.ExceptionUtil;

public class IerpIscK3CloudSend
implements IIscSend {
    private static Log log = LogFactory.getLog(IerpIscEasSend.class);
    private static final Map<String, Object> apiMap = new HashMap<String, Object>(64);
    private static final List<String> iscUnDoMethod = new ArrayList<String>();

    @Override
    public String doExec(Map<String, Object> map, String method, Object obj) {
        DynamicObject isIsc = QueryServiceHelper.queryOne((String)"pur_updateparamconfig", (String)"id,paramvalue,paramkey", (QFilter[])new QFilter[]{new QFilter("paramkey", "=", (Object)"ISCK3Cloud")});
        if (iscUnDoMethod.contains(method) && Objects.nonNull(isIsc) && "Y".equals(isIsc.getString("paramvalue"))) {
            return "success";
        }
        if (apiMap.containsKey(method)) {
            IerpIscK3CloudSend service = (IerpIscK3CloudSend)apiMap.get(method);
            return service.doExec(map, method, obj);
        }
        return this.doExec(map, method, "", "data", obj);
    }

    @Override
    public String doExec(Map<String, Object> map, String method, String facade, Object obj) {
        if (apiMap.containsKey(method)) {
            IerpIscK3CloudSend service = (IerpIscK3CloudSend)apiMap.get(method);
            return service.doExec(map, method, obj);
        }
        return this.doExec(map, method, facade, "data", obj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String doExec(Map<String, Object> map, String method, String facade, String paramMapkey, Object obj) {
        Object data = "";
        DynamicObject dataLog = null;
        if (apiMap.containsKey(method)) {
            IerpIscK3CloudSend service = (IerpIscK3CloudSend)apiMap.get(method);
            return service.doExec(map, method, obj);
        }
        try {
            HashMap<String, Object> customRequestMap = new HashMap<String, Object>(16);
            customRequestMap.put("actionName", method);
            customRequestMap.put(paramMapkey, map);
            dataLog = DataTransterLogUtil.logInputData(EipConfigration.getAPICONFIGID(), method, method, customRequestMap);
            String number = String.valueOf(((Map)obj).get("number"));
            if (number != null && !number.isEmpty()) {
                DynamicObject iscLinkData = BusinessDataServiceHelper.loadSingleFromCache((String)"isc_database_link", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
                if (iscLinkData == null) throw new KDException(new ErrorCode("", ResManager.loadKDString((String)"\u65e0\u6709\u6548\u96c6\u6210\u4e91\u8fde\u63a5\u5668\u6570\u636e\uff0c\u65e0\u6cd5\u6267\u884c\u96c6\u6210\u4e91\u8bf7\u6c42\u3002", (String)"IerpIscK3CloudSend_0", (String)"scm-common", (Object[])new Object[0])), new Object[0]);
                data = HttpJointSystemHelper.sendCustomRequest(customRequestMap, iscLinkData);
            } else {
                data = String.valueOf(K3CloudUtil.sendRequest(customRequestMap));
            }
        }
        catch (Exception e) {
            SRMStoreExceptionTraceHelper.saveExceptionData(e);
            throw new KDBizException(ExceptionUtil.getStackTrace(e));
        }
        DataTransterLogUtil.logOutputData(dataLog, data);
        return String.valueOf(data);
    }

    static {
        apiMap.put("doIerp2Supplier", new SupplierIscToIerp());
        iscUnDoMethod.add("doIerp2Supplier");
        iscUnDoMethod.add("doIerpOperateSupplier");
    }
}

