/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.kuaidi100.impl;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.kuaidi100.api.IHttpApiService;
import kd.scm.common.kuaidi100.util.KuaidiUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.common.util.MD5Util;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public final class kuaidiQueryHelper
implements IHttpApiService {
    private static Log log = LogFactory.getLog(kuaidiQueryHelper.class);
    private static final String URL = "http://poll.kuaidi100.com/poll/query.do";

    @Override
    public Map<String, Object> executeApi(Map<String, Object> map) {
        String param = this.addFromTo(map);
        String customer = "";
        String content = "";
        if (!KuaidiUtil.IsExistAccount()) {
            throw new KDException(new ErrorCode("exception", ResManager.loadKDString((String)"\u9700\u8981\u914d\u7f6e\u5feb\u9012100\u8d26\u53f7\u624d\u80fd\u67e5\u8be2\u7269\u6d41\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u3002", (String)"kuaidiQueryHelper_5", (String)"scm-common", (Object[])new Object[0])), new Object[0]);
        }
        DynamicObject kuaidiObj = KuaidiUtil.getKuaidi100Info();
        customer = kuaidiObj.getString("user");
        content = kuaidiObj.getString("newpwd");
        String sign = MD5Util.encode(param + content + customer);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        paramMap.put("sign", sign);
        paramMap.put("customer", customer);
        paramMap.put("param", param);
        String respBody = null;
        HttpPost method = new HttpPost(URL);
        CloseableHttpClient httpClient = HttpClientBuilder.create().useSystemProperties().setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectTimeout(500000).build()).build();
        HttpResponse response = null;
        int statusCode = 0;
        try {
            method.setEntity((HttpEntity)kuaidiQueryHelper.toEntity(paramMap));
        }
        catch (UnsupportedEncodingException e) {
            throw new KDException(new ErrorCode("exception", ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff0c\u8bbf\u95ee\u88ab\u62d2\u7edd\uff01", (String)"kuaidiQueryHelper_0", (String)"scm-common", (Object[])new Object[0])), new Object[]{e.getLocalizedMessage()});
        }
        try {
            response = httpClient.execute((HttpUriRequest)method);
            HttpEntity entity = response.getEntity();
            respBody = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (ClientProtocolException e) {
            log.info(ExceptionUtil.getStackTrace(e));
            throw new KDException(new ErrorCode("exception", ResManager.loadKDString((String)"\u8bf7\u6c42\u534f\u8bae\u4e0d\u5408\u6cd5\uff0c\u8bf7\u6c42\u88ab\u62d2\u7edd\u3002", (String)"kuaidiQueryHelper_1", (String)"scm-common", (Object[])new Object[0])), new Object[]{e.getLocalizedMessage()});
        }
        catch (ParseException e) {
            log.info(ExceptionUtil.getStackTrace(e));
            throw new KDException(new ErrorCode("exception", ResManager.loadKDString((String)"\u6570\u636e\u8f6c\u6362\u5931\u8d25", (String)"kuaidiQueryHelper_2", (String)"scm-common", (Object[])new Object[0])), new Object[]{e.getLocalizedMessage()});
        }
        catch (IOException e) {
            log.info(ExceptionUtil.getStackTrace(e));
            throw new KDException(new ErrorCode("exception", ResManager.loadKDString((String)"\u6570\u636e\u8f6c\u6362\u5931\u8d25", (String)"kuaidiQueryHelper_2", (String)"scm-common", (Object[])new Object[0])), new Object[]{e.getLocalizedMessage()});
        }
        finally {
            method.releaseConnection();
        }
        statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            throw new KDException(new ErrorCode("200", ResManager.loadKDString((String)"\u7269\u6d41\u67e5\u8be2\u63a5\u53e3\u6682\u65f6\u4e0d\u53ef\u7528\uff0c\u8bf7\u7a0d\u7b49\u518d\u8bd5\u3002", (String)"kuaidiQueryHelper_3", (String)"scm-common", (Object[])new Object[0])), new Object[]{response.getStatusLine().getStatusCode()});
        }
        try {
            resultMap.putAll(JacksonJsonUtil.fromJSON(respBody, HashMap.class));
        }
        catch (JsonParseException e) {
            throw new KDException(new ErrorCode("exception", ResManager.loadKDString((String)"\u6570\u636e\u89e3\u6790\u5931\u8d25", (String)"kuaidiQueryHelper_4", (String)"scm-common", (Object[])new Object[0])), new Object[]{e.getLocalizedMessage()});
        }
        catch (JsonMappingException e) {
            throw new KDException(new ErrorCode("exception", ResManager.loadKDString((String)"\u6570\u636e\u89e3\u6790\u5931\u8d25", (String)"kuaidiQueryHelper_4", (String)"scm-common", (Object[])new Object[0])), new Object[]{e.getLocalizedMessage()});
        }
        catch (IOException e) {
            throw new KDException(new ErrorCode("exception", ResManager.loadKDString((String)"\u6570\u636e\u89e3\u6790\u5931\u8d25", (String)"kuaidiQueryHelper_4", (String)"scm-common", (Object[])new Object[0])), new Object[]{e.getLocalizedMessage()});
        }
        log.info(this.getClass().getName() + resultMap);
        return resultMap;
    }

    protected String addFromTo(Map<String, Object> map) {
        map.put("from", "");
        map.put("to", "");
        return JacksonJsonUtil.toJSON(map);
    }

    private static UrlEncodedFormEntity toEntity(Map<String, String> paramMap) throws UnsupportedEncodingException {
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        if (paramMap != null) {
            for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                parameters.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
        }
        return new UrlEncodedFormEntity(parameters, "UTF-8");
    }
}

